/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.search;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyFileType;

public class GrSourceFilterScope
extends GlobalSearchScope {
    private final GlobalSearchScope myDelegate;
    private final ProjectFileIndex myIndex;

    public GrSourceFilterScope(GlobalSearchScope delegate, Project project) {
        super(project);
        this.myDelegate = delegate;
        this.myIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
    }

    public boolean contains(VirtualFile file) {
        FileType fileType = file.getFileType();
        return (this.myDelegate == null || this.myDelegate.contains(file)) && GroovyFileType.GROOVY_FILE_TYPE == fileType && this.myIndex.isInSourceContent(file);
    }

    public int compare(VirtualFile file1, VirtualFile file2) {
        return this.myDelegate != null ? this.myDelegate.compare(file1, file2) : 0;
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/search/GrSourceFilterScope.isSearchInModuleContent must not be null");
        }
        return this.myDelegate == null || this.myDelegate.isSearchInModuleContent(aModule);
    }

    public boolean isSearchInLibraries() {
        return this.myDelegate == null || this.myDelegate.isSearchInLibraries();
    }
}

