/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.psi.PsiMethod;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyElementPattern;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyMethodCallPattern;

public class GroovyExpressionPattern<T extends GrExpression, Self extends GroovyExpressionPattern<T, Self>>
extends GroovyElementPattern<T, Self> {
    protected GroovyExpressionPattern(Class<T> aClass) {
        super(aClass);
    }

    public Self ofType(final @NotNull ElementPattern pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/patterns/GroovyExpressionPattern.ofType must not be null");
        }
        return (Self)((Object)((GroovyExpressionPattern)this.with(new PatternCondition<T>("ofType"){

            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/patterns/GroovyExpressionPattern$1.accepts must not be null");
                }
                return pattern.getCondition().accepts((Object)t.getType(), context);
            }
        })));
    }

    public GroovyMethodCallPattern methodCall(final ElementPattern<? extends PsiMethod> method) {
        return (GroovyMethodCallPattern)((GroovyMethodCallPattern)new GroovyMethodCallPattern().and((ElementPattern)this)).with((PatternCondition)new PatternCondition<GrCallExpression>("methodCall"){

            public boolean accepts(@NotNull GrCallExpression callExpression, ProcessingContext context) {
                GroovyResolveResult[] results;
                if (callExpression == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/patterns/GroovyExpressionPattern$2.accepts must not be null");
                }
                for (GroovyResolveResult result : results = callExpression.getMethodVariants()) {
                    if (!method.getCondition().accepts((Object)result.getElement(), context)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public Self skipParentheses(final ElementPattern<? extends GrExpression> expressionPattern) {
        return (Self)((Object)((GroovyExpressionPattern)this.with(new PatternCondition<T>("skipParentheses"){

            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/patterns/GroovyExpressionPattern$3.accepts must not be null");
                }
                Object expression = t;
                while (expression instanceof GrParenthesizedExpression) {
                    expression = ((GrParenthesizedExpression)expression).getOperand();
                }
                return expressionPattern.accepts(expression, context);
            }
        })));
    }

    public static class Capture<T extends GrExpression>
    extends GroovyExpressionPattern<T, Capture<T>> {
        public Capture(Class<T> aClass) {
            super(aClass);
        }
    }
}

