/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.util;

import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;

public abstract class GroovyUtils {
    public static final String PLUGIN_MODULE_ID = "PLUGIN_MODULE";

    public static File[] getFilesInDirectoryByPattern(String dirPath, String patternString) {
        Pattern pattern = Pattern.compile(patternString);
        return GroovyUtils.getFilesInDirectoryByPattern(dirPath, pattern);
    }

    public static File[] getFilesInDirectoryByPattern(String dirPath, final Pattern pattern) {
        File distDir = new File(dirPath);
        File[] files = distDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return pattern.matcher(name).matches();
            }
        });
        return files != null ? files : new File[]{};
    }

    public static <E> List<E> flatten(Collection<? extends Collection<E>> collections) {
        ArrayList<E> result = new ArrayList<E>();
        for (Collection<E> list : collections) {
            result.addAll(list);
        }
        return result;
    }

    public static boolean isSuitableModule(Module module) {
        if (module == null) {
            return false;
        }
        return GroovyUtils.isAcceptableModuleType(module.getModuleType());
    }

    public static boolean isAcceptableModuleType(ModuleType type) {
        return type instanceof JavaModuleType || PLUGIN_MODULE_ID.equals(type.getId());
    }
}

