/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkout;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import git4idea.GitBranch;
import git4idea.GitTag;
import git4idea.GitVcs;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitSimpleHandler;
import git4idea.config.GitVcsSettings;
import git4idea.i18n.GitBundle;
import git4idea.ui.GitReferenceValidator;
import git4idea.ui.GitUIUtil;
import git4idea.validators.GitBranchNameValidator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nullable;

public class GitCheckoutDialog
extends DialogWrapper {
    private JPanel myPanel;
    private JComboBox myGitRoot;
    private JComboBox myBranchToCkeckout;
    private JLabel myCurrentBranch;
    private JCheckBox myIncludeTagsCheckBox;
    private JTextField myNewBranchName;
    private JCheckBox myOverrideCheckBox;
    private JCheckBox myCreateRefLogCheckBox;
    private JCheckBox myTrackBranchCheckBox;
    private final GitReferenceValidator myBranchToCkeckoutValidator;
    private JButton myValidateButton;
    private final Project myProject;
    private final GitVcsSettings mySettings;
    private final HashSet<String> existingBranches;

    public GitCheckoutDialog(Project project, List<VirtualFile> roots, VirtualFile defaultRoot) {
        super(project, true);
        this.$$$setupUI$$$();
        this.existingBranches = new HashSet();
        this.setTitle(GitBundle.getString("checkout.branch"));
        this.myProject = project;
        this.mySettings = GitVcsSettings.getInstance(this.myProject);
        GitUIUtil.setupRootChooser(this.myProject, roots, defaultRoot, this.myGitRoot, this.myCurrentBranch);
        this.setupIncludeTags();
        this.setupBranches();
        this.setOKButtonText(GitBundle.getString("checkout.branch"));
        this.myBranchToCkeckoutValidator = new GitReferenceValidator(project, this.myGitRoot, this.getBranchToCheckoutTextField(), this.myValidateButton, new Runnable(){

            @Override
            public void run() {
                GitCheckoutDialog.this.checkOkButton();
            }
        });
        this.setupNewBranchName();
        this.init();
        this.checkOkButton();
    }

    private void checkOkButton() {
        String sourceRev = this.getSourceBranch();
        if (sourceRev == null || sourceRev.length() == 0) {
            this.setErrorText(null);
            this.setOKActionEnabled(false);
            return;
        }
        if (this.myBranchToCkeckoutValidator.isInvalid()) {
            this.setErrorText(GitBundle.getString("checkout.validation.failed"));
            this.setOKActionEnabled(false);
            return;
        }
        String newBranchName = this.myNewBranchName.getText();
        if (newBranchName.length() != 0 && !GitBranchNameValidator.INSTANCE.checkInput(newBranchName)) {
            this.setErrorText(GitBundle.getString("checkout.invalid.new.branch.name"));
            this.setOKActionEnabled(false);
            return;
        }
        if (this.existingBranches.contains(newBranchName) && !this.myOverrideCheckBox.isSelected()) {
            this.setErrorText(GitBundle.getString("checkout.branch.name.exists"));
            this.setOKActionEnabled(false);
            return;
        }
        this.setErrorText(null);
        this.setOKActionEnabled(true);
    }

    private void setupNewBranchName() {
        this.myOverrideCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitCheckoutDialog.this.checkOkButton();
            }
        });
        DocumentAdapter l = new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                GitCheckoutDialog.this.checkOkButton();
                String text = GitCheckoutDialog.this.myNewBranchName.getText();
                if (text.length() == 0) {
                    this.disableCheckboxes();
                } else if (GitBranchNameValidator.INSTANCE.checkInput(text)) {
                    if (GitCheckoutDialog.this.existingBranches.contains(text)) {
                        GitCheckoutDialog.this.myOverrideCheckBox.setEnabled(true);
                    } else {
                        GitCheckoutDialog.this.myOverrideCheckBox.setEnabled(false);
                        GitCheckoutDialog.this.myOverrideCheckBox.setSelected(false);
                    }
                    if (GitCheckoutDialog.this.existingBranches.contains(GitCheckoutDialog.this.getSourceBranch())) {
                        if (!GitCheckoutDialog.this.myTrackBranchCheckBox.isEnabled()) {
                            GitCheckoutDialog.this.myTrackBranchCheckBox.setSelected(true);
                            GitCheckoutDialog.this.myTrackBranchCheckBox.setEnabled(true);
                        }
                    } else {
                        GitCheckoutDialog.this.myTrackBranchCheckBox.setSelected(false);
                        GitCheckoutDialog.this.myTrackBranchCheckBox.setEnabled(false);
                    }
                    GitCheckoutDialog.this.myCreateRefLogCheckBox.setEnabled(true);
                } else {
                    this.disableCheckboxes();
                }
            }

            private void disableCheckboxes() {
                GitCheckoutDialog.this.myOverrideCheckBox.setSelected(false);
                GitCheckoutDialog.this.myOverrideCheckBox.setEnabled(false);
                GitCheckoutDialog.this.myTrackBranchCheckBox.setSelected(false);
                GitCheckoutDialog.this.myTrackBranchCheckBox.setEnabled(false);
                GitCheckoutDialog.this.myCreateRefLogCheckBox.setSelected(false);
                GitCheckoutDialog.this.myCreateRefLogCheckBox.setEnabled(false);
            }
        };
        this.myNewBranchName.getDocument().addDocumentListener((DocumentListener)l);
        JTextField text = this.getBranchToCheckoutTextField();
        text.getDocument().addDocumentListener((DocumentListener)l);
    }

    private JTextField getBranchToCheckoutTextField() {
        return (JTextField)this.myBranchToCkeckout.getEditor().getEditorComponent();
    }

    public String getSourceBranch() {
        return GitUIUtil.getTextField(this.myBranchToCkeckout).getText();
    }

    private void setupBranches() {
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ArrayList<String> branchesAndTags = new ArrayList<String>();
                    GitBranch.listAsStrings(GitCheckoutDialog.this.myProject, GitCheckoutDialog.this.gitRoot(), true, true, branchesAndTags);
                    GitCheckoutDialog.this.existingBranches.clear();
                    GitCheckoutDialog.this.existingBranches.addAll(branchesAndTags);
                    Collections.sort(branchesAndTags);
                    if (GitCheckoutDialog.this.myIncludeTagsCheckBox.isSelected()) {
                        int mark = branchesAndTags.size();
                        GitTag.listAsStrings(GitCheckoutDialog.this.myProject, GitCheckoutDialog.this.gitRoot(), branchesAndTags);
                        Collections.sort(branchesAndTags.subList(mark, branchesAndTags.size()));
                    }
                    GitCheckoutDialog.this.myBranchToCkeckout.removeAllItems();
                    for (String item : branchesAndTags) {
                        GitCheckoutDialog.this.myBranchToCkeckout.addItem(item);
                    }
                    GitCheckoutDialog.this.myBranchToCkeckout.setSelectedItem("");
                }
                catch (VcsException ex) {
                    GitVcs.getInstance(GitCheckoutDialog.this.myProject).showErrors(Collections.singletonList(ex), GitBundle.getString("checkout.retrieving.branches.and.tags"));
                }
            }
        };
        this.myGitRoot.addActionListener(l);
        l.actionPerformed(null);
        this.myIncludeTagsCheckBox.addActionListener(l);
    }

    @Nullable
    public GitSimpleHandler createBranchHandler() {
        String branch = this.myNewBranchName.getText();
        if (branch.length() == 0) {
            return null;
        }
        GitSimpleHandler h = new GitSimpleHandler(this.myProject, this.gitRoot(), GitCommand.BRANCH);
        h.setNoSSH(true);
        if (this.myTrackBranchCheckBox.isSelected()) {
            h.addParameters("--track");
        }
        if (this.myCreateRefLogCheckBox.isSelected()) {
            h.addParameters("-l");
        }
        if (this.myOverrideCheckBox.isSelected()) {
            h.addParameters("-f");
        }
        h.addParameters(branch, this.getSourceBranch());
        return h;
    }

    public GitLineHandler checkoutHandler() {
        GitLineHandler h = new GitLineHandler(this.myProject, this.gitRoot(), GitCommand.CHECKOUT);
        h.setNoSSH(true);
        String newBranch = this.myNewBranchName.getText();
        if (newBranch.length() == 0) {
            h.addParameters(this.getSourceBranch());
        } else {
            h.addParameters(newBranch);
        }
        return h;
    }

    public VirtualFile gitRoot() {
        return (VirtualFile)this.myGitRoot.getSelectedItem();
    }

    private void setupIncludeTags() {
        boolean tagsIncluded = this.mySettings.isCheckoutIncludesTags();
        this.myIncludeTagsCheckBox.setSelected(tagsIncluded);
        this.myIncludeTagsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitCheckoutDialog.this.mySettings.setCheckoutIncludesTags(GitCheckoutDialog.this.myIncludeTagsCheckBox.isSelected());
            }
        });
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected String getHelpId() {
        return "reference.VersionControl.Git.CheckoutBranch";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JTextField jTextField;
        JComboBox jComboBox;
        JLabel jLabel;
        JComboBox jComboBox2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel2 = new JLabel();
        jLabel2.setToolTipText("");
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.git.root"));
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(6, 1, 1, 2, 0, 1, 6, 1, null, null, null));
        this.myGitRoot = jComboBox2 = new JComboBox();
        jComboBox2.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.git.root.tooltip"));
        jPanel.add(jComboBox2, new GridConstraints(0, 1, 1, 2, 8, 1, 2, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.current.branch"));
        jPanel.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCurrentBranch = jLabel = new JLabel();
        jLabel.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.current.branch.tooltip"));
        jLabel.setText("  ");
        jPanel.add((Component)jLabel, new GridConstraints(1, 1, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myBranchToCkeckout = jComboBox = new JComboBox();
        jComboBox.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("checkout.ref.tooltip"));
        jComboBox.setEditable(true);
        jPanel.add(jComboBox, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("checkout.branch.label"));
        jPanel.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("checkout.new.branch"));
        jPanel.add((Component)jLabel5, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNewBranchName = jTextField = new JTextField();
        jTextField.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("checkout.new.branch.tooltip"));
        jPanel.add((Component)jTextField, new GridConstraints(4, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(5, 1, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myCreateRefLogCheckBox = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("checkout.create.ref.log"));
        ((Component)jCheckBox4).setEnabled(false);
        jCheckBox4.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("checkout.create.ref.log.tooltip"));
        jPanel2.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel2.add((Component)spacer3, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myOverrideCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("checkout.override.branch"));
        ((Component)jCheckBox3).setEnabled(false);
        jCheckBox3.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("checkout.override.tooltip"));
        jPanel2.add((Component)jCheckBox3, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTrackBranchCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("checkout.track.branch"));
        ((Component)jCheckBox2).setEnabled(false);
        jCheckBox2.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("checkout.track.tooltip"));
        jCheckBox2.setSelected(false);
        jPanel2.add((Component)jCheckBox2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myIncludeTagsCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("checkout.include.tags"));
        jCheckBox.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("checkout.include.tags.tooltip"));
        jPanel.add((Component)jCheckBox, new GridConstraints(3, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myValidateButton = jButton = new JButton();
        jButton.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("checkout.validate.tooltip"));
        jButton.setVerticalAlignment(0);
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("checkout.validate"));
        jPanel.add((Component)jButton, new GridConstraints(2, 2, 1, 1, 0, 1, 0, 0, null, null, null));
        jLabel2.setLabelFor(jComboBox2);
        jLabel4.setLabelFor(jComboBox);
        jLabel5.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

