/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Icons;
import com.intellij.util.ui.tree.TreeUtil;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandlerUtil;
import git4idea.commands.GitSimpleHandler;
import git4idea.commands.StringScanner;
import git4idea.i18n.GitBundle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.MutableTreeNode;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class GitRefspecAddRefsDialog
extends DialogWrapper {
    private JButton myGetRefsButton;
    private JCheckBox myIncludeBranchesCheckBox;
    private JCheckBox myIncludeTagsCheckBox;
    private CheckboxTree myReferenceChooser;
    private JPanel myPanel;
    private final Project myProject;
    private CheckedTreeNode myTreeRoot;
    private final VirtualFile myRoot;
    private final String myRemote;
    private final SortedSet<String> myTags;
    private final SortedSet<String> myBranches;
    private static final Logger log = Logger.getInstance((String)GitRefspecAddRefsDialog.class.getName());

    protected GitRefspecAddRefsDialog(@NotNull Project project, @NotNull VirtualFile root, @NotNull String remote, @NotNull SortedSet<String> tags, @NotNull SortedSet<String> branches) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/ui/GitRefspecAddRefsDialog.<init> must not be null");
        }
        if (root == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/ui/GitRefspecAddRefsDialog.<init> must not be null");
        }
        if (remote == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of git4idea/ui/GitRefspecAddRefsDialog.<init> must not be null");
        }
        if (tags == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of git4idea/ui/GitRefspecAddRefsDialog.<init> must not be null");
        }
        if (branches == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of git4idea/ui/GitRefspecAddRefsDialog.<init> must not be null");
        }
        super(project, true);
        this.$$$setupUI$$$();
        this.setTitle(GitBundle.getString("addrefspec.title"));
        this.setOKButtonText(GitBundle.getString("addrefspec.button"));
        this.myProject = project;
        this.myRoot = root;
        this.myRemote = remote;
        this.myTags = tags;
        this.myBranches = branches;
        this.updateTree();
        this.setupGetReferences();
        this.init();
        this.setOKActionEnabled(false);
    }

    private void setupGetReferences() {
        ActionListener enabledListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitRefspecAddRefsDialog.this.myGetRefsButton.setEnabled(GitRefspecAddRefsDialog.this.myIncludeBranchesCheckBox.isSelected() || GitRefspecAddRefsDialog.this.myIncludeTagsCheckBox.isSelected());
            }
        };
        this.myIncludeBranchesCheckBox.addActionListener(enabledListener);
        this.myIncludeTagsCheckBox.addActionListener(enabledListener);
        this.myGetRefsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitSimpleHandler handler = new GitSimpleHandler(GitRefspecAddRefsDialog.this.myProject, GitRefspecAddRefsDialog.this.myRoot, GitCommand.LS_REMOTE);
                if (GitRefspecAddRefsDialog.this.myIncludeBranchesCheckBox.isSelected()) {
                    handler.addParameters("--heads");
                    GitRefspecAddRefsDialog.this.myBranches.clear();
                }
                if (GitRefspecAddRefsDialog.this.myIncludeTagsCheckBox.isSelected()) {
                    handler.addParameters("--tags");
                    GitRefspecAddRefsDialog.this.myTags.clear();
                }
                handler.addParameters(GitRefspecAddRefsDialog.this.myRemote);
                String result = GitHandlerUtil.doSynchronously(handler, GitBundle.message("addrefspec.getting.references.title", GitRefspecAddRefsDialog.this.myRemote), handler.printableCommandLine());
                if (result != null) {
                    StringScanner s = new StringScanner(result);
                    while (s.hasMoreData()) {
                        s.tabToken();
                        String ref = s.line();
                        if (ref.startsWith("refs/heads/")) {
                            GitRefspecAddRefsDialog.this.myBranches.add(ref);
                            continue;
                        }
                        if (ref.startsWith("refs/tags/")) {
                            GitRefspecAddRefsDialog.this.myTags.add(ref);
                            continue;
                        }
                        log.warn("Unknwon reference type from ls-remote \"" + GitRefspecAddRefsDialog.this.myRemote + "\" :" + ref);
                    }
                }
                GitRefspecAddRefsDialog.this.updateTree();
            }
        });
    }

    private void updateTree() {
        HashSet<String> oldTags = new HashSet<String>();
        HashSet<String> oldBranches = new HashSet<String>();
        for (Reference ref : (Reference[])this.myReferenceChooser.getCheckedNodes(Reference.class, null)) {
            (ref.isTag ? oldTags : oldBranches).add(ref.name);
        }
        this.myTreeRoot.removeAllChildren();
        this.addReferences(false, oldBranches, this.myBranches, GitBundle.getString("addrefspec.node.branches"));
        this.addReferences(true, oldTags, this.myTags, GitBundle.getString("addrefspec.node.tags"));
        TreeUtil.expandAll((JTree)this.myReferenceChooser);
        this.myReferenceChooser.treeDidChange();
    }

    private void addReferences(boolean isTag, HashSet<String> old, SortedSet<String> current, @Nls String name) {
        if (!current.isEmpty()) {
            CheckedTreeNode tagsRoot = new CheckedTreeNode((Object)name);
            for (String t : current) {
                CheckedTreeNode node = new CheckedTreeNode((Object)new Reference(isTag, t));
                node.setChecked(old.contains(t));
                tagsRoot.add((MutableTreeNode)node);
            }
            this.myTreeRoot.add((MutableTreeNode)tagsRoot);
        }
    }

    protected String getDimensionServiceKey() {
        return GitRefspecAddRefsDialog.class.getName();
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    private void createUIComponents() {
        this.myTreeRoot = new CheckedTreeNode((Object)"");
        this.myReferenceChooser = new CheckboxTree(new CheckboxTree.CheckboxTreeCellRenderer(){

            public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Icon icon;
                SimpleTextAttributes attributes;
                String text;
                CheckedTreeNode node = (CheckedTreeNode)value;
                Object userObject = node.getUserObject();
                if (userObject == null) {
                    text = "INVISBLE ROOT";
                    attributes = SimpleTextAttributes.ERROR_ATTRIBUTES;
                    icon = null;
                } else if (userObject instanceof String) {
                    text = (String)userObject;
                    attributes = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
                    icon = expanded ? Icons.DIRECTORY_OPEN_ICON : Icons.DIRECTORY_CLOSED_ICON;
                } else {
                    text = ((Reference)userObject).name;
                    attributes = node.isChecked() ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES;
                    icon = null;
                }
                ColoredTreeCellRenderer textRenderer = this.getTextRenderer();
                if (icon != null) {
                    textRenderer.setIcon(icon);
                }
                if (text != null) {
                    textRenderer.append(text, attributes);
                }
            }
        }, this.myTreeRoot){

            protected void onNodeStateChanged(CheckedTreeNode node) {
                boolean flag = node.isChecked() || ((Reference[])GitRefspecAddRefsDialog.this.myReferenceChooser.getCheckedNodes(Reference.class, null)).length != 0;
                GitRefspecAddRefsDialog.this.setOKActionEnabled(flag);
                super.onNodeStateChanged(node);
            }
        };
    }

    public SortedSet<String> getSelected(final boolean isTag) {
        Reference[] checked;
        TreeSet<String> rc = new TreeSet<String>();
        for (Reference r : checked = (Reference[])this.myReferenceChooser.getCheckedNodes(Reference.class, (Tree.NodeFilter)new Tree.NodeFilter<Reference>(){

            public boolean accept(Reference node) {
                return node.isTag == isTag;
            }
        })) {
            rc.add(r.name);
        }
        return rc;
    }

    protected String getHelpId() {
        return "reference.VersionControl.Git.Fetch.AddReference";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 3, 0, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myIncludeBranchesCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setSelected(true);
        jCheckBox2.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("addrefspec.include.branches.tooltip"));
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("addrefspec.include.branches"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myIncludeTagsCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("addrefspec.include.tags.tooltip"));
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("addrefspec.include.tags"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myGetRefsButton = jButton = new JButton();
        jButton.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("addrefspec.get.references.tooltip"));
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("addrefspec.get.references"));
        jPanel2.add((Component)jButton, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, new Dimension(100, 40), null, null));
        CheckboxTree checkboxTree = this.myReferenceChooser;
        checkboxTree.setRootVisible(false);
        checkboxTree.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("addrefspec.reference.chooser.tooltip"));
        jScrollPane.setViewportView((Component)checkboxTree);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    static final class Reference {
        final boolean isTag;
        final String name;

        public Reference(boolean tag, String name) {
            this.isTag = tag;
            this.name = name;
        }
    }
}

