/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.JavaClasspathPolicyExtender;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectClasspathTraversing;
import com.intellij.openapi.roots.ProjectRootsTraversing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import java.nio.charset.Charset;

public class JavaParameters
extends SimpleJavaParameters {
    public static final DataKey<JavaParameters> JAVA_PARAMETERS = DataKey.create("javaParameters");
    public static final int JDK_ONLY = 1;
    public static final int CLASSES_ONLY = 2;
    private static final int TESTS_ONLY = 4;
    public static final int JDK_AND_CLASSES = 3;
    public static final int JDK_AND_CLASSES_AND_TESTS = 7;
    public static final int CLASSES_AND_TESTS = 6;

    public String getJdkPath() throws CantRunException {
        Sdk jdk = this.getJdk();
        if (jdk == null) {
            throw new CantRunException(ExecutionBundle.message("no.jdk.specified..error.message", new Object[0]));
        }
        String jdkHome = jdk.getHomeDirectory().getPresentableUrl();
        if (jdkHome == null || jdkHome.length() == 0) {
            throw new CantRunException(ExecutionBundle.message("home.directory.not.specified.for.jdk.error.message", new Object[0]));
        }
        return jdkHome;
    }

    public void configureByModule(Module module, int classPathType, Sdk jdk) throws CantRunException {
        if ((classPathType & 1) != 0) {
            if (jdk == null) {
                throw CantRunException.noJdkConfigured();
            }
            this.setJdk(jdk);
        }
        if ((classPathType & 2) == 0) {
            return;
        }
        Charset encoding = EncodingProjectManager.getInstance(module.getProject()).getDefaultCharset();
        if (encoding != null) {
            this.setCharset(encoding);
        }
        ProjectRootsTraversing.collectRoots(module, this.getPolicy(null, module, classPathType), this.getClassPath());
    }

    public void configureByModule(Module module, int classPathType) throws CantRunException {
        this.configureByModule(module, classPathType, JavaParameters.getModuleJdk(module));
    }

    public static Sdk getModuleJdk(Module module) throws CantRunException {
        Sdk jdk = ModuleRootManager.getInstance(module).getSdk();
        if (jdk == null) {
            throw CantRunException.noJdkForModule(module);
        }
        VirtualFile homeDirectory = jdk.getHomeDirectory();
        if (homeDirectory == null || !homeDirectory.isValid()) {
            throw CantRunException.jdkMisconfigured(jdk, module);
        }
        return jdk;
    }

    public void configureByProject(Project project, int classPathType, Sdk jdk) throws CantRunException {
        if ((classPathType & 1) != 0) {
            if (jdk == null) {
                throw CantRunException.noJdkConfigured();
            }
            this.setJdk(jdk);
        }
        if ((classPathType & 2) == 0) {
            return;
        }
        ProjectRootsTraversing.collectRoots(project, this.getPolicy(project, null, classPathType), this.getClassPath());
    }

    private ProjectRootsTraversing.RootTraversePolicy getPolicy(Project project, Module module, int classPathType) {
        ProjectRootsTraversing.RootTraversePolicy result = (classPathType & 4) != 0 ? ((classPathType & 1) != 0 ? ProjectClasspathTraversing.FULL_CLASSPATH_RECURSIVE : ProjectClasspathTraversing.FULL_CLASS_RECURSIVE_WO_JDK) : ((classPathType & 1) != 0 ? ProjectClasspathTraversing.FULL_CLASSPATH_WITHOUT_TESTS : ProjectClasspathTraversing.FULL_CLASSPATH_WITHOUT_JDK_AND_TESTS);
        for (JavaClasspathPolicyExtender each : (JavaClasspathPolicyExtender[])Extensions.getExtensions(JavaClasspathPolicyExtender.EP_NAME)) {
            result = project == null ? each.extend(module, result) : each.extend(project, result);
        }
        return result;
    }
}

