/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.DocCommentTokenTypes;
import com.intellij.lexer.LexerBase;
import com.intellij.lexer.MergingLexerAdapter;
import com.intellij.lexer._JavaDocLexer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.text.CharArrayUtil;
import java.io.IOException;

public class DocCommentLexer
extends MergingLexerAdapter {
    public DocCommentLexer(DocCommentTokenTypes tokenTypes, boolean isJdk15Enabled) {
        super(new AsteriskStripperLexer(new _JavaDocLexer(isJdk15Enabled, tokenTypes), tokenTypes), TokenSet.create(tokenTypes.commentData(), tokenTypes.space()));
    }

    private static class AsteriskStripperLexer
    extends LexerBase {
        private final _JavaDocLexer myFlex;
        private final DocCommentTokenTypes myTokenTypes;
        private CharSequence myBuffer;
        private int myBufferIndex;
        private int myBufferEndOffset;
        private int myTokenEndOffset;
        private int myState;
        private IElementType myTokenType;
        private boolean myAfterLineBreak;
        private boolean myInLeadingSpace;

        public AsteriskStripperLexer(_JavaDocLexer flex, DocCommentTokenTypes tokenTypes) {
            this.myFlex = flex;
            this.myTokenTypes = tokenTypes;
        }

        @Override
        public final void start(CharSequence buffer, int startOffset, int endOffset, int initialState) {
            this.myBuffer = buffer;
            this.myBufferIndex = startOffset;
            this.myBufferEndOffset = endOffset;
            this.myTokenType = null;
            this.myTokenEndOffset = startOffset;
            this.myFlex.reset(this.myBuffer, startOffset, endOffset, initialState);
        }

        @Override
        public int getState() {
            return this.myState;
        }

        @Override
        public CharSequence getBufferSequence() {
            return this.myBuffer;
        }

        @Override
        public int getBufferEnd() {
            return this.myBufferEndOffset;
        }

        @Override
        public final IElementType getTokenType() {
            this.locateToken();
            return this.myTokenType;
        }

        @Override
        public final int getTokenStart() {
            this.locateToken();
            return this.myBufferIndex;
        }

        @Override
        public final int getTokenEnd() {
            this.locateToken();
            return this.myTokenEndOffset;
        }

        @Override
        public final void advance() {
            this.locateToken();
            this.myTokenType = null;
        }

        protected final void locateToken() {
            if (this.myTokenType != null) {
                return;
            }
            this._locateToken();
            if (this.myTokenType == this.myTokenTypes.space()) {
                this.myAfterLineBreak = CharArrayUtil.containLineBreaks((CharSequence)this.myBuffer, (int)this.getTokenStart(), (int)this.getTokenEnd());
            }
        }

        private void _locateToken() {
            if (this.myTokenEndOffset == this.myBufferEndOffset) {
                this.myTokenType = null;
                this.myBufferIndex = this.myBufferEndOffset;
                return;
            }
            this.myBufferIndex = this.myTokenEndOffset;
            if (this.myAfterLineBreak) {
                this.myAfterLineBreak = false;
                while (this.myTokenEndOffset < this.myBufferEndOffset && this.myBuffer.charAt(this.myTokenEndOffset) == '*' && (this.myTokenEndOffset + 1 >= this.myBufferEndOffset || this.myBuffer.charAt(this.myTokenEndOffset + 1) != '/')) {
                    ++this.myTokenEndOffset;
                }
                this.myInLeadingSpace = true;
                if (this.myBufferIndex < this.myTokenEndOffset) {
                    this.myTokenType = this.myTokenTypes.commentLeadingAsterisks();
                    return;
                }
            }
            if (this.myInLeadingSpace) {
                this.myInLeadingSpace = false;
                boolean lf = false;
                while (this.myTokenEndOffset < this.myBufferEndOffset && Character.isWhitespace(this.myBuffer.charAt(this.myTokenEndOffset))) {
                    if (this.myBuffer.charAt(this.myTokenEndOffset) == '\n') {
                        lf = true;
                    }
                    ++this.myTokenEndOffset;
                }
                int state = this.myFlex.yystate();
                if (state == 2 || this.myTokenEndOffset < this.myBufferEndOffset && (this.myBuffer.charAt(this.myTokenEndOffset) == '@' || this.myBuffer.charAt(this.myTokenEndOffset) == '{' || this.myBuffer.charAt(this.myTokenEndOffset) == '\"' || this.myBuffer.charAt(this.myTokenEndOffset) == '<')) {
                    this.myFlex.yybegin(1);
                }
                if (this.myBufferIndex < this.myTokenEndOffset) {
                    this.myTokenType = lf || state == 4 || state == 3 || state == 8 || state == 6 ? this.myTokenTypes.space() : this.myTokenTypes.commentData();
                    return;
                }
            }
            this.flexLocateToken();
        }

        private void flexLocateToken() {
            try {
                this.myState = this.myFlex.yystate();
                this.myFlex.goTo(this.myBufferIndex);
                this.myTokenType = this.myFlex.advance();
                this.myTokenEndOffset = this.myFlex.getTokenEnd();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

