/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.DelegateLexer;
import com.intellij.lexer.FilterLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.psi.tree.IElementType;

public class StoppableLexerAdapter
extends DelegateLexer {
    private final StoppingCondition myCondition;
    private boolean myStopped = false;

    public StoppableLexerAdapter(StoppingCondition condition, Lexer original) {
        super(original);
        this.myCondition = condition;
        this.myStopped = this.myCondition.stopsAt(original.getTokenType(), original.getTokenStart(), original.getTokenEnd());
    }

    @Override
    public void advance() {
        if (this.myStopped) {
            return;
        }
        super.advance();
        if (this.myCondition.stopsAt(this.getDelegate().getTokenType(), this.getDelegate().getTokenStart(), this.getDelegate().getTokenEnd())) {
            this.myStopped = true;
        }
    }

    public int getPrevTokenEnd() {
        Lexer delegate = this.getDelegate();
        return delegate instanceof StoppableLexerAdapter ? ((StoppableLexerAdapter)delegate).getPrevTokenEnd() : ((FilterLexer)delegate).getPrevTokenEnd();
    }

    @Override
    public int getTokenEnd() {
        return this.myStopped ? super.getTokenStart() : super.getTokenEnd();
    }

    @Override
    public IElementType getTokenType() {
        return this.myStopped ? null : super.getTokenType();
    }

    @Override
    public LexerPosition getCurrentPosition() {
        return this.getDelegate().getCurrentPosition();
    }

    @Override
    public void restore(LexerPosition position) {
        this.getDelegate().restore(position);
    }

    public static interface StoppingCondition {
        public boolean stopsAt(IElementType var1, int var2, int var3);
    }
}

