/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler;

import com.intellij.CommonBundle;
import com.intellij.openapi.projectRoots.Sdk;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.PropertyKey;

public class CompilerBundle {
    private static Reference<ResourceBundle> ourBundle;
    @NonNls
    private static final String BUNDLE = "messages.CompilerBundle";

    private CompilerBundle() {
    }

    public static String jdkHomeNotFoundMessage(Sdk jdk) {
        return CompilerBundle.message("javac.error.jdk.home.missing", jdk.getName(), jdk.getHomePath());
    }

    public static String message(@PropertyKey(resourceBundle="messages.CompilerBundle") String key, Object ... params) {
        return CommonBundle.message((ResourceBundle)CompilerBundle.getBundle(), (String)key, (Object[])params);
    }

    private static ResourceBundle getBundle() {
        ResourceBundle bundle = null;
        if (ourBundle != null) {
            bundle = ourBundle.get();
        }
        if (bundle == null) {
            bundle = ResourceBundle.getBundle(BUNDLE);
            ourBundle = new SoftReference<ResourceBundle>(bundle);
        }
        return bundle;
    }
}

