/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchHunk;
import com.intellij.openapi.diff.impl.patch.PatchLine;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;

public class UnifiedDiffWriter {
    @NonNls
    private static final String INDEX_SIGNATURE = "Index: {0}{1}";
    private static final String HEADER_SEPARATOR = "===================================================================";

    private UnifiedDiffWriter() {
    }

    public static void write(Collection<FilePatch> patches, Writer writer, String lineSeparator) throws IOException {
        for (FilePatch filePatch : patches) {
            if (!(filePatch instanceof TextFilePatch)) continue;
            TextFilePatch patch = (TextFilePatch)filePatch;
            UnifiedDiffWriter.writeFileHeading(patch, writer, lineSeparator);
            for (PatchHunk hunk : patch.getHunks()) {
                UnifiedDiffWriter.writeHunkStart(writer, hunk.getStartLineBefore(), hunk.getEndLineBefore(), hunk.getStartLineAfter(), hunk.getEndLineAfter(), lineSeparator);
                for (PatchLine line : hunk.getLines()) {
                    char prefixChar = ' ';
                    switch (line.getType()) {
                        case ADD: {
                            prefixChar = '+';
                            break;
                        }
                        case REMOVE: {
                            prefixChar = '-';
                            break;
                        }
                        case CONTEXT: {
                            prefixChar = ' ';
                        }
                    }
                    String text = line.getText();
                    if (text.endsWith("\n")) {
                        text = text.substring(0, text.length() - 1);
                    }
                    UnifiedDiffWriter.writeLine(writer, text, prefixChar);
                    if (line.isSuppressNewLine()) {
                        writer.write(lineSeparator + "\\ No newline at end of file" + lineSeparator);
                        continue;
                    }
                    writer.write(lineSeparator);
                }
            }
        }
    }

    private static void writeFileHeading(FilePatch patch, Writer writer, String lineSeparator) throws IOException {
        writer.write(MessageFormat.format(INDEX_SIGNATURE, patch.getBeforeName(), lineSeparator));
        writer.write(HEADER_SEPARATOR + lineSeparator);
        UnifiedDiffWriter.writeRevisionHeading(writer, "---", patch.getBeforeName(), patch.getBeforeVersionId(), lineSeparator);
        UnifiedDiffWriter.writeRevisionHeading(writer, "+++", patch.getAfterName(), patch.getAfterVersionId(), lineSeparator);
    }

    private static void writeRevisionHeading(Writer writer, String prefix, String revisionPath, String revisionName, String lineSeparator) throws IOException {
        writer.write(prefix + " ");
        writer.write(revisionPath);
        writer.write("\t");
        writer.write(revisionName);
        writer.write(lineSeparator);
    }

    private static void writeHunkStart(Writer writer, int startLine1, int endLine1, int startLine2, int endLine2, String lineSeparator) throws IOException {
        StringBuilder builder = new StringBuilder("@@ -");
        builder.append(startLine1 + 1).append(",").append(endLine1 - startLine1);
        builder.append(" +").append(startLine2 + 1).append(",").append(endLine2 - startLine2).append(" @@").append(lineSeparator);
        writer.append(builder.toString());
    }

    private static void writeLine(Writer writer, String line, char prefix) throws IOException {
        writer.write(prefix);
        writer.write(line);
    }
}

