/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.ui.Painter;
import java.awt.Component;
import java.awt.Graphics2D;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPainter
implements Painter {
    private boolean myNeedsRepaint;
    private final Set<Painter.Listener> myListeners = new HashSet<Painter.Listener>();

    @Override
    public boolean needsRepaint() {
        return this.myNeedsRepaint;
    }

    public void setNeedsRepaint(boolean needsRepaint) {
        this.setNeedsRepaint(needsRepaint, null);
    }

    public void setNeedsRepaint(boolean needsRepaint, @Nullable JComponent dirtyComponent) {
        this.myNeedsRepaint = needsRepaint;
        if (this.myNeedsRepaint) {
            this.fireNeedsRepaint(dirtyComponent);
        }
    }

    @Override
    public void addListener(Painter.Listener listener) {
        this.myListeners.add(listener);
    }

    @Override
    public void removeListener(Painter.Listener listener) {
        this.myListeners.remove(listener);
    }

    @Nullable
    public <T> T setNeedsRepaint(T oldValue, T newValue) {
        if (!this.myNeedsRepaint) {
            if (oldValue != null) {
                this.setNeedsRepaint(!oldValue.equals(newValue));
            } else if (newValue != null) {
                this.setNeedsRepaint(!newValue.equals(oldValue));
            } else {
                this.setNeedsRepaint(false);
            }
        }
        return newValue;
    }

    @Nullable
    public <T> T setNeedsRepaint(T oldValue, T newValue, JComponent dirtyComponent) {
        if (!this.myNeedsRepaint) {
            if (oldValue != null) {
                this.setNeedsRepaint(!oldValue.equals(newValue));
            } else if (newValue != null) {
                this.setNeedsRepaint(!newValue.equals(oldValue));
            } else {
                this.setNeedsRepaint(false);
            }
        }
        return newValue;
    }

    protected void fireNeedsRepaint(JComponent dirtyComponent) {
        for (Painter.Listener each : this.myListeners) {
            each.onNeedsRepaint(this, dirtyComponent);
        }
    }

    @Override
    public final void paint(Component component, Graphics2D g) {
        this.myNeedsRepaint = false;
        this.executePaint(component, g);
    }

    public abstract void executePaint(Component var1, Graphics2D var2);
}

