/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.CommonBundle;
import com.intellij.ide.ui.SplitterProportionsDataImpl;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.MasterDetails;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.DetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.MultiLineTooltipUI;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Icons;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Tag;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MasterDetailsComponent
implements Configurable,
PersistentStateComponent<UIState>,
DetailsComponent.Facade,
MasterDetails {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.ui.MasterDetailsComponent");
    protected static final Icon COPY_ICON = IconLoader.getIcon((String)"/actions/copy.png");
    protected NamedConfigurable myCurrentConfigurable;
    private final Splitter mySplitter = new Splitter(false, 0.2f);
    @NonNls
    public static final String TREE_OBJECT = "treeObject";
    @NonNls
    public static final String TREE_NAME = "treeName";
    protected History myHistory = new History(new Place.Navigator(){

        @Override
        public void setHistory(History history) {
            MasterDetailsComponent.this.myHistory = history;
        }

        @Override
        public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
            return null;
        }

        @Override
        public void queryPlace(@NotNull Place place) {
            if (place == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/ui/MasterDetailsComponent$1.queryPlace must not be null");
            }
        }
    });
    private JScrollPane myMaster;
    protected UIState myState = new UIState();
    protected Runnable TREE_UPDATER = new Runnable(){

        @Override
        public void run() {
            MyNode node = (MyNode)MasterDetailsComponent.this.myTree.getSelectionPath().getLastPathComponent();
            if (node != null) {
                MasterDetailsComponent.this.myState.lastEditedConfigurable = MasterDetailsComponent.getNodePathString(node);
                MasterDetailsComponent.this.myDetails.setText(node.getConfigurable().getBannerSlogan());
                ((DefaultTreeModel)MasterDetailsComponent.this.myTree.getModel()).reload(node);
                MasterDetailsComponent.this.fireItemsChangedExternally();
            }
        }
    };
    protected MyNode myRoot = new MyRootNode();
    protected Tree myTree = new Tree();
    private final DetailsComponent myDetails = new DetailsComponent();
    protected JPanel myWholePanel;
    public JPanel myNorthPanel = new JPanel(new BorderLayout());
    private final ArrayList<ItemsChangeListener> myListners = new ArrayList();
    private final Set<NamedConfigurable> myInitializedConfigurables = new HashSet();
    private boolean myHasDeletedItems;
    protected AutoScrollToSourceHandler myAutoScrollHandler;
    private boolean myToReinitWholePanel = true;

    public void setHistory(History history) {
        this.myHistory = history;
    }

    protected MasterDetailsComponent() {
        this.installAutoScroll();
        this.reinintWholePanelIfNeeded();
    }

    private void reinintWholePanelIfNeeded() {
        if (!this.myToReinitWholePanel) {
            return;
        }
        this.myWholePanel = new JPanel(new BorderLayout()){

            @Override
            public void addNotify() {
                super.addNotify();
                MasterDetailsComponent.this.addNotify();
            }
        };
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.myWholePanel.add((Component)this.mySplitter, "Center");
        JPanel left = new JPanel(new BorderLayout()){

            @Override
            public Dimension getMinimumSize() {
                Dimension original = super.getMinimumSize();
                return new Dimension(Math.max(original.width, 100), original.height);
            }
        };
        left.add((Component)this.myNorthPanel, "North");
        this.myMaster = new JScrollPane(this.myTree);
        left.add((Component)this.myMaster, "Center");
        this.mySplitter.setFirstComponent((JComponent)left);
        JPanel right = new JPanel(new BorderLayout());
        right.add((Component)this.myDetails.getComponent(), "Center");
        this.mySplitter.setSecondComponent((JComponent)right);
        GuiUtils.replaceJSplitPaneWithIDEASplitter(this.myWholePanel);
        this.myToReinitWholePanel = false;
    }

    private void installAutoScroll() {
        this.myAutoScrollHandler = new AutoScrollToSourceHandler(){

            @Override
            protected boolean isAutoScrollMode() {
                return MasterDetailsComponent.this.isAutoScrollEnabled();
            }

            @Override
            protected void setAutoScrollMode(boolean state) {
            }

            @Override
            protected void scrollToSource(Component tree) {
                MasterDetailsComponent.this.updateSelectionFromTree();
            }

            @Override
            protected boolean needToCheckFocus() {
                return false;
            }
        };
        this.myAutoScrollHandler.install(this.myTree);
    }

    protected void addNotify() {
        this.updateSelectionFromTree();
    }

    private void updateSelectionFromTree() {
        TreePath path;
        TreePath[] treePaths = this.myTree.getSelectionPaths();
        if (treePaths != null) {
            ArrayList<NamedConfigurable> selectedConfigurables = new ArrayList<NamedConfigurable>();
            for (TreePath path2 : treePaths) {
                Object lastPathComponent = path2.getLastPathComponent();
                if (!(lastPathComponent instanceof MyNode)) continue;
                selectedConfigurables.add(((MyNode)lastPathComponent).getConfigurable());
            }
            if (selectedConfigurables.size() > 1 && this.updateMultiSelection(selectedConfigurables)) {
                return;
            }
        }
        if ((path = this.myTree.getSelectionPath()) != null) {
            Object lastPathComp = path.getLastPathComponent();
            if (!(lastPathComp instanceof MyNode)) {
                return;
            }
            MyNode node = (MyNode)lastPathComp;
            this.setSelectedNode(node);
        } else {
            this.setSelectedNode(null);
        }
    }

    protected boolean updateMultiSelection(List<NamedConfigurable> selectedConfigurables) {
        return false;
    }

    @Override
    public DetailsComponent getDetailsComponent() {
        return this.myDetails;
    }

    public Splitter getSplitter() {
        return this.mySplitter;
    }

    protected boolean isAutoScrollEnabled() {
        return this.myHistory != null ? !this.myHistory.isNavigatingNow() : true;
    }

    private void initToolbar() {
        ArrayList<AnAction> actions = this.createActions(false);
        if (actions != null) {
            DefaultActionGroup group = new DefaultActionGroup();
            for (AnAction action : actions) {
                if (action instanceof ActionGroupWithPreselection) {
                    group.add(new MyActionGroupWrapper((ActionGroupWithPreselection)((Object)action)));
                    continue;
                }
                group.add(action);
            }
            JComponent component = ActionManager.getInstance().createActionToolbar("unknown", group, true).getComponent();
            this.myNorthPanel.add((Component)component, "North");
        }
    }

    public void addItemsChangeListener(ItemsChangeListener l) {
        this.myListners.add(l);
    }

    protected Dimension getPanelPrefferedSize() {
        return new Dimension(800, 600);
    }

    @Override
    public JComponent createComponent() {
        this.reinintWholePanelIfNeeded();
        this.updateSelectionFromTree();
        JPanel panel = new JPanel(new BorderLayout()){

            @Override
            public Dimension getPreferredSize() {
                return MasterDetailsComponent.this.getPanelPrefferedSize();
            }
        };
        panel.add((Component)this.myWholePanel, "Center");
        return panel;
    }

    @Override
    public boolean isModified() {
        if (this.myHasDeletedItems) {
            return true;
        }
        final boolean[] modified = new boolean[1];
        TreeUtil.traverseDepth(this.myRoot, new TreeUtil.Traverse(){

            @Override
            public boolean accept(Object node) {
                NamedConfigurable configurable;
                if (node instanceof MyNode && MasterDetailsComponent.this.isInitialized(configurable = ((MyNode)node).getConfigurable()) && configurable.isModified()) {
                    modified[0] = true;
                    return false;
                }
                return true;
            }
        });
        return modified[0];
    }

    protected boolean isInitialized(NamedConfigurable configurable) {
        return this.myInitializedConfigurables.contains(configurable);
    }

    @Override
    public void apply() throws ConfigurationException {
        this.processRemovedItems();
        final ConfigurationException[] ex = new ConfigurationException[1];
        TreeUtil.traverse(this.myRoot, new TreeUtil.Traverse(){

            @Override
            public boolean accept(Object node) {
                if (node instanceof MyNode) {
                    try {
                        NamedConfigurable configurable = ((MyNode)node).getConfigurable();
                        if (MasterDetailsComponent.this.isInitialized(configurable) && configurable.isModified()) {
                            configurable.apply();
                        }
                    }
                    catch (ConfigurationException e) {
                        ex[0] = e;
                        return false;
                    }
                }
                return true;
            }
        });
        if (ex[0] != null) {
            throw ex[0];
        }
        this.myHasDeletedItems = false;
    }

    protected abstract void processRemovedItems();

    protected abstract boolean wasObjectStored(Object var1);

    @Override
    public void reset() {
        this.myHasDeletedItems = false;
        ((DefaultTreeModel)this.myTree.getModel()).reload();
        this.myState.proportions.restoreSplitterProportions(this.myWholePanel);
        Enumeration<TreeNode> enumeration = this.myRoot.breadthFirstEnumeration();
        boolean selected = false;
        while (enumeration.hasMoreElements()) {
            MyNode node = (MyNode)enumeration.nextElement();
            if (node instanceof MyRootNode) continue;
            String path = MasterDetailsComponent.getNodePathString(node);
            if (selected || !Comparing.strEqual((String)path, (String)this.myState.lastEditedConfigurable)) continue;
            TreeUtil.selectInTree(node, false, this.myTree);
            selected = true;
        }
        if (!selected) {
            TreeUtil.selectFirstNode(this.myTree);
        }
        this.updateSelectionFromTree();
    }

    private static String getNodePathString(MyNode node) {
        String displayName;
        Object userObject;
        StringBuilder path = new StringBuilder();
        MyNode current = node;
        while (current != null && (userObject = current.getUserObject()) instanceof NamedConfigurable && !StringUtil.isEmptyOrSpaces((String)(displayName = current.getDisplayName()))) {
            if (path.length() > 0) {
                path.append('|');
            }
            path.append(displayName);
            TreeNode parent = current.getParent();
            if (!(parent instanceof MyNode)) break;
            current = (MyNode)parent;
        }
        return path.toString();
    }

    @Nullable
    protected PersistentStateComponent<?> getAdditionalSettings() {
        return null;
    }

    @Override
    public UIState getState() {
        Object state;
        this.myState.mySettingsElement = null;
        PersistentStateComponent<?> additionalSettings = this.getAdditionalSettings();
        if (additionalSettings != null && (state = additionalSettings.getState()) != null) {
            this.myState.mySettingsElement = XmlSerializer.serialize(state, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
        }
        return this.myState;
    }

    @Override
    public void loadState(UIState object) {
        Element settingsElement;
        this.myState.lastEditedConfigurable = object.lastEditedConfigurable;
        this.myState.proportions = object.proportions;
        PersistentStateComponent<?> additionalSettings = this.getAdditionalSettings();
        if (additionalSettings != null && (settingsElement = object.mySettingsElement) != null) {
            Class stateType = ReflectionUtil.getRawType((Type)ReflectionUtil.resolveVariableInHierarchy(PersistentStateComponent.class.getTypeParameters()[0], additionalSettings.getClass()));
            additionalSettings.loadState(XmlSerializer.deserialize((Element)settingsElement, (Class)stateType));
        }
    }

    @Override
    public void disposeUIResources() {
        this.myState.proportions.saveSplitterProportions(this.myWholePanel);
        this.myAutoScrollHandler.cancelAllRequests();
        this.myDetails.disposeUIResources();
        this.myInitializedConfigurables.clear();
        TreeUtil.traverseDepth(this.myRoot, new TreeUtil.Traverse(){

            @Override
            public boolean accept(Object node) {
                if (node instanceof MyNode) {
                    MyNode treeNode = (MyNode)node;
                    treeNode.getConfigurable().disposeUIResources();
                    if (!(treeNode instanceof MyRootNode)) {
                        treeNode.setUserObject(null);
                    }
                }
                return true;
            }
        });
        this.myRoot.removeAllChildren();
        this.myCurrentConfigurable = null;
    }

    @Nullable
    protected ArrayList<AnAction> createActions(boolean fromPopup) {
        return null;
    }

    protected void initTree() {
        ((DefaultTreeModel)this.myTree.getModel()).setRoot(this.myRoot);
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        UIUtil.setLineStyleAngled((JTree)this.myTree);
        TreeUtil.installActions(this.myTree);
        this.myTree.setCellRenderer(new ColoredTreeCellRenderer(){

            @Override
            public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (value instanceof MyNode) {
                    MyNode node = (MyNode)value;
                    this.setIcon(node.getConfigurable().getIcon(expanded));
                    Font font = UIUtil.getTreeFont();
                    if (node.isDisplayInBold()) {
                        this.setFont(font.deriveFont(1));
                    } else {
                        this.setFont(font.deriveFont(0));
                    }
                    this.append(node.getDisplayName(), node.isDisplayInBold() ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            }
        });
        this.initToolbar();
        ArrayList<AnAction> actions = this.createActions(true);
        if (actions != null) {
            DefaultActionGroup group = new DefaultActionGroup();
            for (AnAction action : actions) {
                group.add(action);
            }
            actions = this.getAdditionalActions();
            if (actions != null) {
                group.addSeparator();
                for (AnAction action : actions) {
                    group.add(action);
                }
            }
            PopupHandler.installPopupHandler(this.myTree, group, "unknown", ActionManager.getInstance());
        }
    }

    @Nullable
    protected ArrayList<AnAction> getAdditionalActions() {
        return null;
    }

    public void fireItemsChangeListener(Object editableObject) {
        for (ItemsChangeListener listener : this.myListners) {
            listener.itemChanged(editableObject);
        }
    }

    private void fireItemsChangedExternally() {
        for (ItemsChangeListener listener : this.myListners) {
            listener.itemsExternallyChanged();
        }
    }

    private void createUIComponents() {
        this.myTree = new Tree(){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                Dimension size = super.getPreferredScrollableViewportSize();
                size = new Dimension(size.width + 20, size.height);
                return size;
            }

            @Override
            public JToolTip createToolTip() {
                JToolTip toolTip = new JToolTip(){
                    {
                        this.setUI(new MultiLineTooltipUI());
                    }
                };
                toolTip.setComponent(this);
                return toolTip;
            }
        };
    }

    protected void addNode(MyNode nodeToAdd, MyNode parent) {
        parent.add(nodeToAdd);
        TreeUtil.sort(parent, new Comparator(){

            public int compare(Object o1, Object o2) {
                MyNode node1 = (MyNode)o1;
                MyNode node2 = (MyNode)o2;
                return node1.getDisplayName().compareToIgnoreCase(node2.getDisplayName());
            }
        });
        ((DefaultTreeModel)this.myTree.getModel()).reload(parent);
    }

    public ActionCallback selectNodeInTree(DefaultMutableTreeNode nodeToSelect) {
        return this.selectNodeInTree(nodeToSelect, true, false);
    }

    public ActionCallback selectNodeInTree(DefaultMutableTreeNode nodeToSelect, boolean requestFocus) {
        return this.selectNodeInTree(nodeToSelect, true, requestFocus);
    }

    public ActionCallback selectNodeInTree(DefaultMutableTreeNode nodeToSelect, boolean center, boolean requestFocus) {
        if (requestFocus) {
            this.myTree.requestFocus();
        }
        if (nodeToSelect != null) {
            return TreeUtil.selectInTree(nodeToSelect, requestFocus, this.myTree, center);
        }
        return TreeUtil.selectFirstNode(this.myTree);
    }

    @Nullable
    public Object getSelectedObject() {
        TreePath selectionPath = this.myTree.getSelectionPath();
        if (selectionPath != null && selectionPath.getLastPathComponent() instanceof MyNode) {
            MyNode node = (MyNode)selectionPath.getLastPathComponent();
            NamedConfigurable configurable = node.getConfigurable();
            LOG.assertTrue(configurable != null, (Object)"already disposed");
            return configurable.getEditableObject();
        }
        return null;
    }

    @Nullable
    public NamedConfigurable getSelectedConfugurable() {
        TreePath selectionPath = this.myTree.getSelectionPath();
        if (selectionPath != null) {
            MyNode node = (MyNode)selectionPath.getLastPathComponent();
            NamedConfigurable configurable = node.getConfigurable();
            LOG.assertTrue(configurable != null, (Object)"already disposed");
            return configurable;
        }
        return null;
    }

    public void selectNodeInTree(String displayName) {
        MyNode nodeByName = MasterDetailsComponent.findNodeByName(this.myRoot, displayName);
        this.selectNodeInTree(nodeByName, true);
    }

    public void selectNodeInTree(Object object) {
        this.selectNodeInTree(MasterDetailsComponent.findNodeByObject(this.myRoot, object), true);
    }

    @Nullable
    protected static MyNode findNodeByName(TreeNode root, final String profileName) {
        if (profileName == null) {
            return null;
        }
        return MasterDetailsComponent.findNodeByCondition(root, new Condition<NamedConfigurable>(){

            public boolean value(NamedConfigurable configurable) {
                return Comparing.strEqual((String)profileName, (String)configurable.getDisplayName());
            }
        });
    }

    @Nullable
    public static MyNode findNodeByObject(TreeNode root, final Object editableObject) {
        if (editableObject == null) {
            return null;
        }
        return MasterDetailsComponent.findNodeByCondition(root, new Condition<NamedConfigurable>(){

            public boolean value(NamedConfigurable configurable) {
                return Comparing.equal((Object)editableObject, configurable.getEditableObject());
            }
        });
    }

    protected static MyNode findNodeByCondition(TreeNode root, final Condition<NamedConfigurable> condition) {
        final MyNode[] nodeToSelect = new MyNode[1];
        TreeUtil.traverseDepth(root, new TreeUtil.Traverse(){

            @Override
            public boolean accept(Object node) {
                if (condition.value((Object)((MyNode)node).getConfigurable())) {
                    nodeToSelect[0] = (MyNode)node;
                    return false;
                }
                return true;
            }
        });
        return nodeToSelect[0];
    }

    protected void setSelectedNode(@Nullable MyNode node) {
        if (node != null) {
            this.myState.lastEditedConfigurable = MasterDetailsComponent.getNodePathString(node);
        }
        this.updateSelection(node != null ? node.getConfigurable() : null);
    }

    protected void updateSelection(@Nullable NamedConfigurable configurable) {
        this.myDetails.setText(configurable != null ? configurable.getBannerSlogan() : null);
        this.myCurrentConfigurable = configurable;
        if (configurable != null) {
            JComponent comp = configurable.createComponent();
            if (comp == null) {
                this.setEmpty();
                LOG.error("createComponent() returned null. configurable=" + configurable);
            } else {
                this.myDetails.setContent(comp);
                if (!this.isInitialized(configurable)) {
                    configurable.reset();
                    this.initializeConfigurable(configurable);
                }
                this.myHistory.pushPlaceForElement(TREE_OBJECT, configurable.getEditableObject());
            }
        } else {
            this.setEmpty();
        }
    }

    private void setEmpty() {
        this.myDetails.setContent(null);
        this.myDetails.setEmptyContentText(this.getEmptySelectionString());
    }

    @Override
    public String getHelpTopic() {
        if (this.myCurrentConfigurable != null) {
            return this.myCurrentConfigurable.getHelpTopic();
        }
        return null;
    }

    @Nullable
    protected String getEmptySelectionString() {
        return null;
    }

    protected void initializeConfigurable(NamedConfigurable configurable) {
        this.myInitializedConfigurables.add(configurable);
    }

    protected void checkApply(Set<MyNode> rootNodes, String prefix, String title) throws ConfigurationException {
        for (MyNode rootNode : rootNodes) {
            HashSet names = new HashSet();
            for (int i = 0; i < rootNode.getChildCount(); ++i) {
                MyNode node = (MyNode)rootNode.getChildAt(i);
                NamedConfigurable scopeConfigurable = node.getConfigurable();
                String name = scopeConfigurable.getDisplayName();
                if (name.trim().length() == 0) {
                    this.selectNodeInTree(node);
                    throw new ConfigurationException("Name should contain non-space characters");
                }
                if (names.contains(name)) {
                    NamedConfigurable selectedConfugurable = this.getSelectedConfugurable();
                    if (selectedConfugurable == null || !Comparing.strEqual((String)selectedConfugurable.getDisplayName(), (String)name)) {
                        this.selectNodeInTree(node);
                    }
                    throw new ConfigurationException(CommonBundle.message((String)"smth.already.exist.error.message", (Object[])new Object[]{prefix, name}), title);
                }
                names.add(name);
            }
        }
    }

    public Tree getTree() {
        return this.myTree;
    }

    protected void removePaths(TreePath ... paths) {
        DefaultMutableTreeNode parentNode = null;
        int idx = -1;
        for (TreePath path : paths) {
            MyNode node = (MyNode)path.getLastPathComponent();
            NamedConfigurable namedConfigurable = node.getConfigurable();
            Object editableObject = namedConfigurable.getEditableObject();
            parentNode = (MyNode)node.getParent();
            idx = parentNode.getIndex(node);
            parentNode.remove(node);
            this.myHasDeletedItems |= this.wasObjectStored(editableObject);
            this.fireItemsChangeListener(editableObject);
            this.onItemDeleted(editableObject);
            namedConfigurable.disposeUIResources();
        }
        ((DefaultTreeModel)this.myTree.getModel()).reload();
        if (parentNode != null && idx != -1) {
            TreeUtil.selectInTree((DefaultMutableTreeNode)(idx < parentNode.getChildCount() ? parentNode.getChildAt(idx) : parentNode), true, this.myTree);
        } else {
            TreeUtil.selectFirstNode(this.myTree);
        }
    }

    protected void onItemDeleted(Object item) {
    }

    @Override
    public JComponent getToolbar() {
        this.myToReinitWholePanel = true;
        return this.myNorthPanel;
    }

    @Override
    public JComponent getMaster() {
        this.myToReinitWholePanel = true;
        return this.myMaster;
    }

    @Override
    public DetailsComponent getDetails() {
        this.myToReinitWholePanel = true;
        return this.myDetails;
    }

    @Override
    public void initUi() {
        this.createComponent();
    }

    protected class MyActionGroupWrapper
    extends AnAction
    implements DumbAware {
        private ActionGroup myActionGroup;
        private ActionGroupWithPreselection myPreselection;

        public MyActionGroupWrapper(ActionGroupWithPreselection actionGroup) {
            this(actionGroup.getActionGroup());
            this.myPreselection = actionGroup;
        }

        public MyActionGroupWrapper(ActionGroup actionGroup) {
            super(actionGroup.getTemplatePresentation().getText(), actionGroup.getTemplatePresentation().getDescription(), actionGroup.getTemplatePresentation().getIcon());
            this.myActionGroup = actionGroup;
            this.registerCustomShortcutSet(actionGroup.getShortcutSet(), MasterDetailsComponent.this.myTree);
        }

        @Override
        public void actionPerformed(AnActionEvent e) {
            JBPopupFactory popupFactory = JBPopupFactory.getInstance();
            ListPopupStep step = popupFactory.createActionsStep(this.myActionGroup, e.getDataContext(), false, false, this.myActionGroup.getTemplatePresentation().getText(), MasterDetailsComponent.this.myTree, true, this.myPreselection != null ? this.myPreselection.getDefaultIndex() : 0, true);
            ListPopup listPopup = popupFactory.createListPopup(step);
            listPopup.setHandleAutoSelectionBeforeShow(true);
            listPopup.showUnderneathOf(MasterDetailsComponent.this.myNorthPanel);
        }
    }

    public static interface ActionGroupWithPreselection {
        public ActionGroup getActionGroup();

        public int getDefaultIndex();
    }

    protected static interface ItemsChangeListener {
        public void itemChanged(@Nullable Object var1);

        public void itemsExternallyChanged();
    }

    protected static class MyRootNode
    extends MyNode {
        public MyRootNode() {
            super(new NamedConfigurable(false, null){

                @Override
                public void setDisplayName(String name) {
                }

                public Object getEditableObject() {
                    return null;
                }

                @Override
                public String getBannerSlogan() {
                    return null;
                }

                @Override
                public String getDisplayName() {
                    return "";
                }

                @Override
                public Icon getIcon() {
                    return IconLoader.getIcon((String)"/general/applicationSettings.png");
                }

                @Override
                @Nullable
                @NonNls
                public String getHelpTopic() {
                    return null;
                }

                @Override
                public JComponent createOptionsPanel() {
                    return null;
                }

                @Override
                public boolean isModified() {
                    return false;
                }

                @Override
                public void apply() throws ConfigurationException {
                }

                @Override
                public void reset() {
                }

                @Override
                public void disposeUIResources() {
                }
            }, false);
        }
    }

    public static class MyNode
    extends DefaultMutableTreeNode {
        private boolean myDisplayInBold;

        public MyNode(NamedConfigurable userObject) {
            super(userObject);
        }

        public MyNode(NamedConfigurable userObject, boolean displayInBold) {
            super(userObject);
            this.myDisplayInBold = displayInBold;
        }

        @NotNull
        public String getDisplayName() {
            NamedConfigurable configurable = (NamedConfigurable)this.getUserObject();
            LOG.assertTrue(configurable != null, (Object)"Tree was already disposed");
            String string = configurable.getDisplayName();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/ui/MasterDetailsComponent$MyNode.getDisplayName must not return null");
            }
            return string;
        }

        public NamedConfigurable getConfigurable() {
            return (NamedConfigurable)this.getUserObject();
        }

        public boolean isDisplayInBold() {
            return this.myDisplayInBold;
        }

        public void setDisplayInBold(boolean displayInBold) {
            this.myDisplayInBold = displayInBold;
        }
    }

    protected class MyDeleteAction
    extends AnAction
    implements DumbAware {
        private final Condition<Object> myCondition;

        public MyDeleteAction(Condition<Object> availableCondition) {
            super(CommonBundle.message((String)"button.delete", (Object[])new Object[0]), CommonBundle.message((String)"button.delete", (Object[])new Object[0]), Icons.DELETE_ICON);
            this.registerCustomShortcutSet(CommonShortcuts.DELETE, MasterDetailsComponent.this.myTree);
            this.myCondition = availableCondition;
        }

        @Override
        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(false);
            TreePath[] selectionPath = MasterDetailsComponent.this.myTree.getSelectionPaths();
            if (selectionPath != null) {
                for (TreePath path : selectionPath) {
                    if (this.myCondition.value(path.getLastPathComponent())) continue;
                    return;
                }
                presentation.setEnabled(true);
            }
        }

        @Override
        public void actionPerformed(AnActionEvent e) {
            MasterDetailsComponent.this.removePaths(MasterDetailsComponent.this.myTree.getSelectionPaths());
        }
    }

    public static class UIState {
        @Tag(value="splitter-proportions")
        public SplitterProportionsDataImpl proportions = new SplitterProportionsDataImpl();
        @Tag(value="last-edited")
        public String lastEditedConfigurable;
        @Tag(value="settings")
        public Element mySettingsElement;
    }
}

