/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.wm.FocusCommand;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.PassThroughtIdeFocusManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IdeFocusManager {
    @NotNull
    public abstract ActionCallback requestFocus(@NotNull Component var1, boolean var2);

    @NotNull
    public abstract ActionCallback requestFocus(@NotNull FocusCommand var1, boolean var2);

    @Nullable
    public abstract JComponent getFocusTargetFor(@NotNull JComponent var1);

    public abstract void doWhenFocusSettlesDown(@NotNull Runnable var1);

    @Nullable
    public abstract Component getFocusedDescendantFor(Component var1);

    public abstract boolean dispatch(KeyEvent var1);

    public abstract void suspendKeyProcessingUntil(@NotNull ActionCallback var1);

    public abstract boolean isFocusBeingTransferred();

    public abstract ActionCallback requestDefaultFocus(boolean var1);

    public static IdeFocusManager getInstance(@Nullable Project project) {
        if (project == null) {
            return IdeFocusManager.getGlobalInstance();
        }
        if (project.isDisposed() || !project.isInitialized()) {
            return IdeFocusManager.getGlobalInstance();
        }
        return project.getComponent(IdeFocusManager.class);
    }

    @NotNull
    public static IdeFocusManager findInstanceByContext(@Nullable DataContext context) {
        IdeFocusManager instance = null;
        if (context != null) {
            instance = IdeFocusManager.getInstanceSafe(PlatformDataKeys.PROJECT.getData(context));
        }
        if (instance == null) {
            instance = IdeFocusManager.findByComponent(KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow());
        }
        if (instance == null) {
            instance = IdeFocusManager.getGlobalInstance();
        }
        IdeFocusManager ideFocusManager = instance;
        if (ideFocusManager == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/wm/IdeFocusManager.findInstanceByContext must not return null");
        }
        return ideFocusManager;
    }

    @NotNull
    public static IdeFocusManager findInstanceByComponent(@NotNull Component c) {
        if (c == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/IdeFocusManager.findInstanceByComponent must not be null");
        }
        IdeFocusManager instance = IdeFocusManager.findByComponent(c);
        IdeFocusManager ideFocusManager = instance != null ? instance : IdeFocusManager.findInstanceByContext(null);
        if (ideFocusManager == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/wm/IdeFocusManager.findInstanceByComponent must not return null");
        }
        return ideFocusManager;
    }

    @Nullable
    private static IdeFocusManager findByComponent(Component c) {
        Component parent = UIUtil.findUltimateParent((Component)c);
        if (parent instanceof IdeFrame) {
            return IdeFocusManager.getInstanceSafe(((IdeFrame)((Object)parent)).getProject());
        }
        return null;
    }

    @Nullable
    private static IdeFocusManager getInstanceSafe(@Nullable Project project) {
        if (project != null && !project.isDisposed() && project.isInitialized()) {
            return IdeFocusManager.getInstance(project);
        }
        return null;
    }

    @NotNull
    public static IdeFocusManager findInstance() {
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        IdeFocusManager ideFocusManager = owner != null ? IdeFocusManager.findInstanceByComponent(owner) : IdeFocusManager.findInstanceByContext(null);
        if (ideFocusManager == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/wm/IdeFocusManager.findInstance must not return null");
        }
        return ideFocusManager;
    }

    public abstract Expirable getTimestamp(boolean var1);

    @NotNull
    public static IdeFocusManager getGlobalInstance() {
        PassThroughtIdeFocusManager fm;
        Application app = ApplicationManager.getApplication();
        IdeFocusManager ideFocusManager = fm = app != null ? app.getComponent(IdeFocusManager.class) : PassThroughtIdeFocusManager.getInstance();
        if (fm == null) {
            fm = PassThroughtIdeFocusManager.getInstance();
        }
        PassThroughtIdeFocusManager passThroughtIdeFocusManager = fm;
        if (passThroughtIdeFocusManager == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/wm/IdeFocusManager.getGlobalInstance must not return null");
        }
        return passThroughtIdeFocusManager;
    }
}

