/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.references;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.PomNamedTarget;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomReferenceUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PomReference {
    public static final PomReference[] EMPTY_ARRAY = new PomReference[0];
    private final PsiElement myElement;
    private final TextRange myRangeInElement;

    protected PomReference(PsiElement element, TextRange rangeInElement) {
        this.myElement = element;
        this.myRangeInElement = rangeInElement;
    }

    protected PomReference(PsiElement element) {
        this(element, PomReferenceUtil.getDefaultRangeInElement(element));
    }

    public final PsiElement getElement() {
        return this.myElement;
    }

    public final TextRange getRangeInElement() {
        return this.myRangeInElement;
    }

    @Nullable
    public abstract PomTarget resolve();

    @NotNull
    public abstract PomTarget[] multiResolve();

    public abstract boolean isReferenceTo(@NotNull PomTarget var1);

    public void bindToElement(@NotNull PomTarget target) {
        if (target == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/pom/references/PomReference.bindToElement must not be null");
        }
        if (target instanceof PomNamedTarget) {
            PomNamedTarget namedTarget = (PomNamedTarget)target;
            PomReferenceUtil.changeContent(this, namedTarget.getName());
        }
        throw new UnsupportedOperationException("Cannot bind reference " + this + " to unnamed target " + target);
    }

    public void processVariants(@NotNull CompletionResultSet result, @NotNull CompletionParameters parameters) {
        LookupElement[] elements;
        if (result == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/pom/references/PomReference.processVariants must not be null");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/pom/references/PomReference.processVariants must not be null");
        }
        for (LookupElement element : elements = ApplicationManager.getApplication().runReadAction(new Computable<LookupElement[]>(){

            public LookupElement[] compute() {
                return PomReference.this.getVariants();
            }
        })) {
            result.addElement(element);
        }
    }

    @NotNull
    public LookupElement[] getVariants() {
        if (LookupElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/pom/references/PomReference.getVariants must not return null");
        }
        return LookupElement.EMPTY_ARRAY;
    }
}

