/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.projectImport;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectOpenProcessor {
    public static final ExtensionPointName<ProjectOpenProcessor> EXTENSION_POINT_NAME = new ExtensionPointName("com.intellij.projectOpenProcessor");

    public abstract String getName();

    @Nullable
    public abstract Icon getIcon();

    public abstract boolean canOpenProject(VirtualFile var1);

    @Nullable
    public abstract Project doOpenProject(@NotNull VirtualFile var1, Project var2, boolean var3);

    @Nullable
    public static ProjectOpenProcessor getImportProvider(VirtualFile file) {
        for (ProjectOpenProcessor provider : (ProjectOpenProcessor[])Extensions.getExtensions(EXTENSION_POINT_NAME)) {
            if (!provider.canOpenProject(file)) continue;
            return provider;
        }
        return null;
    }
}

