/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.RowIcon;
import com.intellij.util.IconUtil;
import com.intellij.util.Icons;
import com.intellij.util.PsiIconUtil;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public abstract class ElementBase
extends UserDataHolderBase
implements Iconable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.ElementBase");
    public static final int FLAGS_LOCKED = 2048;
    private static final List<IconLayer> ourIconLayers = new ArrayList<IconLayer>();

    @Override
    @Nullable
    public Icon getIcon(int flags) {
        if (!(this instanceof PsiElement)) {
            return null;
        }
        try {
            PsiElement element = (PsiElement)((Object)this);
            Icon providersIcon = PsiIconUtil.getProvidersIcon(element, flags);
            if (providersIcon != null) {
                return providersIcon instanceof RowIcon ? (RowIcon)providersIcon : ElementBase.createLayeredIcon(providersIcon, flags);
            }
            return this.getElementIcon(flags);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (IndexNotReadyException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    protected Icon getElementIcon(int flags) {
        int elementFlags;
        PsiElement element = (PsiElement)((Object)this);
        boolean isLocked = (flags & 2) != 0 && !element.isWritable();
        int n = elementFlags = isLocked ? 2048 : 0;
        if (!(element instanceof ItemPresentation) || ((ItemPresentation)((Object)element)).getIcon(false) == null) {
            if (element instanceof PsiFile) {
                PsiFile file = (PsiFile)element;
                VirtualFile virtualFile = file.getVirtualFile();
                Icon fileTypeIcon = virtualFile == null ? file.getFileType().getIcon() : IconUtil.getIcon(virtualFile, flags & 0xFFFFFFFD, file.getProject());
                return ElementBase.createLayeredIcon(fileTypeIcon, elementFlags);
            }
            return null;
        }
        RowIcon baseIcon = ElementBase.createLayeredIcon(((ItemPresentation)((Object)element)).getIcon(false), elementFlags);
        return baseIcon;
    }

    public static RowIcon createLayeredIcon(Icon icon, int flags) {
        if (flags != 0) {
            SmartList iconLayers = new SmartList();
            for (IconLayer l : ourIconLayers) {
                if ((flags & l.flagMask) == 0) continue;
                iconLayers.add(l.icon);
            }
            LayeredIcon layeredIcon = new LayeredIcon(1 + iconLayers.size());
            layeredIcon.setIcon(icon, 0);
            for (int i = 0; i < iconLayers.size(); ++i) {
                Icon icon1 = (Icon)iconLayers.get(i);
                layeredIcon.setIcon(icon1, i + 1);
            }
            icon = layeredIcon;
        }
        RowIcon baseIcon = new RowIcon(2);
        baseIcon.setIcon(icon, 0);
        return baseIcon;
    }

    public static int transformFlags(PsiElement element, int _flags) {
        boolean isLocked;
        int flags = 0;
        boolean bl = isLocked = (_flags & 2) != 0 && !element.isWritable();
        if (isLocked) {
            flags |= 0x800;
        }
        return flags;
    }

    public static void registerIconLayer(int flagMask, Icon icon) {
        for (IconLayer iconLayer : ourIconLayers) {
            if (iconLayer.flagMask != flagMask) continue;
            return;
        }
        ourIconLayers.add(new IconLayer(flagMask, icon));
    }

    static {
        ElementBase.registerIconLayer(2048, Icons.LOCKED_ICON);
    }

    private static class IconLayer {
        int flagMask;
        Icon icon;

        IconLayer(int flagMask, Icon icon) {
            this.flagMask = flagMask;
            this.icon = icon;
        }
    }
}

