/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.StringBuilderSpinAllocator;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class SimpleColoredText {
    private final ArrayList<String> myTexts;
    private final ArrayList<SimpleTextAttributes> myAttributes;
    private String myCachedToString;

    public SimpleColoredText() {
        this.myCachedToString = null;
        this.myTexts = new ArrayList(3);
        this.myAttributes = new ArrayList(3);
    }

    public SimpleColoredText(@NotNull String fragment, @NotNull SimpleTextAttributes attributes) {
        if (fragment == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/SimpleColoredText.<init> must not be null");
        }
        if (attributes == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ui/SimpleColoredText.<init> must not be null");
        }
        this();
        this.append(fragment, attributes);
    }

    public void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes) {
        if (fragment == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/SimpleColoredText.append must not be null");
        }
        if (attributes == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ui/SimpleColoredText.append must not be null");
        }
        this.myTexts.add(fragment);
        this.myCachedToString = null;
        this.myAttributes.add(attributes);
    }

    public void clear() {
        this.myTexts.clear();
        this.myCachedToString = null;
        this.myAttributes.clear();
    }

    public void appendToComponent(SimpleColoredComponent component) {
        int size = this.myTexts.size();
        for (int i = 0; i < size; ++i) {
            String text = this.myTexts.get(i);
            SimpleTextAttributes attribute = this.myAttributes.get(i);
            component.append(text, attribute);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this.myCachedToString == null) {
            StringBuilder builder = StringBuilderSpinAllocator.alloc();
            try {
                for (String text : this.myTexts) {
                    builder.append(text);
                }
                this.myCachedToString = builder.toString();
            }
            finally {
                StringBuilderSpinAllocator.dispose((StringBuilder)builder);
            }
        }
        return this.myCachedToString;
    }

    public ArrayList<String> getTexts() {
        return this.myTexts;
    }

    public ArrayList<SimpleTextAttributes> getAttributes() {
        return this.myAttributes;
    }
}

