/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.psi.PsiElement;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.PsiElementUsageTarget;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.rules.PsiElementUsage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class UsageViewManager {
    public static UsageViewManager getInstance(Project project) {
        return ServiceManager.getService(project, UsageViewManager.class);
    }

    @NotNull
    public abstract UsageView createUsageView(@NotNull UsageTarget[] var1, @NotNull Usage[] var2, @NotNull UsageViewPresentation var3, Factory<UsageSearcher> var4);

    @NotNull
    public abstract UsageView showUsages(@NotNull UsageTarget[] var1, @NotNull Usage[] var2, @NotNull UsageViewPresentation var3, Factory<UsageSearcher> var4);

    @NotNull
    public abstract UsageView showUsages(@NotNull UsageTarget[] var1, @NotNull Usage[] var2, @NotNull UsageViewPresentation var3);

    @Nullable(value="in case no usages found or usage view not shown for one usage")
    public abstract UsageView searchAndShowUsages(@NotNull UsageTarget[] var1, Factory<UsageSearcher> var2, boolean var3, boolean var4, @NotNull UsageViewPresentation var5, UsageViewStateListener var6);

    public abstract void setCurrentSearchCancelled(boolean var1);

    public abstract boolean searchHasBeenCancelled();

    public abstract void checkSearchCanceled() throws ProcessCanceledException;

    public abstract void searchAndShowUsages(@NotNull UsageTarget[] var1, @NotNull Factory<UsageSearcher> var2, @NotNull FindUsagesProcessPresentation var3, @NotNull UsageViewPresentation var4, UsageViewStateListener var5);

    @Nullable
    public abstract UsageView getSelectedUsageView();

    public static boolean isSelfUsage(Usage usage, UsageTarget[] searchForTarget) {
        boolean selfUsage = false;
        if (!(usage instanceof PsiElementUsage)) {
            return false;
        }
        PsiElement element = ((PsiElementUsage)usage).getElement();
        if (element == null) {
            return false;
        }
        for (UsageTarget ut : searchForTarget) {
            if (!(ut instanceof PsiElementUsageTarget) || !UsageViewManager.isSelfUsage(element, ((PsiElementUsageTarget)ut).getElement())) continue;
            selfUsage = true;
            break;
        }
        return selfUsage;
    }

    public static boolean isSelfUsage(PsiElement element, PsiElement psiElement) {
        return element.getParent() == psiElement;
    }

    public static interface UsageViewStateListener {
        public void usageViewCreated(UsageView var1);

        public void findingUsagesFinished(UsageView var1);
    }
}

