/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.GenericValue;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GenericValueUtil {
    public static NullableFunction<GenericValue, String> STRING_VALUE = new NullableFunction<GenericValue, String>(){

        public String fun(GenericValue genericValue) {
            return genericValue.getStringValue();
        }
    };
    public static NullableFunction<GenericValue, Object> OBJECT_VALUE = new NullableFunction<GenericValue, Object>(){

        public Object fun(GenericValue genericValue) {
            return genericValue.getValue();
        }
    };

    private GenericValueUtil() {
    }

    public static boolean containsString(List<? extends GenericValue<?>> list, String value) {
        for (GenericValue<?> o : list) {
            if (!Comparing.equal((String)value, (String)o.getStringValue())) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean containsValue(List<? extends GenericValue<? extends T>> list, T value) {
        for (GenericValue<T> o : list) {
            if (!Comparing.equal(value, o.getValue())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static <T> Collection<T> getValueCollection(Collection<? extends GenericValue<? extends T>> collection, Collection<T> result) {
        for (GenericValue<T> o : collection) {
            ContainerUtil.addIfNotNull(o.getValue(), result);
        }
        Collection<T> collection2 = result;
        if (collection2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/GenericValueUtil.getValueCollection must not return null");
        }
        return collection2;
    }

    @NotNull
    public static Collection<String> getStringCollection(Collection<? extends GenericValue> collection, Collection<String> result) {
        for (GenericValue genericValue : collection) {
            ContainerUtil.addIfNotNull((Object)genericValue.getStringValue(), result);
        }
        Collection<String> collection2 = result;
        if (collection2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/GenericValueUtil.getStringCollection must not return null");
        }
        return collection2;
    }

    @NotNull
    public static Collection<String> getClassStringCollection(Collection<? extends GenericValue> collection, Collection<String> result) {
        for (GenericValue genericValue : collection) {
            String value = genericValue.getStringValue();
            if (value == null) continue;
            result.add(value.replace('$', '.'));
        }
        Collection<String> collection2 = result;
        if (collection2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/GenericValueUtil.getClassStringCollection must not return null");
        }
        return collection2;
    }
}

