/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class TestClassesFilter {
    private final Map<String, List<Pattern>> myPatterns = new HashMap<String, List<Pattern>>();
    public static final TestClassesFilter EMPTY_CLASSES_FILTER = new TestClassesFilter(new HashMap<String, List<String>>());
    public static final ArrayList<Pattern> EMPTY_LIST = new ArrayList();
    private final List<Pattern> myAllPatterns = new ArrayList<Pattern>();
    public static final String ALL_EXCLUDE_DEFINED = "ALL_EXCLUDE_DEFINED";

    private TestClassesFilter(Map<String, List<String>> filters) {
        for (String groupName : filters.keySet()) {
            List<String> filterList = filters.get(groupName);
            this.addPatterns(groupName, filterList);
        }
    }

    TestClassesFilter(List<String> filterList) {
        this.addPatterns("", filterList);
    }

    private void addPatterns(String groupName, List<String> filterList) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        this.myPatterns.put(groupName, patterns);
        for (String aFilter : filterList) {
            String filter = aFilter.trim();
            if (filter.length() == 0) continue;
            filter = filter.replaceAll("\\*", ".\\*");
            Pattern pattern = Pattern.compile(filter);
            this.myAllPatterns.add(pattern);
            patterns.add(pattern);
        }
    }

    public static TestClassesFilter createOn(InputStreamReader inputStreamReader) {
        try {
            String line;
            HashMap<String, List<String>> groupNameToPatternsMap = new HashMap<String, List<String>>();
            String currentGroupName = "";
            LineNumberReader lineNumberReader = new LineNumberReader(inputStreamReader);
            while ((line = lineNumberReader.readLine()) != null) {
                if (line.startsWith("[") && line.endsWith("]")) {
                    currentGroupName = line.substring(1, line.length() - 1);
                    continue;
                }
                if (!groupNameToPatternsMap.containsKey(currentGroupName)) {
                    groupNameToPatternsMap.put(currentGroupName, new ArrayList());
                }
                ((List)groupNameToPatternsMap.get(currentGroupName)).add(line);
            }
            return new TestClassesFilter(groupNameToPatternsMap);
        }
        catch (IOException e) {
            return EMPTY_CLASSES_FILTER;
        }
    }

    private static boolean matches(Collection<Pattern> patterns, String className) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(className).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean matches(String className, String groupName) {
        List<Pattern> patterns = this.collectPatternsFor(groupName);
        boolean result = TestClassesFilter.matches(patterns, className);
        if (TestClassesFilter.isAllExcludeDefinedGroup(groupName)) {
            return !result;
        }
        return result;
    }

    private static boolean isAllExcludeDefinedGroup(String groupName) {
        if (groupName == null) {
            return true;
        }
        return ALL_EXCLUDE_DEFINED.equals(groupName);
    }

    private List<Pattern> collectPatternsFor(String groupName) {
        if (TestClassesFilter.isAllExcludeDefinedGroup(groupName)) {
            return this.myAllPatterns;
        }
        if (!this.myPatterns.containsKey(groupName)) {
            return EMPTY_LIST;
        }
        return this.myPatterns.get(groupName);
    }
}

