/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.ListScrollingUtil;
import com.intellij.util.containers.HashMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class SelectFontDialog
extends DialogWrapper {
    private JList myFontList;
    private JCheckBox myShowMonospacedCheckbox;
    private final List<String> myFontNames;
    private final String myInitialFontName;
    private final HashMap myNameToIsMonospaced;

    public SelectFontDialog(Component parent, List<String> fontNames, String initialFontName, HashMap nameToIsMonospaced) {
        super(parent, true);
        this.myNameToIsMonospaced = nameToIsMonospaced;
        this.setTitle(ApplicationBundle.message((String)"title.select.font", (Object[])new Object[0]));
        this.myFontNames = fontNames;
        this.myInitialFontName = initialFontName;
        this.init();
    }

    protected JComponent createCenterPanel() {
        this.myShowMonospacedCheckbox = new JCheckBox(ApplicationBundle.message((String)"checkbox.show.only.monospaced.fonts", (Object[])new Object[0]));
        final boolean useOnlyMonospacedFonts = EditorColorsManager.getInstance().isUseOnlyMonospacedFonts();
        this.myShowMonospacedCheckbox.setSelected(useOnlyMonospacedFonts);
        this.myFontList = new JList();
        this.myFontList.setModel(new DefaultListModel());
        this.fillList(useOnlyMonospacedFonts);
        this.myFontList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    SelectFontDialog.this.doOKAction();
                }
            }
        });
        this.myFontList.setCellRenderer(new MyListCellRenderer());
        this.myShowMonospacedCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean onlyMonospaced = SelectFontDialog.this.myShowMonospacedCheckbox.isSelected();
                EditorColorsManager.getInstance().setUseOnlyMonospacedFonts(onlyMonospaced);
                String selection = (String)SelectFontDialog.this.myFontList.getSelectedValue();
                SelectFontDialog.this.fillList(onlyMonospaced);
                if (selection != null) {
                    SelectFontDialog.this.myFontList.setSelectedValue(selection, true);
                    SelectFontDialog.this.myFontList.ensureIndexIsVisible(SelectFontDialog.this.myFontList.getSelectedIndex());
                }
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.myShowMonospacedCheckbox, "North");
        panel.add((Component)new JScrollPane(this.myFontList), "Center");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SelectFontDialog.this.myShowMonospacedCheckbox.setSelected(useOnlyMonospacedFonts);
            }
        });
        return panel;
    }

    private void fillList(boolean onlyMonospaced) {
        DefaultListModel model = (DefaultListModel)this.myFontList.getModel();
        model.removeAllElements();
        for (int i = 0; i < this.myFontNames.size(); ++i) {
            String fontName = this.myFontNames.get(i);
            if (onlyMonospaced && !Boolean.TRUE.equals(this.myNameToIsMonospaced.get((Object)fontName))) continue;
            model.addElement(fontName);
        }
    }

    public void show() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ListScrollingUtil.selectItem((JList)SelectFontDialog.this.myFontList, (Object)SelectFontDialog.this.myInitialFontName);
            }
        });
        super.show();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myFontList;
    }

    public String getFontName() {
        return (String)this.myFontList.getSelectedValue();
    }

    private static class MyListCellRenderer
    extends DefaultListCellRenderer {
        private MyListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            String fontName = (String)value;
            c.setFont(new Font(fontName, 0, 14));
            return c;
        }
    }
}

