/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ClickNavigator;
import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.ColorSettingsUtil;
import com.intellij.application.options.colors.EditorSchemeAttributeDescriptor;
import com.intellij.application.options.colors.FontEditorPreview;
import com.intellij.application.options.colors.PreviewPanel;
import com.intellij.application.options.colors.highlighting.HighlightData;
import com.intellij.application.options.colors.highlighting.HighlightsExtractor;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.options.colors.EditorHighlightingProvidingColorSettingsPage;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Alarm;
import com.intellij.util.EventDispatcher;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;

public class SimpleEditorPreview
implements PreviewPanel {
    private final ColorSettingsPage myPage;
    private final EditorEx myEditor;
    private final Alarm myBlinkingAlarm;
    private final HighlightData[] myHighlightData;
    private final ColorAndFontOptions myOptions;
    private final EventDispatcher<ColorAndFontSettingsListener> myDispatcher = EventDispatcher.create(ColorAndFontSettingsListener.class);
    private static final int BLINK_COUNT = 6;

    public SimpleEditorPreview(ColorAndFontOptions options, final ColorSettingsPage page) {
        this.myOptions = options;
        this.myPage = page;
        String text = page.getDemoText();
        HighlightsExtractor extractant2 = new HighlightsExtractor(page.getAdditionalHighlightingTagToDescriptorMap());
        this.myHighlightData = extractant2.extractHighlights(text);
        int selectedLine = -1;
        this.myEditor = (EditorEx)FontEditorPreview.createPreviewEditor(extractant2.cutDefinedTags(text), 10, 3, selectedLine, this.myOptions);
        FontEditorPreview.installTrafficLights(this.myEditor);
        this.myBlinkingAlarm = new Alarm().setActivationComponent(this.myEditor.getComponent());
        this.addMouseMotionListener(this.myEditor, page.getHighlighter(), this.myHighlightData, false);
        CaretListener listener = new CaretListener(){

            public void caretPositionChanged(CaretEvent e) {
                SimpleEditorPreview.this.navigate(SimpleEditorPreview.this.myEditor, true, e.getNewPosition(), page.getHighlighter(), SimpleEditorPreview.this.myHighlightData, false);
            }
        };
        this.myEditor.getCaretModel().addCaretListener(listener);
    }

    private void addMouseMotionListener(final Editor view, final SyntaxHighlighter highlighter, final HighlightData[] data, final boolean isBackgroundImportant) {
        view.getContentComponent().addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                LogicalPosition pos = view.xyToLogicalPosition(new Point(e.getX(), e.getY()));
                SimpleEditorPreview.this.navigate(view, false, pos, highlighter, data, isBackgroundImportant);
            }
        });
    }

    private void navigate(Editor editor, boolean select, LogicalPosition pos, SyntaxHighlighter highlighter, HighlightData[] data, boolean isBackgroundImportant) {
        int offset = editor.logicalPositionToOffset(pos);
        if (!isBackgroundImportant && editor.offsetToLogicalPosition((int)offset).column != pos.column && !select) {
            ClickNavigator.setCursor(editor, 2);
            return;
        }
        if (data != null) {
            for (HighlightData highlightData : data) {
                if (!ClickNavigator.highlightDataContainsOffset(highlightData, editor.logicalPositionToOffset(pos))) continue;
                if (!select) {
                    ClickNavigator.setCursor(editor, 12);
                } else {
                    ((ColorAndFontSettingsListener)this.myDispatcher.getMulticaster()).selectionInPreviewChanged(highlightData.getHighlightType());
                }
                return;
            }
        }
        if (highlighter != null) {
            HighlighterIterator itr = ((EditorEx)editor).getHighlighter().createIterator(offset);
            this.selectItem(itr, highlighter, select);
            if (!select) {
                ClickNavigator.setCursor(editor, 12);
            } else {
                ClickNavigator.setCursor(editor, 2);
            }
        }
    }

    private void selectItem(HighlighterIterator itr, SyntaxHighlighter highlighter, boolean select) {
        IElementType tokenType = itr.getTokenType();
        if (tokenType == null) {
            return;
        }
        String type = ClickNavigator.highlightingTypeFromTokenType(tokenType, highlighter);
        if (select) {
            ((ColorAndFontSettingsListener)this.myDispatcher.getMulticaster()).selectionInPreviewChanged(type);
        }
    }

    @Override
    public JComponent getPanel() {
        return this.myEditor.getComponent();
    }

    @Override
    public void updateView() {
        EditorColorsScheme scheme = this.myOptions.getSelectedScheme();
        this.myEditor.setColorsScheme(scheme);
        EditorHighlighter highlighter = null;
        if (this.myPage instanceof EditorHighlightingProvidingColorSettingsPage) {
            highlighter = ((EditorHighlightingProvidingColorSettingsPage)this.myPage).createEditorHighlighter(scheme);
        }
        if (highlighter == null) {
            SyntaxHighlighter pageHighlighter = this.myPage.getHighlighter();
            highlighter = HighlighterFactory.createHighlighter((SyntaxHighlighter)pageHighlighter, (EditorColorsScheme)scheme);
        }
        this.myEditor.setHighlighter(highlighter);
        this.updateHighlighters();
        this.myEditor.reinitSettings();
    }

    private void updateHighlighters() {
        HighlightData[] datum = this.myHighlightData;
        Map<TextAttributesKey, String> displayText = ColorSettingsUtil.keyToDisplayTextMap(this.myPage);
        for (HighlightData data : datum) {
            data.addHighlToView(this.myEditor, this.myOptions.getSelectedScheme(), displayText);
        }
    }

    @Override
    public void blinkSelectedHighlightType(Object description) {
        if (description instanceof EditorSchemeAttributeDescriptor) {
            String type = ((EditorSchemeAttributeDescriptor)description).getType();
            List<HighlightData> highlights = this.startBlinkingHighlights(this.myEditor, this.myHighlightData, type, this.myPage.getHighlighter(), true, this.myBlinkingAlarm, 6, this.myPage);
            SimpleEditorPreview.scrollHighlightInView(highlights, this.myEditor);
        }
    }

    private static void scrollHighlightInView(List<HighlightData> highlightDatas, Editor editor) {
        boolean needScroll = true;
        int minOffset = Integer.MAX_VALUE;
        for (HighlightData data : highlightDatas) {
            if (SimpleEditorPreview.isOffsetVisible(editor, data.getStartOffset())) {
                needScroll = false;
                break;
            }
            minOffset = Math.min(minOffset, data.getStartOffset());
        }
        if (needScroll && minOffset != Integer.MAX_VALUE) {
            LogicalPosition pos = editor.offsetToLogicalPosition(minOffset);
            editor.getScrollingModel().scrollTo(pos, ScrollType.MAKE_VISIBLE);
        }
    }

    private static boolean isOffsetVisible(Editor editor, int startOffset) {
        Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
        Point point = editor.logicalPositionToXY(editor.offsetToLogicalPosition(startOffset));
        return point.y >= visibleArea.y && point.y < visibleArea.x + visibleArea.height;
    }

    private void stopBlinking() {
        this.myBlinkingAlarm.cancelAllRequests();
    }

    private List<HighlightData> startBlinkingHighlights(final EditorEx editor, final HighlightData[] highlightDatum, final String attrKey, final SyntaxHighlighter highlighter, final boolean show, final Alarm alarm, final int count, final ColorSettingsPage page) {
        if (show && count <= 0) {
            return Collections.emptyList();
        }
        editor.getMarkupModel().removeAllHighlighters();
        boolean found = false;
        ArrayList<HighlightData> highlights = new ArrayList<HighlightData>();
        ArrayList<HighlightData> matchingHighlights = new ArrayList<HighlightData>();
        for (int i = 0; highlightDatum != null && i < highlightDatum.length; ++i) {
            HighlightData highlightData = highlightDatum[i];
            String type = highlightData.getHighlightType();
            highlights.add(highlightData);
            if (!show || !type.equals(attrKey)) continue;
            highlightData = new HighlightData(highlightData.getStartOffset(), highlightData.getEndOffset(), CodeInsightColors.BLINKING_HIGHLIGHTS_ATTRIBUTES);
            highlights.add(highlightData);
            matchingHighlights.add(highlightData);
            found = true;
        }
        if (!found && highlighter != null) {
            HighlighterIterator iterator = editor.getHighlighter().createIterator(0);
            do {
                TextAttributesKey[] tokenHighlights;
                IElementType tokenType = iterator.getTokenType();
                for (TextAttributesKey tokenHighlight : tokenHighlights = highlighter.getTokenHighlights(tokenType)) {
                    String type = tokenHighlight.getExternalName();
                    if (!show || type == null || !type.equals(attrKey)) continue;
                    HighlightData highlightData = new HighlightData(iterator.getStart(), iterator.getEnd(), CodeInsightColors.BLINKING_HIGHLIGHTS_ATTRIBUTES);
                    highlights.add(highlightData);
                    matchingHighlights.add(highlightData);
                }
                iterator.advance();
            } while (!iterator.atEnd());
        }
        Map<TextAttributesKey, String> displayText = ColorSettingsUtil.keyToDisplayTextMap(page);
        Collections.sort(highlights, new Comparator<HighlightData>(){

            @Override
            public int compare(HighlightData highlightData1, HighlightData highlightData2) {
                return highlightData1.getStartOffset() - highlightData2.getStartOffset();
            }
        });
        for (int i = highlights.size() - 1; i >= 0; --i) {
            HighlightData prevHighlightData;
            HighlightData highlightData = (HighlightData)highlights.get(i);
            int startOffset = highlightData.getStartOffset();
            HighlightData highlightData2 = prevHighlightData = i == 0 ? null : (HighlightData)highlights.get(i - 1);
            if (prevHighlightData != null && startOffset <= prevHighlightData.getEndOffset() && highlightData.getHighlightType().equals(prevHighlightData.getHighlightType())) {
                prevHighlightData.setEndOffset(highlightData.getEndOffset());
                continue;
            }
            highlightData.addHighlToView(editor, this.myOptions.getSelectedScheme(), displayText);
        }
        alarm.cancelAllRequests();
        alarm.addComponentRequest(new Runnable(){

            @Override
            public void run() {
                SimpleEditorPreview.this.startBlinkingHighlights(editor, highlightDatum, attrKey, highlighter, !show, alarm, count - 1, page);
            }
        }, 400);
        return matchingHighlights;
    }

    @Override
    public void addListener(ColorAndFontSettingsListener listener) {
        this.myDispatcher.addListener((EventListener)listener);
    }

    @Override
    public void disposeUIResources() {
        EditorFactory editorFactory = EditorFactory.getInstance();
        editorFactory.releaseEditor((Editor)this.myEditor);
        this.stopBlinking();
    }
}

