/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.util.proximity.PsiProximityComparator;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.FilteredQuery;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeInsightUtil {
    @Nullable
    public static PsiExpression findExpressionInRange(PsiFile file, int startOffset, int endOffset) {
        PsiJavaToken token;
        IElementType tokenType;
        PsiElement element2;
        if (!file.getViewProvider().getLanguages().contains(StdLanguages.JAVA)) {
            return null;
        }
        PsiExpression expression = CodeInsightUtil.findElementInRange(file, startOffset, endOffset, PsiExpression.class);
        if (expression == null && CodeInsightUtil.findStatementsInRange(file, startOffset, endOffset).length == 0 && (element2 = file.getViewProvider().findElementAt(endOffset - 1, StdLanguages.JAVA)) instanceof PsiJavaToken && (tokenType = (token = (PsiJavaToken)element2).getTokenType()).equals(JavaTokenType.SEMICOLON)) {
            expression = CodeInsightUtil.findElementInRange(file, startOffset, element2.getTextRange().getStartOffset(), PsiExpression.class);
        }
        if (expression instanceof PsiReferenceExpression && expression.getParent() instanceof PsiMethodCallExpression) {
            return null;
        }
        return expression;
    }

    public static <T extends PsiElement> T findElementInRange(PsiFile file, int startOffset, int endOffset, Class<T> klass) {
        return CodeInsightUtilBase.findElementInRange(file, startOffset, endOffset, klass, StdLanguages.JAVA);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PsiElement[] findStatementsInRange(@NotNull PsiFile file, int startOffset, int endOffset) {
        PsiElement[] psiElementArray;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/CodeInsightUtil.findStatementsInRange must not be null");
        }
        Language language = CodeInsightUtil.findJavaOrLikeLanguage(file);
        if (language == null) {
            psiElementArray = PsiElement.EMPTY_ARRAY;
            if (PsiElement.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/CodeInsightUtil.findStatementsInRange must not return null");
            return psiElementArray;
        }
        FileViewProvider viewProvider = file.getViewProvider();
        PsiElement element1 = viewProvider.findElementAt(startOffset, language);
        PsiElement element2 = viewProvider.findElementAt(endOffset - 1, language);
        if (element1 instanceof PsiWhiteSpace) {
            startOffset = element1.getTextRange().getEndOffset();
            element1 = file.findElementAt(startOffset);
        }
        if (element2 instanceof PsiWhiteSpace) {
            endOffset = element2.getTextRange().getStartOffset();
            element2 = file.findElementAt(endOffset - 1);
        }
        if (element1 == null || element2 == null) {
            psiElementArray = PsiElement.EMPTY_ARRAY;
            if (PsiElement.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/CodeInsightUtil.findStatementsInRange must not return null");
            return psiElementArray;
        }
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        if (parent == null) {
            psiElementArray = PsiElement.EMPTY_ARRAY;
            if (PsiElement.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/CodeInsightUtil.findStatementsInRange must not return null");
            return psiElementArray;
        }
        while (true) {
            if (parent instanceof PsiStatement) {
                parent = parent.getParent();
                break;
            }
            if (parent instanceof PsiCodeBlock || JspPsiUtil.isInJspFile((PsiElement)parent) && parent instanceof PsiFile || parent instanceof PsiCodeFragment) break;
            if (parent == null || parent instanceof PsiFile) {
                psiElementArray = PsiElement.EMPTY_ARRAY;
                if (PsiElement.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/CodeInsightUtil.findStatementsInRange must not return null");
                return psiElementArray;
            }
            parent = parent.getParent();
        }
        if (!parent.equals(element1)) {
            while (!parent.equals(element1.getParent())) {
                element1 = element1.getParent();
            }
        }
        if (startOffset != element1.getTextRange().getStartOffset()) {
            psiElementArray = PsiElement.EMPTY_ARRAY;
            if (PsiElement.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/CodeInsightUtil.findStatementsInRange must not return null");
            return psiElementArray;
        }
        if (!parent.equals(element2)) {
            while (!parent.equals(element2.getParent())) {
                element2 = element2.getParent();
            }
        }
        if (endOffset != element2.getTextRange().getEndOffset()) {
            psiElementArray = PsiElement.EMPTY_ARRAY;
            if (PsiElement.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/CodeInsightUtil.findStatementsInRange must not return null");
            return psiElementArray;
        }
        if (parent instanceof PsiCodeBlock && parent.getParent() instanceof PsiBlockStatement && element1 == ((PsiCodeBlock)parent).getLBrace() && element2 == ((PsiCodeBlock)parent).getRBrace()) {
            psiElementArray = new PsiElement[]{parent.getParent()};
            if (psiElementArray == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/CodeInsightUtil.findStatementsInRange must not return null");
            return psiElementArray;
        }
        PsiElement[] children = parent.getChildren();
        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
        boolean flag = false;
        for (PsiElement child : children) {
            if (child.equals(element1)) {
                flag = true;
            }
            if (flag && !(child instanceof PsiWhiteSpace)) {
                array.add(child);
            }
            if (child.equals(element2)) break;
        }
        for (PsiElement element : array) {
            if (element instanceof PsiStatement || element instanceof PsiWhiteSpace || element instanceof PsiComment) continue;
            psiElementArray = PsiElement.EMPTY_ARRAY;
            if (PsiElement.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/CodeInsightUtil.findStatementsInRange must not return null");
            return psiElementArray;
        }
        psiElementArray = array.toArray(new PsiElement[array.size()]);
        if (psiElementArray != null) return psiElementArray;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/CodeInsightUtil.findStatementsInRange must not return null");
    }

    @Nullable
    public static Language findJavaOrLikeLanguage(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/CodeInsightUtil.findJavaOrLikeLanguage must not be null");
        }
        Set languages = file.getViewProvider().getLanguages();
        for (Language language : languages) {
            if (language != StdLanguages.JAVA) continue;
            return language;
        }
        for (Language language : languages) {
            if (!language.isKindOf(StdLanguages.JAVA)) continue;
            return language;
        }
        return null;
    }

    public static void sortIdenticalShortNameClasses(PsiClass[] classes, @NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/CodeInsightUtil.sortIdenticalShortNameClasses must not be null");
        }
        if (classes.length <= 1) {
            return;
        }
        Arrays.sort(classes, new PsiProximityComparator(context));
    }

    public static PsiExpression[] findExpressionOccurrences(PsiElement scope, PsiExpression expr) {
        ArrayList<PsiExpression> array = new ArrayList<PsiExpression>();
        CodeInsightUtil.addExpressionOccurrences(RefactoringUtil.unparenthesizeExpression(expr), array, scope);
        return array.toArray(new PsiExpression[array.size()]);
    }

    private static void addExpressionOccurrences(PsiExpression expr, List<PsiExpression> array, PsiElement scope) {
        PsiElement[] children;
        for (PsiElement child : children = scope.getChildren()) {
            if (child instanceof PsiExpression && CodeInsightUtil.areExpressionsEquivalent(RefactoringUtil.unparenthesizeExpression((PsiExpression)child), expr)) {
                array.add((PsiExpression)child);
                continue;
            }
            CodeInsightUtil.addExpressionOccurrences(expr, array, child);
        }
    }

    public static PsiExpression[] findReferenceExpressions(PsiElement scope, PsiElement referee) {
        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
        CodeInsightUtil.addReferenceExpressions(array, scope, referee);
        return array.toArray(new PsiExpression[array.size()]);
    }

    private static void addReferenceExpressions(ArrayList<PsiElement> array, PsiElement scope, PsiElement referee) {
        PsiElement[] children;
        for (PsiElement child : children = scope.getChildren()) {
            PsiElement ref;
            if (child instanceof PsiReferenceExpression && (ref = ((PsiReferenceExpression)child).resolve()) != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)ref, (PsiElement)referee)) {
                array.add(child);
            }
            CodeInsightUtil.addReferenceExpressions(array, child, referee);
        }
    }

    public static boolean areExpressionsEquivalent(PsiExpression expr1, PsiExpression expr2) {
        return PsiEquivalenceUtil.areElementsEquivalent((PsiElement)expr1, (PsiElement)expr2);
    }

    public static Editor positionCursor(Project project, PsiFile targetFile, PsiElement element) {
        TextRange range = element.getTextRange();
        int textOffset = range.getStartOffset();
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, targetFile.getVirtualFile(), textOffset);
        return FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
    }

    public static boolean preparePsiElementsForWrite(PsiElement ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/CodeInsightUtil.preparePsiElementsForWrite must not be null");
        }
        return CodeInsightUtilBase.preparePsiElementsForWrite(Arrays.asList(elements));
    }

    public static Set<PsiType> addSubtypes(PsiType psiType, final PsiElement context, boolean getRawSubtypes, Condition<String> shortNameCondition) {
        int arrayDim = psiType.getArrayDimensions();
        if (!((psiType = psiType.getDeepComponentType()) instanceof PsiClassType)) {
            return Collections.emptySet();
        }
        final PsiClassType baseType = (PsiClassType)psiType;
        PsiClassType.ClassResolveResult baseResult = (PsiClassType.ClassResolveResult)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClassType.ClassResolveResult>(){

            public PsiClassType.ClassResolveResult compute() {
                return JavaCompletionUtil.originalize(baseType).resolveGenerics();
            }
        });
        PsiClass baseClass = baseResult.getElement();
        PsiSubstitutor baseSubstitutor = baseResult.getSubstitutor();
        if (baseClass == null) {
            return Collections.emptySet();
        }
        HashSet<PsiType> result = new HashSet<PsiType>();
        GlobalSearchScope scope = (GlobalSearchScope)ApplicationManager.getApplication().runReadAction((Computable)new Computable<GlobalSearchScope>(){

            public GlobalSearchScope compute() {
                return context.getResolveScope();
            }
        });
        Query baseQuery = ClassInheritorsSearch.search((ClassInheritorsSearch.SearchParameters)new ClassInheritorsSearch.SearchParameters(baseClass, (SearchScope)scope, true, false, false, shortNameCondition));
        FilteredQuery query = new FilteredQuery(baseQuery, (Condition)new Condition<PsiClass>(){

            public boolean value(PsiClass psiClass) {
                return !(psiClass instanceof PsiTypeParameter);
            }
        });
        query.forEach(CodeInsightUtil.createInheritorsProcessor(context, baseType, arrayDim, getRawSubtypes, result, baseClass, baseSubstitutor));
        return result;
    }

    public static Processor<PsiClass> createInheritorsProcessor(final PsiElement context, final PsiClassType baseType, final int arrayDim, final boolean getRawSubtypes, final Set<PsiType> result, final @NotNull PsiClass baseClass, final PsiSubstitutor baseSubstitutor) {
        if (baseClass == null) {
            throw new IllegalArgumentException("Argument 5 for @NotNull parameter of com/intellij/codeInsight/CodeInsightUtil.createInheritorsProcessor must not be null");
        }
        final PsiManager manager = context.getManager();
        final JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
        final PsiResolveHelper resolveHelper = facade.getResolveHelper();
        return new Processor<PsiClass>(){

            public boolean process(final PsiClass inheritor) {
                ProgressManager.checkCanceled();
                return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                    public Boolean compute() {
                        if (!(context.isValid() && inheritor.isValid() && facade.getResolveHelper().isAccessible((PsiMember)inheritor, context, null))) {
                            return true;
                        }
                        if (inheritor.getQualifiedName() == null && !manager.areElementsEquivalent((PsiElement)inheritor.getContainingFile(), (PsiElement)context.getContainingFile().getOriginalFile())) {
                            return true;
                        }
                        if (JavaCompletionUtil.isInExcludedPackage(inheritor)) {
                            return true;
                        }
                        PsiSubstitutor superSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)baseClass, (PsiClass)inheritor, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                        if (superSubstitutor == null) {
                            return true;
                        }
                        if (getRawSubtypes) {
                            result.add(CodeInsightUtil.createType(inheritor, facade.getElementFactory().createRawSubstitutor((PsiTypeParameterListOwner)inheritor), arrayDim));
                            return true;
                        }
                        PsiSubstitutor inheritorSubstitutor = PsiSubstitutor.EMPTY;
                        block0: for (PsiTypeParameter inheritorParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)inheritor)) {
                            for (PsiTypeParameter baseParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)baseClass)) {
                                PsiType substitution;
                                PsiType substituted = superSubstitutor.substitute(baseParameter);
                                PsiType arg = baseSubstitutor.substitute(baseParameter);
                                if (arg instanceof PsiWildcardType) {
                                    arg = ((PsiWildcardType)arg).getExtendsBound();
                                }
                                if (PsiType.NULL.equals(substitution = resolveHelper.getSubstitutionForTypeParameter(inheritorParameter, substituted, arg, true, PsiUtil.getLanguageLevel((PsiElement)context))) || substitution instanceof PsiWildcardType) continue;
                                if (substitution == null) {
                                    result.add(CodeInsightUtil.createType(inheritor, facade.getElementFactory().createRawSubstitutor((PsiTypeParameterListOwner)inheritor), arrayDim));
                                    return true;
                                }
                                inheritorSubstitutor = inheritorSubstitutor.put(inheritorParameter, substitution);
                                continue block0;
                            }
                        }
                        PsiType toAdd = CodeInsightUtil.createType(inheritor, inheritorSubstitutor, arrayDim);
                        if (baseType.isAssignableFrom(toAdd)) {
                            result.add(toAdd);
                        }
                        return true;
                    }
                });
            }
        };
    }

    private static PsiType createType(PsiClass cls, PsiSubstitutor currentSubstitutor, int arrayDim) {
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)cls.getProject()).getElementFactory();
        PsiClassType newType = elementFactory.createType(cls, currentSubstitutor);
        for (int i = 0; i < arrayDim; ++i) {
            newType = newType.createArrayType();
        }
        return newType;
    }
}

