/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.CompletionVariant;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.paths.PsiDynaReference;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.util.PairConsumer;
import com.intellij.util.ProcessingContext;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public class LegacyCompletionContributor
extends CompletionContributor {
    public static boolean DEBUG = false;

    public LegacyCompletionContributor() {
        PsiElementPattern.Capture everywhere = PlatformPatterns.psiElement();
        this.extend(CompletionType.BASIC, (ElementPattern)everywhere, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            public void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext matchingContext, @NotNull CompletionResultSet _result) {
                if (parameters == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/LegacyCompletionContributor$1.addCompletions must not be null");
                }
                if (_result == null) {
                    throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/completion/LegacyCompletionContributor$1.addCompletions must not be null");
                }
                final PsiFile file = parameters.getOriginalFile();
                int startOffset = parameters.getOffset();
                PsiElement insertedElement = parameters.getPosition();
                CompletionData completionData = (CompletionData)ApplicationManager.getApplication().runReadAction((Computable)new Computable<CompletionData>(){

                    public CompletionData compute() {
                        return CompletionUtil.getCompletionDataByElement(file);
                    }
                });
                CompletionResultSet result = _result.withPrefixMatcher(completionData == null ? CompletionData.findPrefixStatic(insertedElement, startOffset) : completionData.findPrefix(insertedElement, startOffset));
                if (completionData == null) {
                    completionData = (CompletionData)ApplicationManager.getApplication().runReadAction((Computable)new Computable<CompletionData>(){

                        public CompletionData compute() {
                            return CompletionUtil.getCompletionDataByElement(file);
                        }
                    });
                }
                if (completionData == null) {
                    return;
                }
                LegacyCompletionContributor.completeReference(parameters, result, completionData);
                LinkedHashSet<LookupElement> lookupSet = new LinkedHashSet<LookupElement>();
                HashSet<CompletionVariant> keywordVariants = new HashSet<CompletionVariant>();
                completionData.addKeywordVariants(keywordVariants, insertedElement, parameters.getOriginalFile());
                completionData.completeKeywordsBySet(lookupSet, keywordVariants, insertedElement, result.getPrefixMatcher(), parameters.getOriginalFile());
                for (LookupElement item : lookupSet) {
                    result.addElement(item);
                }
            }
        });
    }

    public static boolean completeReference(final CompletionParameters parameters, CompletionResultSet result, final CompletionData completionData) {
        final Ref hasVariants = Ref.create((Object)false);
        LegacyCompletionContributor.processReferences(parameters, result, completionData, new PairConsumer<PsiReference, CompletionResultSet>(){

            public void consume(PsiReference reference, CompletionResultSet resultSet) {
                LinkedHashSet<LookupElement> lookupSet = new LinkedHashSet<LookupElement>();
                completionData.completeReference(reference, lookupSet, parameters.getPosition(), parameters.getOriginalFile(), parameters.getOffset());
                for (LookupElement item : lookupSet) {
                    if (!resultSet.getPrefixMatcher().prefixMatches(item)) continue;
                    hasVariants.set((Object)true);
                    resultSet.addElement(item);
                }
            }
        });
        return (Boolean)hasVariants.get();
    }

    public static void processReferences(final CompletionParameters parameters, CompletionResultSet result, CompletionData completionData, PairConsumer<PsiReference, CompletionResultSet> consumer) {
        final int startOffset = parameters.getOffset();
        PsiReference ref = (PsiReference)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiReference>(){

            public PsiReference compute() {
                return parameters.getPosition().getContainingFile().findReferenceAt(startOffset);
            }
        });
        if (ref instanceof PsiMultiReference) {
            for (PsiReference reference : completionData.getReferences((PsiMultiReference)ref)) {
                LegacyCompletionContributor.processReference(result, startOffset, consumer, reference);
            }
        } else if (ref instanceof PsiDynaReference) {
            int offset = startOffset - ref.getElement().getTextRange().getStartOffset();
            for (PsiReference reference : ((PsiDynaReference)ref).getReferences()) {
                if (!reference.getRangeInElement().contains(offset)) continue;
                LegacyCompletionContributor.processReference(result, startOffset, consumer, reference);
            }
        } else if (ref != null) {
            LegacyCompletionContributor.processReference(result, startOffset, consumer, ref);
        }
    }

    private static void processReference(CompletionResultSet result, int startOffset, PairConsumer<PsiReference, CompletionResultSet> consumer, final PsiReference reference) {
        final int offsetInElement = startOffset - reference.getElement().getTextRange().getStartOffset();
        String prefix = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return reference.getElement().getText().substring(reference.getRangeInElement().getStartOffset(), offsetInElement);
            }
        });
        consumer.consume((Object)reference, (Object)result.withPrefixMatcher(prefix));
    }
}

