/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.DefaultInsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.simple.RParenthTailType;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

class SmartCastProvider
extends CompletionProvider<CompletionParameters> {
    static final PsiElementPattern.Capture<PsiElement> INSIDE_TYPECAST_TYPE = (PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withText("(")).withParent(PsiTypeCastExpression.class));
    public static final Key<Boolean> TYPE_CAST = Key.create((String)"TYPE_CAST");

    SmartCastProvider() {
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/SmartCastProvider.addCompletions must not be null");
        }
        if (result == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/completion/SmartCastProvider.addCompletions must not be null");
        }
        for (ExpectedTypeInfo type : JavaSmartCompletionContributor.getExpectedTypes(parameters)) {
            if (type.getType() == PsiType.VOID) continue;
            final boolean overwrite = INSIDE_TYPECAST_TYPE.accepts((Object)parameters.getOriginalPosition());
            LookupElement item = AutoCompletionPolicy.ALWAYS_AUTOCOMPLETE.applyPolicy((LookupElement)new LookupElementDecorator<LookupItem>(PsiTypeLookupItem.createLookupItem(type.getDefaultType(), parameters.getPosition())){

                public void handleInsert(InsertionContext context) {
                    FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.smarttype.casting");
                    Editor editor = context.getEditor();
                    Document document = editor.getDocument();
                    if (overwrite) {
                        document.deleteString(context.getSelectionEndOffset(), context.getOffsetMap().getOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET));
                    }
                    CodeStyleSettings csSettings = CodeStyleSettingsManager.getSettings((Project)context.getProject());
                    int oldTail = context.getTailOffset();
                    context.setTailOffset(RParenthTailType.addRParenth(editor, oldTail, csSettings.SPACE_WITHIN_CAST_PARENTHESES));
                    LookupItem typeItem = (LookupItem)this.getDelegate();
                    InsertionContext typeContext = CompletionUtil.newContext(context, (LookupElement)typeItem, context.getStartOffset(), oldTail);
                    new DefaultInsertHandler().handleInsert(typeContext, (LookupElement)typeItem);
                    PostprocessReformattingAspect.getInstance(context.getProject()).doPostponedFormatting();
                    if (csSettings.SPACE_AFTER_TYPE_CAST) {
                        context.setTailOffset(TailType.insertChar((Editor)editor, (int)context.getTailOffset(), (char)' '));
                    }
                    editor.getCaretModel().moveToOffset(context.getTailOffset());
                    editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                }
            });
            item.putUserData(TYPE_CAST, (Object)Boolean.TRUE);
            result.addElement(item);
        }
    }
}

