/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.cache.impl.id.IdTableBuilding;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HippieWordCompletionHandler
implements CodeInsightActionHandler {
    private static final Key<CompletionState> KEY_STATE = new Key("HIPPIE_COMPLETION_STATE");
    private final Direction myDirection;

    public HippieWordCompletionHandler(Direction direction) {
        this.myDirection = direction;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        CompletionVariant nextVariant;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/actions/HippieWordCompletionHandler.invoke must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/completion/actions/HippieWordCompletionHandler.invoke must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/completion/actions/HippieWordCompletionHandler.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(file)) {
            return;
        }
        CharSequence charsSequence = editor.getDocument().getCharsSequence();
        CompletionData data = HippieWordCompletionHandler.computeData(editor, charsSequence);
        String currentPrefix = data.myPrefix;
        CompletionState completionState = HippieWordCompletionHandler.getCompletionState(editor);
        String oldPrefix = completionState.oldPrefix;
        CompletionVariant lastProposedVariant = completionState.lastProposedVariant;
        if (lastProposedVariant == null || oldPrefix == null || !new CamelHumpMatcher(oldPrefix).prefixMatches(currentPrefix) || oldPrefix.length() == 0 || !currentPrefix.equals(lastProposedVariant.variant)) {
            completionState.oldPrefix = oldPrefix = currentPrefix;
            lastProposedVariant = null;
        }
        if ((nextVariant = this.computeNextVariant(editor, oldPrefix, lastProposedVariant, data)) == null) {
            return;
        }
        int replacementEnd = data.startOffset + data.myWordUnderCursor.length();
        editor.getDocument().replaceString(data.startOffset, replacementEnd, (CharSequence)nextVariant.variant);
        editor.getCaretModel().moveToOffset(data.startOffset + nextVariant.variant.length());
        completionState.lastProposedVariant = nextVariant;
        HippieWordCompletionHandler.highlightWord(editor, nextVariant, project, data);
    }

    private static void highlightWord(Editor editor, CompletionVariant variant, Project project, CompletionData data) {
        int delta = data.startOffset < variant.offset ? variant.variant.length() - data.myWordUnderCursor.length() : 0;
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        EditorColorsManager colorManager = EditorColorsManager.getInstance();
        TextAttributes attributes = colorManager.getGlobalScheme().getAttributes(EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES);
        highlightManager.addOccurrenceHighlight(editor, variant.offset + delta, variant.offset + variant.variant.length() + delta, attributes, 2, null, null);
    }

    @Nullable
    private CompletionVariant computeNextVariant(Editor editor, @Nullable String prefix, @Nullable CompletionVariant lastProposedVariant, CompletionData data) {
        CompletionVariant result;
        List<CompletionVariant> variants = HippieWordCompletionHandler.computeVariants(editor, prefix);
        if (variants.isEmpty()) {
            return null;
        }
        for (CompletionVariant variant : variants) {
            if (lastProposedVariant == null || !variant.variant.equals(lastProposedVariant.variant)) continue;
            if (lastProposedVariant.offset > data.startOffset && variant.offset > data.startOffset) {
                lastProposedVariant = variant;
            }
            if (lastProposedVariant.offset >= data.startOffset || variant.offset >= data.startOffset) continue;
            lastProposedVariant = variant;
        }
        if (lastProposedVariant == null) {
            result = null;
            if (this.myDirection == Direction.FORWARD) {
                for (CompletionVariant variant : variants) {
                    if (variant.offset < data.startOffset) {
                        result = variant;
                        continue;
                    }
                    if (result != null) continue;
                    result = variant;
                    break;
                }
            } else {
                for (CompletionVariant variant : variants) {
                    if (variant.offset <= data.startOffset) continue;
                    return variant;
                }
                return variants.iterator().next();
            }
            return result;
        }
        if (this.myDirection == Direction.FORWARD) {
            result = null;
            for (CompletionVariant variant : variants) {
                if (variant == lastProposedVariant) {
                    if (result == null) {
                        return variants.get(variants.size() - 1);
                    }
                    return result;
                }
                result = variant;
            }
            return variants.get(variants.size() - 1);
        }
        Iterator<CompletionVariant> i = variants.iterator();
        while (i.hasNext()) {
            CompletionVariant variant;
            variant = i.next();
            if (variant != lastProposedVariant) continue;
            if (i.hasNext()) {
                return i.next();
            }
            return variants.iterator().next();
        }
        return null;
    }

    private static List<CompletionVariant> computeVariants(final @NotNull Editor editor, @Nullable String prefix) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/actions/HippieWordCompletionHandler.computeVariants must not be null");
        }
        final CamelHumpMatcher matcher = new CamelHumpMatcher(prefix == null ? "" : prefix);
        CharSequence chars = editor.getDocument().getCharsSequence();
        final ArrayList words = new ArrayList();
        final ArrayList afterWords = new ArrayList();
        IdTableBuilding.scanWords(new IdTableBuilding.ScanWordProcessor(){

            @Override
            public void run(CharSequence chars, int start, int end) {
                int caretOffset = editor.getCaretModel().getOffset();
                if (start <= caretOffset && end >= caretOffset) {
                    return;
                }
                String word = ((Object)chars.subSequence(start, end)).toString();
                if (!matcher.prefixMatches(word)) {
                    return;
                }
                CompletionVariant v = new CompletionVariant(word, start);
                if (end > caretOffset) {
                    afterWords.add(v);
                } else {
                    words.add(v);
                }
            }
        }, chars, 0, chars.length());
        HashSet<String> allWords = new HashSet<String>();
        ArrayList<CompletionVariant> result = new ArrayList<CompletionVariant>();
        Collections.reverse(words);
        for (CompletionVariant variant : words) {
            if (allWords.contains(variant.variant)) continue;
            result.add(variant);
            allWords.add(variant.variant);
        }
        Collections.reverse(result);
        allWords.clear();
        for (CompletionVariant variant : afterWords) {
            if (allWords.contains(variant.variant)) continue;
            result.add(variant);
            allWords.add(variant.variant);
        }
        return result;
    }

    private static CompletionData computeData(Editor editor, CharSequence charsSequence) {
        int endOffset;
        int offset;
        for (offset = editor.getCaretModel().getOffset(); offset > 1 && Character.isJavaIdentifierPart(charsSequence.charAt(offset - 1)); --offset) {
        }
        CompletionData data = new CompletionData();
        data.startOffset = offset;
        for (endOffset = offset; charsSequence.length() > endOffset && Character.isJavaIdentifierPart(charsSequence.charAt(endOffset)) && endOffset < editor.getDocument().getTextLength(); ++endOffset) {
            if (endOffset != editor.getCaretModel().getOffset()) continue;
            data.myPrefix = ((Object)charsSequence.subSequence(offset, endOffset)).toString();
        }
        data.myWordUnderCursor = ((Object)charsSequence.subSequence(offset, endOffset)).toString();
        if (data.myPrefix == null) {
            data.myPrefix = data.myWordUnderCursor;
        }
        return data;
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static CompletionState getCompletionState(Editor editor) {
        CompletionState state = (CompletionState)editor.getUserData(KEY_STATE);
        if (state == null) {
            state = new CompletionState();
            editor.putUserData(KEY_STATE, (Object)state);
        }
        return state;
    }

    private static class CompletionState {
        public String oldPrefix;
        public CompletionVariant lastProposedVariant;

        private CompletionState() {
        }
    }

    public static class CompletionVariant {
        public final String variant;
        public final int offset;

        public CompletionVariant(String variant, int offset) {
            this.variant = variant;
            this.offset = offset;
        }
    }

    private static class CompletionData {
        public String myPrefix;
        public String myWordUnderCursor;
        public int startOffset;

        private CompletionData() {
        }
    }

    static enum Direction {
        FORWARD,
        BACKWARD;

    }
}

