/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.DirtyScopeTrackingHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.WeakHashMap;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileStatusMap
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.FileStatusMap");
    private final Project myProject;
    private final Map<Document, FileStatus> myDocumentToStatusMap;
    private boolean myAllowDirt;

    public FileStatusMap(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/FileStatusMap.<init> must not be null");
        }
        this.myDocumentToStatusMap = new WeakHashMap();
        this.myAllowDirt = true;
        this.myProject = project;
    }

    public void dispose() {
        this.markAllFilesDirty();
    }

    @Nullable
    public static TextRange getDirtyTextRange(@NotNull Editor editor, int passId) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/FileStatusMap.getDirtyTextRange must not be null");
        }
        Document document = editor.getDocument();
        FileStatusMap me = ((DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)editor.getProject())).getFileStatusMap();
        TextRange dirtyScope = me.getFileDirtyScope(document, passId);
        if (dirtyScope == null) {
            return null;
        }
        TextRange documentRange = TextRange.from((int)0, (int)document.getTextLength());
        return documentRange.intersection(dirtyScope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setErrorFoundFlag(@NotNull Document document, boolean errorFound) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/FileStatusMap.setErrorFoundFlag must not be null");
        }
        Map<Document, FileStatus> map = this.myDocumentToStatusMap;
        synchronized (map) {
            FileStatus status = this.myDocumentToStatusMap.get(document);
            if (status == null) {
                if (!errorFound) {
                    return;
                }
                PsiFile file = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
                assert (file != null) : document;
                status = new FileStatus(file, document);
                this.myDocumentToStatusMap.put(document, status);
            }
            status.errorFound = errorFound;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasErrorFound(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/FileStatusMap.wasErrorFound must not be null");
        }
        Map<Document, FileStatus> map = this.myDocumentToStatusMap;
        synchronized (map) {
            FileStatus status = this.myDocumentToStatusMap.get(document);
            return status != null && status.errorFound;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAllFilesDirty() {
        assert (this.myAllowDirt);
        LOG.debug("********************************* Mark all dirty");
        Map<Document, FileStatus> map = this.myDocumentToStatusMap;
        synchronized (map) {
            this.myDocumentToStatusMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markFileUpToDate(@NotNull Document document, @NotNull PsiFile file, int passId) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/FileStatusMap.markFileUpToDate must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/FileStatusMap.markFileUpToDate must not be null");
        }
        Map<Document, FileStatus> map = this.myDocumentToStatusMap;
        synchronized (map) {
            RangeMarker marker;
            FileStatus status = this.myDocumentToStatusMap.get(document);
            if (status == null) {
                status = new FileStatus(file, document);
                this.myDocumentToStatusMap.put(document, status);
            }
            status.defensivelyMarked = false;
            if (passId == 9) {
                status.wolfPassFinfished = true;
            } else if (status.dirtyScopes.containsKey(passId) && (marker = (RangeMarker)status.dirtyScopes.get(passId)) != null) {
                ((DocumentEx)document).removeRangeMarker((RangeMarkerEx)marker);
                status.dirtyScopes.put(passId, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public TextRange getFileDirtyScope(@NotNull Document document, int passId) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/FileStatusMap.getFileDirtyScope must not be null");
        }
        Map<Document, FileStatus> map = this.myDocumentToStatusMap;
        synchronized (map) {
            PsiFile file = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
            if (!CollectHighlightsUtil.shouldHighlightFile(file)) {
                return null;
            }
            FileStatus status = this.myDocumentToStatusMap.get(document);
            if (status == null) {
                return file == null ? null : file.getTextRange();
            }
            if (status.defensivelyMarked) {
                status.markWholeFile(file, document, this.myProject);
                status.defensivelyMarked = false;
            }
            LOG.assertTrue(status.dirtyScopes.containsKey(passId), (Object)("Unknown pass " + passId));
            RangeMarker marker = (RangeMarker)status.dirtyScopes.get(passId);
            return marker == null ? null : (marker.isValid() ? new TextRange(marker.getStartOffset(), marker.getEndOffset()) : new TextRange(0, document.getTextLength()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markFileScopeDirty(@NotNull Document document, int passId) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/FileStatusMap.markFileScopeDirty must not be null");
        }
        assert (this.myAllowDirt);
        Map<Document, FileStatus> map = this.myDocumentToStatusMap;
        synchronized (map) {
            FileStatus status = this.myDocumentToStatusMap.get(document);
            if (status == null) {
                return;
            }
            if (passId == 9) {
                status.wolfPassFinfished = false;
            } else {
                LOG.assertTrue(status.dirtyScopes.containsKey(passId));
                RangeMarker marker = (RangeMarker)status.dirtyScopes.get(passId);
                if (marker != null) {
                    ((DocumentEx)document).removeRangeMarker((RangeMarkerEx)marker);
                }
                marker = document.createRangeMarker(0, document.getTextLength());
                status.dirtyScopes.put(passId, (Object)marker);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markFileScopeDirtyDefensively(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/FileStatusMap.markFileScopeDirtyDefensively must not be null");
        }
        assert (this.myAllowDirt);
        if (LOG.isDebugEnabled()) {
            LOG.debug("********************************* Mark dirty file defensively: " + file.getName());
        }
        Map<Document, FileStatus> map = this.myDocumentToStatusMap;
        synchronized (map) {
            Document document = PsiDocumentManager.getInstance((Project)this.myProject).getCachedDocument(file);
            if (document == null) {
                return;
            }
            FileStatus status = this.myDocumentToStatusMap.get(document);
            if (status == null) {
                return;
            }
            status.defensivelyMarked = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markFileScopeDirty(@NotNull Document document, @NotNull TextRange scope, int fileLength) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/FileStatusMap.markFileScopeDirty must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/FileStatusMap.markFileScopeDirty must not be null");
        }
        assert (this.myAllowDirt);
        if (LOG.isDebugEnabled()) {
            LOG.debug("********************************* Mark dirty: " + scope);
        }
        Map<Document, FileStatus> map = this.myDocumentToStatusMap;
        synchronized (map) {
            FileStatus status = this.myDocumentToStatusMap.get(document);
            if (status == null) {
                return;
            }
            if (status.defensivelyMarked) {
                status.defensivelyMarked = false;
            }
            status.combineScopesWith(scope, fileLength, document);
        }
    }

    private static RangeMarker combineScopes(RangeMarker old, TextRange scope, int textLength, @NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/FileStatusMap.combineScopes must not be null");
        }
        if (scope == null) {
            return old;
        }
        if (old == null) {
            return document.createRangeMarker(scope);
        }
        TextRange oldRange = !old.isValid() || scope.getEndOffset() >= textLength ? new TextRange(0, textLength) : new TextRange(old.getStartOffset(), old.getEndOffset());
        TextRange union = scope.union(oldRange);
        if (old.isValid() && union.equals((Object)oldRange)) {
            return old;
        }
        ((DocumentEx)document).removeRangeMarker((RangeMarkerEx)old);
        return document.createRangeMarker(union);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allDirtyScopesAreNull(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/FileStatusMap.allDirtyScopesAreNull must not be null");
        }
        Map<Document, FileStatus> map = this.myDocumentToStatusMap;
        synchronized (map) {
            PsiFile file = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
            if (!CollectHighlightsUtil.shouldHighlightFile(file)) {
                return true;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl10 : MonitorExitStatement: MONITOREXIT : var2_2
            FileStatus status = this.myDocumentToStatusMap.get(document);
            return status != null && !status.defensivelyMarked && status.wolfPassFinfished && status.allDirtyScopesAreNull();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertAllDirtyScopesAreNull(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/FileStatusMap.assertAllDirtyScopesAreNull must not be null");
        }
        Map<Document, FileStatus> map = this.myDocumentToStatusMap;
        synchronized (map) {
            FileStatus status = this.myDocumentToStatusMap.get(document);
            assert (status != null && !status.defensivelyMarked && status.wolfPassFinfished && status.allDirtyScopesAreNull()) : status;
        }
    }

    public void allowDirt(boolean allow) {
        this.myAllowDirt = allow;
    }

    private static class FileStatus {
        public boolean defensivelyMarked;
        private boolean wolfPassFinfished;
        private final TIntObjectHashMap<RangeMarker> dirtyScopes;
        private boolean errorFound;

        private FileStatus(@NotNull PsiFile file, @NotNull Document document) {
            if (file == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/FileStatusMap$FileStatus.<init> must not be null");
            }
            if (document == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/FileStatusMap$FileStatus.<init> must not be null");
            }
            this.dirtyScopes = new TIntObjectHashMap();
            this.markWholeFile(file, document, file.getProject());
        }

        private void markWholeFile(PsiFile file, Document document, Project project) {
            this.dirtyScopes.put(4, (Object)FileStatus.createWholeFileMarker(file, document));
            this.dirtyScopes.put(8, (Object)FileStatus.createWholeFileMarker(file, document));
            this.dirtyScopes.put(7, (Object)FileStatus.createWholeFileMarker(file, document));
            TextEditorHighlightingPassRegistrarImpl registrar = (TextEditorHighlightingPassRegistrarImpl)TextEditorHighlightingPassRegistrar.getInstance(project);
            for (DirtyScopeTrackingHighlightingPassFactory factory : registrar.getDirtyScopeTrackingFactories()) {
                this.dirtyScopes.put(factory.getPassId(), (Object)FileStatus.createWholeFileMarker(file, document));
            }
        }

        private static RangeMarker createWholeFileMarker(PsiFile file, Document document) {
            int length = file == null ? -1 : Math.min(file.getTextLength(), document.getTextLength());
            return length == -1 ? null : document.createRangeMarker(0, length);
        }

        public boolean allDirtyScopesAreNull() {
            for (Object o : this.dirtyScopes.getValues()) {
                if (o == null) continue;
                return false;
            }
            return true;
        }

        public void combineScopesWith(final TextRange scope, final int fileLength, final Document document) {
            this.dirtyScopes.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<RangeMarker>(){

                public boolean execute(int id, RangeMarker oldScope) {
                    RangeMarker newScope = FileStatusMap.combineScopes(oldScope, scope, fileLength, document);
                    if (newScope != oldScope) {
                        FileStatus.this.dirtyScopes.put(id, (Object)newScope);
                    }
                    return true;
                }
            });
        }

        public String toString() {
            final StringBuilder s = new StringBuilder();
            s.append("defensivelyMarked = " + this.defensivelyMarked);
            s.append("; wolfPassFinfished = " + this.wolfPassFinfished);
            s.append("; errorFound = " + this.errorFound);
            s.append("; dirtyScopes: (");
            this.dirtyScopes.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<RangeMarker>(){

                public boolean execute(int passId, RangeMarker rangeMarker) {
                    s.append(" pass: " + passId + " -> " + rangeMarker + ";");
                    return true;
                }
            });
            s.append(")");
            return s.toString();
        }
    }
}

