/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightRangeExtension;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.PassExecutorService;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightLevelUtil;
import com.intellij.codeInsight.problems.ProblemImpl;
import com.intellij.concurrency.JobUtil;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.Problem;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.TodoItem;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import gnu.trove.THashSet;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class GeneralHighlightingPass
extends ProgressableTextEditorHighlightingPass
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.GeneralHighlightingPass");
    static final Icon IN_PROGRESS_ICON = IconLoader.getIcon((String)"/general/errorsInProgress.png");
    static final String PRESENTABLE_NAME = DaemonBundle.message((String)"pass.syntax", (Object[])new Object[0]);
    private static final Key<Boolean> HAS_ERROR_ELEMENT = Key.create((String)"HAS_ERROR_ELEMENT");
    private final int myStartOffset;
    private final int myEndOffset;
    private final boolean myUpdateAll;
    private volatile Collection<HighlightInfo> myHighlights;
    private final Map<TextRange, Collection<HighlightInfo>> myInjectedPsiHighlights;
    protected volatile boolean myHasErrorElement;
    private volatile boolean myErrorFound;
    private static final Comparator<HighlightVisitor> VISITOR_ORDER_COMPARATOR = new Comparator<HighlightVisitor>(){

        @Override
        public int compare(HighlightVisitor o1, HighlightVisitor o2) {
            return o1.order() - o2.order();
        }
    };
    private volatile UserDataHolder myProgress;
    private static final Key<AtomicInteger> HIGHLIGHT_VISITOR_INSTANCE_COUNT = new Key("HIGHLIGHT_VISITOR_INSTANCE_COUNT");
    private static final Key<List<GeneralHighlightingPass>> UPDATE_ALL_FINISHED = Key.create((String)"UPDATE_ALL_FINISHED");

    public GeneralHighlightingPass(@NotNull Project project, @NotNull PsiFile file, @NotNull Document document, int startOffset, int endOffset, boolean updateAll) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass.<init> must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass.<init> must not be null");
        }
        if (document == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass.<init> must not be null");
        }
        super(project, document, IN_PROGRESS_ICON, PRESENTABLE_NAME, file, true);
        this.myHighlights = Collections.emptyList();
        this.myInjectedPsiHighlights = new HashMap<TextRange, Collection<HighlightInfo>>();
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
        this.myUpdateAll = updateAll;
        LOG.assertTrue(file.isValid());
        this.setId(4);
        this.myHasErrorElement = !this.isWholeFileHighlighting() && Boolean.TRUE.equals(this.myFile.getUserData(HAS_ERROR_ELEMENT));
        FileStatusMap fileStatusMap = ((DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)this.myProject)).getFileStatusMap();
        this.myErrorFound = !this.isWholeFileHighlighting() && fileStatusMap.wasErrorFound(this.myDocument);
    }

    @NotNull
    private HighlightVisitor[] createHighlightVisitors() {
        int oldCount = this.incVisitorUsageCount(1);
        HighlightVisitor[] highlightVisitors = (HighlightVisitor[])Extensions.getExtensions(HighlightVisitor.EP_HIGHLIGHT_VISITOR, (AreaInstance)this.myProject);
        if (oldCount != 0) {
            HighlightVisitor[] clones = new HighlightVisitor[highlightVisitors.length];
            for (int i = 0; i < highlightVisitors.length; ++i) {
                HighlightVisitor highlightVisitor = highlightVisitors[i];
                clones[i] = highlightVisitor.clone();
            }
            highlightVisitors = clones;
        }
        if (highlightVisitors == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass.createHighlightVisitors must not return null");
        }
        return highlightVisitors;
    }

    private int incVisitorUsageCount(int delta) {
        AtomicInteger count = (AtomicInteger)this.myProject.getUserData(HIGHLIGHT_VISITOR_INSTANCE_COUNT);
        if (count == null) {
            count = (AtomicInteger)((UserDataHolderEx)this.myProject).putUserDataIfAbsent(HIGHLIGHT_VISITOR_INSTANCE_COUNT, (Object)new AtomicInteger(0));
        }
        int old = count.getAndAdd(delta);
        assert (old + delta >= 0) : old + ";" + delta;
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void collectInformationWithProgress(ProgressIndicator progress) {
        this.myProgress = (UserDataHolder)progress;
        THashSet result = new THashSet(100);
        DaemonCodeAnalyzer daemonCodeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)this.myProject);
        FileStatusMap fileStatusMap = ((DaemonCodeAnalyzerImpl)daemonCodeAnalyzer).getFileStatusMap();
        HighlightVisitor[] highlightVisitors = this.createHighlightVisitors();
        HighlightVisitor[] filtered = GeneralHighlightingPass.filterVisitors(highlightVisitors, this.myFile);
        try {
            FileViewProvider viewProvider = this.myFile.getViewProvider();
            Set relevantLanguages = viewProvider.getLanguages();
            List<PsiElement> elements = null;
            for (Language language : relevantLanguages) {
                PsiFile psiRoot = viewProvider.getPsi(language);
                if (!HighlightLevelUtil.shouldHighlight((PsiElement)psiRoot)) continue;
                List<PsiElement> underRoot = CollectHighlightsUtil.getElementsInRange((PsiElement)psiRoot, this.myStartOffset, this.myEndOffset);
                if (elements == null) {
                    elements = underRoot;
                } else {
                    elements.addAll(underRoot);
                }
                if (!underRoot.isEmpty()) continue;
                elements.add((PsiElement)psiRoot);
            }
            if (elements != null) {
                result.addAll(this.collectHighlights(elements, progress, filtered));
                this.addInjectedPsiHighlights(elements, progress);
            }
            if (!this.isDumbMode()) {
                result.addAll(GeneralHighlightingPass.highlightTodos(this.myFile, this.myDocument.getCharsSequence(), this.myStartOffset, this.myEndOffset));
            }
            if (this.myUpdateAll) {
                fileStatusMap.setErrorFoundFlag(this.myDocument, this.myErrorFound);
            }
        }
        finally {
            this.incVisitorUsageCount(-1);
        }
        this.myHighlights = result;
    }

    private void addInjectedPsiHighlights(@NotNull List<PsiElement> elements, final ProgressIndicator progress) {
        if (elements == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass.addInjectedPsiHighlights must not be null");
        }
        List<DocumentWindow> injected = InjectedLanguageUtil.getCachedInjectedDocuments(this.myFile);
        THashSet hosts = new THashSet(elements.size() + injected.size());
        for (DocumentWindow documentRange : injected) {
            PsiElement context;
            PsiFile file;
            if (!documentRange.isValid() || (file = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile((Document)documentRange)) == null || (context = file.getContext()) == null || !context.isValid() || file.getProject().isDisposed() || !this.myUpdateAll && !new ProperTextRange(this.myStartOffset, this.myEndOffset).intersects(context.getTextRange())) continue;
            hosts.add(context);
        }
        hosts.addAll(elements);
        THashSet injectedFiles = new THashSet();
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        TextAttributes injectedAttributes = scheme.getAttributes(EditorColors.INJECTED_LANGUAGE_FRAGMENT);
        for (PsiElement element : hosts) {
            InjectedLanguageUtil.enumerate(element, this.myFile, new PsiLanguageInjectionHost.InjectedPsiVisitor((Collection)injectedFiles, injectedAttributes){
                final /* synthetic */ Collection val$injectedFiles;
                final /* synthetic */ TextAttributes val$injectedAttributes;
                {
                    this.val$injectedFiles = collection;
                    this.val$injectedAttributes = textAttributes;
                }

                public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                    if (injectedPsi == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass$2.visit must not be null");
                    }
                    if (places == null) {
                        throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass$2.visit must not be null");
                    }
                    if (this.val$injectedFiles.add(injectedPsi)) {
                        for (PsiLanguageInjectionHost.Shred place : places) {
                            TextRange textRange = place.getRangeInsideHost().shiftRight(place.host.getTextRange().getStartOffset());
                            if (textRange.isEmpty()) continue;
                            String desc = injectedPsi.getText();
                            HighlightInfo info = HighlightInfo.createHighlightInfo(HighlightInfoType.INJECTED_LANGUAGE_FRAGMENT, textRange, null, desc, this.val$injectedAttributes);
                            GeneralHighlightingPass.this.addHighlightInfo(textRange, info);
                        }
                    }
                }
            }, false);
        }
        if (injectedFiles.isEmpty()) {
            return;
        }
        final InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)this.myProject);
        JobUtil.invokeConcurrentlyUnderMyProgress(injectedFiles, new Processor<PsiFile>(){

            public boolean process(PsiFile injectedPsi) {
                TextRange fixedTextRange;
                int startOffset;
                HighlightInfo info;
                int i;
                DocumentWindow documentWindow = (DocumentWindow)PsiDocumentManager.getInstance((Project)GeneralHighlightingPass.this.myProject).getCachedDocument(injectedPsi);
                HighlightInfoHolder holder = GeneralHighlightingPass.this.createInfoHolder(injectedPsi);
                GeneralHighlightingPass.this.runHighlightVisitosForInjected(injectedPsi, holder, progress);
                for (i = 0; i < holder.size(); ++i) {
                    info = holder.get(i);
                    startOffset = documentWindow.injectedToHost(info.startOffset);
                    fixedTextRange = GeneralHighlightingPass.getFixedTextRange(documentWindow, startOffset);
                    GeneralHighlightingPass.this.addPatchedInfos(info, injectedPsi, documentWindow, injectedLanguageManager, fixedTextRange);
                }
                holder.clear();
                GeneralHighlightingPass.highlightInjectedSyntax(injectedPsi, holder);
                for (i = 0; i < holder.size(); ++i) {
                    info = holder.get(i);
                    startOffset = info.startOffset;
                    fixedTextRange = GeneralHighlightingPass.getFixedTextRange(documentWindow, startOffset);
                    if (fixedTextRange == null) {
                        GeneralHighlightingPass.this.addHighlightInfo(new TextRange(info.startOffset, info.endOffset), info);
                        continue;
                    }
                    HighlightInfo patched = new HighlightInfo(info.forcedTextAttributes, info.type, fixedTextRange.getStartOffset(), fixedTextRange.getEndOffset(), info.description, info.toolTip, info.type.getSeverity(null), info.isAfterEndOfLine, null, false);
                    GeneralHighlightingPass.this.addHighlightInfo(fixedTextRange, patched);
                }
                if (!GeneralHighlightingPass.this.isDumbMode()) {
                    Collection todos = GeneralHighlightingPass.highlightTodos(injectedPsi, injectedPsi.getText(), 0, injectedPsi.getTextLength());
                    for (HighlightInfo info2 : todos) {
                        GeneralHighlightingPass.this.addPatchedInfos(info2, injectedPsi, documentWindow, injectedLanguageManager, null);
                    }
                }
                return true;
            }
        }, "Highlight injected language fragments");
    }

    private static TextRange getFixedTextRange(@NotNull DocumentWindow documentWindow, int startOffset) {
        ProperTextRange fixedTextRange;
        if (documentWindow == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass.getFixedTextRange must not be null");
        }
        TextRange textRange = documentWindow.getHostRange(startOffset);
        if (textRange == null) {
            textRange = GeneralHighlightingPass.findNearestTextRange(documentWindow, startOffset);
            boolean isBefore = startOffset < textRange.getStartOffset();
            fixedTextRange = new ProperTextRange(isBefore ? textRange.getStartOffset() - 1 : textRange.getEndOffset(), isBefore ? textRange.getStartOffset() : textRange.getEndOffset() + 1);
        } else {
            fixedTextRange = null;
        }
        return fixedTextRange;
    }

    private void addPatchedInfos(HighlightInfo info, PsiFile injectedPsi, DocumentWindow documentWindow, InjectedLanguageManager injectedLanguageManager, TextRange fixedTextRange) {
        ProperTextRange textRange = new ProperTextRange(info.startOffset, info.endOffset);
        List editables = injectedLanguageManager.intersectWithAllEditableFragments(injectedPsi, (TextRange)textRange);
        for (TextRange editable : editables) {
            TextRange hostRange = fixedTextRange == null ? documentWindow.injectedToHost(editable) : fixedTextRange;
            HighlightInfo patched = new HighlightInfo(info.forcedTextAttributes, info.type, hostRange.getStartOffset(), hostRange.getEndOffset(), info.description, info.toolTip, info.type.getSeverity(null), info.isAfterEndOfLine, null, false);
            patched.setHint(info.hasHint());
            patched.setGutterIconRenderer(info.getGutterIconRenderer());
            if (info.quickFixActionRanges != null) {
                for (Pair<HighlightInfo.IntentionActionDescriptor, TextRange> pair : info.quickFixActionRanges) {
                    TextRange quickfixTextRange = (TextRange)pair.getSecond();
                    List editableQF = injectedLanguageManager.intersectWithAllEditableFragments(injectedPsi, quickfixTextRange);
                    for (TextRange editableRange : editableQF) {
                        HighlightInfo.IntentionActionDescriptor descriptor = (HighlightInfo.IntentionActionDescriptor)pair.getFirst();
                        if (patched.quickFixActionRanges == null) {
                            patched.quickFixActionRanges = new ArrayList<Pair<HighlightInfo.IntentionActionDescriptor, TextRange>>();
                        }
                        TextRange hostEditableRange = documentWindow.injectedToHost(editableRange);
                        patched.quickFixActionRanges.add((Pair<HighlightInfo.IntentionActionDescriptor, TextRange>)Pair.create((Object)descriptor, (Object)hostEditableRange));
                    }
                }
            }
            this.addHighlightInfo(hostRange, patched);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHighlightInfo(@NotNull TextRange textRange, @NotNull HighlightInfo highlightInfo) {
        if (textRange == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass.addHighlightInfo must not be null");
        }
        if (highlightInfo == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass.addHighlightInfo must not be null");
        }
        Map<TextRange, Collection<HighlightInfo>> map = this.myInjectedPsiHighlights;
        synchronized (map) {
            SmartList infos = this.myInjectedPsiHighlights.get(textRange);
            if (infos == null) {
                infos = new SmartList();
                this.myInjectedPsiHighlights.put(textRange, (Collection<HighlightInfo>)infos);
            }
            infos.add((HighlightInfo)highlightInfo);
        }
    }

    private static TextRange findNearestTextRange(DocumentWindow documentWindow, int startOffset) {
        RangeMarker marker;
        TextRange curRange;
        TextRange textRange = null;
        RangeMarker[] arr$ = documentWindow.getHostRanges();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && ((curRange = InjectedLanguageUtil.toTextRange(marker = arr$[i$])).getStartOffset() <= startOffset || textRange == null); ++i$) {
            textRange = curRange;
        }
        assert (textRange != null);
        return textRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runHighlightVisitosForInjected(PsiFile injectedPsi, final HighlightInfoHolder holder, final ProgressIndicator progress) {
        HighlightVisitor[] visitors = this.createHighlightVisitors();
        try {
            HighlightVisitor[] filtered = GeneralHighlightingPass.filterVisitors(visitors, injectedPsi);
            final List<PsiElement> elements = CollectHighlightsUtil.getElementsInRange((PsiElement)injectedPsi, 0, injectedPsi.getTextLength());
            for (final HighlightVisitor hvisitor : filtered) {
                hvisitor.analyze(new Runnable(){

                    @Override
                    public void run() {
                        for (PsiElement element : elements) {
                            progress.checkCanceled();
                            hvisitor.visit(element, holder);
                        }
                    }
                }, true, injectedPsi);
            }
        }
        finally {
            this.incVisitorUsageCount(-1);
        }
    }

    private static void highlightInjectedSyntax(PsiFile injectedPsi, HighlightInfoHolder holder) {
        List<Trinity<IElementType, PsiLanguageInjectionHost, TextRange>> tokens = InjectedLanguageUtil.getHighlightTokens(injectedPsi);
        if (tokens == null) {
            return;
        }
        Language injectedLanguage = injectedPsi.getLanguage();
        SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)injectedLanguage, (Project)injectedPsi.getProject(), (VirtualFile)injectedPsi.getVirtualFile());
        EditorColorsScheme globalScheme = EditorColorsManager.getInstance().getGlobalScheme();
        TextAttributes defaultAttrs = globalScheme.getAttributes(HighlighterColors.TEXT);
        for (Trinity<IElementType, PsiLanguageInjectionHost, TextRange> token : tokens) {
            TextAttributes forcedAttributes;
            IElementType tokenType = (IElementType)token.getFirst();
            PsiLanguageInjectionHost injectionHost = (PsiLanguageInjectionHost)token.getSecond();
            TextRange textRange = (TextRange)token.getThird();
            TextAttributesKey[] keys = syntaxHighlighter.getTokenHighlights(tokenType);
            if (textRange.getLength() == 0) continue;
            TextRange annRange = textRange.shiftRight(injectionHost.getTextRange().getStartOffset());
            TextAttributes attributes = null;
            for (TextAttributesKey key : keys) {
                TextAttributes attrs2 = globalScheme.getAttributes(key);
                if (attrs2 == null) continue;
                attributes = attributes != null ? TextAttributes.merge((TextAttributes)attributes, (TextAttributes)attrs2) : attrs2;
            }
            if (attributes == null || attributes.isEmpty() || attributes.equals((Object)defaultAttrs)) {
                forcedAttributes = TextAttributes.ERASE_MARKER;
            } else {
                Color back = attributes.getBackgroundColor() == null ? globalScheme.getDefaultBackground() : attributes.getBackgroundColor();
                Color fore = attributes.getForegroundColor() == null ? globalScheme.getDefaultForeground() : attributes.getForegroundColor();
                forcedAttributes = new TextAttributes(fore, back, attributes.getEffectColor(), attributes.getEffectType(), attributes.getFontType());
            }
            HighlightInfo info = HighlightInfo.createHighlightInfo(HighlightInfoType.INJECTED_LANGUAGE_FRAGMENT, annRange, null, null, forcedAttributes);
            holder.add(info);
        }
    }

    private boolean isWholeFileHighlighting() {
        return this.myUpdateAll && this.myStartOffset == 0 && this.myEndOffset == this.myFile.getTextLength();
    }

    @Override
    protected void applyInformationWithProgress() {
        this.myFile.putUserData(HAS_ERROR_ELEMENT, (Object)this.myHasErrorElement);
        TextRange range = new TextRange(this.myStartOffset, this.myEndOffset);
        Collection<HighlightInfo> collection = this.myInjectedPsiHighlights.get(range);
        if (collection == null) {
            collection = new ArrayList<HighlightInfo>(this.myHighlights.size());
        }
        collection.addAll(this.myHighlights);
        this.myInjectedPsiHighlights.put(range, collection);
        this.myHighlights = Collections.emptyList();
        ArrayList<GeneralHighlightingPass> updateAllFinished = (ArrayList<GeneralHighlightingPass>)this.myProgress.getUserData(UPDATE_ALL_FINISHED);
        if (updateAllFinished == null || !updateAllFinished.contains(this)) {
            UpdateHighlightersUtil.setHighlightersToEditor(this.myProject, this.myDocument, this.myInjectedPsiHighlights, 4);
            if (this.myUpdateAll) {
                if (updateAllFinished == null) {
                    updateAllFinished = new ArrayList<GeneralHighlightingPass>();
                    this.myProgress.putUserData(UPDATE_ALL_FINISHED, updateAllFinished);
                }
                updateAllFinished.add(this);
            }
        }
        if (this.myUpdateAll) {
            this.reportErrorsToWolf();
        }
    }

    @NotNull
    public Collection<HighlightInfo> getHighlights() {
        ArrayList<HighlightInfo> list = new ArrayList<HighlightInfo>(this.myHighlights);
        for (Collection<HighlightInfo> infos : this.myInjectedPsiHighlights.values()) {
            list.addAll(infos);
        }
        ArrayList<HighlightInfo> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass.getHighlights must not return null");
        }
        return arrayList;
    }

    private Collection<HighlightInfo> collectHighlights(final @NotNull List<PsiElement> elements, final @NotNull ProgressIndicator progress, HighlightVisitor[] visitors) {
        if (elements == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass.collectHighlights must not be null");
        }
        if (progress == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass.collectHighlights must not be null");
        }
        THashSet skipParentsSet = new THashSet();
        THashSet gotHighlights = new THashSet();
        boolean forceHighlightParents = this.forceHighlightParents();
        HighlightInfoHolder holder = this.createInfoHolder(this.myFile);
        this.setProgressLimit((long)elements.size() * (long)visitors.length);
        final int chunkSize = Math.max(1, elements.size() / 100);
        for (HighlightVisitor visitor : visitors) {
            Runnable action = new Runnable((Set)skipParentsSet, holder, visitor, (Set)gotHighlights, forceHighlightParents){
                final /* synthetic */ Set val$skipParentsSet;
                final /* synthetic */ HighlightInfoHolder val$holder;
                final /* synthetic */ HighlightVisitor val$visitor;
                final /* synthetic */ Set val$gotHighlights;
                final /* synthetic */ boolean val$forceHighlightParents;
                {
                    this.val$skipParentsSet = set;
                    this.val$holder = highlightInfoHolder;
                    this.val$visitor = highlightVisitor;
                    this.val$gotHighlights = set2;
                    this.val$forceHighlightParents = bl;
                }

                @Override
                public void run() {
                    int nextLimit = chunkSize;
                    for (int i = 0; i < elements.size(); ++i) {
                        PsiElement element = (PsiElement)elements.get(i);
                        progress.checkCanceled();
                        if (element != GeneralHighlightingPass.this.myFile && !this.val$skipParentsSet.isEmpty() && element.getFirstChild() != null && this.val$skipParentsSet.contains(element)) {
                            this.val$skipParentsSet.add(element.getParent());
                            continue;
                        }
                        if (element instanceof PsiErrorElement) {
                            GeneralHighlightingPass.this.myHasErrorElement = true;
                        }
                        this.val$holder.clear();
                        this.val$visitor.visit(element, this.val$holder);
                        if (i == nextLimit) {
                            GeneralHighlightingPass.this.advanceProgress(chunkSize);
                            nextLimit = i + chunkSize;
                        }
                        for (int j = 0; j < this.val$holder.size(); ++j) {
                            boolean isError;
                            HighlightInfo info = this.val$holder.get(j);
                            assert (info != null);
                            if (!this.val$gotHighlights.add(info)) continue;
                            boolean bl = isError = info.getSeverity() == HighlightSeverity.ERROR;
                            if (!isError) continue;
                            if (!this.val$forceHighlightParents) {
                                this.val$skipParentsSet.add(element.getParent());
                            }
                            GeneralHighlightingPass.this.myErrorFound = true;
                        }
                    }
                    GeneralHighlightingPass.this.advanceProgress(elements.size() - (nextLimit - chunkSize));
                }
            };
            if (visitor.analyze(action, this.myUpdateAll, this.myFile)) continue;
            GeneralHighlightingPass.cancelAndRestartDaemonLater(progress, this.myProject, this);
        }
        return gotHighlights;
    }

    private static HighlightVisitor[] filterVisitors(HighlightVisitor[] highlightVisitors, PsiFile file) {
        ArrayList<HighlightVisitor> visitors = new ArrayList<HighlightVisitor>(highlightVisitors.length);
        List<HighlightVisitor> list = Arrays.asList(highlightVisitors);
        for (HighlightVisitor visitor : DumbService.getInstance((Project)file.getProject()).filterByDumbAwareness(list)) {
            if (!visitor.suitableForFile(file)) continue;
            visitors.add(visitor);
        }
        LOG.assertTrue(!visitors.isEmpty(), list);
        HighlightVisitor[] visitorArray = visitors.toArray(new HighlightVisitor[visitors.size()]);
        Arrays.sort(visitorArray, VISITOR_ORDER_COMPARATOR);
        return visitorArray;
    }

    static Void cancelAndRestartDaemonLater(ProgressIndicator progress, final Project project, TextEditorHighlightingPass pass) {
        PassExecutorService.log(progress, pass, "Cancel and restart");
        progress.cancel();
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(new Random().nextInt(100));
                }
                catch (InterruptedException e) {
                    LOG.error((Throwable)e);
                }
                DaemonCodeAnalyzer.getInstance((Project)project).restart();
            }
        }, project.getDisposed());
        throw new ProcessCanceledException();
    }

    private boolean forceHighlightParents() {
        boolean forceHighlightParents = false;
        for (HighlightRangeExtension extension : (HighlightRangeExtension[])Extensions.getExtensions(HighlightRangeExtension.EP_NAME)) {
            if (!extension.isForceHighlightParents(this.myFile)) continue;
            forceHighlightParents = true;
            break;
        }
        return forceHighlightParents;
    }

    protected HighlightInfoHolder createInfoHolder(PsiFile file) {
        HighlightInfoFilter[] filters = (HighlightInfoFilter[])ApplicationManager.getApplication().getExtensions(HighlightInfoFilter.EXTENSION_POINT_NAME);
        return new HighlightInfoHolder(file, filters);
    }

    private static Collection<HighlightInfo> highlightTodos(PsiFile file, CharSequence text, int startOffset, int endOffset) {
        PsiManager psiManager = file.getManager();
        PsiSearchHelper helper = psiManager.getSearchHelper();
        TodoItem[] todoItems = helper.findTodoItems(file, startOffset, endOffset);
        if (todoItems.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<HighlightInfo> list = new ArrayList<HighlightInfo>(todoItems.length);
        for (TodoItem todoItem : todoItems) {
            TextRange range = todoItem.getTextRange();
            String description = ((Object)text.subSequence(range.getStartOffset(), range.getEndOffset())).toString();
            TextAttributes attributes = todoItem.getPattern().getAttributes().getTextAttributes();
            HighlightInfo info = HighlightInfo.createHighlightInfo(HighlightInfoType.TODO, range, description, description, attributes);
            assert (info != null);
            list.add(info);
        }
        return list;
    }

    private void reportErrorsToWolf() {
        if (!this.myFile.getViewProvider().isPhysical()) {
            return;
        }
        Project project = this.myFile.getProject();
        if (!PsiManager.getInstance((Project)project).isInProject((PsiElement)this.myFile)) {
            return;
        }
        VirtualFile file = this.myFile.getVirtualFile();
        if (file == null) {
            return;
        }
        List<Problem> problems = GeneralHighlightingPass.convertToProblems(this.getHighlights(), file, this.myHasErrorElement);
        WolfTheProblemSolver wolf = WolfTheProblemSolver.getInstance((Project)project);
        List<HighlightInfo> errors = DaemonCodeAnalyzerImpl.getHighlights(this.getDocument(), HighlightSeverity.ERROR, project);
        if (errors.isEmpty() || this.isWholeFileHighlighting()) {
            wolf.reportProblems(file, problems);
        } else {
            wolf.weHaveGotProblems(file, problems);
        }
    }

    @Override
    public double getProgress() {
        return this.myUpdateAll ? super.getProgress() : -1.0;
    }

    private static List<Problem> convertToProblems(Collection<HighlightInfo> infos, VirtualFile file, boolean hasErrorElement) {
        SmartList problems = new SmartList();
        for (HighlightInfo info : infos) {
            if (info.getSeverity() != HighlightSeverity.ERROR) continue;
            ProblemImpl problem = new ProblemImpl(file, info, hasErrorElement);
            problems.add(problem);
        }
        return problems;
    }

    @Override
    public String toString() {
        return super.toString() + " updateAll=" + this.myUpdateAll + " range=(" + this.myStartOffset + "," + this.myEndOffset + ")";
    }
}

