/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;

public class StatusBarUpdater
implements Disposable {
    private final Project myProject;
    private final UpdateStatusRunnable myUpdateStatusRunnable = new UpdateStatusRunnable();

    public StatusBarUpdater(Project project) {
        this.myProject = project;
        CaretListener caretListener = new CaretListener(){

            public void caretPositionChanged(CaretEvent e) {
                ApplicationManager.getApplication().invokeLater((Runnable)((Object)StatusBarUpdater.this.myUpdateStatusRunnable));
            }
        };
        EditorFactory.getInstance().getEventMulticaster().addCaretListener(caretListener, (Disposable)this);
        project.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerAdapter(){

            public void selectionChanged(FileEditorManagerEvent event) {
                ApplicationManager.getApplication().invokeLater((Runnable)((Object)StatusBarUpdater.this.myUpdateStatusRunnable));
            }
        });
    }

    public void dispose() {
    }

    public void updateStatus() {
        Editor editor = FileEditorManager.getInstance((Project)this.myProject).getSelectedTextEditor();
        if (editor == null || !editor.getContentComponent().hasFocus()) {
            return;
        }
        Document document = editor.getDocument();
        if (document instanceof DocumentEx && ((DocumentEx)document).isInBulkUpdate()) {
            return;
        }
        int offset = editor.getCaretModel().getOffset();
        DaemonCodeAnalyzer codeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)this.myProject);
        HighlightInfo info = ((DaemonCodeAnalyzerImpl)codeAnalyzer).findHighlightByOffset(document, offset, false);
        String text = info != null && info.description != null ? info.description : "";
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(this.myProject);
        if (statusBar instanceof StatusBarEx) {
            StatusBarEx barEx = (StatusBarEx)statusBar;
            if (!text.equals(barEx.getInfo())) {
                statusBar.setInfo(text);
            }
            barEx.update(editor);
        }
    }

    private class UpdateStatusRunnable
    implements DumbAwareRunnable {
        private UpdateStatusRunnable() {
        }

        public void run() {
            if (!StatusBarUpdater.this.myProject.isDisposed()) {
                StatusBarUpdater.this.updateStatus();
            }
        }
    }
}

