/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.GeneralHighlightingPass;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarEx;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.util.ArrayUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TextEditorBackgroundHighlighter
implements BackgroundEditorHighlighter {
    private static final int[] EXCEPT_OVERRIDDEN = new int[]{1, 2, 3, 4, 5, 7, 8};
    private final Editor myEditor;
    private final Document myDocument;
    private PsiFile myFile;
    private final Project myProject;
    private boolean myCompiled;
    private static final int[] EXCEPT_VISIBLE = new int[]{5, 6, 7, 8};

    public TextEditorBackgroundHighlighter(@NotNull Project project, @NotNull Editor editor) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/TextEditorBackgroundHighlighter.<init> must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/TextEditorBackgroundHighlighter.<init> must not be null");
        }
        this.myProject = project;
        this.myEditor = editor;
        this.myDocument = this.myEditor.getDocument();
        this.renewFile();
    }

    private void renewFile() {
        if (this.myFile == null || !this.myFile.isValid()) {
            this.myFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myDocument);
            this.myCompiled = this.myFile instanceof PsiCompiledElement;
            if (this.myCompiled) {
                this.myFile = (PsiFile)((PsiCompiledElement)this.myFile).getMirror();
            }
            if (this.myFile != null && !this.myFile.isValid()) {
                this.myFile = null;
            }
        }
        if (this.myFile != null) {
            this.myFile.putUserData(PsiFileEx.BATCH_REFERENCE_PROCESSING, (Object)Boolean.TRUE);
        }
    }

    public List<TextEditorHighlightingPass> getPasses(int[] passesToIgnore) {
        if (this.myProject.isDisposed()) {
            return Collections.emptyList();
        }
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        this.renewFile();
        if (this.myFile == null || !this.myFile.isPhysical()) {
            return Collections.emptyList();
        }
        if (this.myCompiled) {
            passesToIgnore = EXCEPT_OVERRIDDEN;
        } else if (!DaemonCodeAnalyzer.getInstance((Project)this.myProject).isHighlightingAvailable(this.myFile)) {
            return Collections.emptyList();
        }
        TextEditorHighlightingPassRegistrarEx passRegistrar = TextEditorHighlightingPassRegistrarEx.getInstanceEx(this.myProject);
        return passRegistrar.instantiatePasses(this.myFile, this.myEditor, passesToIgnore);
    }

    @NotNull
    public TextEditorHighlightingPass[] createPassesForVisibleArea() {
        List<TextEditorHighlightingPass> passes = this.getPasses(EXCEPT_VISIBLE);
        int updateAllIndex = -1;
        int updateVisibleIndex = -1;
        int passesSize = passes.size();
        for (int i = 0; i < passesSize; ++i) {
            TextEditorHighlightingPass pass = passes.get(i);
            if (!(pass instanceof GeneralHighlightingPass)) continue;
            if (pass.getId() == 4) {
                updateAllIndex = i;
            }
            if (pass.getId() != 2) continue;
            updateVisibleIndex = i;
        }
        if (!(updateVisibleIndex != -1 && updateAllIndex == -1 || updateVisibleIndex == -1 && updateAllIndex != -1 || updateVisibleIndex == -1 || updateAllIndex == -1)) {
            passes.remove(updateAllIndex);
        }
        TextEditorHighlightingPass[] textEditorHighlightingPassArray = passes.isEmpty() ? TextEditorHighlightingPass.EMPTY_ARRAY : passes.toArray(new TextEditorHighlightingPass[passes.size()]);
        if (textEditorHighlightingPassArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/TextEditorBackgroundHighlighter.createPassesForVisibleArea must not return null");
        }
        return textEditorHighlightingPassArray;
    }

    @NotNull
    public TextEditorHighlightingPass[] createPassesForEditor() {
        List<TextEditorHighlightingPass> passes = this.getPasses(ArrayUtil.EMPTY_INT_ARRAY);
        TextEditorHighlightingPass[] textEditorHighlightingPassArray = passes.isEmpty() ? TextEditorHighlightingPass.EMPTY_ARRAY : passes.toArray(new TextEditorHighlightingPass[passes.size()]);
        if (textEditorHighlightingPassArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/TextEditorBackgroundHighlighter.createPassesForEditor must not return null");
        }
        return textEditorHighlightingPassArray;
    }
}

