/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.ClassUtil;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.RefCountHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.ChangeExtendsToImplementsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateConstructorMatchingSuperFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MoveClassToSeparateFileFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveNewQualifierFix;
import com.intellij.codeInsight.daemon.impl.quickfix.RenameElementFix;
import com.intellij.codeInsight.daemon.impl.quickfix.RenameFileFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.jsp.jspJava.JspClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiMatcherImpl;
import com.intellij.psi.util.PsiMatchers;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightClassUtil {
    public static final String INTERFACE_EXPECTED = JavaErrorMessages.message("interface.expected", new Object[0]);
    public static final String NO_INTERFACE_EXPECTED = JavaErrorMessages.message("no.interface.expected", new Object[0]);
    private static final String STATIC_DECLARATION_IN_INNER_CLASS = JavaErrorMessages.message("static.declaration.in.inner.class", new Object[0]);
    private static final QuickFixFactory QUICK_FIX_FACTORY = QuickFixFactory.getInstance();

    static HighlightInfo checkAbstractInstantiation(PsiJavaCodeReferenceElement ref) {
        PsiElement parent = ref.getParent();
        HighlightInfo highlightInfo = null;
        if (parent instanceof PsiNewExpression && !PsiUtilBase.hasErrorElementChild((PsiElement)parent)) {
            if (((PsiNewExpression)parent).getType() instanceof PsiArrayType) {
                return null;
            }
            PsiElement refElement = ref.resolve();
            if (refElement instanceof PsiClass) {
                highlightInfo = HighlightClassUtil.checkInstantiationOfAbstractClass((PsiClass)refElement, (PsiElement)ref);
            }
        } else if (parent instanceof PsiAnonymousClass && parent.getParent() instanceof PsiNewExpression && !PsiUtilBase.hasErrorElementChild((PsiElement)parent.getParent())) {
            PsiAnonymousClass aClass = (PsiAnonymousClass)parent;
            highlightInfo = HighlightClassUtil.checkClassWithAbstractMethods((PsiClass)aClass, ref.getTextRange());
        }
        return highlightInfo;
    }

    static HighlightInfo checkClassWithAbstractMethods(PsiClass aClass, TextRange textRange) {
        PsiMethod abstractMethod = ClassUtil.getAnyAbstractMethod((PsiClass)aClass);
        if (abstractMethod == null || abstractMethod.getContainingClass() == null) {
            return null;
        }
        String baseClassName = HighlightUtil.formatClass(aClass, false);
        String methodName = HighlightUtil.formatMethod(abstractMethod);
        String message = JavaErrorMessages.message("class.must.be.abstract", baseClassName, methodName, HighlightUtil.formatClass(abstractMethod.getContainingClass(), false));
        HighlightInfo errorResult = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, textRange, message);
        if (ClassUtil.getAnyMethodToImplement((PsiClass)aClass) != null) {
            QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createImplementMethodsFix(aClass));
        }
        if (!(aClass instanceof PsiAnonymousClass) && HighlightUtil.getIncompatibleModifier("abstract", aClass.getModifierList()) == null) {
            IntentionAction fix = QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)aClass, "abstract", true, false);
            QuickFixAction.registerQuickFixAction(errorResult, fix);
        }
        return errorResult;
    }

    static HighlightInfo checkClassMustBeAbstract(PsiClass aClass, TextRange textRange) {
        if (aClass.hasModifierProperty("abstract") || aClass.getRBrace() == null || aClass.isEnum() && HighlightClassUtil.hasEnumConstants(aClass)) {
            return null;
        }
        return HighlightClassUtil.checkClassWithAbstractMethods(aClass, textRange);
    }

    public static HighlightInfo checkInstantiationOfAbstractClass(PsiClass aClass, PsiElement highlighElement) {
        HighlightInfo errorResult = null;
        if (aClass.hasModifierProperty("abstract")) {
            String baseClassName = aClass.getName();
            String message = JavaErrorMessages.message("abstract.cannot.be.instantiated", baseClassName);
            errorResult = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, highlighElement, message);
            if (!aClass.isInterface() && ClassUtil.getAnyAbstractMethod((PsiClass)aClass) == null) {
                IntentionAction fix = QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)aClass, "abstract", false, false);
                QuickFixAction.registerQuickFixAction(errorResult, fix);
            }
        }
        return errorResult;
    }

    private static boolean hasEnumConstants(PsiClass aClass) {
        PsiField[] fields;
        for (PsiField field : fields = aClass.getFields()) {
            if (!(field instanceof PsiEnumConstant)) continue;
            return true;
        }
        return false;
    }

    static HighlightInfo checkDuplicateTopLevelClass(PsiClass aClass) {
        if (!(aClass.getParent() instanceof PsiFile)) {
            return null;
        }
        String qualifiedName = aClass.getQualifiedName();
        if (qualifiedName == null) {
            return null;
        }
        int numOfClassesToFind = 2;
        if (qualifiedName.contains("$")) {
            qualifiedName = qualifiedName.replaceAll("\\$", ".");
            numOfClassesToFind = 1;
        }
        PsiManager manager = aClass.getManager();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)aClass);
        if (module == null) {
            return null;
        }
        PsiClass[] classes = JavaPsiFacade.getInstance((Project)aClass.getProject()).findClasses(qualifiedName, GlobalSearchScope.moduleScope((Module)module));
        if (classes.length < numOfClassesToFind) {
            return null;
        }
        String dupFileName = null;
        for (PsiClass dupClass : classes) {
            VirtualFile file;
            if (dupClass == aClass || (file = dupClass.getContainingFile().getVirtualFile()) == null || !manager.isInProject((PsiElement)dupClass)) continue;
            dupFileName = FileUtil.toSystemDependentName((String)file.getPath());
            break;
        }
        if (dupFileName == null) {
            return null;
        }
        String message = JavaErrorMessages.message("duplicate.class.in.other.file", dupFileName);
        TextRange textRange = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
        return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, textRange, message);
    }

    static HighlightInfo checkDuplicateNestedClass(PsiClass aClass) {
        String name;
        if (aClass == null) {
            return null;
        }
        PsiClass parent = aClass;
        if (aClass.getParent() instanceof PsiDeclarationStatement) {
            parent = aClass.getParent();
        }
        if ((name = aClass.getName()) == null) {
            return null;
        }
        boolean duplicateFound = false;
        boolean checkSiblings = true;
        while (parent != null && !(parent instanceof PsiFile)) {
            PsiElement element;
            PsiElement psiElement = element = checkSiblings ? parent.getPrevSibling() : null;
            if (element == null && ((element = parent.getParent()) instanceof PsiMethod || element instanceof PsiClass)) {
                checkSiblings = false;
            }
            parent = element;
            if (element instanceof PsiDeclarationStatement) {
                element = PsiTreeUtil.getChildOfType((PsiElement)element, PsiClass.class);
            }
            if (!(element instanceof PsiClass) || !name.equals(((PsiClass)element).getName())) continue;
            duplicateFound = true;
            break;
        }
        if (duplicateFound) {
            String message = JavaErrorMessages.message("duplicate.class", name);
            TextRange textRange = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, textRange, message);
        }
        return null;
    }

    static HighlightInfo checkPublicClassInRightFile(PsiKeyword keyword, PsiModifierList psiModifierList) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        if (new PsiMatcherImpl((PsiElement)keyword).dot(PsiMatchers.hasText((String)"public")).parent(PsiMatchers.hasClass(PsiModifierList.class)).parent(PsiMatchers.hasClass(PsiClass.class)).parent(PsiMatchers.hasClass(PsiJavaFile.class)).getElement() == null) {
            return null;
        }
        PsiClass aClass = (PsiClass)keyword.getParent().getParent();
        PsiJavaFile file = (PsiJavaFile)aClass.getContainingFile();
        VirtualFile virtualFile = file.getVirtualFile();
        HighlightInfo errorResult = null;
        if (virtualFile != null && !aClass.getName().equals(virtualFile.getNameWithoutExtension()) && aClass.getNameIdentifier() != null) {
            String message = JavaErrorMessages.message("public.class.should.be.named.after.file", aClass.getName());
            errorResult = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)aClass.getNameIdentifier(), message);
            IntentionAction fix = QUICK_FIX_FACTORY.createModifierListFix(psiModifierList, "public", false, false);
            QuickFixAction.registerQuickFixAction(errorResult, fix);
            PsiClass[] classes = file.getClasses();
            if (classes.length > 1) {
                QuickFixAction.registerQuickFixAction(errorResult, new MoveClassToSeparateFileFix(aClass));
            }
            for (PsiClass otherClass : classes) {
                if (otherClass.getManager().areElementsEquivalent((PsiElement)otherClass, (PsiElement)aClass) || !otherClass.hasModifierProperty("public") || !otherClass.getName().equals(virtualFile.getNameWithoutExtension())) continue;
                return errorResult;
            }
            QuickFixAction.registerQuickFixAction(errorResult, new RenameFileFix(aClass.getName() + "." + StdFileTypes.JAVA.getDefaultExtension()));
            QuickFixAction.registerQuickFixAction(errorResult, new RenameElementFix((PsiNamedElement)aClass));
        }
        return errorResult;
    }

    private static HighlightInfo checkStaticFieldDeclarationInInnerClass(PsiKeyword keyword) {
        if (HighlightClassUtil.getEnclosingStaticClass(keyword, PsiField.class) == null) {
            return null;
        }
        PsiField field = (PsiField)keyword.getParent().getParent();
        if (PsiUtilBase.hasErrorElementChild((PsiElement)field)) {
            return null;
        }
        if (PsiUtil.isCompileTimeConstant((PsiField)field)) {
            return null;
        }
        HighlightInfo errorResult = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)keyword, STATIC_DECLARATION_IN_INNER_CLASS);
        IntentionAction fix1 = QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)field, "static", false, false);
        QuickFixAction.registerQuickFixAction(errorResult, fix1);
        IntentionAction fix = QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)field.getContainingClass(), "static", true, false);
        QuickFixAction.registerQuickFixAction(errorResult, fix);
        return errorResult;
    }

    private static HighlightInfo checkStaticMethodDeclarationInInnerClass(PsiKeyword keyword) {
        if (HighlightClassUtil.getEnclosingStaticClass(keyword, PsiMethod.class) == null) {
            return null;
        }
        PsiMethod method = (PsiMethod)keyword.getParent().getParent();
        if (PsiUtilBase.hasErrorElementChild((PsiElement)method)) {
            return null;
        }
        HighlightInfo errorResult = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)keyword, STATIC_DECLARATION_IN_INNER_CLASS);
        IntentionAction fix1 = QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)method, "static", false, false);
        QuickFixAction.registerQuickFixAction(errorResult, fix1);
        IntentionAction fix = QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)((PsiClass)keyword.getParent().getParent().getParent()), "static", true, false);
        QuickFixAction.registerQuickFixAction(errorResult, fix);
        return errorResult;
    }

    private static HighlightInfo checkStaticInitializerDeclarationInInnerClass(PsiKeyword keyword) {
        if (HighlightClassUtil.getEnclosingStaticClass(keyword, PsiClassInitializer.class) == null) {
            return null;
        }
        PsiClassInitializer initializer = (PsiClassInitializer)keyword.getParent().getParent();
        if (PsiUtilBase.hasErrorElementChild((PsiElement)initializer)) {
            return null;
        }
        HighlightInfo errorResult = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)keyword, STATIC_DECLARATION_IN_INNER_CLASS);
        IntentionAction fix1 = QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)initializer, "static", false, false);
        QuickFixAction.registerQuickFixAction(errorResult, fix1);
        PsiClass owner = (PsiClass)keyword.getParent().getParent().getParent();
        IntentionAction fix = QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)owner, "static", true, false);
        QuickFixAction.registerQuickFixAction(errorResult, fix);
        return errorResult;
    }

    private static PsiElement getEnclosingStaticClass(PsiKeyword keyword, Class<?> parentClass) {
        return new PsiMatcherImpl((PsiElement)keyword).dot(PsiMatchers.hasText((String)"static")).parent(PsiMatchers.hasClass(PsiModifierList.class)).parent(PsiMatchers.hasClass(parentClass)).parent(PsiMatchers.hasClass(PsiClass.class)).dot(PsiMatchers.hasModifier((String)"static", (boolean)false)).parent(PsiMatchers.hasClass((Class[])new Class[]{PsiClass.class, PsiDeclarationStatement.class, PsiNewExpression.class, PsiEnumConstant.class})).getElement();
    }

    private static HighlightInfo checkStaticClassDeclarationInInnerClass(PsiKeyword keyword) {
        TextRange textRange;
        PsiElement[] children;
        if (new PsiMatcherImpl((PsiElement)keyword).parent(PsiMatchers.hasClass(PsiClass.class)).dot(PsiMatchers.hasModifier((String)"static", (boolean)true)).parent(PsiMatchers.hasClass(PsiClass.class)).dot(PsiMatchers.hasModifier((String)"static", (boolean)false)).parent(PsiMatchers.hasClass((Class[])new Class[]{PsiClass.class, PsiDeclarationStatement.class, PsiNewExpression.class, PsiEnumConstant.class})).getElement() == null) {
            return null;
        }
        PsiClass aClass = (PsiClass)keyword.getParent();
        if (PsiUtilBase.hasErrorElementChild((PsiElement)aClass)) {
            return null;
        }
        PsiElement context = null;
        PsiModifierList modifierList = aClass.getModifierList();
        for (PsiElement element : children = modifierList.getChildren()) {
            if (!Comparing.equal((String)element.getText(), (String)"static")) continue;
            context = element;
            break;
        }
        TextRange textRange2 = textRange = context == null ? null : context.getTextRange();
        if (textRange == null) {
            textRange = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
        }
        HighlightInfo errorResult = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, textRange, STATIC_DECLARATION_IN_INNER_CLASS);
        if (context != keyword) {
            IntentionAction fix = QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)aClass, "static", false, false);
            QuickFixAction.registerQuickFixAction(errorResult, fix);
        }
        IntentionAction fix = QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)aClass.getContainingClass(), "static", true, false);
        QuickFixAction.registerQuickFixAction(errorResult, fix);
        return errorResult;
    }

    static HighlightInfo checkStaticDeclarationInInnerClass(PsiKeyword keyword) {
        HighlightInfo errorResult = HighlightClassUtil.checkStaticFieldDeclarationInInnerClass(keyword);
        if (errorResult != null) {
            return errorResult;
        }
        errorResult = HighlightClassUtil.checkStaticMethodDeclarationInInnerClass(keyword);
        if (errorResult != null) {
            return errorResult;
        }
        errorResult = HighlightClassUtil.checkStaticClassDeclarationInInnerClass(keyword);
        if (errorResult != null) {
            return errorResult;
        }
        errorResult = HighlightClassUtil.checkStaticInitializerDeclarationInInnerClass(keyword);
        if (errorResult != null) {
            return errorResult;
        }
        return null;
    }

    static HighlightInfo checkImplementsAllowed(PsiReferenceList list) {
        boolean isImplements;
        PsiClass aClass;
        if (list.getParent() instanceof PsiClass && (aClass = (PsiClass)list.getParent()).isInterface() && (isImplements = list.equals(aClass.getImplementsList()))) {
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)list, JavaErrorMessages.message("implements.after.interface", new Object[0]));
        }
        return null;
    }

    static HighlightInfo checkExtendsClassAndImplementsInterface(PsiReferenceList referenceList, JavaResolveResult resolveResult, PsiJavaCodeReferenceElement context) {
        PsiClass aClass = (PsiClass)referenceList.getParent();
        boolean isImplements = referenceList.equals(aClass.getImplementsList());
        boolean isInterface = aClass.isInterface();
        if (isInterface && isImplements) {
            return null;
        }
        boolean mustBeInterface = isImplements || isInterface;
        HighlightInfo errorResult = null;
        PsiClass extendFrom = (PsiClass)resolveResult.getElement();
        if (extendFrom.isInterface() != mustBeInterface) {
            errorResult = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)context, mustBeInterface ? INTERFACE_EXPECTED : NO_INTERFACE_EXPECTED);
            PsiClassType type = JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory().createType(extendFrom, resolveResult.getSubstitutor());
            QuickFixAction.registerQuickFixAction(errorResult, new ChangeExtendsToImplementsFix(aClass, type));
        }
        return errorResult;
    }

    static HighlightInfo checkCannotInheritFromFinal(PsiClass superClass, PsiElement elementToHighlight) {
        HighlightInfo errorResult = null;
        if (superClass.hasModifierProperty("final") || superClass.isEnum()) {
            String message = JavaErrorMessages.message("inheritance.from.final.class", superClass.getQualifiedName());
            errorResult = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, elementToHighlight, message);
            IntentionAction fix = QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)superClass, "final", false, false);
            QuickFixAction.registerQuickFixAction(errorResult, fix);
        }
        return errorResult;
    }

    static HighlightInfo checkAnonymousInheritFinal(PsiNewExpression expression) {
        PsiAnonymousClass aClass = (PsiAnonymousClass)PsiTreeUtil.getChildOfType((PsiElement)expression, PsiAnonymousClass.class);
        if (aClass == null) {
            return null;
        }
        PsiClassType baseClassReference = aClass.getBaseClassType();
        PsiClass baseClass = baseClassReference.resolve();
        if (baseClass == null) {
            return null;
        }
        return HighlightClassUtil.checkCannotInheritFromFinal(baseClass, (PsiElement)aClass.getBaseClassReference());
    }

    private static String checkDefaultConstructorThrowsException(PsiMethod constructor, @NotNull PsiClassType[] handledExceptions) {
        if (handledExceptions == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/HighlightClassUtil.checkDefaultConstructorThrowsException must not be null");
        }
        PsiClassType[] referencedTypes = constructor.getThrowsList().getReferencedTypes();
        ArrayList<PsiClassType> exceptions = new ArrayList<PsiClassType>();
        for (PsiClassType referencedType : referencedTypes) {
            if (ExceptionUtil.isUncheckedException(referencedType) || ExceptionUtil.isHandledBy(referencedType, handledExceptions)) continue;
            exceptions.add(referencedType);
        }
        if (!exceptions.isEmpty()) {
            return HighlightUtil.getUnhandledExceptionsDescriptor(exceptions);
        }
        return null;
    }

    public static HighlightInfo checkClassDoesNotCallSuperConstructorOrHandleExceptions(PsiClass aClass, RefCountHolder refCountHolder, PsiResolveHelper resolveHelper) {
        if (aClass.isEnum()) {
            return null;
        }
        if (aClass.getConstructors().length != 0) {
            return null;
        }
        TextRange textRange = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
        return HighlightClassUtil.checkBaseClassDefaultConstructorProblem(aClass, refCountHolder, resolveHelper, textRange, PsiClassType.EMPTY_ARRAY);
    }

    public static HighlightInfo checkBaseClassDefaultConstructorProblem(PsiClass aClass, RefCountHolder refCountHolder, PsiResolveHelper resolveHelper, TextRange textRange, @NotNull PsiClassType[] handledExceptions) {
        if (handledExceptions == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/HighlightClassUtil.checkBaseClassDefaultConstructorProblem must not be null");
        }
        PsiClass baseClass = aClass.getSuperClass();
        if (baseClass == null) {
            return null;
        }
        PsiMethod[] constructors = baseClass.getConstructors();
        if (constructors.length == 0) {
            return null;
        }
        for (PsiMethod constructor : constructors) {
            if (!resolveHelper.isAccessible((PsiMember)constructor, (PsiElement)aClass, null) || constructor.getParameterList().getParametersCount() != 0 && (constructor.getParameterList().getParametersCount() != 1 || !constructor.isVarArgs())) continue;
            String description = HighlightClassUtil.checkDefaultConstructorThrowsException(constructor, handledExceptions);
            if (description != null) {
                return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, textRange, description);
            }
            if (refCountHolder != null) {
                refCountHolder.registerLocallyReferenced((PsiNamedElement)constructor);
            }
            return null;
        }
        String description = JavaErrorMessages.message("no.default.constructor.available", HighlightUtil.formatClass(baseClass));
        HighlightInfo info = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, textRange, description);
        QuickFixAction.registerQuickFixAction(info, (IntentionAction)new CreateConstructorMatchingSuperFix(aClass));
        return info;
    }

    static HighlightInfo checkInterfaceCannotBeLocal(PsiClass aClass) {
        if (PsiUtil.isLocalClass((PsiClass)aClass)) {
            TextRange textRange = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, textRange, JavaErrorMessages.message("interface.cannot.be.local", new Object[0]));
        }
        return null;
    }

    public static HighlightInfo checkCyclicInheritance(PsiClass aClass) {
        PsiClass circularClass = HighlightClassUtil.getCircularClass(aClass, new HashSet<PsiClass>());
        if (circularClass != null) {
            String description = JavaErrorMessages.message("cyclic.inheritance", HighlightUtil.formatClass(circularClass));
            TextRange textRange = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, textRange, description);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PsiClass getCircularClass(PsiClass aClass, Collection<PsiClass> usedClasses) {
        if (usedClasses.contains(aClass)) {
            return aClass;
        }
        try {
            PsiClass[] superTypes;
            usedClasses.add(aClass);
            for (PsiClass superType : superTypes = aClass.getSupers()) {
                while (superType instanceof PsiClass) {
                    PsiClass circularClass;
                    if (!"java.lang.Object".equals(superType.getQualifiedName()) && (circularClass = HighlightClassUtil.getCircularClass(superType, usedClasses)) != null) {
                        PsiClass psiClass = circularClass;
                        return psiClass;
                    }
                    superType = superType.getParent();
                }
            }
        }
        finally {
            usedClasses.remove(aClass);
        }
        return null;
    }

    public static HighlightInfo checkExtendsDuplicate(PsiJavaCodeReferenceElement element, PsiElement resolved) {
        if (!(element.getParent() instanceof PsiReferenceList)) {
            return null;
        }
        PsiReferenceList list = (PsiReferenceList)element.getParent();
        if (!(list.getParent() instanceof PsiClass)) {
            return null;
        }
        if (!(resolved instanceof PsiClass)) {
            return null;
        }
        PsiClass aClass = (PsiClass)resolved;
        PsiClassType[] referencedTypes = list.getReferencedTypes();
        int dupCount = 0;
        for (PsiClassType referencedType : referencedTypes) {
            PsiClass resolvedElement = referencedType.resolve();
            if (resolvedElement == null || !list.getManager().areElementsEquivalent((PsiElement)resolvedElement, (PsiElement)aClass)) continue;
            ++dupCount;
        }
        if (dupCount > 1) {
            String description = JavaErrorMessages.message("duplicate.class", HighlightUtil.formatClass(aClass));
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)element, description);
        }
        return null;
    }

    public static HighlightInfo checkClassAlreadyImported(PsiClass aClass, PsiElement elementToHighlight) {
        PsiImportStatementBase[] importStatements;
        PsiFile file = aClass.getContainingFile();
        if (!(file instanceof PsiJavaFile)) {
            return null;
        }
        PsiJavaFile javaFile = (PsiJavaFile)file;
        if (aClass.getParent() != javaFile) {
            return null;
        }
        PsiImportList importList = javaFile.getImportList();
        if (importList == null) {
            return null;
        }
        for (PsiImportStatementBase importStatement : importStatements = importList.getAllImportStatements()) {
            PsiElement resolved;
            if (importStatement.isOnDemand() || !((resolved = importStatement.resolve()) instanceof PsiClass) || resolved.equals(aClass) || !Comparing.equal((String)aClass.getName(), (String)((PsiClass)resolved).getName(), (boolean)true)) continue;
            String description = JavaErrorMessages.message("class.already.imported", HighlightUtil.formatClass(aClass, false));
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, elementToHighlight, description);
        }
        return null;
    }

    public static HighlightInfo checkClassExtendsOnlyOneClass(PsiReferenceList list) {
        PsiClassType[] referencedTypes = list.getReferencedTypes();
        PsiElement parent = list.getParent();
        if (!(parent instanceof PsiClass)) {
            return null;
        }
        PsiClass aClass = (PsiClass)parent;
        if (!aClass.isInterface() && referencedTypes.length > 1 && aClass.getExtendsList() == list) {
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)list, JavaErrorMessages.message("class.cannot.extend.multiple.classes", new Object[0]));
        }
        return null;
    }

    public static HighlightInfo checkThingNotAllowedInInterface(PsiElement element, PsiClass aClass) {
        if (aClass == null || !aClass.isInterface()) {
            return null;
        }
        return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, element, JavaErrorMessages.message("not.allowed.in.interface", new Object[0]));
    }

    public static HighlightInfo checkQualifiedNewOfStaticClass(PsiNewExpression expression) {
        PsiExpression qualifier = expression.getQualifier();
        if (qualifier == null) {
            return null;
        }
        PsiType type = expression.getType();
        if (type instanceof PsiArrayType) {
            HighlightInfo info = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)expression, JavaErrorMessages.message("invalid.qualified.new", new Object[0]));
            QuickFixAction.registerQuickFixAction(info, new RemoveNewQualifierFix(expression, null));
            return info;
        }
        PsiClass aClass = PsiUtil.resolveClassInType((PsiType)type);
        if (aClass != null && aClass.hasModifierProperty("static")) {
            HighlightInfo info = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)expression, JavaErrorMessages.message("qualified.new.of.static.class", new Object[0]));
            if (!aClass.isEnum()) {
                IntentionAction fix = QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)aClass, "static", false, false);
                QuickFixAction.registerQuickFixAction(info, fix);
            }
            QuickFixAction.registerQuickFixAction(info, new RemoveNewQualifierFix(expression, aClass));
            return info;
        }
        return null;
    }

    public static HighlightInfo checkClassExtendsForeignInnerClass(PsiJavaCodeReferenceElement extendRef, PsiElement resolved) {
        PsiElement parent = extendRef.getParent();
        if (!(parent instanceof PsiReferenceList)) {
            return null;
        }
        PsiElement grand = parent.getParent();
        if (!(grand instanceof PsiClass)) {
            return null;
        }
        PsiClass aClass = (PsiClass)grand;
        if (aClass.getExtendsList() != parent || aClass instanceof PsiTypeParameter) {
            return null;
        }
        if (!(resolved instanceof PsiClass)) {
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)extendRef, JavaErrorMessages.message("class.name.expected", new Object[0]));
        }
        PsiClass base = (PsiClass)resolved;
        if (!PsiUtil.isInnerClass((PsiClass)base)) {
            return null;
        }
        PsiClass baseClass = base.getContainingClass();
        if (!HighlightClassUtil.hasEnclosingInstanceInScope(baseClass, (PsiElement)extendRef, true) && !HighlightClassUtil.qualifiedNewCalledInConstructors(aClass, baseClass)) {
            String description = JavaErrorMessages.message("no.enclosing.instance.in.scope", HighlightUtil.formatClass(baseClass));
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)extendRef, description);
        }
        return null;
    }

    private static boolean qualifiedNewCalledInConstructors(PsiClass aClass, PsiClass baseClass) {
        PsiMethod[] constructors = aClass.getConstructors();
        if (constructors.length == 0) {
            return false;
        }
        for (PsiMethod constructor : constructors) {
            PsiCodeBlock body = constructor.getBody();
            if (body == null) {
                return false;
            }
            PsiStatement[] statements = body.getStatements();
            if (statements.length == 0) {
                return false;
            }
            PsiStatement firstStatement = statements[0];
            if (!(firstStatement instanceof PsiExpressionStatement)) {
                return false;
            }
            PsiExpression expression = ((PsiExpressionStatement)firstStatement).getExpression();
            if (!HighlightUtil.isSuperOrThisMethodCall((PsiElement)expression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            if ("this".equals(methodCallExpression.getMethodExpression().getReferenceName())) continue;
            PsiReferenceExpression referenceExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifierExpression = referenceExpression.getQualifierExpression();
            if (!(qualifierExpression instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiType type = qualifierExpression.getType();
            if (!(type instanceof PsiClassType)) {
                return false;
            }
            PsiClass resolved = ((PsiClassType)type).resolve();
            if (resolved == baseClass) continue;
            return false;
        }
        return true;
    }

    static HighlightInfo checkExternalizableHasPublicNoArgsConstructor(PsiClass aClass, PsiElement context) {
        if (!HighlightClassUtil.isExternalizable(aClass) || aClass.hasModifierProperty("abstract")) {
            return null;
        }
        PsiMethod[] constructors = aClass.getConstructors();
        boolean hasPublicNoArgsConstructor = constructors.length == 0;
        for (PsiMethod constructor : constructors) {
            if (constructor.getParameterList().getParametersCount() != 0 || !constructor.hasModifierProperty("public")) continue;
            hasPublicNoArgsConstructor = true;
            break;
        }
        if (!hasPublicNoArgsConstructor) {
            HighlightInfo highlightInfo = HighlightInfo.createHighlightInfo(HighlightInfoType.WARNING, context, JavaErrorMessages.message("externalizable.class.should.have.public.constructor", new Object[0]));
            QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createAddDefaultConstructorFix(aClass));
            return highlightInfo;
        }
        return null;
    }

    private static boolean isExternalizable(PsiClass aClass) {
        PsiManager manager = aClass.getManager();
        PsiClass externalizableClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.io.Externalizable", aClass.getResolveScope());
        return externalizableClass != null && aClass.isInheritor(externalizableClass, true);
    }

    public static boolean hasEnclosingInstanceInScope(PsiClass aClass, PsiElement scope, boolean isSuperClassAccepted) {
        PsiElement place;
        PsiManager manager = aClass.getManager();
        for (place = scope; place != null && place != aClass && !(place instanceof PsiFile); place = place.getParent()) {
            if (place instanceof PsiClass && (isSuperClassAccepted ? InheritanceUtil.isInheritorOrSelf((PsiClass)((PsiClass)place), (PsiClass)aClass, (boolean)true) : manager.areElementsEquivalent(place, (PsiElement)aClass))) {
                return true;
            }
            if (!(place instanceof PsiModifierListOwner) || !((PsiModifierListOwner)place).hasModifierProperty("static")) continue;
            return false;
        }
        return place == aClass;
    }

    @Nullable
    public static HighlightInfo checkCreateInnerClassFromStaticContext(PsiNewExpression expression) {
        PsiNewExpression placeToSearchEnclosingFrom;
        PsiType type = expression.getType();
        if (type == null || type instanceof PsiArrayType || type instanceof PsiPrimitiveType) {
            return null;
        }
        PsiClass aClass = PsiUtil.resolveClassInType((PsiType)type);
        if (aClass == null) {
            return null;
        }
        if (aClass instanceof PsiAnonymousClass && (aClass = ((PsiAnonymousClass)aClass).getBaseClassType().resolve()) == null) {
            return null;
        }
        if (!PsiUtil.isInnerClass((PsiClass)aClass)) {
            return null;
        }
        PsiClass outerClass = aClass.getContainingClass();
        if (outerClass == null) {
            return null;
        }
        PsiExpression qualifier = expression.getQualifier();
        if (qualifier != null) {
            PsiType qtype = qualifier.getType();
            placeToSearchEnclosingFrom = PsiUtil.resolveClassInType((PsiType)qtype);
        } else {
            placeToSearchEnclosingFrom = expression;
        }
        if (outerClass instanceof JspClass || HighlightClassUtil.hasEnclosingInstanceInScope(outerClass, (PsiElement)placeToSearchEnclosingFrom, true)) {
            return null;
        }
        return HighlightClassUtil.reportIllegalEnclosingUsage((PsiElement)placeToSearchEnclosingFrom, aClass, outerClass, (PsiElement)expression);
    }

    public static HighlightInfo checkSuperQualifierType(PsiMethodCallExpression superCall) {
        if (!HighlightUtil.isSuperMethodCall((PsiElement)superCall)) {
            return null;
        }
        PsiMethod ctr = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)superCall, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiMember.class});
        if (ctr == null) {
            return null;
        }
        PsiClass targetClass = ctr.getContainingClass().getSuperClass();
        if (targetClass == null) {
            return null;
        }
        PsiExpression qualifier = superCall.getMethodExpression().getQualifierExpression();
        if (qualifier != null && PsiUtil.isInnerClass((PsiClass)targetClass)) {
            PsiClass outerClass = targetClass.getContainingClass();
            PsiClassType outerType = JavaPsiFacade.getInstance((Project)superCall.getProject()).getElementFactory().createType(outerClass);
            return HighlightUtil.checkAssignability((PsiType)outerType, null, qualifier, (PsiElement)qualifier);
        }
        return null;
    }

    @Nullable
    public static HighlightInfo reportIllegalEnclosingUsage(PsiElement place, PsiClass aClass, PsiClass outerClass, PsiElement elementToHighlight) {
        if (outerClass != null && !PsiTreeUtil.isContextAncestor((PsiElement)outerClass, (PsiElement)place, (boolean)false)) {
            String description = JavaErrorMessages.message("is.not.an.enclosing.class", HighlightUtil.formatClass(outerClass));
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, elementToHighlight, description);
        }
        PsiModifierListOwner staticParent = PsiUtil.getEnclosingStaticElement((PsiElement)place, (PsiClass)outerClass);
        if (staticParent != null) {
            String description = JavaErrorMessages.message("cannot.be.referenced.from.static.context", outerClass == null ? "" : HighlightUtil.formatClass(outerClass) + "." + "this");
            HighlightInfo highlightInfo = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, elementToHighlight, description);
            IntentionAction fix = QUICK_FIX_FACTORY.createModifierListFix(staticParent, "static", false, false);
            QuickFixAction.registerQuickFixAction(highlightInfo, fix);
            if (aClass != null && HighlightUtil.getIncompatibleModifier("static", aClass.getModifierList()) == null) {
                IntentionAction fix2 = QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)aClass, "static", true, false);
                QuickFixAction.registerQuickFixAction(highlightInfo, fix2);
            }
            return highlightInfo;
        }
        return null;
    }
}

