/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.GenericsHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightClassUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.AddExceptionToCatchFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddExceptionToThrowsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddNewArrayExpressionFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddTypeCastFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ChangeNewOperatorTypeFix;
import com.intellij.codeInsight.daemon.impl.quickfix.DeleteCatchFix;
import com.intellij.codeInsight.daemon.impl.quickfix.GeneralizeCatchFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodReturnBooleanFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MoveCatchUpFix;
import com.intellij.codeInsight.daemon.impl.quickfix.NegationBroadScopeFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixActionRegistrarImpl;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveQualifierFix;
import com.intellij.codeInsight.daemon.impl.quickfix.RenameWrongRefFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ReuseVariableDeclarationFix;
import com.intellij.codeInsight.daemon.impl.quickfix.SurroundWithArrayFix;
import com.intellij.codeInsight.daemon.impl.quickfix.SurroundWithTryCatchFix;
import com.intellij.codeInsight.daemon.impl.quickfix.VariableArrayTypeFix;
import com.intellij.codeInsight.daemon.impl.quickfix.WrapExpressionFix;
import com.intellij.codeInsight.highlighting.HighlightUsagesDescriptionLocation;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInsight.quickfix.ChangeVariableTypeQuickFixProvider;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.ExternallyDefinedPsiElement;
import com.intellij.psi.ImplicitVariable;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.jsp.jspJava.JspHolderMethod;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.scope.processor.VariablesNotProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.psi.util.EnclosingLoopMatcherExpression;
import com.intellij.psi.util.EnclosingLoopOrSwitchMatcherExpression;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiMatcherImpl;
import com.intellij.psi.util.PsiMatchers;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.util.XmlStringUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil");
    private static final Map<String, Set<String>> ourInterfaceIncompatibleModifiers;
    private static final Map<String, Set<String>> ourMethodIncompatibleModifiers;
    private static final Map<String, Set<String>> ourFieldIncompatibleModifiers;
    private static final Map<String, Set<String>> ourClassIncompatibleModifiers;
    private static final Map<String, Set<String>> ourClassInitializerIncompatibleModifiers;
    private static final Set<String> ourConstructorNotAllowedModifiers;
    @NonNls
    private static final String SERIAL_VERSION_UID_FIELD_NAME = "serialVersionUID";
    @NonNls
    private static final String SERIAL_PERSISTENT_FIELDS_FIELD_NAME = "serialPersistentFields";
    private static final QuickFixFactory QUICK_FIX_FACTORY;

    private HighlightUtil() {
    }

    @Nullable
    public static String getIncompatibleModifier(String modifier, PsiModifierList modifierList, Map<String, Set<String>> incompatibleModifiersHash) {
        if (modifierList == null) {
            return null;
        }
        PsiElement[] modifiers = modifierList.getChildren();
        int modifierCount = 0;
        for (PsiElement otherModifier : modifiers) {
            if (!Comparing.equal((String)modifier, (String)otherModifier.getText(), (boolean)true)) continue;
            ++modifierCount;
        }
        if (modifierCount > 1) {
            return modifier;
        }
        Set<String> incompatibles = incompatibleModifiersHash.get(modifier);
        if (incompatibles == null) {
            return null;
        }
        for (String incompatible : incompatibles) {
            if (!modifierList.hasModifierProperty(incompatible)) continue;
            return incompatible;
        }
        return null;
    }

    static void registerAccessQuickFixAction(PsiMember refElement, PsiJavaCodeReferenceElement place, HighlightInfo errorResult, PsiElement fileResolveScope) {
        if (refElement instanceof PsiCompiledElement) {
            return;
        }
        PsiModifierList modifierList = refElement.getModifierList();
        if (modifierList == null) {
            return;
        }
        PsiClass packageLocalClassInTheMiddle = HighlightUtil.getPackageLocalClassInTheMiddle(place);
        if (packageLocalClassInTheMiddle != null) {
            IntentionAction fix = QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)packageLocalClassInTheMiddle, "public", true, true);
            QuickFixAction.registerQuickFixAction(errorResult, fix);
            return;
        }
        try {
            Project project = refElement.getProject();
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
            PsiModifierList modifierListCopy = facade.getElementFactory().createFieldFromText("int a;", null).getModifierList();
            modifierListCopy.setModifierProperty("static", modifierList.hasModifierProperty("static"));
            String minModifier = "packageLocal";
            if (refElement.hasModifierProperty("packageLocal")) {
                minModifier = "protected";
            }
            if (refElement.hasModifierProperty("protected")) {
                minModifier = "public";
            }
            Object[] modifiers = new String[]{"packageLocal", "protected", "public"};
            PsiClass accessObjectClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)place, PsiClass.class, (boolean)false);
            for (int i = ArrayUtil.indexOf((Object[])modifiers, (Object)minModifier); i < modifiers.length; ++i) {
                Object modifier = modifiers[i];
                modifierListCopy.setModifierProperty((String)modifier, true);
                if (!facade.getResolveHelper().isAccessible(refElement, modifierListCopy, (PsiElement)place, accessObjectClass, fileResolveScope)) continue;
                IntentionAction fix = QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)refElement, (String)modifier, true, true);
                TextRange fixRange = new TextRange(errorResult.startOffset, errorResult.endOffset);
                PsiElement ref = place.getReferenceNameElement();
                if (ref != null) {
                    fixRange = fixRange.union(ref.getTextRange());
                }
                QuickFixAction.registerQuickFixAction(errorResult, fixRange, fix, null);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @Nullable
    private static PsiClass getPackageLocalClassInTheMiddle(PsiJavaCodeReferenceElement place) {
        if (place instanceof PsiReferenceExpression) {
            PsiReferenceExpression expression = (PsiReferenceExpression)place;
            while (true) {
                PsiField field;
                PsiClass aClass;
                PsiElement resolved;
                if ((resolved = expression.resolve()) instanceof PsiField && (aClass = (field = (PsiField)resolved).getContainingClass()) != null && aClass.hasModifierProperty("packageLocal") && !JavaPsiFacade.getInstance((Project)aClass.getProject()).arePackagesTheSame((PsiElement)aClass, (PsiElement)place)) {
                    return aClass;
                }
                PsiExpression qualifier = expression.getQualifierExpression();
                if (!(qualifier instanceof PsiReferenceExpression)) break;
                expression = (PsiReferenceExpression)qualifier;
            }
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkInstanceOfApplicable(PsiInstanceOfExpression expression) {
        PsiExpression operand = expression.getOperand();
        PsiTypeElement typeElement = expression.getCheckType();
        if (typeElement == null) {
            return null;
        }
        PsiType checkType = typeElement.getType();
        PsiType operandType = operand.getType();
        if (operandType == null) {
            return null;
        }
        if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)operandType) || TypeConversionUtil.isPrimitiveAndNotNull((PsiType)checkType) || !TypeConversionUtil.areTypesConvertible((PsiType)operandType, (PsiType)checkType)) {
            String message = JavaErrorMessages.message("inconvertible.type.cast", HighlightUtil.formatType(operandType), HighlightUtil.formatType(checkType));
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)expression, message);
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkInconvertibleTypeCast(PsiTypeCastExpression expression) {
        PsiType operandType;
        PsiExpression operand = expression.getOperand();
        PsiType castType = expression.getCastType().getType();
        PsiType psiType = operandType = operand == null ? null : operand.getType();
        if (operandType != null && !TypeConversionUtil.areTypesConvertible((PsiType)operandType, (PsiType)castType)) {
            String message = JavaErrorMessages.message("inconvertible.type.cast", HighlightUtil.formatType(operandType), HighlightUtil.formatType(castType));
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)expression, message);
        }
        return null;
    }

    static HighlightInfo checkVariableExpected(PsiExpression expression) {
        PsiExpression lValue;
        if (expression instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)expression;
            lValue = assignment.getLExpression();
        } else {
            lValue = PsiUtil.isIncrementDecrementOperation((PsiElement)expression) ? (expression instanceof PsiPostfixExpression ? ((PsiPostfixExpression)expression).getOperand() : ((PsiPrefixExpression)expression).getOperand()) : null;
        }
        HighlightInfo errorResult = null;
        if (lValue != null && !TypeConversionUtil.isLValue((PsiExpression)lValue)) {
            errorResult = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)lValue, JavaErrorMessages.message("variable.expected", new Object[0]));
        }
        return errorResult;
    }

    @Nullable
    static HighlightInfo checkAssignmentOperatorApplicable(PsiAssignmentExpression assignment) {
        PsiJavaToken operationSign = assignment.getOperationSign();
        IElementType eqOpSign = operationSign.getTokenType();
        IElementType opSign = TypeConversionUtil.convertEQtoOperation((IElementType)eqOpSign);
        if (opSign == null) {
            return null;
        }
        HighlightInfo errorResult = null;
        if (!TypeConversionUtil.isBinaryOperatorApplicable((IElementType)opSign, (PsiExpression)assignment.getLExpression(), (PsiExpression)assignment.getRExpression(), (boolean)true)) {
            String operatorText = operationSign.getText().substring(0, operationSign.getText().length() - 1);
            String message = JavaErrorMessages.message("binary.operator.not.applicable", operatorText, HighlightUtil.formatType(assignment.getLExpression().getType()), HighlightUtil.formatType(assignment.getRExpression().getType()));
            errorResult = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)assignment, message);
        }
        return errorResult;
    }

    @Nullable
    static HighlightInfo checkAssignmentCompatibleTypes(PsiAssignmentExpression assignment) {
        if (!"=".equals(assignment.getOperationSign().getText())) {
            return null;
        }
        PsiExpression lExpr = assignment.getLExpression();
        PsiExpression rExpr = assignment.getRExpression();
        if (rExpr == null) {
            return null;
        }
        PsiType lType = lExpr.getType();
        PsiType rType = rExpr.getType();
        if (rType == null) {
            return null;
        }
        HighlightInfo highlightInfo = HighlightUtil.checkAssignability(lType, rType, rExpr, (PsiElement)assignment);
        if (highlightInfo != null) {
            PsiElement element;
            PsiVariable leftVar = null;
            if (lExpr instanceof PsiReferenceExpression && (element = ((PsiReferenceExpression)lExpr).resolve()) instanceof PsiVariable) {
                leftVar = (PsiVariable)element;
            }
            if (leftVar != null) {
                HighlightUtil.registerChangeVariableTypeFixes(leftVar, rType, highlightInfo);
            }
        }
        return highlightInfo;
    }

    private static boolean isCastIntentionApplicable(PsiExpression expression, PsiType toType) {
        while (expression instanceof PsiTypeCastExpression || expression instanceof PsiParenthesizedExpression) {
            if (expression instanceof PsiTypeCastExpression) {
                expression = ((PsiTypeCastExpression)expression).getOperand();
            }
            if (!(expression instanceof PsiParenthesizedExpression)) continue;
            expression = ((PsiParenthesizedExpression)expression).getExpression();
        }
        if (expression == null) {
            return false;
        }
        PsiType rType = expression.getType();
        return rType != null && toType != null && TypeConversionUtil.areTypesConvertible((PsiType)rType, (PsiType)toType);
    }

    @Nullable
    static HighlightInfo checkVariableInitializerType(PsiVariable variable) {
        int end;
        int start;
        PsiType rType;
        PsiExpression initializer = variable.getInitializer();
        if (initializer == null || initializer instanceof PsiArrayInitializerExpression) {
            return null;
        }
        PsiType lType = variable.getType();
        HighlightInfo highlightInfo = HighlightUtil.checkAssignability(lType, rType = initializer.getType(), initializer, new TextRange(start = variable.getTypeElement().getTextRange().getStartOffset(), end = variable.getTextRange().getEndOffset()));
        if (highlightInfo != null) {
            HighlightUtil.registerChangeVariableTypeFixes(variable, rType, highlightInfo);
        }
        return highlightInfo;
    }

    @Nullable
    static HighlightInfo checkAssignability(PsiType lType, PsiType rType, PsiExpression expression, PsiElement elementToHighlight) {
        TextRange textRange = elementToHighlight.getTextRange();
        return HighlightUtil.checkAssignability(lType, rType, expression, textRange);
    }

    @Nullable
    public static HighlightInfo checkAssignability(@Nullable PsiType lType, @Nullable PsiType rType, @Nullable PsiExpression expression, TextRange textRange) {
        if (lType == rType) {
            return null;
        }
        if (expression == null) {
            if (rType == null || lType == null || TypeConversionUtil.isAssignable((PsiType)lType, (PsiType)rType)) {
                return null;
            }
        } else if (TypeConversionUtil.areTypesAssignmentCompatible((PsiType)lType, (PsiExpression)expression)) {
            if (lType == null || rType == null) {
                return null;
            }
            return GenericsHighlightUtil.checkRawToGenericAssignment(lType, rType, (PsiElement)expression);
        }
        if (rType == null) {
            rType = expression.getType();
        }
        HighlightInfo highlightInfo = HighlightUtil.createIncompatibleTypeHighlightInfo(lType, rType, textRange);
        if (rType != null && expression != null && HighlightUtil.isCastIntentionApplicable(expression, lType)) {
            QuickFixAction.registerQuickFixAction(highlightInfo, new AddTypeCastFix(lType, expression));
        }
        if (lType instanceof PsiClassType && expression != null) {
            QuickFixAction.registerQuickFixAction(highlightInfo, new WrapExpressionFix((PsiClassType)lType, expression));
        }
        ChangeNewOperatorTypeFix.register(highlightInfo, expression, lType);
        return highlightInfo;
    }

    @Nullable
    static HighlightInfo checkReturnStatementType(PsiReturnStatement statement) {
        PsiMethod method = null;
        PsiElement parent = statement.getParent();
        while (!(parent instanceof PsiFile) && !(parent instanceof PsiClassInitializer)) {
            if (parent instanceof PsiMethod) {
                method = (PsiMethod)parent;
                break;
            }
            parent = parent.getParent();
        }
        int navigationShift = 0;
        HighlightInfo errorResult = null;
        if (method == null && !(parent instanceof JspFile)) {
            String description = JavaErrorMessages.message("return.outside.method", new Object[0]);
            errorResult = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)statement, description);
        } else {
            PsiType returnType = method != null ? method.getReturnType() : null;
            boolean isMethodVoid = returnType == null || PsiType.VOID.equals(returnType);
            final PsiExpression returnValue = statement.getReturnValue();
            if (returnValue != null) {
                PsiType valueType = returnValue.getType();
                if (isMethodVoid) {
                    String description = JavaErrorMessages.message("return.from.void.method", new Object[0]);
                    errorResult = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)statement, description);
                    if (valueType != null) {
                        IntentionAction fix = QUICK_FIX_FACTORY.createMethodReturnFix(method, valueType, true);
                        QuickFixAction.registerQuickFixAction(errorResult, fix);
                    }
                } else {
                    errorResult = HighlightUtil.checkAssignability(returnType, valueType, returnValue, (PsiElement)statement);
                    if (errorResult != null && valueType != null) {
                        IntentionAction fix = QUICK_FIX_FACTORY.createMethodReturnFix(method, valueType, true);
                        QuickFixAction.registerQuickFixAction(errorResult, fix);
                        if (returnType instanceof PsiArrayType && TypeConversionUtil.isAssignable((PsiType)((PsiArrayType)returnType).getComponentType(), (PsiType)valueType)) {
                            QuickFixAction.registerQuickFixAction(errorResult, (IntentionAction)new SurroundWithArrayFix(null){

                                @Override
                                protected PsiExpression getExpression(PsiElement element) {
                                    return returnValue.isValid() ? returnValue : null;
                                }
                            });
                        }
                    }
                }
                navigationShift = returnValue.getStartOffsetInParent();
            } else if (!isMethodVoid) {
                String description = JavaErrorMessages.message("missing.return.value", new Object[0]);
                errorResult = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)statement, description);
                IntentionAction fix = QUICK_FIX_FACTORY.createMethodReturnFix(method, PsiType.VOID, true);
                QuickFixAction.registerQuickFixAction(errorResult, fix);
                navigationShift = "return".length();
            }
        }
        if (errorResult != null) {
            errorResult.navigationShift = navigationShift;
        }
        return errorResult;
    }

    public static String getUnhandledExceptionsDescriptor(Collection<PsiClassType> unhandledExceptions) {
        StringBuilder exceptionsText = new StringBuilder();
        for (PsiClassType unhandledException : unhandledExceptions) {
            if (exceptionsText.length() != 0) {
                exceptionsText.append(", ");
            }
            exceptionsText.append(HighlightUtil.formatType((PsiType)unhandledException));
        }
        return JavaErrorMessages.message("unhandled.exceptions", exceptionsText.toString(), unhandledExceptions.size());
    }

    @Nullable
    static HighlightInfo checkVariableAlreadyDefined(PsiVariable variable) {
        String name;
        PsiIdentifier identifier;
        boolean isIncorrect;
        block5: {
            PsiElement[] children;
            PsiElement scope;
            block6: {
                block4: {
                    if (variable instanceof ExternallyDefinedPsiElement) {
                        return null;
                    }
                    isIncorrect = false;
                    identifier = variable.getNameIdentifier();
                    name = variable.getName();
                    if (!(variable instanceof PsiLocalVariable) && (!(variable instanceof PsiParameter) || !(((PsiParameter)variable).getDeclarationScope() instanceof PsiCatchSection)) && (!(variable instanceof PsiParameter) || !(((PsiParameter)variable).getDeclarationScope() instanceof PsiForeachStatement))) break block4;
                    scope = PsiTreeUtil.getParentOfType((PsiElement)variable, (Class[])new Class[]{PsiFile.class, PsiMethod.class, PsiClassInitializer.class});
                    VariablesNotProcessor proc = new VariablesNotProcessor(variable, false){

                        @Override
                        protected boolean check(PsiVariable var, ResolveState state) {
                            return (var instanceof PsiLocalVariable || var instanceof PsiParameter) && super.check(var, state);
                        }
                    };
                    PsiScopesUtil.treeWalkUp(proc, (PsiElement)identifier, scope);
                    if (proc.size() <= 0) break block5;
                    isIncorrect = true;
                    break block5;
                }
                if (!(variable instanceof PsiField)) break block6;
                PsiField field = (PsiField)variable;
                PsiClass aClass = field.getContainingClass();
                if (aClass == null) {
                    return null;
                }
                PsiField fieldByName = aClass.findFieldByName(name, false);
                if (fieldByName == null || fieldByName == field) break block5;
                isIncorrect = true;
                break block5;
            }
            scope = variable.getParent();
            for (PsiElement child : children = scope.getChildren()) {
                if (!(child instanceof PsiVariable) || child.equals(variable) || !name.equals(((PsiVariable)child).getName())) continue;
                isIncorrect = true;
                break;
            }
        }
        if (isIncorrect) {
            String description = JavaErrorMessages.message("variable.already.defined", name);
            HighlightInfo highlightInfo = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)identifier, description);
            QuickFixAction.registerQuickFixAction(highlightInfo, new ReuseVariableDeclarationFix(variable, identifier));
            return highlightInfo;
        }
        return null;
    }

    @NotNull
    public static String formatClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil.formatClass must not be null");
        }
        String string = HighlightUtil.formatClass(aClass, true);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil.formatClass must not return null");
        }
        return string;
    }

    @NotNull
    public static String formatClass(@NotNull PsiClass aClass, boolean fqn) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil.formatClass must not be null");
        }
        String string = PsiFormatUtil.formatClass((PsiClass)aClass, (int)(0x8001 | (fqn ? 2048 : 0)));
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil.formatClass must not return null");
        }
        return string;
    }

    @NotNull
    public static String formatMethod(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil.formatMethod must not be null");
        }
        String string = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil.formatMethod must not return null");
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static String formatType(@Nullable PsiType type) {
        if (type == null) {
            return "null";
        }
        String text = type.getInternalCanonicalText();
        if (text == null) {
            return "null";
        }
        String string = text;
        String string2 = string;
        if (string == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil.formatType must not return null");
        return string2;
    }

    public static HighlightInfo checkUnhandledExceptions(PsiElement element, TextRange fixRange) {
        List<PsiClassType> unhandledExceptions = ExceptionUtil.getUnhandledExceptions(element);
        HighlightInfo errorResult = null;
        if (!unhandledExceptions.isEmpty()) {
            HighlightInfoType highlightType;
            if (fixRange == null) {
                fixRange = element.getTextRange();
            }
            if ((highlightType = HighlightUtil.getUnhandledExceptionHighlightType(element)) == null) {
                return null;
            }
            errorResult = HighlightInfo.createHighlightInfo(highlightType, fixRange, HighlightUtil.getUnhandledExceptionsDescriptor(unhandledExceptions));
            QuickFixAction.registerQuickFixAction(errorResult, (IntentionAction)new AddExceptionToCatchFix());
            QuickFixAction.registerQuickFixAction(errorResult, (IntentionAction)new AddExceptionToThrowsFix(element));
            QuickFixAction.registerQuickFixAction(errorResult, new SurroundWithTryCatchFix(element));
            if (unhandledExceptions.size() == 1) {
                QuickFixAction.registerQuickFixAction(errorResult, new GeneralizeCatchFix(element, unhandledExceptions.get(0)));
            }
        }
        return errorResult;
    }

    private static HighlightInfoType getUnhandledExceptionHighlightType(PsiElement element) {
        if (!JspPsiUtil.isInJspFile((PsiElement)element)) {
            return HighlightInfoType.UNHANDLED_EXCEPTION;
        }
        PsiMethod targetMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
        if (!(targetMethod instanceof JspHolderMethod)) {
            return HighlightInfoType.UNHANDLED_EXCEPTION;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkBreakOutsideLoop(PsiBreakStatement statement) {
        if (statement.getLabelIdentifier() == null && new PsiMatcherImpl((PsiElement)statement).ancestor(EnclosingLoopOrSwitchMatcherExpression.INSTANCE).getElement() == null) {
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)statement, JavaErrorMessages.message("break.outside.switch.or.loop", new Object[0]));
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkContinueOutsideLoop(PsiContinueStatement statement) {
        if (statement.getLabelIdentifier() == null) {
            if (new PsiMatcherImpl((PsiElement)statement).ancestor(EnclosingLoopMatcherExpression.INSTANCE).getElement() == null) {
                return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)statement, JavaErrorMessages.message("continue.outside.loop", new Object[0]));
            }
        } else {
            PsiStatement exitedStatement = statement.findContinuedStatement();
            if (exitedStatement == null) {
                return null;
            }
            if (!(exitedStatement instanceof PsiForStatement || exitedStatement instanceof PsiWhileStatement || exitedStatement instanceof PsiDoWhileStatement || exitedStatement instanceof PsiForeachStatement)) {
                String description = JavaErrorMessages.message("not.loop.label", statement.getLabelIdentifier().getText());
                return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)statement, description);
            }
        }
        return null;
    }

    static HighlightInfo checkIllegalModifierCombination(PsiKeyword keyword, PsiModifierList modifierList) {
        String modifier = keyword.getText();
        String incompatible = HighlightUtil.getIncompatibleModifier(modifier, modifierList);
        HighlightInfo highlightInfo = null;
        if (incompatible != null) {
            String message = JavaErrorMessages.message("incompatible.modifiers", modifier, incompatible);
            highlightInfo = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)keyword, message);
            QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createModifierListFix(modifierList, modifier, false, false));
        }
        return highlightInfo;
    }

    @Nullable
    private static Map<String, Set<String>> getIncompatibleModifierMap(PsiModifierList modifierList) {
        PsiElement parent = modifierList.getParent();
        if (parent == null || PsiUtilBase.hasErrorElementChild((PsiElement)parent)) {
            return null;
        }
        return parent instanceof PsiClass ? (((PsiClass)parent).isInterface() ? ourInterfaceIncompatibleModifiers : ourClassIncompatibleModifiers) : (parent instanceof PsiMethod ? ourMethodIncompatibleModifiers : (parent instanceof PsiVariable ? ourFieldIncompatibleModifiers : (parent instanceof PsiClassInitializer ? ourClassInitializerIncompatibleModifiers : null)));
    }

    @Nullable
    public static String getIncompatibleModifier(String modifier, PsiModifierList modifierList) {
        PsiElement parent = modifierList.getParent();
        if (parent == null || PsiUtilBase.hasErrorElementChild((PsiElement)parent)) {
            return null;
        }
        Map<String, Set<String>> incompatibleModifierMap = HighlightUtil.getIncompatibleModifierMap(modifierList);
        if (incompatibleModifierMap == null) {
            return null;
        }
        return HighlightUtil.getIncompatibleModifier(modifier, modifierList, incompatibleModifierMap);
    }

    @Nullable
    public static HighlightInfo checkNotAllowedModifier(PsiKeyword keyword, PsiModifierList modifierList) {
        PsiElement modifierOwnerParent;
        PsiElement modifierOwner = modifierList.getParent();
        if (modifierOwner == null) {
            return null;
        }
        if (PsiUtilBase.hasErrorElementChild((PsiElement)modifierOwner)) {
            return null;
        }
        String modifier = keyword.getText();
        Map<String, Set<String>> incompatibleModifierMap = HighlightUtil.getIncompatibleModifierMap(modifierList);
        if (incompatibleModifierMap == null) {
            return null;
        }
        Set<String> incompatibles = incompatibleModifierMap.get(modifier);
        Object object = modifierOwnerParent = modifierOwner instanceof PsiMember ? ((PsiMember)modifierOwner).getContainingClass() : modifierOwner.getParent();
        if (modifierOwnerParent == null) {
            modifierOwnerParent = modifierOwner.getParent();
        }
        boolean isAllowed = true;
        if (modifierOwner instanceof PsiClass) {
            PsiClass aClass = (PsiClass)modifierOwner;
            if (aClass.isInterface()) {
                if ("static".equals(modifier) || "private".equals(modifier) || "protected".equals(modifier) || "packageLocal".equals(modifier)) {
                    isAllowed = modifierOwnerParent instanceof PsiClass;
                }
            } else {
                if ("public".equals(modifier)) {
                    isAllowed = modifierOwnerParent instanceof PsiJavaFile || modifierOwnerParent instanceof PsiClass;
                } else if ("static".equals(modifier) || "private".equals(modifier) || "protected".equals(modifier) || "packageLocal".equals(modifier)) {
                    isAllowed = modifierOwnerParent instanceof PsiClass;
                }
                if (aClass.isEnum()) {
                    isAllowed &= !"final".equals(modifier) && !"abstract".equals(modifier);
                }
            }
        } else if (modifierOwner instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)modifierOwner;
            isAllowed = !method.isConstructor() || !ourConstructorNotAllowedModifiers.contains(modifier);
            PsiClass containingClass = method.getContainingClass();
            if ((method.hasModifierProperty("public") || method.hasModifierProperty("protected")) && method.isConstructor() && containingClass != null && containingClass.isEnum()) {
                isAllowed = false;
            }
            if ("private".equals(modifier) || "protected".equals(modifier) || "transient".equals(modifier) || "strictfp".equals(modifier) || "synchronized".equals(modifier)) {
                isAllowed &= modifierOwnerParent instanceof PsiClass && !((PsiClass)modifierOwnerParent).isInterface();
            }
        } else if (modifierOwner instanceof PsiField) {
            if ("private".equals(modifier) || "protected".equals(modifier) || "transient".equals(modifier) || "strictfp".equals(modifier) || "synchronized".equals(modifier)) {
                isAllowed = modifierOwnerParent instanceof PsiClass && !((PsiClass)modifierOwnerParent).isInterface();
            }
        } else if (modifierOwner instanceof PsiClassInitializer) {
            isAllowed = "static".equals(modifier);
        } else if (modifierOwner instanceof PsiLocalVariable || modifierOwner instanceof PsiParameter) {
            isAllowed = "final".equals(modifier);
        }
        if (!(isAllowed &= incompatibles != null)) {
            String message = JavaErrorMessages.message("modifier.not.allowed", modifier);
            HighlightInfo highlightInfo = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)keyword, message);
            QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createModifierListFix(modifierList, modifier, false, false));
            return highlightInfo;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkLiteralExpressionParsingError(PsiLiteralExpression expression) {
        String error = expression.getParsingError();
        if (error != null) {
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)expression, error);
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkMustBeBoolean(PsiExpression expr) {
        PsiElement parent = expr.getParent();
        if (parent instanceof PsiIfStatement || parent instanceof PsiWhileStatement || parent instanceof PsiForStatement && expr.equals(((PsiForStatement)parent).getCondition()) || parent instanceof PsiDoWhileStatement && expr.equals(((PsiDoWhileStatement)parent).getCondition())) {
            if (expr.getNextSibling() instanceof PsiErrorElement) {
                return null;
            }
            PsiType type = expr.getType();
            if (!TypeConversionUtil.isBooleanType((PsiType)type)) {
                PsiMethodCallExpression methodCall;
                PsiMethod method;
                HighlightInfo info = HighlightUtil.createIncompatibleTypeHighlightInfo(PsiType.BOOLEAN, type, expr.getTextRange());
                if (expr instanceof PsiMethodCallExpression && (method = (methodCall = (PsiMethodCallExpression)expr).resolveMethod()) != null && PsiType.VOID.equals(method.getReturnType())) {
                    QuickFixAction.registerQuickFixAction(info, new MethodReturnBooleanFix(method, PsiType.BOOLEAN));
                }
                return info;
            }
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkExceptionThrownInTry(PsiParameter parameter) {
        PsiElement declarationScope = parameter.getDeclarationScope();
        if (!(declarationScope instanceof PsiCatchSection)) {
            return null;
        }
        PsiTryStatement statement = ((PsiCatchSection)declarationScope).getTryStatement();
        Collection<PsiClassType> classes = ExceptionUtil.collectUnhandledExceptions((PsiElement)statement.getTryBlock(), (PsiElement)statement.getTryBlock());
        PsiType caughtType = parameter.getType();
        if (!(caughtType instanceof PsiClassType)) {
            return null;
        }
        if (ExceptionUtil.isUncheckedExceptionOrSuperclass((PsiClassType)caughtType)) {
            return null;
        }
        for (PsiClassType exceptionType : classes) {
            if (!exceptionType.isAssignableFrom(caughtType) && !caughtType.isAssignableFrom((PsiType)exceptionType)) continue;
            return null;
        }
        String description = JavaErrorMessages.message("exception.never.thrown.try", HighlightUtil.formatType(caughtType));
        HighlightInfo errorResult = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)parameter, description);
        QuickFixAction.registerQuickFixAction(errorResult, new DeleteCatchFix(parameter));
        return errorResult;
    }

    @Nullable
    static HighlightInfo checkNotAStatement(PsiStatement statement) {
        if (!PsiUtil.isStatement((PsiElement)statement) && !PsiUtilBase.hasErrorElementChild((PsiElement)statement)) {
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)statement, JavaErrorMessages.message("not.a.statement", new Object[0]));
        }
        return null;
    }

    public static HighlightInfo checkSwitchSelectorType(PsiSwitchStatement statement) {
        PsiType type;
        PsiExpression expression = statement.getExpression();
        HighlightInfo errorResult = null;
        if (expression != null && expression.getType() != null && !HighlightUtil.isValidTypeForSwitchSelector(type = expression.getType())) {
            String message = JavaErrorMessages.message("incompatible.types", JavaErrorMessages.message("valid.switch.selector.types", new Object[0]), HighlightUtil.formatType(type));
            errorResult = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)expression, message);
            if (PsiType.LONG.equals(type) || PsiType.FLOAT.equals(type) || PsiType.DOUBLE.equals(type)) {
                QuickFixAction.registerQuickFixAction(errorResult, new AddTypeCastFix(PsiType.INT, expression));
            }
        }
        return errorResult;
    }

    private static boolean isValidTypeForSwitchSelector(PsiType type) {
        if (TypeConversionUtil.getTypeRank((PsiType)type) <= 4) {
            return true;
        }
        if (type instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)type).resolve();
            if (psiClass == null) {
                return false;
            }
            if (psiClass.isEnum()) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    static HighlightInfo checkBinaryOperatorApplicable(PsiBinaryExpression expression) {
        PsiExpression lOperand = expression.getLOperand();
        PsiExpression rOperand = expression.getROperand();
        PsiJavaToken operationSign = expression.getOperationSign();
        if (!TypeConversionUtil.isBinaryOperatorApplicable((IElementType)operationSign.getTokenType(), (PsiExpression)lOperand, (PsiExpression)rOperand, (boolean)false)) {
            String message = JavaErrorMessages.message("binary.operator.not.applicable", operationSign.getText(), HighlightUtil.formatType(lOperand.getType()), HighlightUtil.formatType(rOperand.getType()));
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)expression, message);
        }
        return null;
    }

    @Nullable
    public static HighlightInfo checkUnaryOperatorApplicable(PsiJavaToken token, PsiExpression expression) {
        if (token != null && expression != null && !TypeConversionUtil.isUnaryOperatorApplicable((PsiJavaToken)token, (PsiExpression)expression)) {
            PsiType type = expression.getType();
            if (type == null) {
                return null;
            }
            String message = JavaErrorMessages.message("unary.operator.not.applicable", token.getText(), HighlightUtil.formatType(type));
            PsiElement parentExpr = token.getParent();
            HighlightInfo highlightInfo = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, parentExpr, message);
            if (parentExpr instanceof PsiPrefixExpression && token.getTokenType() == JavaTokenType.EXCL) {
                QuickFixAction.registerQuickFixAction(highlightInfo, new NegationBroadScopeFix((PsiPrefixExpression)parentExpr));
            }
            return highlightInfo;
        }
        return null;
    }

    @Nullable
    public static HighlightInfo checkThisOrSuperExpressionInIllegalContext(PsiExpression expr, @Nullable PsiJavaCodeReferenceElement qualifier) {
        PsiClass aClass;
        if (expr instanceof PsiSuperExpression && !(expr.getParent() instanceof PsiReferenceExpression)) {
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, expr.getTextRange().getEndOffset(), expr.getTextRange().getEndOffset() + 1, JavaErrorMessages.message("dot.expected.after.super.or.this", new Object[0]));
        }
        PsiElement resolved = null;
        Object object = qualifier == null ? (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expr, PsiClass.class) : (aClass = (resolved = qualifier.resolve()) instanceof PsiClass ? (PsiClass)resolved : null);
        if (resolved != null && !(resolved instanceof PsiClass)) {
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)qualifier, JavaErrorMessages.message("class.expected", new Object[0]));
        }
        if (aClass == null) {
            return null;
        }
        if (qualifier != null && aClass.isInterface()) {
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)qualifier, HighlightClassUtil.NO_INTERFACE_EXPECTED);
        }
        if (!HighlightClassUtil.hasEnclosingInstanceInScope(aClass, (PsiElement)expr, false)) {
            return HighlightClassUtil.reportIllegalEnclosingUsage((PsiElement)expr, null, aClass, (PsiElement)expr);
        }
        return null;
    }

    static String buildProblemWithStaticDescription(PsiElement refElement) {
        String type = ((FindUsagesProvider)LanguageFindUsages.INSTANCE.forLanguage(StdLanguages.JAVA)).getType(refElement);
        String name = HighlightMessageUtil.getSymbolName(refElement, PsiSubstitutor.EMPTY);
        return JavaErrorMessages.message("non.static.symbol.referenced.from.static.context", type, name);
    }

    static void registerStaticProblemQuickFixAction(@NotNull PsiElement refElement, HighlightInfo errorResult, PsiJavaCodeReferenceElement place) {
        PsiModifierListOwner staticParent;
        if (refElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil.registerStaticProblemQuickFixAction must not be null");
        }
        if (refElement instanceof PsiModifierListOwner) {
            QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)refElement, "static", true, false));
        }
        if ((staticParent = PsiUtil.getEnclosingStaticElement((PsiElement)place, null)) != null && HighlightUtil.isInstanceReference(place)) {
            QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createModifierListFix(staticParent, "static", false, false));
        }
    }

    private static boolean isInstanceReference(PsiJavaCodeReferenceElement place) {
        PsiElement qualifier = place.getQualifier();
        if (qualifier == null) {
            return true;
        }
        if (!(qualifier instanceof PsiJavaCodeReferenceElement)) {
            return false;
        }
        PsiElement q = ((PsiReference)qualifier).resolve();
        if (q instanceof PsiClass) {
            return false;
        }
        if (q != null) {
            return true;
        }
        String qname = ((PsiJavaCodeReferenceElement)qualifier).getQualifiedName();
        return qname == null || !Character.isLowerCase(qname.charAt(0));
    }

    static String buildProblemWithAccessDescription(PsiJavaCodeReferenceElement reference, JavaResolveResult result) {
        PsiModifierListOwner refElement = (PsiModifierListOwner)result.getElement();
        String symbolName = HighlightMessageUtil.getSymbolName((PsiElement)refElement, result.getSubstitutor());
        if (refElement.hasModifierProperty("private")) {
            String containerName = HighlightMessageUtil.getSymbolName(refElement.getParent(), result.getSubstitutor());
            return JavaErrorMessages.message("private.symbol", symbolName, containerName);
        }
        if (refElement.hasModifierProperty("protected")) {
            String containerName = HighlightMessageUtil.getSymbolName(refElement.getParent(), result.getSubstitutor());
            return JavaErrorMessages.message("protected.symbol", symbolName, containerName);
        }
        PsiClass packageLocalClass = HighlightUtil.getPackageLocalClassInTheMiddle(reference);
        if (packageLocalClass != null) {
            refElement = packageLocalClass;
            symbolName = HighlightMessageUtil.getSymbolName((PsiElement)refElement, result.getSubstitutor());
        }
        if (refElement.hasModifierProperty("packageLocal") || packageLocalClass != null) {
            String containerName = HighlightMessageUtil.getSymbolName(refElement.getParent(), result.getSubstitutor());
            return JavaErrorMessages.message("package.local.symbol", symbolName, containerName);
        }
        String containerName = HighlightMessageUtil.getSymbolName(refElement instanceof PsiTypeParameter ? refElement.getParent().getParent() : refElement.getParent(), result.getSubstitutor());
        return JavaErrorMessages.message("visibility.access.problem", symbolName, containerName);
    }

    @Nullable
    static HighlightInfo checkValidArrayAccessExpression(PsiExpression arrayExpression, PsiExpression indexExpression) {
        PsiType arrayExpressionType;
        PsiType psiType = arrayExpressionType = arrayExpression == null ? null : arrayExpression.getType();
        if (arrayExpressionType != null && !(arrayExpressionType instanceof PsiArrayType)) {
            String description = JavaErrorMessages.message("array.type.expected", HighlightUtil.formatType(arrayExpressionType));
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)arrayExpression, description);
        }
        return HighlightUtil.checkAssignability(PsiType.INT, indexExpression.getType(), indexExpression, (PsiElement)indexExpression);
    }

    @Nullable
    public static HighlightInfo checkCatchParameterIsThrowable(PsiParameter parameter) {
        if (parameter.getDeclarationScope() instanceof PsiCatchSection) {
            PsiType type = parameter.getType();
            return HighlightUtil.checkMustBeThrowable(type, (PsiElement)parameter, true);
        }
        return null;
    }

    public static void checkArrayInitalizer(PsiExpression initializer, HighlightInfoHolder holder) {
        PsiExpression[] initializers;
        if (!(initializer instanceof PsiArrayInitializerExpression)) {
            return;
        }
        PsiType arrayInitializerType = initializer.getType();
        if (!(arrayInitializerType instanceof PsiArrayType)) {
            return;
        }
        PsiType componentType = ((PsiArrayType)arrayInitializerType).getComponentType();
        PsiArrayInitializerExpression arrayInitializer = (PsiArrayInitializerExpression)initializer;
        boolean arrayTypeFixChecked = false;
        VariableArrayTypeFix fix = null;
        for (PsiExpression expression : initializers = arrayInitializer.getInitializers()) {
            HighlightInfo info = HighlightUtil.checkArrayInitalizerCompatibleTypes(expression, componentType);
            if (info == null) continue;
            holder.add(info);
            if (!arrayTypeFixChecked) {
                PsiType checkResult = HighlightUtil.sameType(initializers);
                fix = checkResult != null ? new VariableArrayTypeFix(arrayInitializer, checkResult) : null;
                arrayTypeFixChecked = true;
            }
            if (fix == null) continue;
            QuickFixAction.registerQuickFixAction(info, fix);
        }
    }

    @Nullable
    private static PsiType getArrayInitializerType(PsiArrayInitializerExpression element) {
        PsiType typeCheckResult = HighlightUtil.sameType(element.getInitializers());
        if (typeCheckResult != null) {
            return typeCheckResult.createArrayType();
        }
        return null;
    }

    private static PsiType sameType(PsiExpression[] expressions) {
        PsiType type = null;
        for (PsiExpression expression : expressions) {
            PsiType currentType = expression instanceof PsiArrayInitializerExpression ? HighlightUtil.getArrayInitializerType((PsiArrayInitializerExpression)expression) : expression.getType();
            if (type == null) {
                type = currentType;
                continue;
            }
            if (type.equals(currentType)) continue;
            return null;
        }
        return type;
    }

    @Nullable
    private static HighlightInfo checkArrayInitalizerCompatibleTypes(PsiExpression initializer, PsiType componentType) {
        PsiType initializerType = initializer.getType();
        if (initializerType == null) {
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)initializer, JavaErrorMessages.message("illegal.initializer", HighlightUtil.formatType(componentType)));
        }
        PsiExpression expression = initializer instanceof PsiArrayInitializerExpression ? null : initializer;
        return HighlightUtil.checkAssignability(componentType, initializerType, expression, (PsiElement)initializer);
    }

    @Nullable
    public static HighlightInfo checkExpressionRequired(PsiReferenceExpression expression) {
        if (expression.getNextSibling() instanceof PsiErrorElement) {
            return null;
        }
        PsiElement resolved = expression.advancedResolve(true).getElement();
        if (resolved == null) {
            return null;
        }
        PsiElement parent = expression.getParent();
        if (parent instanceof PsiReferenceExpression || parent instanceof PsiMethodCallExpression) {
            return null;
        }
        if (resolved instanceof PsiVariable) {
            return null;
        }
        return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)expression, JavaErrorMessages.message("expression.expected", new Object[0]));
    }

    @Nullable
    public static HighlightInfo checkArrayInitializerApplicable(PsiArrayInitializerExpression expression) {
        PsiElement parent = expression.getParent();
        if (parent instanceof PsiVariable) {
            PsiVariable variable = (PsiVariable)parent;
            if (variable.getType() instanceof PsiArrayType) {
                return null;
            }
        } else {
            if (parent instanceof PsiNewExpression) {
                return null;
            }
            if (parent instanceof PsiArrayInitializerExpression) {
                return null;
            }
        }
        HighlightInfo info = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)expression, JavaErrorMessages.message("expression.expected", new Object[0]));
        QuickFixAction.registerQuickFixAction(info, new AddNewArrayExpressionFix(expression));
        return info;
    }

    @Nullable
    public static HighlightInfo checkCaseStatement(PsiSwitchLabelStatement statement) {
        PsiStatement[] statements;
        HighlightInfo highlightInfo;
        PsiSwitchStatement switchStatement = statement.getEnclosingSwitchStatement();
        if (switchStatement == null) {
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)statement, JavaErrorMessages.message("case.statement.outside.switch", new Object[0]));
        }
        if (switchStatement.getBody() == null) {
            return null;
        }
        PsiExpression switchExpression = switchStatement.getExpression();
        PsiType switchType = switchExpression == null ? PsiType.INT : switchExpression.getType();
        PsiExpression caseValue = statement.getCaseValue();
        if (caseValue != null && switchExpression != null && (highlightInfo = HighlightUtil.checkAssignability(switchType, caseValue.getType(), caseValue, (PsiElement)caseValue)) != null) {
            return highlightInfo;
        }
        Object value = null;
        boolean isEnumSwitch = false;
        if (!statement.isDefaultCase() && caseValue != null) {
            PsiElement element;
            if (caseValue instanceof PsiReferenceExpression && (element = ((PsiReferenceExpression)caseValue).resolve()) instanceof PsiEnumConstant) {
                isEnumSwitch = true;
                value = ((PsiEnumConstant)element).getName();
                if (((PsiReferenceExpression)caseValue).getQualifier() != null) {
                    String message = JavaErrorMessages.message("qualified.enum.constant.in.switch", new Object[0]);
                    return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)caseValue, message);
                }
            }
            if (!isEnumSwitch) {
                value = ConstantExpressionUtil.computeCastTo((PsiExpression)caseValue, (PsiType)switchType);
            }
            if (value == null) {
                return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)caseValue, JavaErrorMessages.message("constant.expression.required", new Object[0]));
            }
        }
        for (PsiStatement st : statements = switchStatement.getBody().getStatements()) {
            PsiElement element;
            PsiSwitchLabelStatement labelStatement;
            if (st == statement || !(st instanceof PsiSwitchLabelStatement) || (labelStatement = (PsiSwitchLabelStatement)st).isDefaultCase() != statement.isDefaultCase()) continue;
            PsiExpression caseExpr = labelStatement.getCaseValue();
            if (!isEnumSwitch || !(caseExpr instanceof PsiReferenceExpression) ? !TypeConversionUtil.areTypesAssignmentCompatible((PsiType)switchType, (PsiExpression)caseExpr) || !Comparing.equal((Object)ConstantExpressionUtil.computeCastTo((PsiExpression)caseExpr, (PsiType)switchType), (Object)value) : !((element = ((PsiReferenceExpression)caseExpr).resolve()) instanceof PsiEnumConstant) || !Comparing.equal((Object)((PsiEnumConstant)element).getName(), (Object)value)) continue;
            String description = statement.isDefaultCase() ? JavaErrorMessages.message("duplicate.default.switch.label", new Object[0]) : JavaErrorMessages.message("duplicate.switch.label", value);
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)(value == null ? statement : caseValue), description);
        }
        PsiElement lastChild = statement.getLastChild();
        while (lastChild instanceof PsiComment || lastChild instanceof PsiWhiteSpace) {
            lastChild = lastChild.getPrevSibling();
        }
        if (!(lastChild instanceof PsiJavaToken) || ((PsiJavaToken)lastChild).getTokenType() != JavaTokenType.COLON) {
            int start = statement.getTextRange().getEndOffset();
            int end = statement.getTextRange().getEndOffset() + 1;
            String description = JavaErrorMessages.message("switch.colon.expected.after.case.label", new Object[0]);
            CharSequence chars = statement.getContainingFile().getViewProvider().getContents();
            boolean isAfterEndOfLine = end >= chars.length() || chars.charAt(start) == '\n' || chars.charAt(start) == '\r';
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, null, start, end, description, description, isAfterEndOfLine, null);
        }
        return null;
    }

    @Nullable
    public static HighlightInfo checkIllegalForwardReferenceToField(PsiReferenceExpression expression, PsiField referencedField) {
        boolean inStaticContext;
        PsiClass containingClass = referencedField.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        if (expression.getContainingFile() != referencedField.getContainingFile()) {
            return null;
        }
        if (expression.getTextRange().getStartOffset() >= referencedField.getTextRange().getEndOffset()) {
            return null;
        }
        if (expression.getQualifierExpression() != null) {
            return null;
        }
        PsiField initField = HighlightUtil.findEnclosingFieldInitializer((PsiElement)expression);
        PsiClassInitializer classInitializer = HighlightUtil.findParentClassInitializer((PsiElement)expression);
        if (initField == null && classInitializer == null) {
            return null;
        }
        boolean isStaticClassInitializer = classInitializer != null && classInitializer.hasModifierProperty("static");
        boolean isStaticInitField = initField != null && initField.hasModifierProperty("static");
        boolean bl = inStaticContext = isStaticInitField || isStaticClassInitializer;
        if (!inStaticContext && referencedField.hasModifierProperty("static")) {
            return null;
        }
        if (PsiUtil.isOnAssignmentLeftHand((PsiExpression)expression) && !PsiUtil.isAccessedForReading((PsiExpression)expression)) {
            return null;
        }
        if (!containingClass.getManager().areElementsEquivalent((PsiElement)containingClass, PsiTreeUtil.getParentOfType((PsiElement)expression, PsiClass.class))) {
            return null;
        }
        return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)expression, JavaErrorMessages.message("illegal.forward.reference", new Object[0]));
    }

    @Nullable
    static PsiField findEnclosingFieldInitializer(PsiElement element) {
        while (element != null) {
            PsiElement parent = element.getParent();
            if (parent instanceof PsiField) {
                PsiField field = (PsiField)parent;
                if (element == field.getInitializer()) {
                    return field;
                }
                if (field instanceof PsiEnumConstant && element == ((PsiEnumConstant)field).getArgumentList()) {
                    return field;
                }
            }
            if (element instanceof PsiClass || element instanceof PsiMethod) {
                return null;
            }
            element = parent;
        }
        return null;
    }

    @Nullable
    private static PsiClassInitializer findParentClassInitializer(PsiElement element) {
        while (element != null) {
            if (element instanceof PsiClassInitializer) {
                return (PsiClassInitializer)element;
            }
            if (element instanceof PsiClass || element instanceof PsiMethod) {
                return null;
            }
            element = element.getParent();
        }
        return null;
    }

    @Nullable
    public static HighlightInfo checkIllegalType(PsiTypeElement typeElement) {
        PsiClass aClass;
        if (typeElement == null || typeElement.getParent() instanceof PsiTypeElement) {
            return null;
        }
        if (PsiUtil.isInsideJavadocComment((PsiElement)typeElement)) {
            return null;
        }
        PsiType type = typeElement.getType();
        PsiType componentType = type.getDeepComponentType();
        if (componentType instanceof PsiClassType && (aClass = PsiUtil.resolveClassInType((PsiType)componentType)) == null) {
            String canonicalText = type.getCanonicalText();
            String description = JavaErrorMessages.message("unknown.class", canonicalText);
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)typeElement, description);
        }
        return null;
    }

    @Nullable
    public static HighlightInfo checkIllegalVoidType(PsiKeyword type) {
        if (!"void".equals(type.getText())) {
            return null;
        }
        PsiElement parent = type.getParent();
        if (parent instanceof PsiTypeElement) {
            PsiElement typeOwner = parent.getParent();
            if (typeOwner instanceof PsiMethod) {
                if (((PsiMethod)typeOwner).getReturnTypeElement() == parent) {
                    return null;
                }
            } else {
                if (typeOwner instanceof PsiClassObjectAccessExpression && TypeConversionUtil.isVoidType((PsiType)((PsiClassObjectAccessExpression)typeOwner).getOperand().getType())) {
                    return null;
                }
                if (typeOwner != null && PsiUtilBase.hasErrorElementChild((PsiElement)typeOwner)) {
                    return null;
                }
                if (typeOwner instanceof JavaCodeFragment && typeOwner.getUserData(PsiUtil.VALID_VOID_TYPE_IN_CODE_FRAGMENT) != null) {
                    return null;
                }
            }
        }
        String description = JavaErrorMessages.message("illegal.type.void", new Object[0]);
        return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)type, description);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static HighlightInfo checkMemberReferencedBeforeConstructorCalled(PsiElement expression) {
        String resolvedName;
        PsiClass referencedClass;
        if (expression instanceof PsiJavaCodeReferenceElement) {
            PsiElement resolved = ((PsiJavaCodeReferenceElement)expression).advancedResolve(true).getElement();
            if ("this".equals(((PsiJavaCodeReferenceElement)expression).getReferenceName()) && resolved instanceof PsiMethod && ((PsiMethod)resolved).isConstructor()) {
                return null;
            }
            PsiElement qualifier = ((PsiJavaCodeReferenceElement)expression).getQualifier();
            PsiType type = qualifier instanceof PsiExpression ? ((PsiExpression)qualifier).getType() : null;
            referencedClass = PsiUtil.resolveClassInType((PsiType)type);
            boolean isSuperCall = HighlightUtil.isSuperMethodCall(expression.getParent());
            if (resolved == null && isSuperCall) {
                if (qualifier instanceof PsiReferenceExpression) {
                    resolved = ((PsiReferenceExpression)qualifier).resolve();
                    expression = qualifier;
                    type = ((PsiReferenceExpression)qualifier).getType();
                    referencedClass = PsiUtil.resolveClassInType((PsiType)type);
                } else if (qualifier instanceof PsiThisExpression || qualifier == null) {
                    resolved = PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiMember.class});
                    PsiElement psiElement = expression = qualifier == null ? expression : qualifier;
                    if (resolved instanceof PsiMethod) {
                        referencedClass = ((PsiMethod)resolved).getContainingClass();
                    }
                }
            }
            if (resolved instanceof PsiField) {
                PsiField referencedField = (PsiField)resolved;
                if (referencedField.hasModifierProperty("static")) {
                    return null;
                }
                resolvedName = PsiFormatUtil.formatVariable((PsiVariable)referencedField, (int)4097, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                referencedClass = referencedField.getContainingClass();
            } else if (resolved instanceof PsiMethod) {
                String name;
                PsiMethod method = (PsiMethod)resolved;
                if (method.hasModifierProperty("static")) {
                    return null;
                }
                PsiElement nameElement = expression instanceof PsiThisExpression ? expression : ((PsiJavaCodeReferenceElement)expression).getReferenceNameElement();
                String string = name = nameElement == null ? null : nameElement.getText();
                if (isSuperCall) {
                    if (referencedClass == null) {
                        return null;
                    }
                    if (qualifier == null) {
                        PsiClass superClass = referencedClass.getSuperClass();
                        if (superClass == null || !PsiUtil.isInnerClass((PsiClass)superClass) || !InheritanceUtil.isInheritorOrSelf((PsiClass)referencedClass, (PsiClass)superClass.getContainingClass(), (boolean)true)) return null;
                        resolvedName = "this";
                    } else {
                        resolvedName = qualifier.getText();
                    }
                } else if ("this".equals(name)) {
                    resolvedName = "this";
                } else {
                    resolvedName = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4097, (int)0);
                    if (referencedClass == null) {
                        referencedClass = method.getContainingClass();
                    }
                }
            } else {
                if (!(resolved instanceof PsiClass)) return null;
                PsiClass aClass = (PsiClass)resolved;
                if (aClass.hasModifierProperty("static")) {
                    return null;
                }
                referencedClass = aClass.getContainingClass();
                if (referencedClass == null) {
                    return null;
                }
                resolvedName = PsiFormatUtil.formatClass((PsiClass)aClass, (int)1);
            }
        } else {
            if (!(expression instanceof PsiThisExpression)) return null;
            PsiThisExpression thisExpression = (PsiThisExpression)expression;
            PsiType type = thisExpression.getType();
            referencedClass = PsiUtil.resolveClassInType((PsiType)type);
            resolvedName = thisExpression.getQualifier() != null ? (referencedClass == null ? null : PsiFormatUtil.formatClass((PsiClass)referencedClass, (int)4097) + ".this") : "this";
        }
        if (referencedClass != null) return HighlightUtil.checkReferenceToOurInstanceInsideThisOrSuper(expression, referencedClass, resolvedName);
        return null;
    }

    private static HighlightInfo checkReferenceToOurInstanceInsideThisOrSuper(PsiElement expression, PsiClass referencedClass, String resolvedName) {
        if (PsiTreeUtil.getParentOfType((PsiElement)expression, PsiReferenceParameterList.class) != null) {
            return null;
        }
        for (PsiElement element = expression.getParent(); element != null; element = element.getParent()) {
            if (!HighlightUtil.isSuperOrThisMethodCall(element)) continue;
            PsiElement parentClass = new PsiMatcherImpl(element).parent(PsiMatchers.hasClass(PsiExpressionStatement.class)).parent(PsiMatchers.hasClass(PsiCodeBlock.class)).parent(PsiMatchers.hasClass(PsiMethod.class)).dot(PsiMatchers.isConstructor((boolean)true)).parent(PsiMatchers.hasClass(PsiClass.class)).getElement();
            if (parentClass == null) {
                return null;
            }
            PsiClass aClass = (PsiClass)parentClass;
            if (PsiUtil.isInnerClass((PsiClass)aClass) && referencedClass == aClass.getContainingClass()) {
                return null;
            }
            if (!InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)referencedClass, (boolean)true)) {
                return null;
            }
            if (expression instanceof PsiReferenceExpression && !HighlightUtil.thisOrSuperReference(((PsiReferenceExpression)expression).getQualifierExpression(), aClass)) {
                return null;
            }
            return HighlightUtil.createMemberReferencedError(resolvedName, expression.getTextRange());
        }
        return null;
    }

    private static HighlightInfo createMemberReferencedError(@NonNls String resolvedName, TextRange textRange) {
        String description = JavaErrorMessages.message("member.referenced.before.constructor.called", resolvedName);
        return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, textRange, description);
    }

    public static HighlightInfo checkImplicitThisReferenceBeforeSuper(PsiClass aClass) {
        if (aClass instanceof PsiAnonymousClass) {
            return null;
        }
        PsiClass superClass = aClass.getSuperClass();
        if (superClass == null || !PsiUtil.isInnerClass((PsiClass)superClass)) {
            return null;
        }
        PsiClass outerClass = superClass.getContainingClass();
        if (!InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)outerClass, (boolean)true)) {
            return null;
        }
        PsiMethod[] constructors = aClass.getConstructors();
        if (constructors.length == 0) {
            TextRange range = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
            return HighlightUtil.createMemberReferencedError(aClass.getName() + ".this", range);
        }
        for (PsiMethod constructor : constructors) {
            if (HighlightUtil.isSuperCalledInConstructor(constructor)) continue;
            return HighlightUtil.createMemberReferencedError(aClass.getName() + ".this", HighlightNamesUtil.getMethodDeclarationTextRange(constructor));
        }
        return null;
    }

    private static boolean isSuperCalledInConstructor(PsiMethod constructor) {
        PsiCodeBlock body = constructor.getBody();
        if (body == null) {
            return false;
        }
        PsiStatement[] statements = body.getStatements();
        if (statements.length == 0) {
            return false;
        }
        PsiStatement statement = statements[0];
        PsiElement element = new PsiMatcherImpl((PsiElement)statement).dot(PsiMatchers.hasClass(PsiExpressionStatement.class)).firstChild(PsiMatchers.hasClass(PsiMethodCallExpression.class)).firstChild(PsiMatchers.hasClass(PsiReferenceExpression.class)).firstChild(PsiMatchers.hasClass(PsiKeyword.class)).dot(PsiMatchers.hasText((String)"super")).getElement();
        return element != null;
    }

    private static String getMethodExpressionName(PsiElement element) {
        if (!(element instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiReferenceExpression methodExpression = ((PsiMethodCallExpression)element).getMethodExpression();
        return methodExpression.getReferenceName();
    }

    public static boolean isSuperOrThisMethodCall(PsiElement element) {
        String name = HighlightUtil.getMethodExpressionName(element);
        return "super".equals(name) || "this".equals(name);
    }

    public static boolean isSuperMethodCall(PsiElement element) {
        String name = HighlightUtil.getMethodExpressionName(element);
        return "super".equals(name);
    }

    private static boolean thisOrSuperReference(PsiExpression qualifierExpression, PsiClass aClass) {
        PsiJavaCodeReferenceElement qualifier;
        if (qualifierExpression == null) {
            return true;
        }
        if (qualifierExpression instanceof PsiThisExpression) {
            qualifier = ((PsiThisExpression)qualifierExpression).getQualifier();
        } else if (qualifierExpression instanceof PsiSuperExpression) {
            qualifier = ((PsiSuperExpression)qualifierExpression).getQualifier();
        } else {
            return false;
        }
        if (qualifier == null) {
            return true;
        }
        PsiElement resolved = qualifier.resolve();
        return resolved instanceof PsiClass && InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)((PsiClass)resolved), (boolean)true);
    }

    @Nullable
    public static HighlightInfo checkLabelWithoutStatement(PsiLabeledStatement statement) {
        if (statement.getStatement() == null) {
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)statement, JavaErrorMessages.message("label.without.statement", new Object[0]));
        }
        return null;
    }

    @Nullable
    public static HighlightInfo checkLabelAlreadyInUse(PsiLabeledStatement statement) {
        PsiIdentifier identifier = statement.getLabelIdentifier();
        String text = identifier.getText();
        for (PsiLabeledStatement element = statement; element != null && !(element instanceof PsiMethod) && !(element instanceof PsiClass); element = element.getParent()) {
            if (!(element instanceof PsiLabeledStatement) || element == statement || !Comparing.equal((String)element.getLabelIdentifier().getText(), (String)text)) continue;
            String description = JavaErrorMessages.message("duplicate.label", text);
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)identifier, description);
        }
        return null;
    }

    @Nullable
    public static HighlightInfo checkUnclosedComment(PsiComment comment) {
        if (!(comment instanceof PsiDocComment) && comment.getTokenType() != JavaTokenType.C_STYLE_COMMENT) {
            return null;
        }
        if (!comment.getText().endsWith("*/")) {
            int start = comment.getTextRange().getEndOffset() - 1;
            int end = start + 1;
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, start, end, JavaErrorMessages.message("nonterminated.comment", new Object[0]));
        }
        return null;
    }

    @Nullable
    public static HighlightInfo checkExceptionAlreadyCaught(PsiJavaCodeReferenceElement element, PsiElement resolved) {
        if (!(resolved instanceof PsiClass)) {
            return null;
        }
        PsiClass catchClass = (PsiClass)resolved;
        if (!(element.getParent() instanceof PsiTypeElement)) {
            return null;
        }
        PsiElement catchParameter = element.getParent().getParent();
        if (!(catchParameter instanceof PsiParameter) || !(((PsiParameter)catchParameter).getDeclarationScope() instanceof PsiCatchSection)) {
            return null;
        }
        PsiCatchSection catchSection = (PsiCatchSection)((PsiParameter)catchParameter).getDeclarationScope();
        PsiTryStatement statement = catchSection.getTryStatement();
        Object[] catchSections = statement.getCatchSections();
        int i = ArrayUtil.find((Object[])catchSections, (Object)catchSection);
        --i;
        while (i >= 0) {
            Object section = catchSections[i];
            PsiType type = section.getCatchType();
            PsiClass upCatchClass = PsiUtil.resolveClassInType((PsiType)type);
            if (upCatchClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)catchClass, (PsiClass)upCatchClass, (boolean)true)) {
                String description = JavaErrorMessages.message("exception.already.caught", PsiFormatUtil.formatClass((PsiClass)catchClass, (int)2049));
                HighlightInfo highlightInfo = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)element, description);
                QuickFixAction.registerQuickFixAction(highlightInfo, new MoveCatchUpFix(catchSection, (PsiCatchSection)section));
                QuickFixAction.registerQuickFixAction(highlightInfo, new DeleteCatchFix((PsiParameter)catchParameter));
                return highlightInfo;
            }
            --i;
        }
        return null;
    }

    @Nullable
    public static HighlightInfo checkTernaryOperatorConditionIsBoolean(PsiExpression expression) {
        if (expression.getParent() instanceof PsiConditionalExpression && ((PsiConditionalExpression)expression.getParent()).getCondition() == expression && expression.getType() != null && !TypeConversionUtil.isBooleanType((PsiType)expression.getType())) {
            PsiType foundType = expression.getType();
            return HighlightUtil.createIncompatibleTypeHighlightInfo(PsiType.BOOLEAN, foundType, expression.getTextRange());
        }
        return null;
    }

    @Nullable
    public static HighlightInfo checkStatementPrependedWithCaseInsideSwitch(PsiStatement statement) {
        if (!(statement instanceof PsiSwitchLabelStatement) && statement.getParent() instanceof PsiCodeBlock && statement.getParent().getParent() instanceof PsiSwitchStatement && ((PsiCodeBlock)statement.getParent()).getStatements().length != 0 && statement == ((PsiCodeBlock)statement.getParent()).getStatements()[0]) {
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)statement, JavaErrorMessages.message("statement.must.be.prepended.with.case.label", new Object[0]));
        }
        return null;
    }

    @Nullable
    public static HighlightInfo checkAssertOperatorTypes(PsiExpression expression) {
        if (!(expression.getParent() instanceof PsiAssertStatement)) {
            return null;
        }
        PsiAssertStatement assertStatement = (PsiAssertStatement)expression.getParent();
        PsiType type = expression.getType();
        if (type == null) {
            return null;
        }
        if (expression == assertStatement.getAssertCondition() && !TypeConversionUtil.isBooleanType((PsiType)type)) {
            return HighlightUtil.createIncompatibleTypeHighlightInfo(PsiType.BOOLEAN, type, expression.getTextRange());
        }
        if (expression == assertStatement.getAssertDescription() && TypeConversionUtil.isVoidType((PsiType)type)) {
            String description = JavaErrorMessages.message("void.type.is.not.allowed", new Object[0]);
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)expression, description);
        }
        return null;
    }

    @Nullable
    public static HighlightInfo checkSynchronizedExpressionType(PsiExpression expression) {
        if (expression.getParent() instanceof PsiSynchronizedStatement) {
            PsiType type = expression.getType();
            if (type == null) {
                return null;
            }
            PsiSynchronizedStatement synchronizedStatement = (PsiSynchronizedStatement)expression.getParent();
            if (expression == synchronizedStatement.getLockExpression() && (type instanceof PsiPrimitiveType || TypeConversionUtil.isNullType((PsiType)type))) {
                PsiClassType objectType = PsiType.getJavaLangObject((PsiManager)expression.getManager(), (GlobalSearchScope)expression.getResolveScope());
                return HighlightUtil.createIncompatibleTypeHighlightInfo((PsiType)objectType, type, expression.getTextRange());
            }
        }
        return null;
    }

    @Nullable
    public static HighlightInfo checkConditionalExpressionBranchTypesMatch(PsiExpression expression) {
        if (!(expression.getParent() instanceof PsiConditionalExpression)) {
            return null;
        }
        PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)expression.getParent();
        if (conditionalExpression.getElseExpression() != expression) {
            return null;
        }
        PsiExpression thenExpression = conditionalExpression.getThenExpression();
        assert (thenExpression != null);
        PsiType thenType = thenExpression.getType();
        PsiType elseType = expression.getType();
        if (thenType == null || elseType == null) {
            return null;
        }
        if (conditionalExpression.getType() == null) {
            return HighlightUtil.createIncompatibleTypeHighlightInfo(thenType, elseType, expression.getTextRange());
        }
        return null;
    }

    private static HighlightInfo createIncompatibleTypeHighlightInfo(PsiType lType, PsiType rType, TextRange textRange) {
        PsiType lType1 = lType;
        PsiType rType1 = rType;
        PsiTypeParameter[] lTypeParams = PsiTypeParameter.EMPTY_ARRAY;
        PsiSubstitutor lTypeSubstitutor = PsiSubstitutor.EMPTY;
        if (lType1 instanceof PsiClassType) {
            PsiClassType.ClassResolveResult resolveResult = ((PsiClassType)lType1).resolveGenerics();
            lTypeSubstitutor = resolveResult.getSubstitutor();
            PsiClass psiClass = resolveResult.getElement();
            if (psiClass instanceof PsiAnonymousClass) {
                lType1 = ((PsiAnonymousClass)psiClass).getBaseClassType();
                resolveResult = ((PsiClassType)lType1).resolveGenerics();
                lTypeSubstitutor = resolveResult.getSubstitutor();
                psiClass = resolveResult.getElement();
            }
            lTypeParams = psiClass == null ? PsiTypeParameter.EMPTY_ARRAY : psiClass.getTypeParameters();
        }
        PsiTypeParameter[] rTypeParams = PsiTypeParameter.EMPTY_ARRAY;
        PsiSubstitutor rTypeSubstitutor = PsiSubstitutor.EMPTY;
        if (rType1 instanceof PsiClassType) {
            PsiClassType.ClassResolveResult resolveResult = ((PsiClassType)rType1).resolveGenerics();
            rTypeSubstitutor = resolveResult.getSubstitutor();
            PsiClass psiClass = resolveResult.getElement();
            if (psiClass instanceof PsiAnonymousClass) {
                rType1 = ((PsiAnonymousClass)psiClass).getBaseClassType();
                resolveResult = ((PsiClassType)rType1).resolveGenerics();
                rTypeSubstitutor = resolveResult.getSubstitutor();
                psiClass = resolveResult.getElement();
            }
            rTypeParams = psiClass == null ? PsiTypeParameter.EMPTY_ARRAY : psiClass.getTypeParameters();
        }
        int typeParamColumns = Math.max(lTypeParams.length, rTypeParams.length);
        String requredRow = "";
        String foundRow = "";
        for (int i = 0; i < typeParamColumns; ++i) {
            PsiTypeParameter lTypeParameter = i >= lTypeParams.length ? null : lTypeParams[i];
            PsiTypeParameter rTypeParameter = i >= rTypeParams.length ? null : rTypeParams[i];
            PsiType lSubstedType = lTypeParameter == null ? null : lTypeSubstitutor.substitute(lTypeParameter);
            PsiType rSubstedType = rTypeParameter == null ? null : rTypeSubstitutor.substitute(rTypeParameter);
            boolean matches = Comparing.equal((Object)lSubstedType, (Object)rSubstedType);
            String openBrace = i == 0 ? "&lt;" : "";
            String closeBrace = i == typeParamColumns - 1 ? "&gt;" : ",";
            requredRow = requredRow + "<td>" + (lTypeParams.length == 0 ? "" : openBrace) + HighlightUtil.redIfNotMatch(lSubstedType, matches) + (i < lTypeParams.length ? closeBrace : "") + "</td>";
            foundRow = foundRow + "<td>" + (rTypeParams.length == 0 ? "" : openBrace) + HighlightUtil.redIfNotMatch(rSubstedType, matches) + (i < rTypeParams.length ? closeBrace : "") + "</td>";
        }
        PsiType lRawType = lType1 instanceof PsiClassType ? ((PsiClassType)lType1).rawType() : lType1;
        PsiType rRawType = rType1 instanceof PsiClassType ? ((PsiClassType)rType1).rawType() : rType1;
        boolean assignable = lRawType == null || rRawType == null || TypeConversionUtil.isAssignable((PsiType)lRawType, (PsiType)rRawType);
        String toolTip = JavaErrorMessages.message("incompatible.types.html.tooltip", HighlightUtil.redIfNotMatch(lRawType, assignable), requredRow, HighlightUtil.redIfNotMatch(rRawType, assignable), foundRow);
        String description = JavaErrorMessages.message("incompatible.types", HighlightUtil.formatType(lType1), HighlightUtil.formatType(rType1));
        return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, null, textRange.getStartOffset(), textRange.getEndOffset(), description, toolTip);
    }

    @Nullable
    public static HighlightInfo checkSingleImportClassConflict(PsiImportStatement statement, Map<String, Pair<PsiImportStatementBase, PsiClass>> singleImportedClasses) {
        if (statement.isOnDemand()) {
            return null;
        }
        PsiElement element = statement.resolve();
        if (element instanceof PsiClass) {
            PsiClass importedClass;
            String name = ((PsiClass)element).getName();
            Pair<PsiImportStatementBase, PsiClass> imported = singleImportedClasses.get(name);
            PsiClass psiClass = importedClass = imported == null ? null : (PsiClass)imported.getSecond();
            if (importedClass != null && !element.getManager().areElementsEquivalent((PsiElement)importedClass, element)) {
                String description = JavaErrorMessages.message("single.import.class.conflict", HighlightUtil.formatClass(importedClass));
                return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)statement, description);
            }
            singleImportedClasses.put(name, (Pair<PsiImportStatementBase, PsiClass>)Pair.create((Object)statement, (Object)((PsiClass)element)));
        }
        return null;
    }

    @NonNls
    private static String redIfNotMatch(PsiType type, boolean matches) {
        if (matches) {
            return HighlightUtil.getFQName(type, false);
        }
        return "<font color=red><b>" + HighlightUtil.getFQName(type, true) + "</b></font>";
    }

    private static String getFQName(PsiType type, boolean longName) {
        if (type == null) {
            return "";
        }
        return XmlStringUtil.escapeString((String)(longName ? type.getInternalCanonicalText() : type.getPresentableText()));
    }

    @Nullable
    public static HighlightInfo checkMustBeThrowable(PsiType type, PsiElement context, boolean addCastIntention) {
        if (type == null) {
            return null;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)context.getProject()).getElementFactory();
        PsiClassType throwable = factory.createTypeByFQClassName("java.lang.Throwable", context.getResolveScope());
        if (!TypeConversionUtil.isAssignable((PsiType)throwable, (PsiType)type)) {
            HighlightInfo highlightInfo = HighlightUtil.createIncompatibleTypeHighlightInfo((PsiType)throwable, type, context.getTextRange());
            if (addCastIntention && TypeConversionUtil.areTypesConvertible((PsiType)type, (PsiType)throwable) && context instanceof PsiExpression) {
                QuickFixAction.registerQuickFixAction(highlightInfo, new AddTypeCastFix((PsiType)throwable, (PsiExpression)context));
            }
            return highlightInfo;
        }
        return null;
    }

    @Nullable
    private static HighlightInfo checkMustBeThrowable(PsiClass aClass, PsiElement context) {
        if (aClass == null) {
            return null;
        }
        PsiClassType type = JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory().createType(aClass);
        return HighlightUtil.checkMustBeThrowable((PsiType)type, context, false);
    }

    @Nullable
    public static HighlightInfo checkLabelDefined(PsiIdentifier labelIdentifier, PsiStatement exitedStatement) {
        if (labelIdentifier == null) {
            return null;
        }
        String label = labelIdentifier.getText();
        if (label == null) {
            return null;
        }
        if (exitedStatement == null) {
            String message = JavaErrorMessages.message("unresolved.label", label);
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)labelIdentifier, message);
        }
        return null;
    }

    @Nullable
    public static HighlightInfo checkReference(PsiJavaCodeReferenceElement ref, JavaResolveResult result, PsiElement resolved) {
        PsiElement refName = ref.getReferenceNameElement();
        if (!(refName instanceof PsiIdentifier) && !(refName instanceof PsiKeyword)) {
            return null;
        }
        HighlightInfo highlightInfo = HighlightUtil.checkMemberReferencedBeforeConstructorCalled((PsiElement)ref);
        if (highlightInfo != null) {
            return highlightInfo;
        }
        PsiElement refParent = ref.getParent();
        if (!(refParent instanceof PsiMethodCallExpression)) {
            if (resolved == null) {
                String description;
                if (HighlightUtil.isInsidePackageStatement(refName)) {
                    return null;
                }
                if (result.isPackagePrefixPackageReference()) {
                    return null;
                }
                JavaResolveResult[] results = ref.multiResolve(true);
                if (results.length > 1) {
                    String t1 = HighlightUtil.format(results[0].getElement());
                    String t2 = HighlightUtil.format(results[1].getElement());
                    description = JavaErrorMessages.message("ambiguous.reference", refName.getText(), t1, t2);
                } else {
                    description = JavaErrorMessages.message("cannot.resolve.symbol", refName.getText());
                }
                HighlightInfoType type = HighlightInfoType.WRONG_REF;
                if (PsiUtil.isInsideJavadocComment((PsiElement)ref)) {
                    return null;
                }
                HighlightInfo info = HighlightInfo.createHighlightInfo(type, refName, description);
                UnresolvedReferenceQuickFixProvider.registerReferenceFixes(ref, new QuickFixActionRegistrarImpl(info));
                return info;
            }
            if (!result.isValidResult() && !PsiUtil.isInsideJavadocComment((PsiElement)ref)) {
                if (!result.isAccessible()) {
                    String description = HighlightUtil.buildProblemWithAccessDescription(ref, result);
                    HighlightInfo info = HighlightInfo.createHighlightInfo(HighlightInfoType.WRONG_REF, ref.getReferenceNameElement(), description);
                    if (result.isStaticsScopeCorrect()) {
                        HighlightUtil.registerAccessQuickFixAction((PsiMember)resolved, ref, info, result.getCurrentFileResolveScope());
                        if (ref instanceof PsiReferenceExpression) {
                            QuickFixAction.registerQuickFixAction(info, new RenameWrongRefFix((PsiReferenceExpression)ref));
                        }
                    }
                    return info;
                }
                if (!result.isStaticsScopeCorrect()) {
                    String description = HighlightUtil.buildProblemWithStaticDescription(resolved);
                    HighlightInfo info = HighlightInfo.createHighlightInfo(HighlightInfoType.WRONG_REF, ref.getReferenceNameElement(), description);
                    HighlightUtil.registerStaticProblemQuickFixAction(resolved, info, ref);
                    if (ref instanceof PsiReferenceExpression) {
                        QuickFixAction.registerQuickFixAction(info, new RenameWrongRefFix((PsiReferenceExpression)ref));
                    }
                    return info;
                }
            }
            if ((resolved instanceof PsiLocalVariable || resolved instanceof PsiParameter) && !(resolved instanceof ImplicitVariable)) {
                highlightInfo = HighlightControlFlowUtil.checkVariableMustBeFinal((PsiVariable)resolved, ref);
            }
        }
        return highlightInfo;
    }

    private static String format(PsiElement element) {
        if (element instanceof PsiClass) {
            return HighlightUtil.formatClass((PsiClass)element);
        }
        if (element instanceof PsiMethod) {
            return HighlightUtil.formatMethod((PsiMethod)element);
        }
        return ElementDescriptionUtil.getElementDescription((PsiElement)element, (ElementDescriptionLocation)HighlightUsagesDescriptionLocation.INSTANCE);
    }

    private static boolean isInsidePackageStatement(PsiElement element) {
        while (element != null) {
            if (element instanceof PsiPackageStatement) {
                return true;
            }
            if (!(element instanceof PsiIdentifier) && !(element instanceof PsiJavaCodeReferenceElement)) {
                return false;
            }
            element = element.getParent();
        }
        return false;
    }

    @Nullable
    public static HighlightInfo checkElementInReferenceList(PsiJavaCodeReferenceElement ref, PsiReferenceList referenceList, JavaResolveResult resolveResult) {
        PsiElement resolved = resolveResult.getElement();
        HighlightInfo highlightInfo = null;
        PsiElement refGrandParent = referenceList.getParent();
        if (resolved instanceof PsiClass) {
            PsiClass aClass = (PsiClass)resolved;
            if (refGrandParent instanceof PsiClass) {
                if (refGrandParent instanceof PsiTypeParameter) {
                    highlightInfo = GenericsHighlightUtil.checkElementInTypeParameterExtendsList(referenceList, resolveResult, (PsiElement)ref);
                } else {
                    highlightInfo = HighlightClassUtil.checkExtendsClassAndImplementsInterface(referenceList, resolveResult, ref);
                    if (highlightInfo == null) {
                        highlightInfo = HighlightClassUtil.checkCannotInheritFromFinal(aClass, (PsiElement)ref);
                    }
                    if (highlightInfo == null) {
                        highlightInfo = GenericsHighlightUtil.checkCannotInheritFromEnum(aClass, (PsiElement)ref);
                    }
                    if (highlightInfo == null) {
                        highlightInfo = GenericsHighlightUtil.checkCannotInheritFromTypeParameter(aClass, ref);
                    }
                }
            } else if (refGrandParent instanceof PsiMethod && ((PsiMethod)refGrandParent).getThrowsList() == referenceList) {
                highlightInfo = HighlightUtil.checkMustBeThrowable(aClass, (PsiElement)ref);
            }
        } else if (refGrandParent instanceof PsiMethod && referenceList == ((PsiMethod)refGrandParent).getThrowsList()) {
            highlightInfo = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)ref, JavaErrorMessages.message("class.name.expected", new Object[0]));
        }
        return highlightInfo;
    }

    public static boolean isSerializable(PsiClass aClass) {
        PsiManager manager = aClass.getManager();
        PsiClass serializableClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.io.Serializable", aClass.getResolveScope());
        return serializableClass != null && aClass.isInheritor(serializableClass, true);
    }

    public static boolean isSerializationImplicitlyUsedField(PsiField field) {
        String name = field.getName();
        if (!SERIAL_VERSION_UID_FIELD_NAME.equals(name) && !SERIAL_PERSISTENT_FIELDS_FIELD_NAME.equals(name)) {
            return false;
        }
        if (!field.hasModifierProperty("static")) {
            return false;
        }
        PsiClass aClass = field.getContainingClass();
        return aClass == null || HighlightUtil.isSerializable(aClass);
    }

    public static HighlightInfo checkClassReferenceAfterQualifier(PsiReferenceExpression expression, PsiElement resolved) {
        PsiElement qualifierResolved;
        if (!(resolved instanceof PsiClass)) {
            return null;
        }
        PsiExpression qualifier = expression.getQualifierExpression();
        if (qualifier == null) {
            return null;
        }
        if (qualifier instanceof PsiReferenceExpression && ((qualifierResolved = ((PsiReferenceExpression)qualifier).resolve()) instanceof PsiClass || qualifierResolved instanceof PsiPackage)) {
            return null;
        }
        HighlightInfo info = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)qualifier, JavaErrorMessages.message("expected.class.or.package", new Object[0]));
        QuickFixAction.registerQuickFixAction(info, new RemoveQualifierFix(qualifier, expression, (PsiClass)resolved));
        return info;
    }

    public static void registerChangeVariableTypeFixes(PsiVariable parameter, PsiType itemType, HighlightInfo highlightInfo) {
        for (ChangeVariableTypeQuickFixProvider fixProvider : (ChangeVariableTypeQuickFixProvider[])Extensions.getExtensions((ExtensionPointName)ChangeVariableTypeQuickFixProvider.EP_NAME)) {
            for (IntentionAction action : fixProvider.getFixes(parameter, itemType)) {
                QuickFixAction.registerQuickFixAction(highlightInfo, action, null);
            }
        }
    }

    static {
        QUICK_FIX_FACTORY = QuickFixFactory.getInstance();
        ourClassIncompatibleModifiers = new THashMap(8);
        THashSet modifiers = new THashSet(1);
        modifiers.add("final");
        ourClassIncompatibleModifiers.put("abstract", (Set<String>)modifiers);
        modifiers = new THashSet(1);
        modifiers.add("abstract");
        ourClassIncompatibleModifiers.put("final", (Set<String>)modifiers);
        modifiers = new THashSet(3);
        modifiers.add("private");
        modifiers.add("public");
        modifiers.add("protected");
        ourClassIncompatibleModifiers.put("packageLocal", (Set<String>)modifiers);
        modifiers = new THashSet(3);
        modifiers.add("packageLocal");
        modifiers.add("public");
        modifiers.add("protected");
        ourClassIncompatibleModifiers.put("private", (Set<String>)modifiers);
        modifiers = new THashSet(3);
        modifiers.add("packageLocal");
        modifiers.add("private");
        modifiers.add("protected");
        ourClassIncompatibleModifiers.put("public", (Set<String>)modifiers);
        modifiers = new THashSet(3);
        modifiers.add("packageLocal");
        modifiers.add("public");
        modifiers.add("private");
        ourClassIncompatibleModifiers.put("protected", (Set<String>)modifiers);
        ourClassIncompatibleModifiers.put("strictfp", Collections.emptySet());
        ourClassIncompatibleModifiers.put("static", Collections.emptySet());
        ourInterfaceIncompatibleModifiers = new THashMap(7);
        ourInterfaceIncompatibleModifiers.put("abstract", Collections.emptySet());
        modifiers = new THashSet(3);
        modifiers.add("private");
        modifiers.add("public");
        modifiers.add("protected");
        ourInterfaceIncompatibleModifiers.put("packageLocal", (Set<String>)modifiers);
        modifiers = new THashSet(3);
        modifiers.add("packageLocal");
        modifiers.add("public");
        modifiers.add("protected");
        ourInterfaceIncompatibleModifiers.put("private", (Set<String>)modifiers);
        modifiers = new THashSet(3);
        modifiers.add("private");
        modifiers.add("packageLocal");
        modifiers.add("protected");
        ourInterfaceIncompatibleModifiers.put("public", (Set<String>)modifiers);
        modifiers = new THashSet(3);
        modifiers.add("private");
        modifiers.add("public");
        modifiers.add("packageLocal");
        ourInterfaceIncompatibleModifiers.put("protected", (Set<String>)modifiers);
        ourInterfaceIncompatibleModifiers.put("strictfp", Collections.emptySet());
        ourInterfaceIncompatibleModifiers.put("static", Collections.emptySet());
        ourMethodIncompatibleModifiers = new THashMap(10);
        modifiers = new THashSet(6);
        modifiers.addAll(Arrays.asList("native", "static", "final", "private", "strictfp", "synchronized"));
        ourMethodIncompatibleModifiers.put("abstract", (Set<String>)modifiers);
        modifiers = new THashSet(2);
        modifiers.add("abstract");
        modifiers.add("strictfp");
        ourMethodIncompatibleModifiers.put("native", (Set<String>)modifiers);
        modifiers = new THashSet(3);
        modifiers.add("private");
        modifiers.add("public");
        modifiers.add("protected");
        ourMethodIncompatibleModifiers.put("packageLocal", (Set<String>)modifiers);
        modifiers = new THashSet(4);
        modifiers.add("abstract");
        modifiers.add("packageLocal");
        modifiers.add("public");
        modifiers.add("protected");
        ourMethodIncompatibleModifiers.put("private", (Set<String>)modifiers);
        modifiers = new THashSet(3);
        modifiers.add("packageLocal");
        modifiers.add("private");
        modifiers.add("protected");
        ourMethodIncompatibleModifiers.put("public", (Set<String>)modifiers);
        modifiers = new THashSet(3);
        modifiers.add("packageLocal");
        modifiers.add("public");
        modifiers.add("private");
        ourMethodIncompatibleModifiers.put("protected", (Set<String>)modifiers);
        modifiers = new THashSet(1);
        modifiers.add("abstract");
        ourMethodIncompatibleModifiers.put("static", (Set<String>)modifiers);
        ourMethodIncompatibleModifiers.put("synchronized", (Set<String>)modifiers);
        ourMethodIncompatibleModifiers.put("strictfp", (Set<String>)modifiers);
        ourMethodIncompatibleModifiers.put("final", (Set<String>)modifiers);
        ourFieldIncompatibleModifiers = new THashMap(8);
        modifiers = new THashSet(1);
        modifiers.add("volatile");
        ourFieldIncompatibleModifiers.put("final", (Set<String>)modifiers);
        modifiers = new THashSet(3);
        modifiers.add("private");
        modifiers.add("public");
        modifiers.add("protected");
        ourFieldIncompatibleModifiers.put("packageLocal", (Set<String>)modifiers);
        modifiers = new THashSet(3);
        modifiers.add("packageLocal");
        modifiers.add("public");
        modifiers.add("protected");
        ourFieldIncompatibleModifiers.put("private", (Set<String>)modifiers);
        modifiers = new THashSet(3);
        modifiers.add("packageLocal");
        modifiers.add("private");
        modifiers.add("protected");
        ourFieldIncompatibleModifiers.put("public", (Set<String>)modifiers);
        modifiers = new THashSet(3);
        modifiers.add("packageLocal");
        modifiers.add("private");
        modifiers.add("public");
        ourFieldIncompatibleModifiers.put("protected", (Set<String>)modifiers);
        ourFieldIncompatibleModifiers.put("static", Collections.emptySet());
        ourFieldIncompatibleModifiers.put("transient", Collections.emptySet());
        modifiers = new THashSet(1);
        modifiers.add("final");
        ourFieldIncompatibleModifiers.put("volatile", (Set<String>)modifiers);
        ourClassInitializerIncompatibleModifiers = new THashMap(1);
        ourClassInitializerIncompatibleModifiers.put("static", Collections.emptySet());
        ourConstructorNotAllowedModifiers = new THashSet(6);
        ourConstructorNotAllowedModifiers.add("abstract");
        ourConstructorNotAllowedModifiers.add("static");
        ourConstructorNotAllowedModifiers.add("native");
        ourConstructorNotAllowedModifiers.add("final");
        ourConstructorNotAllowedModifiers.add("strictfp");
        ourConstructorNotAllowedModifiers.add("synchronized");
    }
}

