/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPlainText;
import com.intellij.util.containers.CollectionFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class NaturalLanguageTextSelectioner
extends ExtendWordSelectionHandlerBase {
    private static final Set<Character> NATURAL = CollectionFactory.newTroveSet((Object[])new Character[]{Character.valueOf('('), Character.valueOf(')'), Character.valueOf('.'), Character.valueOf(','), Character.valueOf(':'), Character.valueOf(';'), Character.valueOf('!'), Character.valueOf('?'), Character.valueOf('$'), Character.valueOf('@'), Character.valueOf('%'), Character.valueOf('\"'), Character.valueOf('\'')});
    private static final Set<Character> SENTENCE_END = CollectionFactory.newTroveSet((Object[])new Character[]{Character.valueOf('.'), Character.valueOf('!'), Character.valueOf('?')});

    @Override
    public boolean canSelect(PsiElement e) {
        return e instanceof PsiPlainText || e instanceof PsiComment;
    }

    @Override
    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        int elementEnd;
        boolean isParagraph;
        int elementStart;
        SelectionModel selectionModel = editor.getSelectionModel();
        if (!selectionModel.hasSelection()) {
            return Collections.emptyList();
        }
        int sentenceStart = selectionModel.getSelectionStart();
        if (sentenceStart <= (elementStart = e.getTextRange().getStartOffset())) {
            return Collections.emptyList();
        }
        int paragraphStart = ((Object)editorText.subSequence(elementStart, sentenceStart)).toString().lastIndexOf("\n\n");
        paragraphStart = paragraphStart < 0 ? elementStart : (paragraphStart += 2 + elementStart);
        boolean bl = isParagraph = paragraphStart == sentenceStart;
        while (sentenceStart > paragraphStart) {
            char c = editorText.charAt(sentenceStart - 1);
            if (!NaturalLanguageTextSelectioner.isNatural(c)) {
                return Collections.emptyList();
            }
            if (SENTENCE_END.contains(Character.valueOf(c))) break;
            --sentenceStart;
        }
        while (Character.isWhitespace(editorText.charAt(sentenceStart))) {
            ++sentenceStart;
        }
        int sentenceEnd = selectionModel.getSelectionEnd();
        if (sentenceEnd > (elementEnd = e.getTextRange().getEndOffset())) {
            return Collections.emptyList();
        }
        int paragraphEnd = ((Object)editorText.subSequence(sentenceEnd, elementEnd)).toString().indexOf("\n\n");
        paragraphEnd = paragraphEnd < 0 ? elementEnd : (paragraphEnd += sentenceEnd);
        if (isParagraph &= paragraphEnd == sentenceEnd) {
            return Collections.emptyList();
        }
        if (sentenceEnd > elementStart) {
            --sentenceEnd;
        }
        while (sentenceEnd < paragraphEnd) {
            char c = editorText.charAt(sentenceEnd);
            if (!NaturalLanguageTextSelectioner.isNatural(c)) {
                return Collections.emptyList();
            }
            ++sentenceEnd;
            if (!SENTENCE_END.contains(Character.valueOf(c))) continue;
            break;
        }
        if (sentenceStart == selectionModel.getSelectionStart() && sentenceEnd == selectionModel.getSelectionEnd()) {
            return Arrays.asList(new TextRange(paragraphStart, paragraphEnd));
        }
        return Arrays.asList(new TextRange(sentenceStart, sentenceEnd));
    }

    private static boolean isNatural(char c) {
        return Character.isWhitespace(c) || Character.isLetterOrDigit(c) || NATURAL.contains(Character.valueOf(c));
    }
}

