/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint.api.impls;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodParameterInfoHandler
implements ParameterInfoHandlerWithTabActionSupport<PsiExpressionList, Object, PsiExpression> {
    private static final Set<Class> ourArgumentListAllowedParentClassesSet = new HashSet(Arrays.asList(PsiMethodCallExpression.class, PsiNewExpression.class, PsiAnonymousClass.class, PsiEnumConstant.class));

    public Object[] getParametersForLookup(LookupElement item, ParameterInfoContext context) {
        List<? extends PsiElement> allElements = JavaCompletionUtil.getAllPsiElements(item);
        if (allElements != null && allElements.size() > 0 && allElements.get(0) instanceof PsiMethod) {
            return allElements.toArray(new PsiMethod[allElements.size()]);
        }
        return null;
    }

    public Object[] getParametersForDocumentation(Object p, ParameterInfoContext context) {
        if (p instanceof MethodCandidateInfo) {
            return ((MethodCandidateInfo)p).getElement().getParameterList().getParameters();
        }
        if (p instanceof PsiMethod) {
            return ((PsiMethod)p).getParameterList().getParameters();
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean couldShowInLookup() {
        return true;
    }

    @Nullable
    public PsiExpressionList findElementForParameterInfo(CreateParameterInfoContext context) {
        PsiExpressionList argumentList = this.findArgumentList(context.getFile(), context.getOffset(), context.getParameterListStart());
        if (argumentList != null) {
            return MethodParameterInfoHandler.findMethodsForArgumentList(context, argumentList);
        }
        return argumentList;
    }

    private PsiExpressionList findArgumentList(PsiFile file, int offset, int parameterStart) {
        PsiMethodCallExpression methodCall;
        PsiExpressionList argumentList = (PsiExpressionList)ParameterInfoUtils.findArgumentList((PsiFile)file, (int)offset, (int)parameterStart, (ParameterInfoHandlerWithTabActionSupport)this);
        if (argumentList == null && (methodCall = (PsiMethodCallExpression)ParameterInfoUtils.findParentOfType((PsiFile)file, (int)offset, PsiMethodCallExpression.class)) != null) {
            argumentList = methodCall.getArgumentList();
        }
        return argumentList;
    }

    private static PsiExpressionList findMethodsForArgumentList(CreateParameterInfoContext context, @NotNull PsiExpressionList argumentList) {
        if (argumentList == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/hint/api/impls/MethodParameterInfoHandler.findMethodsForArgumentList must not be null");
        }
        Object[] candidates = MethodParameterInfoHandler.getMethods(argumentList);
        if (candidates.length == 0) {
            DaemonCodeAnalyzer.getInstance((Project)context.getProject()).updateVisibleHighlighters(context.getEditor());
            return null;
        }
        context.setItemsToShow(candidates);
        return argumentList;
    }

    public void showParameterInfo(@NotNull PsiExpressionList element, CreateParameterInfoContext context) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/hint/api/impls/MethodParameterInfoHandler.showParameterInfo must not be null");
        }
        context.showHint((PsiElement)element, element.getTextRange().getStartOffset(), (ParameterInfoHandler)this);
    }

    public PsiExpressionList findElementForUpdatingParameterInfo(UpdateParameterInfoContext context) {
        return this.findArgumentList(context.getFile(), context.getOffset(), context.getParameterListStart());
    }

    public void updateParameterInfo(@NotNull PsiExpressionList o, UpdateParameterInfoContext context) {
        if (o == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/hint/api/impls/MethodParameterInfoHandler.updateParameterInfo must not be null");
        }
        if (context.getParameterOwner() != o) {
            context.removeHint();
            return;
        }
        int index = ParameterInfoUtils.getCurrentParameterIndex((ASTNode)o.getNode(), (int)context.getOffset(), (IElementType)JavaTokenType.COMMA);
        context.setCurrentParameter(index);
        Object[] candidates = context.getObjectsToView();
        PsiExpression[] args = o.getExpressions();
        for (int i = 0; i < candidates.length; ++i) {
            CandidateInfo candidate = (CandidateInfo)candidates[i];
            PsiMethod method = (PsiMethod)candidate.getElement();
            PsiSubstitutor substitutor = candidate.getSubstitutor();
            assert (substitutor != null);
            if (!method.isValid() || !substitutor.isValid()) {
                context.setUIComponentEnabled(i, false);
                continue;
            }
            PsiParameter[] parms = method.getParameterList().getParameters();
            boolean enabled = true;
            if (parms.length <= index) {
                if (parms.length > 0) {
                    if (method.isVarArgs()) {
                        for (int j = 0; j < parms.length - 1; ++j) {
                            PsiType parmType = substitutor.substitute(parms[j].getType());
                            PsiType argType = args[j].getType();
                            if (argType == null || parmType.isAssignableFrom(argType)) continue;
                            enabled = false;
                            break;
                        }
                        if (enabled) {
                            PsiArrayType lastParmType = (PsiArrayType)substitutor.substitute(parms[parms.length - 1].getType());
                            PsiType componentType = lastParmType.getComponentType();
                            if (parms.length == args.length) {
                                PsiType lastArgType = args[args.length - 1].getType();
                                if (lastArgType != null && !lastParmType.isAssignableFrom(lastArgType) && !componentType.isAssignableFrom(lastArgType)) {
                                    enabled = false;
                                }
                            } else {
                                for (int j = parms.length; j <= index && j < args.length; ++j) {
                                    PsiExpression arg = args[j];
                                    PsiType argType = arg.getType();
                                    if (argType == null || componentType.isAssignableFrom(argType)) continue;
                                    enabled = false;
                                    break;
                                }
                            }
                        }
                    } else {
                        enabled = false;
                    }
                } else {
                    enabled = index == 0;
                }
            } else {
                enabled = MethodParameterInfoHandler.isAssignableParametersBeforeGivenIndex(parms, args, index, substitutor);
            }
            context.setUIComponentEnabled(i, enabled);
            if (candidates.length <= 1 || !enabled || parms.length != args.length || !MethodParameterInfoHandler.isAssignableParametersBeforeGivenIndex(parms, args, args.length, substitutor)) continue;
            context.setHighlightedParameter((Object)candidate);
        }
    }

    private static boolean isAssignableParametersBeforeGivenIndex(PsiParameter[] parms, PsiExpression[] args, int length, PsiSubstitutor substitutor) {
        for (int j = 0; j < length; ++j) {
            PsiParameter parm = parms[j];
            PsiExpression arg = args[j];
            assert (parm.isValid());
            assert (arg.isValid());
            PsiType parmType = substitutor.substitute(parm.getType());
            PsiType argType = arg.getType();
            if (argType == null || parmType.isAssignableFrom(argType)) continue;
            return false;
        }
        return true;
    }

    public String getParameterCloseChars() {
        return ",){}";
    }

    public boolean tracksParameterIndex() {
        return true;
    }

    @NotNull
    public Class<PsiExpressionList> getArgumentListClass() {
        if (PsiExpressionList.class == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/hint/api/impls/MethodParameterInfoHandler.getArgumentListClass must not return null");
        }
        return PsiExpressionList.class;
    }

    @NotNull
    public IElementType getActualParametersRBraceType() {
        IElementType iElementType = JavaTokenType.RBRACE;
        if (iElementType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/hint/api/impls/MethodParameterInfoHandler.getActualParametersRBraceType must not return null");
        }
        return iElementType;
    }

    @NotNull
    public Set<Class> getArgumentListAllowedParentClasses() {
        Set<Class> set = ourArgumentListAllowedParentClassesSet;
        if (set == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/hint/api/impls/MethodParameterInfoHandler.getArgumentListAllowedParentClasses must not return null");
        }
        return set;
    }

    @NotNull
    public IElementType getActualParameterDelimiterType() {
        IElementType iElementType = JavaTokenType.COMMA;
        if (iElementType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/hint/api/impls/MethodParameterInfoHandler.getActualParameterDelimiterType must not return null");
        }
        return iElementType;
    }

    @NotNull
    public PsiExpression[] getActualParameters(@NotNull PsiExpressionList psiExpressionList) {
        if (psiExpressionList == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/hint/api/impls/MethodParameterInfoHandler.getActualParameters must not be null");
        }
        PsiExpression[] psiExpressionArray = psiExpressionList.getExpressions();
        if (psiExpressionArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/hint/api/impls/MethodParameterInfoHandler.getActualParameters must not return null");
        }
        return psiExpressionArray;
    }

    private static PsiCall getCall(PsiExpressionList list) {
        if (list.getParent() instanceof PsiMethodCallExpression) {
            return (PsiCall)list.getParent();
        }
        if (list.getParent() instanceof PsiNewExpression) {
            return (PsiCall)list.getParent();
        }
        if (list.getParent() instanceof PsiAnonymousClass) {
            return (PsiCall)list.getParent().getParent();
        }
        if (list.getParent() instanceof PsiEnumConstant) {
            return (PsiCall)list.getParent();
        }
        return null;
    }

    private static CandidateInfo[] getMethods(PsiExpressionList argList) {
        PsiCall call = MethodParameterInfoHandler.getCall(argList);
        PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)argList.getProject()).getResolveHelper();
        if (call instanceof PsiCallExpression) {
            CandidateInfo[] candidates = helper.getReferencedMethodCandidates((PsiCallExpression)call, true);
            ArrayList<CandidateInfo> result = new ArrayList<CandidateInfo>();
            if (!(argList.getParent() instanceof PsiAnonymousClass)) {
                block0: for (CandidateInfo candidate : candidates) {
                    for (CandidateInfo info : result) {
                        if (!MethodSignatureUtil.isSuperMethod((PsiMethod)((PsiMethod)candidate.getElement()), (PsiMethod)((PsiMethod)info.getElement()))) continue;
                        continue block0;
                    }
                    if (!candidate.isStaticsScopeCorrect() || !candidate.isAccessible()) continue;
                    result.add(candidate);
                }
            } else {
                PsiClass aClass = (PsiClass)argList.getParent();
                for (CandidateInfo candidate : candidates) {
                    if (!candidate.isStaticsScopeCorrect() || !helper.isAccessible((PsiMember)((PsiMethod)candidate.getElement()), (PsiElement)argList, aClass)) continue;
                    result.add(candidate);
                }
            }
            return result.toArray(new CandidateInfo[result.size()]);
        }
        assert (call instanceof PsiEnumConstant);
        PsiMethod[] constructors = ((PsiEnumConstant)call).getContainingClass().getConstructors();
        CandidateInfo[] result = new CandidateInfo[constructors.length];
        for (int i = 0; i < constructors.length; ++i) {
            result[i] = new CandidateInfo((PsiElement)constructors[i], PsiSubstitutor.EMPTY);
        }
        return result;
    }

    public static void updateMethodPresentation(PsiMethod method, PsiSubstitutor substitutor, ParameterInfoUIContext context) {
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        if (!method.isValid()) {
            context.setUIComponentEnabled(false);
            return;
        }
        StringBuilder buffer = new StringBuilder();
        if (settings.SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO) {
            if (!method.isConstructor()) {
                PsiType returnType = method.getReturnType();
                if (substitutor != null) {
                    returnType = substitutor.substitute(returnType);
                }
                MethodParameterInfoHandler.appendModifierList(buffer, method.getModifierList());
                buffer.append(returnType.getPresentableText());
                buffer.append(" ");
            }
            buffer.append(method.getName());
            buffer.append("(");
        }
        int currentParameter = context.getCurrentParameterIndex();
        PsiParameter[] parms = method.getParameterList().getParameters();
        int numParams = parms.length;
        int highlightStartOffset = -1;
        int highlightEndOffset = -1;
        if (numParams > 0) {
            for (int j = 0; j < numParams; ++j) {
                PsiParameter parm = parms[j];
                int startOffset = buffer.length();
                if (parm.isValid()) {
                    PsiType paramType = parm.getType();
                    if (substitutor != null) {
                        paramType = substitutor.substitute(paramType);
                    }
                    MethodParameterInfoHandler.appendModifierList(buffer, parm.getModifierList());
                    buffer.append(paramType.getPresentableText());
                    String name = parm.getName();
                    if (name != null) {
                        buffer.append(" ");
                        buffer.append(name);
                    }
                }
                int endOffset = buffer.length();
                if (j < numParams - 1) {
                    buffer.append(", ");
                }
                if (!context.isUIComponentEnabled() || j != currentParameter && (j != numParams - 1 || !parm.isVarArgs() || currentParameter < numParams)) continue;
                highlightStartOffset = startOffset;
                highlightEndOffset = endOffset;
            }
        } else {
            buffer.append(CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]));
        }
        if (settings.SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO) {
            buffer.append(")");
        }
        context.setupUIComponentPresentation(buffer.toString(), highlightStartOffset, highlightEndOffset, !context.isUIComponentEnabled(), method.isDeprecated(), false, context.getDefaultParameterColor());
    }

    private static void appendModifierList(StringBuilder buffer, PsiModifierList list) {
        if (list == null) {
            return;
        }
        int lastSize = buffer.length();
        for (PsiAnnotation a : list.getAnnotations()) {
            PsiJavaCodeReferenceElement element;
            if (lastSize != buffer.length()) {
                buffer.append(" ");
            }
            if ((element = a.getNameReferenceElement()) == null) continue;
            buffer.append("@").append(element.getText());
        }
        if (lastSize != buffer.length()) {
            buffer.append(" ");
        }
    }

    public void updateUI(Object p, ParameterInfoUIContext context) {
        if (p instanceof CandidateInfo) {
            CandidateInfo info = (CandidateInfo)p;
            MethodParameterInfoHandler.updateMethodPresentation((PsiMethod)info.getElement(), info.getSubstitutor(), context);
        } else {
            MethodParameterInfoHandler.updateMethodPresentation((PsiMethod)p, null, context);
        }
    }
}

