/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.preview;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.reference.SoftReference;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ImagePreviewComponent
extends JPanel {
    private static final Key<Long> TIMESTAMP_KEY = Key.create((String)"Image.timeStamp");
    private static final Key<SoftReference<BufferedImage>> BUFFERED_IMAGE_REF_KEY = Key.create((String)"Image.bufferedImage");
    private static final Key<String> FORMAT_KEY = Key.create((String)"Image.format");
    private static final List<String> supportedExtensions = Arrays.asList(ImageIO.getReaderFormatNames());

    private ImagePreviewComponent(@NotNull BufferedImage image) {
        if (image == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/preview/ImagePreviewComponent.<init> must not be null");
        }
        this.setLayout(new BorderLayout());
        this.add((Component)new ImageComp(image), "Center");
        this.add((Component)ImagePreviewComponent.createLabel(image), "South");
        this.setBackground(UIUtil.getToolTipBackground());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
    }

    @NotNull
    private static JLabel createLabel(@NotNull BufferedImage image) {
        if (image == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/preview/ImagePreviewComponent.createLabel must not be null");
        }
        int width = image.getWidth();
        int height = image.getHeight();
        ColorModel colorModel = image.getColorModel();
        int i = colorModel.getPixelSize();
        JLabel jLabel = new JLabel(width + "x" + height + ", " + i + "bpp");
        if (jLabel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/preview/ImagePreviewComponent.createLabel must not return null");
        }
        return jLabel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean refresh(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/preview/ImagePreviewComponent.refresh must not be null");
        }
        Long loadedTimeStamp = (Long)file.getUserData(TIMESTAMP_KEY);
        SoftReference imageRef = (SoftReference)file.getUserData(BUFFERED_IMAGE_REF_KEY);
        if (loadedTimeStamp == null || loadedTimeStamp < file.getTimeStamp() || imageRef == null || imageRef.get() == null) {
            try {
                byte[] content = file.contentsToByteArray();
                ByteArrayInputStream inputStream = new ByteArrayInputStream(content, 0, content.length);
                ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
                try {
                    Iterator<ImageReader> imageReaders = ImageIO.getImageReaders(imageInputStream);
                    if (imageReaders.hasNext()) {
                        ImageReader imageReader = imageReaders.next();
                        try {
                            file.putUserData(FORMAT_KEY, (Object)imageReader.getFormatName());
                            ImageReadParam param = imageReader.getDefaultReadParam();
                            imageReader.setInput(imageInputStream, true, true);
                            int minIndex = imageReader.getMinIndex();
                            BufferedImage image = imageReader.read(minIndex, param);
                            file.putUserData(BUFFERED_IMAGE_REF_KEY, (Object)new SoftReference((Object)image));
                            boolean bl = true;
                            imageReader.dispose();
                            return bl;
                        }
                        catch (Throwable throwable) {
                            imageReader.dispose();
                            throw throwable;
                        }
                    }
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    imageInputStream.close();
                }
            }
            finally {
                file.putUserData(TIMESTAMP_KEY, (Object)System.currentTimeMillis());
            }
        }
        return false;
    }

    public static JComponent getPreviewComponent(PsiElement parent) {
        PsiReference[] references;
        for (PsiReference reference : references = parent.getReferences()) {
            VirtualFile file;
            PsiFileSystemItem item;
            PsiElement fileItem = reference.resolve();
            if (!(fileItem instanceof PsiFileSystemItem) || (item = (PsiFileSystemItem)fileItem).isDirectory() || (file = item.getVirtualFile()) == null || !supportedExtensions.contains(file.getExtension())) continue;
            try {
                ImagePreviewComponent.refresh(file);
                SoftReference imageRef = (SoftReference)file.getUserData(BUFFERED_IMAGE_REF_KEY);
                if (imageRef == null) continue;
                return new ImagePreviewComponent((BufferedImage)imageRef.get());
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return null;
    }

    private static class ImageComp
    extends JComponent {
        private final BufferedImage myImage;
        private final Dimension myPreferredSize;

        private ImageComp(@NotNull BufferedImage image) {
            if (image == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/preview/ImagePreviewComponent$ImageComp.<init> must not be null");
            }
            this.myImage = image;
            if (image.getWidth() > 300 || image.getHeight() > 300) {
                float factor = 300.0f / (float)Math.max(image.getWidth(), image.getHeight());
                this.myPreferredSize = new Dimension((int)((float)image.getWidth() * factor), (int)((float)image.getHeight() * factor));
            } else {
                this.myPreferredSize = new Dimension(image.getWidth(), image.getHeight());
            }
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Rectangle r = this.getBounds();
            int width = this.myImage.getWidth();
            int height = this.myImage.getHeight();
            g.drawImage(this.myImage, 0, 0, r.width > width ? width : r.width, r.height > height ? height : r.height, this);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.myPreferredSize;
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }
}

