/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template;

import com.intellij.codeInsight.template.LiveTemplateBuilder;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomTemplateCallback {
    private final TemplateManager myTemplateManager;
    private final Editor myEditor;
    private final PsiFile myFile;
    private int myStartOffset;
    private final Project myProject;
    private LiveTemplateBuilder.Marker myEndOffsetMarker;
    private final Map<Object, LiveTemplateBuilder.Marker> myCheckpoints = new HashMap();
    private final boolean myInInjectedFragment;
    private FileType myFileType;
    private LiveTemplateBuilder myBuilder = new LiveTemplateBuilder();
    private int myOffset = 0;

    public CustomTemplateCallback(Editor editor, PsiFile file) {
        this.myProject = file.getProject();
        this.myTemplateManager = TemplateManagerImpl.getInstance(this.myProject);
        int caretOffset = editor.getCaretModel().getOffset();
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        PsiElement element = InjectedLanguageUtil.findElementAtNoCommit(file, caretOffset);
        this.myFile = element != null ? element.getContainingFile() : file;
        this.myInInjectedFragment = InjectedLanguageManager.getInstance((Project)this.myProject).isInjectedFragment(this.myFile);
        this.myEditor = this.myInInjectedFragment ? InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(editor, file) : editor;
        this.fixInitialState();
    }

    @NotNull
    public PsiElement getContext() {
        PsiElement psiElement = CustomTemplateCallback.getContext(this.myFile, this.myStartOffset > 0 ? this.myStartOffset - 1 : this.myStartOffset);
        if (psiElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/template/CustomTemplateCallback.getContext must not return null");
        }
        return psiElement;
    }

    public void fixInitialState() {
        this.myStartOffset = this.myEditor.getCaretModel().getOffset();
    }

    public void fixEndOffset() {
        if (this.myEndOffsetMarker == null) {
            this.myEndOffsetMarker = this.myBuilder.createMarker(this.myOffset);
        }
    }

    @Nullable
    public TemplateImpl findApplicableTemplate(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/CustomTemplateCallback.findApplicableTemplate must not be null");
        }
        List<TemplateImpl> templates = this.findApplicableTemplates(key);
        return templates.size() > 0 ? templates.get(0) : null;
    }

    @NotNull
    public List<TemplateImpl> findApplicableTemplates(String key) {
        List<TemplateImpl> templates = CustomTemplateCallback.getMatchingTemplates(key);
        List<TemplateImpl> list = templates = this.filterApplicableCandidates(templates);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/template/CustomTemplateCallback.findApplicableTemplates must not return null");
        }
        return list;
    }

    private List<TemplateImpl> filterApplicableCandidates(Collection<TemplateImpl> candidates) {
        ArrayList<TemplateImpl> result = new ArrayList<TemplateImpl>();
        for (TemplateImpl candidate : candidates) {
            if (!TemplateManagerImpl.isApplicable(this.myFile, this.myStartOffset, candidate)) continue;
            result.add(candidate);
        }
        return result;
    }

    public void expandTemplate(@NotNull String key, Map<String, String> predefinedVarValues) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/CustomTemplateCallback.expandTemplate must not be null");
        }
        List<TemplateImpl> templates = this.findApplicableTemplates(key);
        if (templates.size() > 0) {
            TemplateImpl template = templates.get(0);
            this.expandTemplate(template, predefinedVarValues);
        }
    }

    public void expandTemplate(@NotNull TemplateImpl template, Map<String, String> predefinedVarValues) {
        if (template == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/CustomTemplateCallback.expandTemplate must not be null");
        }
        int offset = this.myBuilder.insertTemplate(this.myOffset, template, predefinedVarValues);
        this.moveToOffset(offset);
    }

    public void fixStartOfTemplate(@NotNull Object key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/CustomTemplateCallback.fixStartOfTemplate must not be null");
        }
        LiveTemplateBuilder.Marker marker = this.myBuilder.createMarker(this.myOffset);
        this.myCheckpoints.put(key, marker);
    }

    public void gotoEndOfTemplate(@NotNull Object key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/CustomTemplateCallback.gotoEndOfTemplate must not be null");
        }
        this.moveToOffset(this.getEndOfTemplate(key));
    }

    public int getEndOfTemplate(@NotNull Object key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/CustomTemplateCallback.getEndOfTemplate must not be null");
        }
        LiveTemplateBuilder.Marker marker = this.myCheckpoints.get(key);
        if (marker == null) {
            throw new IllegalArgumentException();
        }
        return marker.getEndOffset();
    }

    public int getStartOfTemplate(@NotNull Object key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/CustomTemplateCallback.getStartOfTemplate must not be null");
        }
        LiveTemplateBuilder.Marker marker = this.myCheckpoints.get(key);
        if (marker == null) {
            throw new IllegalArgumentException();
        }
        return marker.getStartOffset();
    }

    public void gotoEndOffset() {
        if (this.myEndOffsetMarker != null) {
            this.moveToOffset(this.myEndOffsetMarker.getStartOffset());
        }
    }

    public void startAllExpandedTemplates() {
        if (this.myBuilder.getText().length() == 0) {
            return;
        }
        this.gotoEndOffset();
        if (this.myOffset < this.myBuilder.getText().length()) {
            this.myBuilder.insertVariableSegment(this.myOffset, "END");
        }
        TemplateImpl template = this.myBuilder.buildTemplate();
        template.setToReformat(!this.myInInjectedFragment);
        this.myTemplateManager.startTemplate(this.myEditor, template, false, this.myBuilder.getPredefinedValues(), null);
        this.myBuilder = new LiveTemplateBuilder();
        this.myEndOffsetMarker = null;
        this.myCheckpoints.clear();
    }

    public boolean startTemplate() {
        Map<TemplateImpl, String> template2Argument = ((TemplateManagerImpl)this.myTemplateManager).findMatchingTemplates(this.myFile, this.myEditor, null, TemplateSettings.getInstance());
        return ((TemplateManagerImpl)this.myTemplateManager).startNonCustomTemplates(template2Argument, this.myEditor, null);
    }

    private static List<TemplateImpl> getMatchingTemplates(@NotNull String templateKey) {
        if (templateKey == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/CustomTemplateCallback.getMatchingTemplates must not be null");
        }
        TemplateSettings settings = TemplateSettings.getInstance();
        ArrayList<TemplateImpl> candidates = new ArrayList<TemplateImpl>();
        for (TemplateImpl template : settings.getTemplates(templateKey)) {
            if (template.isDeactivated() || template.isSelectionTemplate()) continue;
            candidates.add(template);
        }
        return candidates;
    }

    @NotNull
    public Editor getEditor() {
        Editor editor = this.myEditor;
        if (editor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/template/CustomTemplateCallback.getEditor must not return null");
        }
        return editor;
    }

    @NotNull
    public FileType getFileType() {
        if (this.myFileType == null) {
            this.myFileType = this.myFile.getFileType();
        }
        FileType fileType = this.myFileType;
        if (fileType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/template/CustomTemplateCallback.getFileType must not return null");
        }
        return fileType;
    }

    public int getOffset() {
        return this.myOffset;
    }

    @NotNull
    public PsiFile parseCurrentText(FileType fileType) {
        PsiFile psiFile = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText("dummy.xml", fileType, this.myBuilder.getText(), LocalTimeCounter.currentTime(), false);
        if (psiFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/template/CustomTemplateCallback.parseCurrentText must not return null");
        }
        return psiFile;
    }

    public Project getProject() {
        return this.myProject;
    }

    public void moveToOffset(int offset) {
        this.myOffset = offset;
    }

    public void insertString(int offset, String text) {
        this.myBuilder.insertText(offset, text);
    }

    public boolean newLineBefore() {
        int i;
        CharSequence text = this.myBuilder.getText();
        for (i = this.myOffset - 1; i >= 0 && Character.isWhitespace(text.charAt(i)); --i) {
            if (text.charAt(i) != '\n') continue;
            return true;
        }
        return i < 0;
    }

    public boolean newLineAfter() {
        int i;
        CharSequence text = this.myBuilder.getText();
        for (i = this.myOffset; i < text.length() && Character.isWhitespace(text.charAt(i)); ++i) {
            if (text.charAt(i) != '\n') continue;
            return true;
        }
        return i == text.length();
    }

    public void deleteTemplateKey(String key) {
        int caretAt = this.myEditor.getCaretModel().getOffset();
        this.myEditor.getDocument().deleteString(caretAt - key.length(), caretAt);
    }

    @NotNull
    public static PsiElement getContext(@NotNull PsiFile file, int offset) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/CustomTemplateCallback.getContext must not be null");
        }
        PsiElement element = null;
        if (!InjectedLanguageManager.getInstance((Project)file.getProject()).isInjectedFragment(file)) {
            element = InjectedLanguageUtil.findInjectedElementNoCommit(file, offset);
        }
        if (element == null && (element = file.findElementAt(offset > 0 ? offset - 1 : offset)) == null) {
            element = file;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/template/CustomTemplateCallback.getContext must not return null");
        }
        return psiElement;
    }
}

