/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.CustomLiveTemplate;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ListTemplatesHandler;
import com.intellij.codeInsight.template.impl.TemplateContext;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.EditorFactoryAdapter;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateManagerImpl
extends TemplateManager
implements ProjectComponent {
    protected Project myProject;
    private boolean myTemplateTesting;
    private final List<Disposable> myDisposables = new ArrayList<Disposable>();
    private static final Key<TemplateState> TEMPLATE_STATE_KEY = Key.create((String)"TEMPLATE_STATE_KEY");

    public TemplateManagerImpl(Project project) {
        this.myProject = project;
    }

    public void disposeComponent() {
        for (Disposable disposable : this.myDisposables) {
            disposable.dispose();
        }
        this.myDisposables.clear();
    }

    public void initComponent() {
    }

    public void projectClosed() {
    }

    public void projectOpened() {
        EditorFactoryAdapter myEditorFactoryListener = new EditorFactoryAdapter(){

            public void editorReleased(EditorFactoryEvent event) {
                Editor editor = event.getEditor();
                if (editor.getProject() != null && editor.getProject() != TemplateManagerImpl.this.myProject) {
                    return;
                }
                TemplateState tState = TemplateManagerImpl.getTemplateState(editor);
                if (tState != null) {
                    TemplateManagerImpl.this.disposeState(tState);
                }
                editor.putUserData(TEMPLATE_STATE_KEY, null);
            }
        };
        EditorFactory.getInstance().addEditorFactoryListener((EditorFactoryListener)myEditorFactoryListener);
        Disposer.register((Disposable)this.myProject, (Disposable)new Disposable((EditorFactoryListener)myEditorFactoryListener){
            final /* synthetic */ EditorFactoryListener val$myEditorFactoryListener;
            {
                this.val$myEditorFactoryListener = editorFactoryListener;
            }

            public void dispose() {
                EditorFactory.getInstance().removeEditorFactoryListener(this.val$myEditorFactoryListener);
            }
        });
    }

    public void setTemplateTesting(boolean templateTesting) {
        this.myTemplateTesting = templateTesting;
    }

    private void disposeState(TemplateState tState) {
        tState.dispose();
        this.myDisposables.remove(tState);
    }

    @Override
    public Template createTemplate(@NotNull String key, String group) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/impl/TemplateManagerImpl.createTemplate must not be null");
        }
        return new TemplateImpl(key, group);
    }

    @Override
    public Template createTemplate(@NotNull String key, String group, String text) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/impl/TemplateManagerImpl.createTemplate must not be null");
        }
        return new TemplateImpl(key, text, group);
    }

    public static TemplateState getTemplateState(Editor editor) {
        return (TemplateState)editor.getUserData(TEMPLATE_STATE_KEY);
    }

    void clearTemplateState(Editor editor) {
        TemplateState prevState = TemplateManagerImpl.getTemplateState(editor);
        if (prevState != null) {
            this.disposeState(prevState);
        }
        editor.putUserData(TEMPLATE_STATE_KEY, null);
    }

    private TemplateState initTemplateState(Editor editor) {
        this.clearTemplateState(editor);
        TemplateState state = new TemplateState(this.myProject, editor);
        this.myDisposables.add(state);
        editor.putUserData(TEMPLATE_STATE_KEY, (Object)state);
        return state;
    }

    @Override
    public boolean startTemplate(@NotNull Editor editor, char shortcutChar) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/impl/TemplateManagerImpl.startTemplate must not be null");
        }
        return this.startTemplate(editor, shortcutChar, null);
    }

    @Override
    public void startTemplate(@NotNull Editor editor, @NotNull Template template) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/impl/TemplateManagerImpl.startTemplate must not be null");
        }
        if (template == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/template/impl/TemplateManagerImpl.startTemplate must not be null");
        }
        this.startTemplate(editor, template, null);
    }

    @Override
    public void startTemplate(@NotNull Editor editor, String selectionString, @NotNull Template template) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/impl/TemplateManagerImpl.startTemplate must not be null");
        }
        if (template == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/template/impl/TemplateManagerImpl.startTemplate must not be null");
        }
        this.startTemplate(editor, selectionString, template, true, null, null, null);
    }

    @Override
    public void startTemplate(@NotNull Editor editor, @NotNull Template template, TemplateEditingListener listener, PairProcessor<String, String> processor) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/impl/TemplateManagerImpl.startTemplate must not be null");
        }
        if (template == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/template/impl/TemplateManagerImpl.startTemplate must not be null");
        }
        this.startTemplate(editor, null, template, true, listener, processor, null);
    }

    private void startTemplate(final Editor editor, final String selectionString, final Template template, boolean inSeparateCommand, TemplateEditingListener listener, final PairProcessor<String, String> processor, final Map<String, String> predefinedVarValues) {
        final TemplateState templateState = this.initTemplateState(editor);
        templateState.getProperties().put(ExpressionContext.SELECTION, selectionString);
        if (listener != null) {
            templateState.addTemplateStateListener(listener);
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (selectionString != null) {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            EditorModificationUtil.deleteSelectedText((Editor)editor);
                        }
                    });
                } else {
                    editor.getSelectionModel().removeSelection();
                }
                templateState.start((TemplateImpl)template, (PairProcessor<String, String>)processor, predefinedVarValues);
            }
        };
        if (inSeparateCommand) {
            CommandProcessor.getInstance().executeCommand(this.myProject, r, CodeInsightBundle.message((String)"insert.code.template.command", (Object[])new Object[0]), null);
        } else {
            r.run();
        }
        if (this.shouldSkipInTests() && !templateState.isFinished()) {
            templateState.gotoEnd();
        }
    }

    public boolean shouldSkipInTests() {
        return ApplicationManager.getApplication().isUnitTestMode() && !this.myTemplateTesting;
    }

    @Override
    public void startTemplate(@NotNull Editor editor, @NotNull Template template, TemplateEditingListener listener) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/impl/TemplateManagerImpl.startTemplate must not be null");
        }
        if (template == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/template/impl/TemplateManagerImpl.startTemplate must not be null");
        }
        this.startTemplate(editor, null, template, true, listener, null, null);
    }

    @Override
    public void startTemplate(@NotNull Editor editor, @NotNull Template template, boolean inSeparateCommand, Map<String, String> predefinedVarValues, TemplateEditingListener listener) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/impl/TemplateManagerImpl.startTemplate must not be null");
        }
        if (template == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/template/impl/TemplateManagerImpl.startTemplate must not be null");
        }
        this.startTemplate(editor, null, template, inSeparateCommand, listener, null, predefinedVarValues);
    }

    private static int passArgumentBack(CharSequence text, int caretOffset) {
        char c;
        int i;
        for (i = caretOffset - 1; i >= 0 && !TemplateManagerImpl.isDelimiter(c = text.charAt(i)); --i) {
        }
        return i + 1;
    }

    private static boolean isDelimiter(char c) {
        return !Character.isJavaIdentifierPart(c);
    }

    private static <T, U> void addToMap(@NotNull Map<T, U> map, @NotNull Collection<? extends T> keys, U value) {
        if (map == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/impl/TemplateManagerImpl.addToMap must not be null");
        }
        if (keys == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/template/impl/TemplateManagerImpl.addToMap must not be null");
        }
        for (T key : keys) {
            map.put(key, value);
        }
    }

    private static boolean containsTemplateStartingBefore(Map<TemplateImpl, String> template2argument, int offset, int caretOffset, CharSequence text) {
        for (TemplateImpl template : template2argument.keySet()) {
            String argument;
            int templateStart = TemplateManagerImpl.getTemplateStart(template, argument = template2argument.get(template), caretOffset, text);
            if (templateStart >= offset) continue;
            return true;
        }
        return false;
    }

    public boolean startTemplate(Editor editor, char shortcutChar, PairProcessor<String, String> processor) {
        PsiFile file = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)this.myProject);
        if (file == null) {
            return false;
        }
        TemplateSettings templateSettings = TemplateSettings.getInstance();
        Map<TemplateImpl, String> template2argument = this.findMatchingTemplates(file, editor, Character.valueOf(shortcutChar), templateSettings);
        for (CustomLiveTemplate customLiveTemplate : (CustomLiveTemplate[])CustomLiveTemplate.EP_NAME.getExtensions()) {
            CustomTemplateCallback callback;
            String key;
            int caretOffset;
            if (shortcutChar != customLiveTemplate.getShortcut() || !customLiveTemplate.isApplicable(file, caretOffset = editor.getCaretModel().getOffset()) || (key = customLiveTemplate.computeTemplateKey(callback = new CustomTemplateCallback(editor, file))) == null) continue;
            int offsetBeforeKey = caretOffset - key.length();
            CharSequence text = editor.getDocument().getCharsSequence();
            if (template2argument != null && TemplateManagerImpl.containsTemplateStartingBefore(template2argument, offsetBeforeKey, caretOffset, text)) continue;
            customLiveTemplate.expand(key, callback);
            callback.startAllExpandedTemplates();
            return true;
        }
        return this.startNonCustomTemplates(template2argument, editor, processor);
    }

    private static int getArgumentOffset(int caretOffset, String argument, CharSequence text) {
        int argumentOffset = caretOffset - argument.length();
        if (argumentOffset > 0 && text.charAt(argumentOffset - 1) == ' ' && argumentOffset - 2 >= 0 && Character.isJavaIdentifierPart(text.charAt(argumentOffset - 2))) {
            --argumentOffset;
        }
        return argumentOffset;
    }

    private static int getTemplateStart(TemplateImpl template, String argument, int caretOffset, CharSequence text) {
        int templateStart;
        if (argument == null) {
            templateStart = caretOffset - template.getKey().length();
        } else {
            int argOffset = TemplateManagerImpl.getArgumentOffset(caretOffset, argument, text);
            templateStart = argOffset - template.getKey().length();
        }
        return templateStart;
    }

    public Map<TemplateImpl, String> findMatchingTemplates(PsiFile file, Editor editor, Character shortcutChar, TemplateSettings templateSettings) {
        List<TemplateImpl> candidatesWithArgument;
        final Document document = editor.getDocument();
        CharSequence text = document.getCharsSequence();
        int caretOffset = editor.getCaretModel().getOffset();
        List<TemplateImpl> candidatesWithoutArgument = TemplateManagerImpl.findMatchingTemplates(text, caretOffset, shortcutChar, templateSettings, false);
        int argumentOffset = TemplateManagerImpl.passArgumentBack(text, caretOffset);
        String argument = null;
        if (argumentOffset >= 0) {
            argument = ((Object)text.subSequence(argumentOffset, caretOffset)).toString();
            if (argumentOffset > 0 && text.charAt(argumentOffset - 1) == ' ' && argumentOffset - 2 >= 0 && Character.isJavaIdentifierPart(text.charAt(argumentOffset - 2))) {
                --argumentOffset;
            }
        }
        if ((candidatesWithArgument = TemplateManagerImpl.findMatchingTemplates(text, argumentOffset, shortcutChar, templateSettings, true)).isEmpty() && candidatesWithoutArgument.isEmpty()) {
            return null;
        }
        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

            @Override
            public void run() {
                PsiDocumentManager.getInstance((Project)TemplateManagerImpl.this.myProject).commitDocument(document);
            }
        }, "", null);
        candidatesWithoutArgument = TemplateManagerImpl.filterApplicableCandidates(file, caretOffset, candidatesWithoutArgument);
        candidatesWithArgument = TemplateManagerImpl.filterApplicableCandidates(file, argumentOffset, candidatesWithArgument);
        HashMap candidate2Argument = new HashMap();
        TemplateManagerImpl.addToMap(candidate2Argument, candidatesWithoutArgument, null);
        TemplateManagerImpl.addToMap(candidate2Argument, candidatesWithArgument, argument);
        return candidate2Argument;
    }

    public boolean startNonCustomTemplates(Map<TemplateImpl, String> template2argument, Editor editor, PairProcessor<String, String> processor) {
        int caretOffset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        CharSequence text = document.getCharsSequence();
        if (template2argument == null || template2argument.size() == 0) {
            return false;
        }
        if (!FileDocumentManager.getInstance().requestWriting(editor.getDocument(), this.myProject)) {
            return false;
        }
        if (template2argument.size() == 1) {
            TemplateImpl template = template2argument.keySet().iterator().next();
            String argument = template2argument.get(template);
            int templateStart = TemplateManagerImpl.getTemplateStart(template, argument, caretOffset, text);
            this.startTemplateWithPrefix(editor, template, templateStart, processor, argument);
        } else {
            ListTemplatesHandler.showTemplatesLookup(this.myProject, editor, template2argument);
        }
        return true;
    }

    public static List<TemplateImpl> findMatchingTemplates(CharSequence text, int caretOffset, Character shortcutChar, TemplateSettings settings, boolean hasArgument) {
        String key;
        int wordStart;
        List<TemplateImpl> candidates = Collections.emptyList();
        for (int i = settings.getMaxKeyLength(); i >= 1 && ((wordStart = caretOffset - i) < 0 || Character.isJavaIdentifierStart((key = ((Object)text.subSequence(wordStart, caretOffset)).toString()).charAt(0)) && wordStart > 0 && Character.isJavaIdentifierPart(text.charAt(wordStart - 1)) || (candidates = settings.collectMatchingCandidates(key, shortcutChar, hasArgument)).isEmpty()); --i) {
        }
        return candidates;
    }

    public void startTemplateWithPrefix(Editor editor, TemplateImpl template, @Nullable PairProcessor<String, String> processor, @Nullable String argument) {
        int caretOffset = editor.getCaretModel().getOffset();
        String key = template.getKey();
        int startOffset = caretOffset - key.length();
        if (argument != null) {
            if (!TemplateManagerImpl.isDelimiter(key.charAt(key.length() - 1))) {
                --startOffset;
            }
            startOffset -= argument.length();
        }
        this.startTemplateWithPrefix(editor, template, startOffset, processor, argument);
    }

    public void startTemplateWithPrefix(final Editor editor, final TemplateImpl template, final int templateStart, final @Nullable PairProcessor<String, String> processor, final @Nullable String argument) {
        final int caretOffset = editor.getCaretModel().getOffset();
        final TemplateState templateState = this.initTemplateState(editor);
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(this.myProject, new Runnable(){

            @Override
            public void run() {
                editor.getDocument().deleteString(templateStart, caretOffset);
                editor.getCaretModel().moveToOffset(templateStart);
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                editor.getSelectionModel().removeSelection();
                HashMap predefinedVarValues = null;
                if (argument != null) {
                    predefinedVarValues = new HashMap();
                    predefinedVarValues.put("ARG", argument);
                }
                templateState.start(template, (PairProcessor<String, String>)processor, (Map<String, String>)predefinedVarValues);
            }
        }, CodeInsightBundle.message((String)"insert.code.template.command", (Object[])new Object[0]), null);
    }

    public static List<TemplateImpl> filterApplicableCandidates(PsiFile file, int caretOffset, List<TemplateImpl> candidates) {
        ArrayList<TemplateImpl> result = new ArrayList<TemplateImpl>();
        for (TemplateImpl candidate : candidates) {
            if (!TemplateManagerImpl.isApplicable(file, caretOffset - candidate.getKey().length(), candidate)) continue;
            result.add(candidate);
        }
        return result;
    }

    @Override
    public TemplateContextType getContextType(@NotNull PsiFile file, int offset) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/impl/TemplateManagerImpl.getContextType must not be null");
        }
        TemplateContextType[] typeCollection = TemplateManagerImpl.getAllContextTypes();
        LinkedList<TemplateContextType> userDefinedExtensionsFirst = new LinkedList<TemplateContextType>();
        for (TemplateContextType contextType : typeCollection) {
            if (contextType.getClass().getName().startsWith("com.intellij.codeInsight.template")) {
                userDefinedExtensionsFirst.addLast(contextType);
                continue;
            }
            userDefinedExtensionsFirst.addFirst(contextType);
        }
        for (TemplateContextType contextType : userDefinedExtensionsFirst) {
            if (!contextType.isInContext(file, offset)) continue;
            return contextType;
        }
        assert (false) : "OtherContextType should match any context";
        return null;
    }

    public static TemplateContextType[] getAllContextTypes() {
        return (TemplateContextType[])Extensions.getExtensions(TemplateContextType.EP_NAME);
    }

    @NotNull
    public String getComponentName() {
        if ("TemplateManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/template/impl/TemplateManagerImpl.getComponentName must not return null");
        }
        return "TemplateManager";
    }

    @Override
    @Nullable
    public Template getActiveTemplate(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/impl/TemplateManagerImpl.getActiveTemplate must not be null");
        }
        TemplateState templateState = TemplateManagerImpl.getTemplateState(editor);
        return templateState != null ? templateState.getTemplate() : null;
    }

    public static boolean isApplicable(PsiFile file, int offset, TemplateImpl template) {
        PsiFile basePsi;
        TemplateManager instance = TemplateManagerImpl.getInstance(file.getProject());
        TemplateContext context = template.getTemplateContext();
        if (context.isEnabled(instance.getContextType(file, offset))) {
            return true;
        }
        Language baseLanguage = file.getViewProvider().getBaseLanguage();
        if (baseLanguage != file.getLanguage() && (basePsi = file.getViewProvider().getPsi(baseLanguage)) != null && context.isEnabled(instance.getContextType(basePsi, offset))) {
            return true;
        }
        if (offset > 0) {
            Language prevLanguage = PsiUtilBase.getLanguageAtOffset((PsiFile)file, (int)(offset - 1));
            PsiFile prevPsi = file.getViewProvider().getPsi(prevLanguage);
            if (prevPsi != null && context.isEnabled(instance.getContextType(prevPsi, offset - 1))) {
                return true;
            }
        }
        return false;
    }
}

