/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.concurrencyAnnotations;

import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.concurrencyAnnotations.JCiPUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class InstanceGuardedByStaticInspection
extends BaseJavaLocalInspectionTool {
    @NotNull
    public String getGroupDisplayName() {
        if ("Concurrency annotation issues" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/concurrencyAnnotations/InstanceGuardedByStaticInspection.getGroupDisplayName must not return null");
        }
        return "Concurrency annotation issues";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Instance member guarded by static field" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/concurrencyAnnotations/InstanceGuardedByStaticInspection.getDisplayName must not return null");
        }
        return "Instance member guarded by static field";
    }

    @NotNull
    public String getShortName() {
        if ("InstanceGuardedByStatic" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/concurrencyAnnotations/InstanceGuardedByStaticInspection.getShortName must not return null");
        }
        return "InstanceGuardedByStatic";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/concurrencyAnnotations/InstanceGuardedByStaticInspection.buildVisitor must not be null");
        }
        Visitor visitor = new Visitor(holder);
        if (visitor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/concurrencyAnnotations/InstanceGuardedByStaticInspection.buildVisitor must not return null");
        }
        return visitor;
    }

    private static class Visitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;

        public Visitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public void visitDocTag(PsiDocTag psiDocTag) {
            super.visitDocTag(psiDocTag);
            if (!JCiPUtil.isGuardedByTag(psiDocTag)) {
                return;
            }
            PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)psiDocTag, PsiMember.class);
            if (member == null) {
                return;
            }
            if (member.hasModifierProperty("static")) {
                return;
            }
            String guardValue = JCiPUtil.getGuardValue(psiDocTag);
            PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiDocTag, PsiClass.class);
            if (containingClass == null) {
                return;
            }
            PsiField guardField = containingClass.findFieldByName(guardValue, true);
            if (guardField == null) {
                return;
            }
            if (!guardField.hasModifierProperty("static")) {
                return;
            }
            this.myHolder.registerProblem((PsiElement)psiDocTag, "Instance member guarded by static \"" + guardValue + "\" #loc", new LocalQuickFix[0]);
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
        }

        public void visitAnnotation(PsiAnnotation annotation) {
            super.visitAnnotation(annotation);
            if (!JCiPUtil.isGuardedByAnnotation(annotation)) {
                return;
            }
            PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiMember.class);
            if (member == null) {
                return;
            }
            if (member.hasModifierProperty("static")) {
                return;
            }
            String guardValue = JCiPUtil.getGuardValue(annotation);
            if (guardValue == null) {
                return;
            }
            PsiAnnotationMemberValue guardRef = annotation.findAttributeValue("value");
            if (guardRef == null) {
                return;
            }
            PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiClass.class);
            if (containingClass == null) {
                return;
            }
            PsiField guardField = containingClass.findFieldByName(guardValue, true);
            if (guardField == null) {
                return;
            }
            if (!guardField.hasModifierProperty("static")) {
                return;
            }
            this.myHolder.registerProblem((PsiElement)guardRef, "Instance member guarded by static #ref #loc", new LocalQuickFix[0]);
        }
    }
}

