/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.AssignInstruction;
import com.intellij.codeInspection.dataFlow.instructions.BinopInstruction;
import com.intellij.codeInspection.dataFlow.instructions.CheckReturnValueInstruction;
import com.intellij.codeInspection.dataFlow.instructions.FieldReferenceInstruction;
import com.intellij.codeInspection.dataFlow.instructions.InstanceofInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.TypeCastInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaNotNullValue;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.FactoryMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Set;

public class StandardInstructionVisitor
extends InstructionVisitor {
    private final Set<BinopInstruction> myReachable = new THashSet();
    private final Set<BinopInstruction> myCanBeNullInInstanceof = new THashSet();
    private final Set<InstanceofInstruction> myUsefulInstanceofs = new THashSet();
    private final FactoryMap<MethodCallInstruction, boolean[]> myParametersNotNull = new FactoryMap<MethodCallInstruction, boolean[]>(){

        protected boolean[] create(MethodCallInstruction key) {
            PsiMethod callee;
            PsiCallExpression callExpression = key.getCallExpression();
            PsiMethod psiMethod = callee = callExpression == null ? null : callExpression.resolveMethod();
            if (callee != null) {
                PsiParameter[] params = callee.getParameterList().getParameters();
                boolean[] result = new boolean[params.length];
                for (int i = 0; i < params.length; ++i) {
                    result[i] = AnnotationUtil.isAnnotated((PsiModifierListOwner)params[i], (String)"org.jetbrains.annotations.NotNull", (boolean)false);
                }
                return result;
            }
            return ArrayUtil.EMPTY_BOOLEAN_ARRAY;
        }
    };
    private final FactoryMap<MethodCallInstruction, Boolean> myCalleeNullability = new FactoryMap<MethodCallInstruction, Boolean>(){

        protected Boolean create(MethodCallInstruction key) {
            PsiMethod callee;
            PsiCallExpression callExpression = key.getCallExpression();
            if (callExpression instanceof PsiNewExpression) {
                return Boolean.FALSE;
            }
            if (callExpression != null && (callee = callExpression.resolveMethod()) != null) {
                if (AnnotationUtil.isNullable((PsiModifierListOwner)callee)) {
                    return Boolean.TRUE;
                }
                if (AnnotationUtil.isNotNull((PsiModifierListOwner)callee)) {
                    return Boolean.FALSE;
                }
            }
            return null;
        }
    };

    @Override
    public DfaInstructionState[] visitAssign(AssignInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaValue dfaSource = memState.pop();
        DfaValue dfaDest = memState.pop();
        if (dfaDest instanceof DfaVariableValue) {
            DfaVariableValue var = (DfaVariableValue)dfaDest;
            PsiVariable psiVariable = var.getPsiVariable();
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiVariable, (String)"org.jetbrains.annotations.NotNull", (boolean)false) && !memState.applyNotNull(dfaSource)) {
                this.onAssigningToNotNullableVariable(instruction, runner);
            }
            memState.setVarValue(var, dfaSource);
        }
        memState.push(dfaDest);
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    protected void onAssigningToNotNullableVariable(AssignInstruction instruction, DataFlowRunner runner) {
    }

    @Override
    public DfaInstructionState[] visitCheckReturnValue(CheckReturnValueInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaValue retValue = memState.pop();
        if (!memState.checkNotNullable(retValue)) {
            this.onNullableReturn(instruction, runner);
        }
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    protected void onNullableReturn(CheckReturnValueInstruction instruction, DataFlowRunner runner) {
    }

    @Override
    public DfaInstructionState[] visitFieldReference(FieldReferenceInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaValue qualifier = memState.pop();
        if (instruction.getExpression().isPhysical() && !memState.applyNotNull(qualifier)) {
            this.onInstructionProducesNPE(instruction, runner);
            return DfaInstructionState.EMPTY_ARRAY;
        }
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    protected void onInstructionProducesNPE(FieldReferenceInstruction instruction, DataFlowRunner runner) {
    }

    @Override
    public DfaInstructionState[] visitTypeCast(TypeCastInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaValueFactory factory = runner.getFactory();
        DfaValue dfaExpr = factory.create(instruction.getCasted());
        if (dfaExpr != null) {
            DfaTypeValue dfaType = factory.getTypeFactory().create(instruction.getCastTo());
            DfaRelationValue dfaInstanceof = factory.getRelationFactory().create(dfaExpr, dfaType, "instanceof", false);
            if (dfaInstanceof != null && !memState.applyInstanceofOrNull(dfaInstanceof)) {
                this.onInstructionProducesCCE(instruction, runner);
            }
        }
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    protected void onInstructionProducesCCE(TypeCastInstruction instruction, DataFlowRunner runner) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DfaInstructionState[] visitMethodCall(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        PsiExpression[] args = instruction.getArgs();
        boolean[] parametersNotNull = (boolean[])this.myParametersNotNull.get((Object)instruction);
        DfaNotNullValue.Factory factory = runner.getFactory().getNotNullFactory();
        for (int i = 0; i < args.length; ++i) {
            DfaValue arg = memState.pop();
            int revIdx = args.length - i - 1;
            if (args.length > parametersNotNull.length || revIdx >= parametersNotNull.length || !parametersNotNull[revIdx] || memState.applyNotNull(arg)) continue;
            this.onPassingNullParameter(runner, args[revIdx]);
            if (!(arg instanceof DfaVariableValue)) continue;
            memState.setVarValue((DfaVariableValue)arg, factory.create(((DfaVariableValue)arg).getPsiVariable().getType()));
        }
        DfaValue qualifier = memState.pop();
        try {
            if (!memState.applyNotNull(qualifier)) {
                if (instruction.getMethodType() == MethodCallInstruction.MethodType.UNBOXING) {
                    this.onUnboxingNullable(instruction, runner);
                } else {
                    this.onInstructionProducesNPE(instruction, runner);
                }
                if (qualifier instanceof DfaVariableValue) {
                    memState.setVarValue((DfaVariableValue)qualifier, factory.create(((DfaVariableValue)qualifier).getPsiVariable().getType()));
                }
            }
            DfaInstructionState[] dfaInstructionStateArray = StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
            return dfaInstructionStateArray;
        }
        finally {
            this.pushResult(instruction, memState, qualifier, runner.getFactory());
            if (instruction.shouldFlushFields()) {
                memState.flushFields(runner);
            }
        }
    }

    private void pushResult(MethodCallInstruction instruction, DfaMemoryState state, DfaValue oldValue, DfaValueFactory factory) {
        PsiType type = instruction.getResultType();
        MethodCallInstruction.MethodType methodType = instruction.getMethodType();
        DfaValue dfaValue = null;
        if (type != null && (type instanceof PsiClassType || type.getArrayDimensions() > 0)) {
            Boolean nullability = (Boolean)this.myCalleeNullability.get((Object)instruction);
            dfaValue = nullability == Boolean.FALSE ? factory.getNotNullFactory().create(type) : factory.getTypeFactory().create(type, nullability == Boolean.TRUE);
        } else if (methodType == MethodCallInstruction.MethodType.UNBOXING) {
            dfaValue = factory.getBoxedFactory().createUnboxed(oldValue);
        } else if (methodType == MethodCallInstruction.MethodType.BOXING) {
            dfaValue = factory.getBoxedFactory().createBoxed(oldValue);
        } else if (methodType == MethodCallInstruction.MethodType.CAST) {
            if (oldValue instanceof DfaConstValue) {
                DfaConstValue constValue = (DfaConstValue)oldValue;
                Object o = constValue.getValue();
                if (o instanceof Double || o instanceof Float) {
                    double dbVal;
                    double d = dbVal = o instanceof Double ? ((Double)o).doubleValue() : ((Float)o).doubleValue();
                    if (Math.floor(dbVal) == dbVal) {
                        o = TypeConversionUtil.computeCastTo((Object)o, (PsiType)PsiType.LONG);
                    }
                } else {
                    o = TypeConversionUtil.computeCastTo((Object)o, (PsiType)PsiType.LONG);
                }
                dfaValue = factory.getConstFactory().createFromValue(o, type);
            } else {
                dfaValue = oldValue;
            }
        }
        state.push(dfaValue == null ? DfaUnknownValue.getInstance() : dfaValue);
    }

    protected void onInstructionProducesNPE(MethodCallInstruction instruction, DataFlowRunner runner) {
    }

    protected void onUnboxingNullable(MethodCallInstruction instruction, DataFlowRunner runner) {
    }

    protected void onPassingNullParameter(DataFlowRunner runner, PsiExpression arg) {
    }

    @Override
    public DfaInstructionState[] visitBinop(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        this.myReachable.add(instruction);
        Instruction next = runner.getInstruction(instruction.getIndex() + 1);
        DfaValue dfaRight = memState.pop();
        DfaValue dfaLeft = memState.pop();
        String opSign = instruction.getOperationSign();
        if (opSign != null) {
            DfaValueFactory factory = runner.getFactory();
            if (("==".equals(opSign) || "!=".equals(opSign)) && dfaLeft instanceof DfaConstValue && dfaRight instanceof DfaConstValue) {
                boolean negated;
                if (dfaLeft == dfaRight ^ (negated = "!=".equals(opSign) ^ (memState.canBeNaN(dfaLeft) || memState.canBeNaN(dfaRight)))) {
                    memState.push(factory.getConstFactory().getTrue());
                    instruction.setTrueReachable();
                } else {
                    memState.push(factory.getConstFactory().getFalse());
                    instruction.setFalseReachable();
                }
                return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
            }
            boolean negated = memState.canBeNaN(dfaLeft) || memState.canBeNaN(dfaRight);
            DfaRelationValue dfaRelation = factory.getRelationFactory().create(dfaLeft, dfaRight, opSign, negated);
            if (dfaRelation != null) {
                DfaMemoryState falseCopy;
                this.myCanBeNullInInstanceof.add(instruction);
                ArrayList<DfaInstructionState> states = new ArrayList<DfaInstructionState>();
                DfaMemoryState trueCopy = memState.createCopy();
                if (trueCopy.applyCondition(dfaRelation)) {
                    trueCopy.push(factory.getConstFactory().getTrue());
                    instruction.setTrueReachable();
                    states.add(new DfaInstructionState(next, trueCopy));
                }
                if ((falseCopy = memState).applyCondition(dfaRelation.createNegated())) {
                    falseCopy.push(factory.getConstFactory().getFalse());
                    instruction.setFalseReachable();
                    states.add(new DfaInstructionState(next, falseCopy));
                    if (instruction instanceof InstanceofInstruction && !falseCopy.isNull(dfaLeft)) {
                        this.myUsefulInstanceofs.add((InstanceofInstruction)instruction);
                    }
                }
                return states.toArray(new DfaInstructionState[states.size()]);
            }
            if ("+".equals(opSign)) {
                memState.push(instruction.getNonNullStringValue(factory));
                instruction.setTrueReachable();
                instruction.setFalseReachable();
            } else {
                if (instruction instanceof InstanceofInstruction) {
                    if ((dfaLeft instanceof DfaTypeValue || dfaLeft instanceof DfaNotNullValue) && dfaRight instanceof DfaTypeValue) {
                        PsiType leftType;
                        if (dfaLeft instanceof DfaNotNullValue) {
                            leftType = ((DfaNotNullValue)dfaLeft).getType();
                        } else {
                            leftType = ((DfaTypeValue)dfaLeft).getType();
                            this.myCanBeNullInInstanceof.add(instruction);
                        }
                        if (!((DfaTypeValue)dfaRight).getType().isAssignableFrom(leftType)) {
                            this.myUsefulInstanceofs.add((InstanceofInstruction)instruction);
                        }
                    } else {
                        this.myUsefulInstanceofs.add((InstanceofInstruction)instruction);
                    }
                }
                memState.push(DfaUnknownValue.getInstance());
            }
        } else {
            memState.push(DfaUnknownValue.getInstance());
        }
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    public boolean isInstanceofRedundant(InstanceofInstruction instruction) {
        return !this.myUsefulInstanceofs.contains(instruction) && !instruction.isConditionConst() && this.myReachable.contains(instruction);
    }

    public boolean canBeNull(BinopInstruction instruction) {
        return this.myCanBeNullInInstanceof.contains(instruction);
    }
}

