/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java15api;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.FileCheckingInspection;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.LanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.HashMap;
import gnu.trove.THashSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Java15APIUsageInspection
extends BaseJavaLocalInspectionTool {
    @NonNls
    public static final String SHORT_NAME = "Since15";
    private static final HashMap<LanguageLevel, THashSet<String>> ourForbiddenAPI = new HashMap(5);
    private static final THashSet<String> ourIgnored16ClassesAPI = new THashSet(10);
    private static final HashMap<LanguageLevel, String> ourAPIPresentationMap = new HashMap(5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initForbiddenApi(@NonNls String list, THashSet<String> set) {
        BufferedReader reader = null;
        try {
            String line;
            InputStream stream = Java15APIUsageInspection.class.getResourceAsStream(list);
            reader = new BufferedReader(new InputStreamReader(stream, CharsetToolkit.UTF8_CHARSET));
            while ((line = reader.readLine()) != null) {
                set.add((Object)line);
            }
        }
        catch (UnsupportedEncodingException e) {
        }
        catch (IOException e) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.JDK15_SPECIFIC_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/java15api/Java15APIUsageInspection.getGroupDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inspection.1.5.display.name", (Object[])new Object[]{"@since 1.5(1.6)"});
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/java15api/Java15APIUsageInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/java15api/Java15APIUsageInspection.getShortName must not return null");
        }
        return SHORT_NAME;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/java15api/Java15APIUsageInspection.getDefaultLevel must not return null");
        }
        return highlightDisplayLevel;
    }

    public boolean isEnabledByDefault() {
        return false;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/java15api/Java15APIUsageInspection.buildVisitor must not be null");
        }
        MyVisitor myVisitor = new MyVisitor(holder);
        if (myVisitor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/java15api/Java15APIUsageInspection.buildVisitor must not return null");
        }
        return myVisitor;
    }

    private static boolean isInProject(PsiElement elt) {
        return elt.getManager().isInProject(elt);
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        FileCheckingInspection[] fileCheckingInspections;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/java15api/Java15APIUsageInspection.checkFile must not be null");
        }
        if (manager == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/java15api/Java15APIUsageInspection.checkFile must not be null");
        }
        ExtensionPoint point = Extensions.getRootArea().getExtensionPoint("com.intellij.java15InspectionTool");
        for (FileCheckingInspection obj : fileCheckingInspections = (FileCheckingInspection[])point.getExtensions()) {
            ProblemDescriptor[] descriptors = obj.checkFile(file, manager, isOnTheFly);
            if (descriptors == null) continue;
            return descriptors;
        }
        return null;
    }

    public static String getPresentable(LanguageLevel languageLevel) {
        return (String)ourAPIPresentationMap.get((Object)languageLevel);
    }

    public static boolean isForbiddenApiUsage(PsiMember member, LanguageLevel languageLevel) {
        if (member == null) {
            return false;
        }
        if (member instanceof PsiClass && ((PsiClass)member).isAnnotationType()) {
            return false;
        }
        if (member instanceof PsiAnonymousClass) {
            return false;
        }
        if (member.getContainingClass() instanceof PsiAnonymousClass) {
            return false;
        }
        if (member instanceof PsiClass && !(member.getParent() instanceof PsiClass) && !(member.getParent() instanceof PsiFile)) {
            return false;
        }
        return Java15APIUsageInspection.isForbiddenSignature(member, languageLevel) || Java15APIUsageInspection.isForbiddenApiUsage((PsiMember)member.getContainingClass(), languageLevel);
    }

    private static boolean isForbiddenSignature(PsiMember member, LanguageLevel languageLevel) {
        THashSet forbiddenApi = (THashSet)ourForbiddenAPI.get((Object)languageLevel);
        if (forbiddenApi == null) {
            return false;
        }
        return forbiddenApi.contains((Object)Java15APIUsageInspection.getSignature(member)) || languageLevel.compareTo((Enum)LanguageLevel.HIGHEST) != 0 && Java15APIUsageInspection.isForbiddenSignature(member, LanguageLevel.values()[languageLevel.ordinal() + 1]);
    }

    public static String getSignature(PsiMember member) {
        if (member instanceof PsiClass) {
            return ((PsiClass)member).getQualifiedName();
        }
        if (member instanceof PsiField) {
            return Java15APIUsageInspection.getSignature((PsiMember)member.getContainingClass()) + "#" + member.getName();
        }
        if (member instanceof PsiMethod) {
            PsiType[] params;
            PsiMethod method = (PsiMethod)member;
            StringBuffer buf = new StringBuffer();
            buf.append(Java15APIUsageInspection.getSignature((PsiMember)method.getContainingClass()));
            buf.append('#');
            buf.append(method.getName());
            buf.append('(');
            for (PsiType type : params = method.getSignature(PsiSubstitutor.EMPTY).getParameterTypes()) {
                buf.append(type.getCanonicalText());
                buf.append(";");
            }
            buf.append(')');
            return buf.toString();
        }
        assert (false);
        return null;
    }

    static {
        THashSet ourForbidden14API = new THashSet(1000);
        Java15APIUsageInspection.initForbiddenApi("api14List.txt", (THashSet<String>)ourForbidden14API);
        ourForbiddenAPI.put((Object)LanguageLevel.JDK_1_3, (Object)ourForbidden14API);
        ourAPIPresentationMap.put((Object)LanguageLevel.JDK_1_3, (Object)"1.4");
        THashSet ourForbidden15API = new THashSet(1000);
        Java15APIUsageInspection.initForbiddenApi("apiList.txt", (THashSet<String>)ourForbidden15API);
        ourForbiddenAPI.put((Object)LanguageLevel.JDK_1_4, (Object)ourForbidden15API);
        ourAPIPresentationMap.put((Object)LanguageLevel.JDK_1_4, (Object)"1.5");
        THashSet ourForbidden16API = new THashSet(1000);
        Java15APIUsageInspection.initForbiddenApi("api16List.txt", (THashSet<String>)ourForbidden16API);
        ourForbiddenAPI.put((Object)LanguageLevel.JDK_1_5, (Object)ourForbidden16API);
        ourAPIPresentationMap.put((Object)LanguageLevel.JDK_1_5, (Object)"1.6");
        Java15APIUsageInspection.initForbiddenApi("ignore16List.txt", ourIgnored16ClassesAPI);
    }

    private class MyVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;

        public MyVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public void visitDocComment(PsiDocComment comment) {
        }

        public void visitClass(PsiClass aClass) {
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            this.visitReferenceElement((PsiJavaCodeReferenceElement)expression);
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            LanguageLevel languageLevel;
            Module module;
            super.visitReferenceElement(reference);
            PsiElement resolved = reference.resolve();
            if (resolved instanceof PsiCompiledElement && resolved instanceof PsiMember && (module = ModuleUtil.findModuleForPsiElement((PsiElement)reference.getElement())) != null && Java15APIUsageInspection.isForbiddenApiUsage((PsiMember)resolved, languageLevel = LanguageLevelUtil.getEffectiveLanguageLevel((Module)module))) {
                PsiClass psiClass = null;
                PsiElement qualifier = reference.getQualifier();
                if (qualifier != null) {
                    if (qualifier instanceof PsiExpression) {
                        psiClass = PsiUtil.resolveClassInType((PsiType)((PsiExpression)qualifier).getType());
                    }
                } else {
                    psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)reference, PsiClass.class);
                }
                if (psiClass != null) {
                    if (this.isIgnored(psiClass)) {
                        return;
                    }
                    for (PsiClass superClass : psiClass.getSupers()) {
                        if (!this.isIgnored(superClass)) continue;
                        return;
                    }
                }
                this.registerError(reference, languageLevel);
            }
        }

        private boolean isIgnored(PsiClass psiClass) {
            String qualifiedName = psiClass.getQualifiedName();
            return qualifiedName != null && ourIgnored16ClassesAPI.contains((Object)qualifiedName);
        }

        public void visitNewExpression(PsiNewExpression expression) {
            super.visitNewExpression(expression);
            PsiMethod constructor = expression.resolveConstructor();
            Module module = ModuleUtil.findModuleForPsiElement((PsiElement)expression);
            if (module != null) {
                LanguageLevel languageLevel = LanguageLevelUtil.getEffectiveLanguageLevel((Module)module);
                if (constructor instanceof PsiCompiledElement && Java15APIUsageInspection.isForbiddenApiUsage((PsiMember)constructor, languageLevel)) {
                    this.registerError(expression.getClassReference(), languageLevel);
                }
            }
        }

        private void registerError(PsiJavaCodeReferenceElement reference, LanguageLevel api) {
            if (Java15APIUsageInspection.isInProject((PsiElement)reference)) {
                this.myHolder.registerProblem((PsiElement)reference, InspectionsBundle.message((String)"inspection.1.5.problem.descriptor", (Object[])new Object[]{Java15APIUsageInspection.getPresentable(api)}), new LocalQuickFix[0]);
            }
        }
    }
}

