/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.lang.InspectionExtensionsFactory;
import com.intellij.codeInspection.lang.RefManagerExtension;
import com.intellij.codeInspection.reference.RefDirectory;
import com.intellij.codeInspection.reference.RefDirectoryImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefFile;
import com.intellij.codeInspection.reference.RefFileImpl;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefGraphAnnotatorEx;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.reference.RefModuleImpl;
import com.intellij.codeInspection.reference.RefProject;
import com.intellij.codeInspection.reference.RefProjectImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.reference.SmartRefElementPointerImpl;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.concurrency.JBReentrantReadWriteLock;
import com.intellij.util.concurrency.LockFactory;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

public class RefManagerImpl
extends RefManager {
    private int myLastUsedMask = 0x4000000;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.reference.RefManager");
    private final Project myProject;
    private AnalysisScope myScope;
    private RefProject myRefProject;
    private THashMap<PsiAnchor, RefElement> myRefTable;
    private THashMap<Module, RefModule> myModules;
    private final ProjectIterator myProjectIterator;
    private boolean myDeclarationsFound = false;
    private boolean myIsInProcess = false;
    private final List<RefGraphAnnotator> myGraphAnnotators = new ArrayList<RefGraphAnnotator>();
    private GlobalInspectionContextImpl myContext;
    private final Map<Key, RefManagerExtension> myExtensions = new HashMap<Key, RefManagerExtension>();
    private final HashMap<Language, RefManagerExtension> myLanguageExtensions = new HashMap();
    private final JBReentrantReadWriteLock myLock = LockFactory.createReadWriteLock();

    public RefManagerImpl(Project project, AnalysisScope scope, GlobalInspectionContextImpl context) {
        this.myProject = project;
        this.myScope = scope;
        this.myContext = context;
        this.myRefProject = new RefProjectImpl(this);
        this.myRefTable = new THashMap();
        this.myProjectIterator = new ProjectIterator();
        for (InspectionExtensionsFactory factory : (InspectionExtensionsFactory[])Extensions.getExtensions((ExtensionPointName)InspectionExtensionsFactory.EP_NAME)) {
            RefManagerExtension extension = factory.createRefManagerExtension((RefManager)this);
            this.myExtensions.put(extension.getID(), extension);
            this.myLanguageExtensions.put(extension.getLanguage(), extension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iterate(RefVisitor visitor) {
        this.myLock.readLock().lock();
        try {
            THashMap<PsiAnchor, RefElement> refTable = this.getRefTable();
            for (RefElement refElement : refTable.values()) {
                refElement.accept(visitor);
            }
            if (this.myModules != null) {
                for (RefModule refModule : this.myModules.values()) {
                    refModule.accept(visitor);
                }
            }
            for (RefManagerExtension extension : this.myExtensions.values()) {
                extension.iterate(visitor);
            }
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    public void cleanup() {
        this.myScope = null;
        this.myRefProject = null;
        this.myRefTable = null;
        this.myModules = null;
        this.myContext = null;
        this.myGraphAnnotators.clear();
        for (RefManagerExtension extension : this.myExtensions.values()) {
            extension.cleanup();
        }
    }

    public AnalysisScope getScope() {
        return this.myScope;
    }

    public void fireNodeInitialized(RefElement refElement) {
        for (RefGraphAnnotator annotator : this.myGraphAnnotators) {
            annotator.onInitialize(refElement);
        }
    }

    public void fireNodeMarkedReferenced(RefElement refWhat, RefElement refFrom, boolean referencedFromClassInitializer, boolean forReading, boolean forWriting) {
        for (RefGraphAnnotator annotator : this.myGraphAnnotators) {
            annotator.onMarkReferenced(refWhat, refFrom, referencedFromClassInitializer, forReading, forWriting);
        }
    }

    public void fireBuildReferences(RefElement refElement) {
        for (RefGraphAnnotator annotator : this.myGraphAnnotators) {
            annotator.onReferencesBuild(refElement);
        }
    }

    public void registerGraphAnnotator(RefGraphAnnotator annotator) {
        this.myGraphAnnotators.add(annotator);
    }

    public int getLastUsedMask() {
        this.myLastUsedMask *= 2;
        return this.myLastUsedMask;
    }

    public <T> T getExtension(Key<T> key) {
        return (T)this.myExtensions.get(key);
    }

    public String getType(RefEntity ref) {
        for (RefManagerExtension extension : this.myExtensions.values()) {
            String type = extension.getType(ref);
            if (type == null) continue;
            return type;
        }
        if (ref instanceof RefFile) {
            return "file";
        }
        if (ref instanceof RefModule) {
            return "module";
        }
        if (ref instanceof RefProject) {
            return "project";
        }
        if (ref instanceof RefDirectory) {
            return "dir";
        }
        return null;
    }

    public RefEntity getRefinedElement(RefEntity ref) {
        for (RefManagerExtension extension : this.myExtensions.values()) {
            ref = extension.getRefinedElement(ref);
        }
        return ref;
    }

    public Element export(RefEntity refEntity, Element element, int actualLine) {
        refEntity = this.getRefinedElement(refEntity);
        Element problem = new Element("problem");
        if (refEntity instanceof RefElement) {
            RefElement refElement = (RefElement)refEntity;
            PsiElement psiElement = refElement.getElement();
            PsiFile psiFile = psiElement.getContainingFile();
            Element fileElement = new Element("file");
            Element lineElement = new Element("line");
            VirtualFile virtualFile = psiFile.getVirtualFile();
            LOG.assertTrue(virtualFile != null);
            fileElement.addContent(virtualFile.getUrl());
            if (actualLine == -1) {
                Document document = PsiDocumentManager.getInstance((Project)refElement.getRefManager().getProject()).getDocument(psiFile);
                LOG.assertTrue(document != null);
                lineElement.addContent(String.valueOf(document.getLineNumber(psiElement.getTextOffset()) + 1));
            } else {
                lineElement.addContent(String.valueOf(actualLine));
            }
            problem.addContent(fileElement);
            problem.addContent(lineElement);
            RefManagerImpl.appendModule(problem, refElement.getModule());
        } else if (refEntity instanceof RefModule) {
            RefModule refModule = (RefModule)refEntity;
            VirtualFile moduleFile = refModule.getModule().getModuleFile();
            Element fileElement = new Element("file");
            fileElement.addContent(moduleFile != null ? moduleFile.getUrl() : refEntity.getName());
            problem.addContent(fileElement);
            RefManagerImpl.appendModule(problem, refModule);
        }
        for (RefManagerExtension extension : this.myExtensions.values()) {
            extension.export(refEntity, problem);
        }
        new SmartRefElementPointerImpl(refEntity, true).writeExternal(problem);
        element.addContent(problem);
        return problem;
    }

    @Nullable
    public String getGroupName(RefElement entity) {
        for (RefManagerExtension extension : this.myExtensions.values()) {
            String groupName = extension.getGroupName((RefEntity)entity);
            if (groupName == null) continue;
            return groupName;
        }
        return null;
    }

    private static void appendModule(Element problem, RefModule refModule) {
        if (refModule != null) {
            Element moduleElement = new Element("module");
            moduleElement.addContent(refModule.getName());
            problem.addContent(moduleElement);
        }
    }

    public void findAllDeclarations() {
        if (!this.myDeclarationsFound) {
            long before = System.currentTimeMillis();
            this.getScope().accept((PsiElementVisitor)this.myProjectIterator);
            this.myDeclarationsFound = true;
            LOG.info("Total duration of processing project usages:" + (System.currentTimeMillis() - before));
        }
    }

    public boolean isDeclarationsFound() {
        return this.myDeclarationsFound;
    }

    public void inspectionReadActionStarted() {
        this.myIsInProcess = true;
    }

    public void inspectionReadActionFinished() {
        this.myIsInProcess = false;
    }

    public boolean isInProcess() {
        return this.myIsInProcess;
    }

    public Project getProject() {
        return this.myProject;
    }

    public RefProject getRefProject() {
        return this.myRefProject;
    }

    public THashMap<PsiAnchor, RefElement> getRefTable() {
        return this.myRefTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeReference(RefElement refElem) {
        this.myLock.writeLock().lock();
        try {
            RefManagerExtension extension;
            THashMap<PsiAnchor, RefElement> refTable = this.getRefTable();
            final PsiElement element = refElem.getElement();
            RefManagerExtension refManagerExtension = extension = element != null ? this.getExtension(element.getLanguage()) : null;
            if (extension != null) {
                extension.removeReference(refElem);
            }
            if (element != null && refTable.remove(ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiAnchor>(){

                public PsiAnchor compute() {
                    return PsiAnchor.create(element);
                }
            })) != null) {
                return;
            }
            for (PsiAnchor psiElement : refTable.keySet()) {
                if (refTable.get((Object)psiElement) != refElem) continue;
                refTable.remove((Object)psiElement);
                return;
            }
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    public void initializeAnnotators() {
        RefGraphAnnotator[] graphAnnotators;
        ExtensionPoint point = Extensions.getRootArea().getExtensionPoint("com.intellij.refGraphAnnotator");
        for (RefGraphAnnotator annotator : graphAnnotators = (RefGraphAnnotator[])point.getExtensions()) {
            this.registerGraphAnnotator(annotator);
        }
        for (RefGraphAnnotator graphAnnotator : this.myGraphAnnotators) {
            if (!(graphAnnotator instanceof RefGraphAnnotatorEx)) continue;
            ((RefGraphAnnotatorEx)graphAnnotator).initialize((RefManager)this);
        }
    }

    @Nullable
    public RefElement getReference(final PsiElement elem) {
        if (elem != null && (elem instanceof PsiDirectory || this.belongsToScope(elem))) {
            if (!elem.isValid()) {
                return null;
            }
            RefElement ref = this.getFromRefTable(elem);
            if (ref == null) {
                if (!this.isValidPointForReference()) {
                    return null;
                }
                final RefElementImpl refElement = (RefElementImpl)ApplicationManager.getApplication().runReadAction((Computable)new Computable<RefElementImpl>(){

                    @Nullable
                    public RefElementImpl compute() {
                        RefElement refElement;
                        RefManagerExtension extension = RefManagerImpl.this.getExtension(elem.getLanguage());
                        if (extension != null && (refElement = extension.createRefElement(elem)) != null) {
                            return (RefElementImpl)refElement;
                        }
                        if (elem instanceof PsiFile) {
                            return new RefFileImpl((PsiFile)elem, (RefManager)RefManagerImpl.this);
                        }
                        if (elem instanceof PsiDirectory) {
                            return new RefDirectoryImpl((PsiDirectory)elem, (RefManager)RefManagerImpl.this);
                        }
                        return null;
                    }
                });
                if (refElement == null) {
                    return null;
                }
                this.putToRefTable(elem, refElement);
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        refElement.initialize();
                    }
                });
                return refElement;
            }
            return ref;
        }
        return null;
    }

    private RefManagerExtension getExtension(Language language) {
        return this.myLanguageExtensions.get(language);
    }

    @Nullable
    public RefEntity getReference(String type, String fqName) {
        VirtualFile vFile;
        for (RefManagerExtension extension : this.myExtensions.values()) {
            RefEntity refEntity = extension.getReference(type, fqName);
            if (refEntity == null) continue;
            return refEntity;
        }
        if ("file".equals(type)) {
            return RefFileImpl.fileFromExternalName(this, fqName);
        }
        if ("module".equals(type)) {
            return RefModuleImpl.moduleFromName(this, fqName);
        }
        if ("project".equals(type)) {
            return this.getRefProject();
        }
        if ("dir".equals(type) && (vFile = LocalFileSystem.getInstance().findFileByPath(PathMacroManager.getInstance((ComponentManager)this.getProject()).expandPath(fqName))) != null) {
            PsiDirectory dir = PsiManager.getInstance((Project)this.getProject()).findDirectory(vFile);
            return this.getReference((PsiElement)dir);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RefElement getFromRefTable(final PsiElement element) {
        this.myLock.readLock().lock();
        try {
            RefElement refElement = (RefElement)this.getRefTable().get(ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiAnchor>(){

                public PsiAnchor compute() {
                    return PsiAnchor.create(element);
                }
            }));
            return refElement;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putToRefTable(final PsiElement element, RefElement ref) {
        this.myLock.writeLock().lock();
        try {
            this.getRefTable().put(ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiAnchor>(){

                public PsiAnchor compute() {
                    return PsiAnchor.create(element);
                }
            }), (Object)ref);
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    public RefModule getRefModule(Module module) {
        RefModule refModule;
        if (module == null) {
            return null;
        }
        if (this.myModules == null) {
            this.myModules = new THashMap();
        }
        if ((refModule = (RefModule)this.myModules.get((Object)module)) == null) {
            refModule = new RefModuleImpl(module, (RefManager)this);
            this.myModules.put((Object)module, (Object)refModule);
        }
        return refModule;
    }

    public boolean belongsToScope(final PsiElement psiElement) {
        if (psiElement == null || !psiElement.isValid()) {
            return false;
        }
        if (psiElement instanceof PsiCompiledElement) {
            return false;
        }
        PsiFile containingFile = (PsiFile)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiFile>(){

            public PsiFile compute() {
                return psiElement.getContainingFile();
            }
        });
        if (containingFile == null) {
            return false;
        }
        for (RefManagerExtension extension : this.myExtensions.values()) {
            if (extension.belongsToScope(psiElement)) continue;
            return false;
        }
        Boolean inProject = (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return psiElement.getManager().isInProject(psiElement);
            }
        });
        return inProject != false && (this.getScope() == null || this.getScope().contains(psiElement));
    }

    public String getQualifiedName(RefEntity refEntity) {
        if (refEntity == null || refEntity instanceof RefElementImpl && !refEntity.isValid()) {
            return InspectionsBundle.message((String)"inspection.reference.invalid", (Object[])new Object[0]);
        }
        return refEntity.getQualifiedName();
    }

    public void removeRefElement(RefElement refElement, List<RefElement> deletedRefs) {
        List children = refElement.getChildren();
        if (children != null) {
            RefElement[] refElements;
            for (RefElement refChild : refElements = children.toArray(new RefElement[children.size()])) {
                this.removeRefElement(refChild, deletedRefs);
            }
        }
        ((RefManagerImpl)refElement.getRefManager()).removeReference(refElement);
        ((RefElementImpl)refElement).referenceRemoved();
        if (!deletedRefs.contains(refElement)) {
            deletedRefs.add(refElement);
        }
    }

    protected boolean isValidPointForReference() {
        return this.myIsInProcess || ApplicationManager.getApplication().isUnitTestMode();
    }

    private class ProjectIterator
    extends PsiElementVisitor {
        private ProjectIterator() {
        }

        public void visitElement(PsiElement element) {
            RefManagerExtension extension = RefManagerImpl.this.getExtension(element.getLanguage());
            if (extension != null) {
                extension.visitElement(element);
            }
            for (PsiElement aChildren : element.getChildren()) {
                aChildren.accept((PsiElementVisitor)this);
            }
        }

        public void visitFile(PsiFile file) {
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile != null) {
                RefManagerImpl.this.myContext.incrementJobDoneAmount(GlobalInspectionContextImpl.BUILD_GRAPH, ProjectUtil.calcRelativeToProjectPath((VirtualFile)virtualFile, (Project)RefManagerImpl.this.myProject));
            }
            FileViewProvider viewProvider = file.getViewProvider();
            Set relevantLanguages = viewProvider.getLanguages();
            for (Language language : relevantLanguages) {
                this.visitElement((PsiElement)viewProvider.getPsi(language));
            }
        }
    }
}

