/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.util.containers.EmptyIterator;
import com.intellij.util.containers.StringInterner;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeBasedMap<T> {
    private Node<T> myRoot = new Node();
    private final StringInterner myInterner;
    private final char mySeparator;
    private int mySize = 0;

    public TreeBasedMap(StringInterner table, char separator) {
        this.myInterner = table;
        this.mySeparator = separator;
    }

    public void put(String key, T value) {
        Node<T> node = this.myRoot.findRelative(key, true, this.myInterner);
        assert (node != null);
        boolean mappingExisted = node.mappingExists();
        node.setValue(value);
        if (!mappingExisted) {
            ++this.mySize;
        }
    }

    public void remove(String key) {
        Node<T> node = this.myRoot.findRelative(key, false, this.myInterner);
        if (node != null && node.mappingExists()) {
            node.removeValue();
            --this.mySize;
        }
    }

    public int size() {
        return this.mySize;
    }

    public T get(String key) {
        Node<T> node = this.myRoot.findRelative(key, false, this.myInterner);
        return node != null && node.mappingExists() ? (T)node.getValue() : null;
    }

    public boolean containsKey(String key) {
        Node<T> node = this.myRoot.findRelative(key, false, this.myInterner);
        return node != null && node.mappingExists();
    }

    public void removeAll() {
        this.myRoot = new Node();
    }

    public Iterator<String> getKeysIterator() {
        return new KeysIterator();
    }

    private class PathElement<T> {
        @NotNull
        final Iterator<String> iterator;
        @NotNull
        final Node<T> node;

        public PathElement(Node<T> node, Iterator<String> iterator) {
            if (node == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/impl/TreeBasedMap$PathElement.<init> must not be null");
            }
            this.node = node;
            this.iterator = iterator;
        }
    }

    private class KeysIterator
    implements Iterator<String> {
        private final Stack<PathElement<T>> myCurrentNodePath = new Stack();
        private final StringBuilder myCurrentName = new StringBuilder();

        public KeysIterator() {
            this.pushNode("", TreeBasedMap.this.myRoot);
            this.findNextNode();
        }

        @Override
        public boolean hasNext() {
            return this.myCurrentNodePath.size() > 0;
        }

        @Override
        public String next() {
            String key = this.myCurrentName.toString();
            this.popNode();
            this.findNextNode();
            return key;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported");
        }

        private boolean pushNode(@NotNull String name, @NotNull Node<T> node) {
            boolean hasChildren;
            if (name == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/impl/TreeBasedMap$KeysIterator.pushNode must not be null");
            }
            if (node == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/compiler/impl/TreeBasedMap$KeysIterator.pushNode must not be null");
            }
            HashMap childrenMap = node.myChildren;
            boolean bl = hasChildren = childrenMap != null && childrenMap.size() > 0;
            if (hasChildren || node.mappingExists()) {
                this.myCurrentNodePath.push(new PathElement(node, (Iterator<String>)(hasChildren ? childrenMap.keySet().iterator() : EmptyIterator.getInstance())));
                if (this.myCurrentNodePath.size() > 2) {
                    this.myCurrentName.append(TreeBasedMap.this.mySeparator);
                }
                this.myCurrentName.append(name);
                return true;
            }
            return false;
        }

        private void popNode() {
            this.myCurrentNodePath.pop();
            int separatorIndex = this.myCurrentName.lastIndexOf(String.valueOf(TreeBasedMap.this.mySeparator));
            if (separatorIndex >= 0) {
                this.myCurrentName.replace(separatorIndex, this.myCurrentName.length(), "");
            } else {
                this.myCurrentName.setLength(0);
            }
        }

        private void findNextNode() {
            block0: while (!this.myCurrentNodePath.isEmpty()) {
                PathElement element = this.myCurrentNodePath.peek();
                Iterator<String> childrenIterator = element.iterator;
                Node currentNode = element.node;
                while (childrenIterator.hasNext()) {
                    Node childNode;
                    String name = childrenIterator.next();
                    if (!this.pushNode(name, childNode = (Node)currentNode.myChildren.get(name))) continue;
                    continue block0;
                }
                if (currentNode.mappingExists()) break;
                this.popNode();
            }
        }
    }

    private class Node<T> {
        private boolean myMappingExists = false;
        private T myValue = null;
        @Nullable
        private HashMap<String, Node<T>> myChildren = null;

        private Node() {
        }

        public void setValue(T value) {
            this.myValue = value;
            this.myMappingExists = true;
        }

        public T getValue() {
            return this.myValue;
        }

        public void removeValue() {
            this.myValue = null;
            this.myMappingExists = false;
        }

        public boolean mappingExists() {
            return this.myMappingExists;
        }

        @Nullable
        public Node<T> findRelative(String text, boolean create, StringInterner table) {
            return this.findRelative(text, 0, create, table);
        }

        @Nullable
        private Node<T> findRelative(String text, int nameStartIndex, boolean create, StringInterner table) {
            Node<T> child;
            int childNameEnd;
            if (this.myChildren == null && !create) {
                return null;
            }
            int textLen = text.length();
            int separatorIdx = text.indexOf(TreeBasedMap.this.mySeparator, nameStartIndex);
            int n = childNameEnd = separatorIdx >= 0 ? separatorIdx : textLen;
            if (this.myChildren != null && (child = this.myChildren.get(text.substring(nameStartIndex, childNameEnd))) != null) {
                if (separatorIdx < 0) {
                    return child;
                }
                return super.findRelative(text, childNameEnd + 1, create, table);
            }
            if (create) {
                return this.addChild(table, text, nameStartIndex, childNameEnd);
            }
            return null;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        private Node<T> addChild(StringInterner table, String text, int nameStartIndex, int nameEndIndex) {
            Node<T> node;
            if (this.myChildren == null) {
                this.myChildren = new HashMap(3, 0.95f);
            }
            Node<T> newChild = new Node<T>();
            String key = table.intern(text.substring(nameStartIndex, nameEndIndex));
            this.myChildren.put(key, newChild);
            if (nameEndIndex == text.length()) {
                node = newChild;
                if (node == null) throw new IllegalStateException("@NotNull method com/intellij/compiler/impl/TreeBasedMap$Node.addChild must not return null");
                return node;
            }
            Node<T> restNodes = super.findRelative(text, nameEndIndex + 1, true, table);
            assert (restNodes != null);
            node = restNodes;
            if (node != null) return node;
            throw new IllegalStateException("@NotNull method com/intellij/compiler/impl/TreeBasedMap$Node.addChild must not return null");
        }
    }
}

