/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.packagingCompiler;

import com.intellij.compiler.impl.packagingCompiler.BuildInstructionBase;
import com.intellij.openapi.compiler.make.BuildInstructionVisitor;
import com.intellij.openapi.compiler.make.FileCopyInstruction;
import java.io.File;

public class FileCopyInstructionImpl
extends BuildInstructionBase
implements FileCopyInstruction {
    private File myFile;
    private boolean myIsDirectory;

    public FileCopyInstructionImpl(File source, boolean isDirectory, String outputRelativePath) {
        super(outputRelativePath);
        this.setFile(source, isDirectory);
    }

    public boolean accept(BuildInstructionVisitor visitor) throws Exception {
        return visitor.visitFileCopyInstruction((FileCopyInstruction)this);
    }

    @Override
    public String toString() {
        return "Copy " + this.getFile() + "->" + this.getOutputRelativePath();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileCopyInstruction)) {
            return false;
        }
        FileCopyInstruction item = (FileCopyInstruction)o;
        if (this.getFile() != null ? !this.getFile().equals(item.getFile()) : item.getFile() != null) {
            return false;
        }
        return !(this.getOutputRelativePath() != null ? !this.getOutputRelativePath().equals(item.getOutputRelativePath()) : item.getOutputRelativePath() != null);
    }

    public int hashCode() {
        return (this.getFile() != null ? this.getFile().hashCode() : 0) + (this.getOutputRelativePath() != null ? this.getOutputRelativePath().hashCode() : 0);
    }

    public File getFile() {
        return this.myFile;
    }

    public boolean isDirectory() {
        return this.myIsDirectory;
    }

    private void setFile(File file, boolean isDirectory) {
        this.myFile = file;
        this.myIsDirectory = isDirectory;
    }
}

