/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.intellij.concurrency.Job;
import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.concurrency.PrioritizedFutureTask;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class JobImpl<T>
implements Job<T> {
    private final String myTitle;
    private final List<Callable<T>> myTasks = ContainerUtil.createEmptyCOWList();
    private final long myJobIndex = JobSchedulerImpl.currentJobIndex();
    private final int myPriority;
    private final List<PrioritizedFutureTask<T>> myFutures = ContainerUtil.createEmptyCOWList();
    private volatile boolean myCanceled = false;

    public JobImpl(String title, int priority) {
        this.myTitle = title;
        this.myPriority = priority;
    }

    public String getTitle() {
        return this.myTitle;
    }

    public void addTask(Callable<T> task) {
        this.checkNotStarted();
        this.myTasks.add(task);
    }

    public void addTask(Runnable task, T result) {
        this.addTask(Executors.callable(task, result));
    }

    public void addTask(Runnable task) {
        this.addTask(Executors.callable(task, null));
    }

    public List<T> scheduleAndWaitForResults() throws Throwable {
        this.checkCanSchedule();
        Application application = ApplicationManager.getApplication();
        boolean callerHasReadAccess = application != null && application.isReadAccessAllowed();
        this.createFutures(callerHasReadAccess, false);
        if (JobSchedulerImpl.CORES_COUNT >= 2 && this.myFutures.size() >= 2) {
            for (PrioritizedFutureTask<T> future : this.myFutures) {
                JobSchedulerImpl.execute(future);
            }
        }
        for (PrioritizedFutureTask<T> future : this.myFutures) {
            future.run();
        }
        return this.waitForTermination();
    }

    private void createFutures(boolean callerHasReadAccess, boolean reportExceptions) {
        int startTaskIndex = JobSchedulerImpl.currentTaskIndex();
        for (Callable<T> task : this.myTasks) {
            PrioritizedFutureTask<T> future = new PrioritizedFutureTask<T>(task, this.myJobIndex, startTaskIndex++, this.myPriority, callerHasReadAccess, reportExceptions);
            this.myFutures.add(future);
        }
    }

    public List<T> waitForTermination() throws Throwable {
        ArrayList<Object> results = new ArrayList<Object>(this.myFutures.size());
        Throwable ex = null;
        for (PrioritizedFutureTask<T> f : this.myFutures) {
            try {
                Object result = null;
                while (true) {
                    try {
                        result = f.get(10L, TimeUnit.MILLISECONDS);
                    }
                    catch (TimeoutException e) {
                        if (f.isDone()) break;
                        if (!f.isCancelled()) continue;
                    }
                    break;
                }
                results.add(result);
            }
            catch (CancellationException ignore) {
            }
            catch (ExecutionException e) {
                this.cancel();
                Throwable cause = e.getCause();
                if (cause == null) continue;
                ex = cause;
            }
        }
        for (PrioritizedFutureTask<T> future : this.myFutures) {
            future.awaitTermination();
        }
        if (ex != null) {
            throw ex;
        }
        return results;
    }

    public void cancel() {
        this.checkScheduled();
        if (this.myCanceled) {
            return;
        }
        this.myCanceled = true;
        for (PrioritizedFutureTask<T> future : this.myFutures) {
            future.cancel(false);
        }
    }

    public boolean isCanceled() {
        this.checkScheduled();
        return this.myCanceled;
    }

    public void schedule() {
        this.checkCanSchedule();
        this.createFutures(false, true);
        for (PrioritizedFutureTask<T> future : this.myFutures) {
            JobSchedulerImpl.execute(future);
        }
    }

    public boolean isDone() {
        this.checkScheduled();
        for (PrioritizedFutureTask<T> future : this.myFutures) {
            if (future.isDone()) continue;
            return false;
        }
        return true;
    }

    private void checkCanSchedule() {
        this.checkNotStarted();
        if (this.myTasks.isEmpty()) {
            throw new IllegalStateException("No tasks to run. You can't schedule a job which has no tasks");
        }
    }

    private void checkNotStarted() {
        if (!this.myFutures.isEmpty()) {
            throw new IllegalStateException("Already running. You can't call this method for a job which is already scheduled");
        }
    }

    private void checkScheduled() {
        if (this.myFutures.isEmpty()) {
            throw new IllegalStateException("Cannot call this method for not yet started job");
        }
    }
}

