/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.ui.breakpoints.AnyExceptionBreakpoint;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointFactory;
import com.intellij.debugger.ui.breakpoints.BreakpointPanel;
import com.intellij.debugger.ui.breakpoints.ExceptionBreakpoint;
import com.intellij.debugger.ui.breakpoints.ExceptionBreakpointPropertiesPanel;
import com.intellij.debugger.ui.breakpoints.actions.AddAction;
import com.intellij.debugger.ui.breakpoints.actions.BreakpointPanelAction;
import com.intellij.debugger.ui.breakpoints.actions.RemoveAction;
import com.intellij.debugger.ui.breakpoints.actions.SwitchViewAction;
import com.intellij.debugger.ui.breakpoints.actions.ToggleFlattenPackagesAction;
import com.intellij.debugger.ui.breakpoints.actions.ToggleGroupByClassesAction;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.search.GlobalSearchScope;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import org.jdom.Element;

public class ExceptionBreakpointFactory
extends BreakpointFactory {
    @Override
    public Breakpoint createBreakpoint(Project project, Element element) {
        return new ExceptionBreakpoint(project);
    }

    @Override
    public Icon getIcon() {
        return ExceptionBreakpoint.ICON;
    }

    @Override
    public Icon getDisabledIcon() {
        return ExceptionBreakpoint.DISABLED_ICON;
    }

    @Override
    public BreakpointPanel createBreakpointPanel(final Project project, DialogWrapper parentDialog) {
        BreakpointPanel panel = new BreakpointPanel(project, new ExceptionBreakpointPropertiesPanel(project), ExceptionBreakpointFactory.createActions(project), this.getBreakpointCategory(), DebuggerBundle.message((String)"exception.breakpoints.tab.title", (Object[])new Object[0]), "debugging.exceptionBreakpoint"){

            @Override
            public void resetBreakpoints() {
                super.resetBreakpoints();
                Breakpoint[] breakpoints = this.getBreakpointManager().getBreakpoints(this.getBreakpointCategory());
                AnyExceptionBreakpoint anyExceptionBreakpoint = DebuggerManagerEx.getInstanceEx(project).getBreakpointManager().getAnyExceptionBreakpoint();
                boolean found = false;
                for (Breakpoint breakpoint : breakpoints) {
                    if (!breakpoint.equals(anyExceptionBreakpoint)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.insertBreakpointAt(anyExceptionBreakpoint, 0);
                }
            }
        };
        panel.getTree().setGroupByMethods(false);
        return panel;
    }

    private static BreakpointPanelAction[] createActions(Project project) {
        return new BreakpointPanelAction[]{new SwitchViewAction(), new AddExceptionBreakpointAction(project), new RemoveAction(project){

            @Override
            public void update() {
                super.update();
                if (this.getButton().isEnabled()) {
                    Breakpoint[] selectedBreakpoints;
                    for (Breakpoint bp : selectedBreakpoints = this.getPanel().getSelectedBreakpoints()) {
                        if (!(bp instanceof AnyExceptionBreakpoint)) continue;
                        this.getButton().setEnabled(false);
                    }
                }
            }
        }, new ToggleGroupByClassesAction(), new ToggleFlattenPackagesAction()};
    }

    public Key<ExceptionBreakpoint> getBreakpointCategory() {
        return ExceptionBreakpoint.CATEGORY;
    }

    private static class AddExceptionBreakpointAction
    extends AddAction {
        private final Project myProject;

        public AddExceptionBreakpointAction(Project project) {
            this.myProject = project;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String qName;
            PsiClass throwableClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass("java.lang.Throwable", GlobalSearchScope.allScope((Project)this.myProject));
            TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)this.myProject).createInheritanceClassChooser(DebuggerBundle.message((String)"add.exception.breakpoint.classchooser.title", (Object[])new Object[0]), GlobalSearchScope.allScope((Project)this.myProject), throwableClass, true, true, null);
            chooser.showDialog();
            PsiClass selectedClass = chooser.getSelectedClass();
            String string = qName = selectedClass == null ? null : JVMNameUtil.getNonAnonymousClassName(selectedClass);
            if (qName != null && qName.length() > 0) {
                ExceptionBreakpoint breakpoint = DebuggerManagerEx.getInstanceEx(this.myProject).getBreakpointManager().addExceptionBreakpoint(qName, ((PsiClassOwner)selectedClass.getContainingFile()).getPackageName());
                this.getPanel().addBreakpoint(breakpoint);
            }
        }
    }
}

