/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.ui;

import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.actions.ScrollToTestSourceAction;
import com.intellij.execution.testframework.sm.SMRunnerUtil;
import com.intellij.execution.testframework.sm.runner.ProxyFilters;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.TestResultsViewer;
import com.intellij.execution.testframework.ui.PrintableTestProxy;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ModalityState;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.config.AbstractProperty;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SMTRunnerUIActionsHandler
implements TestResultsViewer.EventsListener {
    private final TestConsoleProperties myConsoleProperties;

    public SMTRunnerUIActionsHandler(TestConsoleProperties consoleProperties) {
        this.myConsoleProperties = consoleProperties;
    }

    @Override
    public void onTestNodeAdded(TestResultsViewer sender, SMTestProxy test) {
        if (TestConsoleProperties.TRACK_RUNNING_TEST.value((AbstractProperty.AbstractPropertyContainer)this.myConsoleProperties)) {
            sender.selectAndNotify(test);
        }
    }

    @Override
    public void onTestingStarted(TestResultsViewer sender) {
    }

    @Override
    public void onTestingFinished(TestResultsViewer sender) {
        AbstractTestProxy firstFailure;
        List<SMTestProxy> allTests;
        AbstractTestProxy firstError;
        AbstractTestProxy firstDefect;
        SMTestProxy testsRootNode = sender.getTestsRootNode();
        if (TestConsoleProperties.SELECT_FIRST_DEFECT.value((AbstractProperty.AbstractPropertyContainer)this.myConsoleProperties) && (firstDefect = (firstError = ProxyFilters.ERROR_LEAF.detectIn(allTests = testsRootNode.getAllTests())) != null ? firstError : ((firstFailure = ProxyFilters.FAILURE_LEAF.detectIn(allTests)) != null ? firstFailure : null)) != null) {
            sender.selectAndNotify(firstDefect);
        }
    }

    @Override
    public void onSelected(@Nullable PrintableTestProxy selectedTestProxy, @NotNull TestResultsViewer viewer, final @NotNull TestFrameworkRunningModel model) {
        if (viewer == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/ui/SMTRunnerUIActionsHandler.onSelected must not be null");
        }
        if (model == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/ui/SMTRunnerUIActionsHandler.onSelected must not be null");
        }
        SMRunnerUtil.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                if (ScrollToTestSourceAction.isScrollEnabled(model)) {
                    OpenSourceUtil.openSourcesFrom((DataProvider)model.getTreeView(), (boolean)false);
                }
            }
        }, ModalityState.NON_MODAL);
    }
}

