/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.TerminateRemoteProcessDialog;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.GenericProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentListener;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerAdapter;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.HashMap;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunContentManagerImpl
implements RunContentManager,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.ui.RunContentManagerImpl");
    private static final Key<RunContentDescriptor> DESCRIPTOR_KEY = new Key("Descriptor");
    private final Project myProject;
    private final Map<String, ContentManager> myToolwindowIdToContentManagerMap = new HashMap();
    private final Map<RunContentListener, MyRunContentListener> myListeners = new HashMap();
    private final EventDispatcher<MyRunContentListener> myEventDispatcher;
    private final LinkedList<String> myToolwindowIdZbuffer = new LinkedList();

    public RunContentManagerImpl(Project project) {
        this.myProject = project;
        this.myEventDispatcher = EventDispatcher.create(MyRunContentListener.class);
    }

    public void init() {
        Executor[] executors;
        for (Executor executor : executors = ExecutorRegistry.getInstance().getRegisteredExecutors()) {
            this.registerToolwindow(executor);
        }
        if (ToolWindowManager.getInstance((Project)this.myProject) == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (RunContentManagerImpl.this.myProject.isDisposed()) {
                    return;
                }
                ((ToolWindowManagerEx)ToolWindowManager.getInstance((Project)RunContentManagerImpl.this.myProject)).addToolWindowManagerListener(new ToolWindowManagerAdapter(){

                    @Override
                    public void stateChanged() {
                        if (RunContentManagerImpl.this.myProject.isDisposed()) {
                            return;
                        }
                        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)RunContentManagerImpl.this.myProject);
                        HashSet<String> currentWindows = new HashSet<String>();
                        String[] toolWindowIds = toolWindowManager.getToolWindowIds();
                        currentWindows.addAll(Arrays.asList(toolWindowIds));
                        RunContentManagerImpl.this.myToolwindowIdZbuffer.retainAll(currentWindows);
                        String activeToolWindowId = toolWindowManager.getActiveToolWindowId();
                        if (activeToolWindowId != null && RunContentManagerImpl.this.myToolwindowIdZbuffer.remove(activeToolWindowId)) {
                            RunContentManagerImpl.this.myToolwindowIdZbuffer.addFirst(activeToolWindowId);
                        }
                    }
                });
            }
        });
    }

    public void dispose() {
    }

    private void unregisterToolwindow(String id) {
        ContentManager manager = this.myToolwindowIdToContentManagerMap.get(id);
        manager.removeAllContents(true);
        this.myToolwindowIdToContentManagerMap.remove(id);
        this.myToolwindowIdZbuffer.remove(id);
    }

    private void registerToolwindow(final Executor executor) {
        final String toolWindowId = executor.getToolWindowId();
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        if (toolWindowManager == null) {
            return;
        }
        if (toolWindowManager.getToolWindow(toolWindowId) != null) {
            return;
        }
        ToolWindow toolWindow = toolWindowManager.registerToolWindow(toolWindowId, true, ToolWindowAnchor.BOTTOM, (Disposable)this, true);
        final ContentManager contentManager = toolWindow.getContentManager();
        class MyDataProvider
        implements DataProvider {
            private int myInsideGetData = 0;

            MyDataProvider() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object getData(String dataId) {
                ++this.myInsideGetData;
                try {
                    if (PlatformDataKeys.HELP_ID.is(dataId)) {
                        String string = executor.getHelpId();
                        return string;
                    }
                    Object object = this.myInsideGetData == 1 ? DataManager.getInstance().getDataContext((Component)contentManager.getComponent()).getData(dataId) : null;
                    return object;
                }
                finally {
                    --this.myInsideGetData;
                }
            }
        }
        contentManager.addDataProvider((DataProvider)new MyDataProvider());
        toolWindow.setIcon(executor.getToolWindowIcon());
        new ContentManagerWatcher(toolWindow, contentManager);
        contentManager.addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

            public void selectionChanged(ContentManagerEvent event) {
                Content content = event.getContent();
                RunContentDescriptor descriptor = content != null ? RunContentManagerImpl.getRunContentDescriptorByContent(content) : null;
                ((MyRunContentListener)RunContentManagerImpl.this.myEventDispatcher.getMulticaster()).contentSelected(descriptor, toolWindowId);
            }
        });
        this.myToolwindowIdToContentManagerMap.put(toolWindowId, contentManager);
        Disposer.register((Disposable)contentManager, (Disposable)new Disposable(){

            public void dispose() {
                RunContentManagerImpl.this.unregisterToolwindow(toolWindowId);
            }
        });
        this.myToolwindowIdZbuffer.addLast(toolWindowId);
    }

    public void toFrontRunContent(Executor requestor, ProcessHandler handler) {
        RunContentDescriptor descriptor = this.getDescriptorBy(handler, requestor);
        if (descriptor == null) {
            return;
        }
        this.toFrontRunContent(requestor, descriptor);
    }

    public void toFrontRunContent(final Executor requestor, final RunContentDescriptor descriptor) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ContentManager contentManager = RunContentManagerImpl.this.getContentManagerForRunner(requestor);
                Content content = RunContentManagerImpl.getRunContentByDescriptor(contentManager, descriptor);
                if (contentManager != null && content != null) {
                    contentManager.setSelectedContent(content);
                    ToolWindow toolWindow = ToolWindowManager.getInstance((Project)RunContentManagerImpl.this.myProject).getToolWindow(requestor.getToolWindowId());
                    toolWindow.show(null);
                }
            }
        });
    }

    public void hideRunContent(final @NotNull Executor executor, RunContentDescriptor descriptor) {
        if (executor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/ui/RunContentManagerImpl.hideRunContent must not be null");
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!RunContentManagerImpl.this.myProject.isDisposed()) {
                    String toolWindowId = executor.getToolWindowId();
                    ToolWindow toolWindow = ToolWindowManager.getInstance((Project)RunContentManagerImpl.this.myProject).getToolWindow(toolWindowId);
                    if (toolWindow != null) {
                        toolWindow.hide(null);
                    }
                }
            }
        });
    }

    @Nullable
    public RunContentDescriptor getSelectedContent(Executor executor) {
        RunContentDescriptor runContentDescriptorByContent;
        Content selectedContent;
        ContentManager contentManager = this.getContentManagerForRunner(executor);
        if (contentManager != null && (selectedContent = contentManager.getSelectedContent()) != null && (runContentDescriptorByContent = RunContentManagerImpl.getRunContentDescriptorByContent(selectedContent)) != null) {
            return runContentDescriptorByContent;
        }
        return null;
    }

    @Nullable
    public RunContentDescriptor getSelectedContent() {
        RunContentDescriptor runContentDescriptorByContent;
        Content selectedContent;
        ContentManager contentManager;
        String activeWindow;
        String string = activeWindow = this.myToolwindowIdZbuffer.isEmpty() ? null : this.myToolwindowIdZbuffer.getFirst();
        if (activeWindow != null && (contentManager = this.myToolwindowIdToContentManagerMap.get(activeWindow)) != null && (selectedContent = contentManager.getSelectedContent()) != null && (runContentDescriptorByContent = RunContentManagerImpl.getRunContentDescriptorByContent(selectedContent)) != null) {
            return runContentDescriptorByContent;
        }
        return null;
    }

    public boolean removeRunContent(@NotNull Executor executor, RunContentDescriptor descriptor) {
        if (executor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/ui/RunContentManagerImpl.removeRunContent must not be null");
        }
        ContentManager contentManager = this.getContentManagerForRunner(executor);
        Content content = RunContentManagerImpl.getRunContentByDescriptor(contentManager, descriptor);
        return content != null && contentManager.removeContent(content, true);
    }

    public void showRunContent(final @NotNull Executor executor, final RunContentDescriptor descriptor) {
        Content content;
        if (executor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/ui/RunContentManagerImpl.showRunContent must not be null");
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(executor.getToolWindowId());
        final boolean wasInActiveWindow = toolWindow != null && toolWindow.isActive();
        ContentManager contentManager = this.getContentManagerForRunner(executor);
        RunContentDescriptor oldDescriptor = RunContentManagerImpl.chooseReuseContentForDescriptor(contentManager, descriptor);
        if (oldDescriptor != null) {
            content = oldDescriptor.getAttachedContent();
            ((MyRunContentListener)this.myEventDispatcher.getMulticaster()).contentRemoved(oldDescriptor, executor.getToolWindowId());
            oldDescriptor.dispose();
        } else {
            content = this.createNewContent(contentManager, descriptor, executor.getToolWindowId());
            Icon icon = descriptor.getIcon();
            content.setIcon(icon == null ? executor.getToolWindowIcon() : icon);
        }
        content.setComponent(descriptor.getComponent());
        content.putUserData(DESCRIPTOR_KEY, (Object)descriptor);
        final ProcessHandler processHandler = descriptor.getProcessHandler();
        if (processHandler != null) {
            final ProcessAdapter processAdapter = new ProcessAdapter(){

                public void startNotified(ProcessEvent event) {
                    LaterInvocator.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Icon icon = descriptor.getIcon();
                            content.setIcon(icon == null ? executor.getToolWindowIcon() : icon);
                        }
                    });
                }

                public void processTerminated(ProcessEvent event) {
                    LaterInvocator.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Icon icon = descriptor.getIcon();
                            content.setIcon(icon == null ? executor.getDisabledIcon() : IconLoader.getTransparentIcon((Icon)icon));
                        }
                    });
                }
            };
            processHandler.addProcessListener((ProcessListener)processAdapter);
            Disposable disposer = content.getDisposer();
            if (disposer != null) {
                Disposer.register((Disposable)disposer, (Disposable)new Disposable(){

                    public void dispose() {
                        processHandler.removeProcessListener((ProcessListener)processAdapter);
                    }
                });
            }
        }
        content.setDisplayName(descriptor.getDisplayName());
        descriptor.setAttachedContent(content);
        content.getManager().setSelectedContent(content);
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ToolWindow window = ToolWindowManager.getInstance((Project)RunContentManagerImpl.this.myProject).getToolWindow(executor.getToolWindowId());
                if (wasInActiveWindow) {
                    window.activate(null, true, false);
                } else {
                    window.show(null);
                }
            }
        });
    }

    @Nullable
    public RunContentDescriptor getReuseContent(Executor requestor, DataContext dataContext) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        return this.getReuseContent(requestor, (RunContentDescriptor)GenericProgramRunner.CONTENT_TO_REUSE_DATA_KEY.getData(dataContext));
    }

    public RunContentDescriptor getReuseContent(Executor requestor, @Nullable RunContentDescriptor contentToReuse) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        if (contentToReuse != null) {
            return contentToReuse;
        }
        ContentManager contentManager = this.getContentManagerForRunner(requestor);
        return RunContentManagerImpl.chooseReuseContentForDescriptor(contentManager, contentToReuse);
    }

    public RunContentDescriptor findContentDescriptor(Executor requestor, ProcessHandler handler) {
        return this.getDescriptorBy(handler, requestor);
    }

    public void showRunContent(@NotNull Executor info, RunContentDescriptor descriptor, RunContentDescriptor contentToReuse) {
        if (info == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/ui/RunContentManagerImpl.showRunContent must not be null");
        }
        if (contentToReuse != null) {
            descriptor.setAttachedContent(contentToReuse.getAttachedContent());
        }
        this.showRunContent(info, descriptor);
    }

    @Nullable
    private static RunContentDescriptor chooseReuseContentForDescriptor(ContentManager contentManager, RunContentDescriptor descriptor) {
        Content attachedContent;
        Content content = null;
        if (descriptor != null && (attachedContent = descriptor.getAttachedContent()) != null && attachedContent.isValid()) {
            content = attachedContent;
        }
        if (content == null && (content = contentManager.getSelectedContent()) != null && content.isPinned()) {
            content = null;
        }
        if (content == null || !RunContentManagerImpl.isTerminated(content)) {
            return null;
        }
        RunContentDescriptor oldDescriptor = RunContentManagerImpl.getRunContentDescriptorByContent(content);
        if (oldDescriptor != null && !oldDescriptor.isContentReuseProhibited()) {
            return oldDescriptor;
        }
        return null;
    }

    private ContentManager getContentManagerForRunner(Executor executor) {
        ContentManager contentManager = this.myToolwindowIdToContentManagerMap.get(executor.getToolWindowId());
        if (contentManager == null) {
            LOG.error("Runner " + executor.getId() + " is not registered");
        }
        return contentManager;
    }

    private Content createNewContent(ContentManager contentManager, RunContentDescriptor descriptor, String toolWindowId) {
        String processDisplayName = descriptor.getDisplayName();
        Content content = ContentFactory.SERVICE.getInstance().createContent(descriptor.getComponent(), processDisplayName, true);
        content.putUserData(DESCRIPTOR_KEY, (Object)descriptor);
        content.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
        contentManager.addContent(content);
        new CloseListener(content, toolWindowId);
        return content;
    }

    private static boolean isTerminated(Content content) {
        RunContentDescriptor descriptor = RunContentManagerImpl.getRunContentDescriptorByContent(content);
        if (descriptor == null) {
            return true;
        }
        ProcessHandler processHandler = descriptor.getProcessHandler();
        return processHandler == null || processHandler.isProcessTerminated();
    }

    public static RunContentDescriptor getRunContentDescriptorByContent(Content content) {
        return (RunContentDescriptor)content.getUserData(DESCRIPTOR_KEY);
    }

    @Nullable
    private static Content getRunContentByDescriptor(ContentManager contentManager, RunContentDescriptor descriptor) {
        Content[] contents;
        for (Content content : contents = contentManager.getContents()) {
            if (!descriptor.equals(content.getUserData(DESCRIPTOR_KEY))) continue;
            return content;
        }
        return null;
    }

    public void addRunContentListener(final RunContentListener listener, final Executor executor) {
        this.myEventDispatcher.addListener((EventListener)new MyRunContentListener(){

            @Override
            public void contentSelected(RunContentDescriptor descriptor, String toolwindowId) {
                if (toolwindowId.equals(executor.getToolWindowId())) {
                    listener.contentSelected(descriptor);
                }
            }

            @Override
            public void contentRemoved(RunContentDescriptor descriptor, String toolwindowId) {
                if (toolwindowId.equals(executor.getToolWindowId())) {
                    listener.contentRemoved(descriptor);
                }
            }
        });
    }

    public void addRunContentListener(final RunContentListener listener) {
        MyRunContentListener windowedListener = new MyRunContentListener(){

            @Override
            public void contentSelected(RunContentDescriptor descriptor, String ToolwindowId) {
                listener.contentSelected(descriptor);
            }

            @Override
            public void contentRemoved(RunContentDescriptor descriptor, String ToolwindowId) {
                listener.contentRemoved(descriptor);
            }
        };
        this.myEventDispatcher.addListener((EventListener)windowedListener);
        this.myListeners.put(listener, windowedListener);
    }

    public RunContentDescriptor[] getAllDescriptors() {
        String[] ids;
        ArrayList<RunContentDescriptor> descriptors = new ArrayList<RunContentDescriptor>();
        for (String id : ids = this.myToolwindowIdToContentManagerMap.keySet().toArray(new String[this.myToolwindowIdToContentManagerMap.size()])) {
            Content[] contents;
            ContentManager contentManager = this.myToolwindowIdToContentManagerMap.get(id);
            for (Content content : contents = contentManager.getContents()) {
                RunContentDescriptor descriptor = RunContentManagerImpl.getRunContentDescriptorByContent(content);
                if (descriptor == null) continue;
                descriptors.add(descriptor);
            }
        }
        return descriptors.toArray(new RunContentDescriptor[descriptors.size()]);
    }

    public void removeRunContentListener(RunContentListener listener) {
        MyRunContentListener contentListener = this.myListeners.remove(listener);
        this.myEventDispatcher.removeListener((EventListener)contentListener);
    }

    @Nullable
    private RunContentDescriptor getDescriptorBy(ProcessHandler handler, Executor runnerInfo) {
        Content[] contents;
        ContentManager contentManager = this.getContentManagerForRunner(runnerInfo);
        for (Content content : contents = contentManager.getContents()) {
            RunContentDescriptor runContentDescriptor = (RunContentDescriptor)content.getUserData(DESCRIPTOR_KEY);
            if (runContentDescriptor.getProcessHandler() != handler) continue;
            return runContentDescriptor;
        }
        return null;
    }

    private void waitForProcess(final RunContentDescriptor descriptor) {
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                final Semaphore semaphore = new Semaphore();
                semaphore.down();
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ProcessHandler processHandler = descriptor.getProcessHandler();
                        try {
                            if (processHandler != null) {
                                processHandler.waitFor();
                            }
                        }
                        finally {
                            semaphore.up();
                        }
                    }
                });
                final ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                if (progressIndicator != null) {
                    progressIndicator.setText(ExecutionBundle.message((String)"waiting.for.vm.detach.progress.text", (Object[])new Object[0]));
                    ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            while (true) {
                                if (progressIndicator.isCanceled() || !progressIndicator.isRunning()) break;
                                try {
                                    2 var1_1 = this;
                                    synchronized (var1_1) {
                                        this.wait(2000L);
                                        continue;
                                    }
                                }
                                catch (InterruptedException interruptedException) {
                                    continue;
                                }
                                break;
                            }
                            semaphore.up();
                        }
                    });
                }
                semaphore.waitFor();
            }
        }, ExecutionBundle.message((String)"terminating.process.progress.title", (Object[])new Object[]{descriptor.getDisplayName()}), true, this.myProject);
    }

    public static interface MyRunContentListener
    extends EventListener {
        public void contentSelected(RunContentDescriptor var1, String var2);

        public void contentRemoved(RunContentDescriptor var1, String var2);
    }

    private class CloseListener
    extends ContentManagerAdapter
    implements ProjectManagerListener {
        private Content myContent;
        private final String myToolwindowId;

        private CloseListener(Content content, String toolWindowId) {
            this.myContent = content;
            content.getManager().addContentManagerListener((ContentManagerListener)this);
            ProjectManager.getInstance().addProjectManagerListener((ProjectManagerListener)this);
            this.myToolwindowId = toolWindowId;
        }

        public void contentRemoved(ContentManagerEvent event) {
            Content content = event.getContent();
            if (content == this.myContent) {
                this.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispose() {
            if (this.myContent == null) {
                return;
            }
            Content content = this.myContent;
            try {
                RunContentDescriptor descriptor = RunContentManagerImpl.getRunContentDescriptorByContent(content);
                ((MyRunContentListener)RunContentManagerImpl.this.myEventDispatcher.getMulticaster()).contentRemoved(descriptor, this.myToolwindowId);
                descriptor.dispose();
            }
            finally {
                content.getManager().removeContentManagerListener((ContentManagerListener)this);
                ProjectManager.getInstance().removeProjectManagerListener((ProjectManagerListener)this);
                content.release();
                this.myContent = null;
            }
        }

        public void contentRemoveQuery(ContentManagerEvent event) {
            boolean canClose;
            if (event.getContent() == this.myContent && !(canClose = this.closeQuery())) {
                event.consume();
            }
        }

        public void projectOpened(Project project) {
        }

        public void projectClosed(Project project) {
            if (this.myContent != null && project == RunContentManagerImpl.this.myProject) {
                this.myContent.getManager().removeContent(this.myContent, true);
                this.dispose();
            }
        }

        public boolean canCloseProject(Project project) {
            if (project != RunContentManagerImpl.this.myProject) {
                return true;
            }
            if (this.myContent == null) {
                return true;
            }
            boolean canClose = this.closeQuery();
            if (canClose) {
                this.myContent.getManager().removeContent(this.myContent, true);
                this.myContent = null;
            }
            return canClose;
        }

        public void projectClosing(Project project) {
        }

        private boolean closeQuery() {
            boolean destroyProcess;
            RunContentDescriptor descriptor = RunContentManagerImpl.getRunContentDescriptorByContent(this.myContent);
            if (descriptor == null) {
                return true;
            }
            ProcessHandler processHandler = descriptor.getProcessHandler();
            if (processHandler == null || processHandler.isProcessTerminated()) {
                return true;
            }
            if (Boolean.TRUE.equals(processHandler.getUserData(ProcessHandler.SILENTLY_DESTROY_ON_CLOSE))) {
                destroyProcess = true;
            } else {
                TerminateRemoteProcessDialog terminateDialog = new TerminateRemoteProcessDialog(RunContentManagerImpl.this.myProject, descriptor.getDisplayName(), processHandler.detachIsDefault());
                terminateDialog.show();
                if (terminateDialog.getExitCode() != 0) {
                    return false;
                }
                destroyProcess = terminateDialog.forceTermination();
            }
            if (destroyProcess) {
                processHandler.destroyProcess();
            } else {
                processHandler.detachProcess();
            }
            RunContentManagerImpl.this.waitForProcess(descriptor);
            return true;
        }
    }
}

