/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.autodetecting.model;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetType;
import com.intellij.facet.impl.autodetecting.model.FacetInfo2;
import com.intellij.facet.impl.autodetecting.model.ProjectFacetInfoSet;
import com.intellij.openapi.module.Module;
import org.jetbrains.annotations.NotNull;

public class FacetInfoBackedByFacet
implements FacetInfo2<Module> {
    private final Facet myFacet;
    private final ProjectFacetInfoSet myProjectFacetSet;

    FacetInfoBackedByFacet(@NotNull Facet facet, ProjectFacetInfoSet projectFacetSet) {
        if (facet == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/model/FacetInfoBackedByFacet.<init> must not be null");
        }
        this.myFacet = facet;
        this.myProjectFacetSet = projectFacetSet;
    }

    @Override
    @NotNull
    public String getFacetName() {
        String string = this.myFacet.getName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/impl/autodetecting/model/FacetInfoBackedByFacet.getFacetName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public FacetConfiguration getConfiguration() {
        FacetConfiguration facetConfiguration = this.myFacet.getConfiguration();
        if (facetConfiguration == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/impl/autodetecting/model/FacetInfoBackedByFacet.getConfiguration must not return null");
        }
        return facetConfiguration;
    }

    @Override
    @NotNull
    public FacetType getFacetType() {
        FacetType facetType = this.myFacet.getType();
        if (facetType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/impl/autodetecting/model/FacetInfoBackedByFacet.getFacetType must not return null");
        }
        return facetType;
    }

    @Override
    public FacetInfo2<Module> getUnderlyingFacetInfo() {
        Facet underlying = this.myFacet.getUnderlyingFacet();
        return underlying != null ? this.myProjectFacetSet.getOrCreateInfo(underlying) : null;
    }

    @Override
    @NotNull
    public Module getModule() {
        Module module = this.myFacet.getModule();
        if (module == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/impl/autodetecting/model/FacetInfoBackedByFacet.getModule must not return null");
        }
        return module;
    }

    public Facet getFacet() {
        return this.myFacet;
    }
}

