/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.AlignmentFactory;
import com.intellij.formatting.AlignmentImpl;
import com.intellij.formatting.Block;
import com.intellij.formatting.DependantSpacingImpl;
import com.intellij.formatting.FormatProcessor;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormatterEx;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelFactory;
import com.intellij.formatting.FormattingModelProvider;
import com.intellij.formatting.Indent;
import com.intellij.formatting.IndentFactory;
import com.intellij.formatting.IndentImpl;
import com.intellij.formatting.IndentInfo;
import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.SpacingFactory;
import com.intellij.formatting.SpacingImpl;
import com.intellij.formatting.WhiteSpace;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapFactory;
import com.intellij.formatting.WrapImpl;
import com.intellij.formatting.WrapType;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.formatter.PsiBasedFormattingModel;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormatterImpl
extends FormatterEx
implements ApplicationComponent,
IndentFactory,
WrapFactory,
AlignmentFactory,
SpacingFactory,
FormattingModelFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.formatting.FormatterImpl");
    private int myIsDisabledCount = 0;
    private final IndentImpl NONE_INDENT = new IndentImpl(IndentImpl.Type.NONE, false);
    private final IndentImpl myAbsoluteNoneIndent = new IndentImpl(IndentImpl.Type.NONE, true);
    private final IndentImpl myLabelIndent = new IndentImpl(IndentImpl.Type.LABEL, false);
    private final IndentImpl myContinuationIndent = new IndentImpl(IndentImpl.Type.CONTINUATION, false);
    private final IndentImpl myContinutationWithoutFirstIndent = new IndentImpl(IndentImpl.Type.CONTINUATION_WITHOUT_FIRST, false);
    private final IndentImpl myAbsoluteLabelIndent = new IndentImpl(IndentImpl.Type.LABEL, true);
    private final IndentImpl myNormalIndent = new IndentImpl(IndentImpl.Type.NORMAL, false);
    private final SpacingImpl myReadOnlySpacing = new SpacingImpl(0, 0, 0, true, false, true, 0, false, 0);
    private final Map<SpacingImpl, SpacingImpl> ourSharedProperties = new HashMap<SpacingImpl, SpacingImpl>();
    private final SpacingImpl ourSharedSpacing = new SpacingImpl(-1, -1, -1, false, false, false, -1, false, 0);
    private final Object DISABLING_LOCK = new Object();

    public FormatterImpl() {
        Indent.setFactory((IndentFactory)this);
        Wrap.setFactory((WrapFactory)this);
        Alignment.setFactory((AlignmentFactory)this);
        Spacing.setFactory((SpacingFactory)this);
        FormattingModelProvider.setFactory((FormattingModelFactory)this);
    }

    public Alignment createAlignment() {
        return new AlignmentImpl(AlignmentImpl.Type.NORMAL);
    }

    public Alignment createChildAlignment(Alignment base) {
        AlignmentImpl result = new AlignmentImpl(AlignmentImpl.Type.NORMAL);
        result.setParent(base);
        return result;
    }

    public Indent getNormalIndent() {
        return this.myNormalIndent;
    }

    public Indent getNoneIndent() {
        return this.NONE_INDENT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void format(FormattingModel model, CodeStyleSettings settings, CodeStyleSettings.IndentOptions indentOptions, CodeStyleSettings.IndentOptions javaIndentOptions, FormatTextRanges affectedRanges) throws IncorrectOperationException {
        this.disableFormatting();
        try {
            FormatProcessor processor = new FormatProcessor(model.getDocumentModel(), model.getRootBlock(), settings, indentOptions, affectedRanges);
            processor.setJavaIndentOptions(javaIndentOptions);
            processor.format(model);
        }
        finally {
            this.enableFormatting();
        }
    }

    public Wrap createWrap(WrapType type, boolean wrapFirstElement) {
        return new WrapImpl(type, wrapFirstElement);
    }

    public Wrap createChildWrap(Wrap parentWrap, WrapType wrapType, boolean wrapFirstElement) {
        WrapImpl result = new WrapImpl(wrapType, wrapFirstElement);
        result.registerParent((WrapImpl)parentWrap);
        return result;
    }

    public Spacing createSpacing(int minOffset, int maxOffset, int minLineFeeds, boolean keepLineBreaks, int keepBlankLines) {
        return this.getSpacingImpl(minOffset, maxOffset, minLineFeeds, false, false, keepLineBreaks, keepBlankLines, false, 0);
    }

    public Spacing getReadOnlySpacing() {
        return this.myReadOnlySpacing;
    }

    public Spacing createDependentLFSpacing(int minOffset, int maxOffset, TextRange dependence, boolean keepLineBreaks, int keepBlankLines) {
        return new DependantSpacingImpl(minOffset, maxOffset, dependence, keepLineBreaks, keepBlankLines);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void format(FormattingModel model, CodeStyleSettings settings, CodeStyleSettings.IndentOptions indentOptions, FormatTextRanges affectedRanges) throws IncorrectOperationException {
        this.disableFormatting();
        try {
            new FormatProcessor(model.getDocumentModel(), model.getRootBlock(), settings, indentOptions, affectedRanges).format(model);
        }
        finally {
            this.enableFormatting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void formatWithoutModifications(FormattingDocumentModel model, Block rootBlock, CodeStyleSettings settings, CodeStyleSettings.IndentOptions indentOptions, TextRange affectedRange) throws IncorrectOperationException {
        this.disableFormatting();
        try {
            new FormatProcessor(model, rootBlock, settings, indentOptions, new FormatTextRanges(affectedRange, true)).formatWithoutRealModifications();
        }
        finally {
            this.enableFormatting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndentInfo getWhiteSpaceBefore(FormattingDocumentModel model, Block block, CodeStyleSettings settings, CodeStyleSettings.IndentOptions indentOptions, TextRange affectedRange, boolean mayChangeLineFeeds) {
        this.disableFormatting();
        try {
            FormatProcessor processor = new FormatProcessor(model, block, settings, indentOptions, new FormatTextRanges(affectedRange, true));
            LeafBlockWrapper blockBefore = processor.getBlockAfter(affectedRange.getStartOffset());
            LOG.assertTrue(blockBefore != null);
            WhiteSpace whiteSpace = blockBefore.getWhiteSpace();
            LOG.assertTrue(whiteSpace != null);
            if (!mayChangeLineFeeds) {
                whiteSpace.setLineFeedsAreReadOnly();
            }
            processor.setAllWhiteSpacesAreReadOnly();
            whiteSpace.setReadOnly(false);
            processor.formatWithoutRealModifications();
            IndentInfo indentInfo = new IndentInfo(whiteSpace.getLineFeeds(), whiteSpace.getIndentOffset(), whiteSpace.getSpaces());
            return indentInfo;
        }
        finally {
            this.enableFormatting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustLineIndentsForRange(FormattingModel model, CodeStyleSettings settings, CodeStyleSettings.IndentOptions indentOptions, TextRange rangeToAdjust) {
        this.disableFormatting();
        try {
            FormattingDocumentModel documentModel = model.getDocumentModel();
            Block block = model.getRootBlock();
            FormatProcessor processor = new FormatProcessor(documentModel, block, settings, indentOptions, new FormatTextRanges(rangeToAdjust, true));
            for (LeafBlockWrapper tokenBlock = processor.getFirstTokenBlock(); tokenBlock != null; tokenBlock = tokenBlock.getNextBlock()) {
                WhiteSpace whiteSpace = tokenBlock.getWhiteSpace();
                whiteSpace.setLineFeedsAreReadOnly(true);
                if (whiteSpace.containsLineFeeds()) continue;
                whiteSpace.setIsReadOnly(true);
            }
            processor.formatWithoutRealModifications();
            processor.performModifications(model);
        }
        finally {
            this.enableFormatting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void formatAroundRange(FormattingModel model, CodeStyleSettings settings, TextRange textRange, FileType fileType) {
        this.disableFormatting();
        try {
            FormattingDocumentModel documentModel = model.getDocumentModel();
            Block block = model.getRootBlock();
            FormatProcessor processor = new FormatProcessor(documentModel, block, settings, settings.getIndentOptions(fileType), null);
            for (LeafBlockWrapper tokenBlock = processor.getFirstTokenBlock(); tokenBlock != null; tokenBlock = tokenBlock.getNextBlock()) {
                WhiteSpace whiteSpace = tokenBlock.getWhiteSpace();
                if (whiteSpace.getEndOffset() < textRange.getStartOffset()) {
                    whiteSpace.setIsReadOnly(true);
                    continue;
                }
                if (whiteSpace.getStartOffset() > textRange.getStartOffset() && whiteSpace.getEndOffset() < textRange.getEndOffset()) {
                    if (whiteSpace.containsLineFeeds()) {
                        whiteSpace.setLineFeedsAreReadOnly(true);
                        continue;
                    }
                    whiteSpace.setIsReadOnly(true);
                    continue;
                }
                if (whiteSpace.getEndOffset() <= textRange.getEndOffset() + 1) continue;
                whiteSpace.setIsReadOnly(true);
            }
            processor.formatWithoutRealModifications();
            processor.performModifications(model);
        }
        finally {
            this.enableFormatting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int adjustLineIndent(FormattingModel model, CodeStyleSettings settings, CodeStyleSettings.IndentOptions indentOptions, int offset, TextRange affectedRange) throws IncorrectOperationException {
        this.disableFormatting();
        if (model instanceof PsiBasedFormattingModel) {
            ((PsiBasedFormattingModel)model).canModifyAllWhiteSpaces();
        }
        try {
            FormattingDocumentModel documentModel = model.getDocumentModel();
            Block block = model.getRootBlock();
            FormatProcessor processor = new FormatProcessor(documentModel, block, settings, indentOptions, new FormatTextRanges(affectedRange, true), offset);
            LeafBlockWrapper blockAfterOffset = processor.getBlockAfter(offset);
            if (blockAfterOffset != null && blockAfterOffset.contains(offset)) {
                int n = offset;
                return n;
            }
            if (blockAfterOffset != null) {
                int n = FormatterImpl.adjustLineIndent(offset, documentModel, processor, indentOptions, model, blockAfterOffset.getWhiteSpace());
                return n;
            }
            int n = FormatterImpl.adjustLineIndent(offset, documentModel, processor, indentOptions, model, processor.getLastWhiteSpace());
            return n;
        }
        finally {
            this.enableFormatting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int adjustLineIndent(int offset, FormattingDocumentModel documentModel, FormatProcessor processor, CodeStyleSettings.IndentOptions indentOptions, FormattingModel model, WhiteSpace whiteSpace) {
        IndentInfo indent;
        boolean wsContainsCaret = whiteSpace.getStartOffset() <= offset && offset < whiteSpace.getEndOffset();
        CharSequence text = FormatterImpl.getCharSequence(documentModel);
        int lineStartOffset = FormatterImpl.getLineStartOffset(offset, whiteSpace, text, documentModel);
        String newWS = whiteSpace.generateWhiteSpace(indentOptions, lineStartOffset, indent = FormatterImpl.calcIndent(offset, documentModel, processor, whiteSpace)).toString();
        if (!whiteSpace.equalsToString(newWS)) {
            try {
                model.replaceWhiteSpace(whiteSpace.getTextRange(), newWS);
            }
            finally {
                model.commitChanges();
            }
        }
        int defaultOffset = offset - whiteSpace.getLength() + newWS.length();
        if (wsContainsCaret) {
            int ws = whiteSpace.getStartOffset() + CharArrayUtil.shiftForward((CharSequence)newWS, (int)(lineStartOffset - whiteSpace.getStartOffset()), (String)" \t");
            return Math.max(defaultOffset, ws);
        }
        return defaultOffset;
    }

    private static boolean hasContentAfterLineBreak(FormattingDocumentModel documentModel, int offset, WhiteSpace whiteSpace) {
        return documentModel.getLineNumber(offset) == documentModel.getLineNumber(whiteSpace.getEndOffset()) && documentModel.getTextLength() != offset;
    }

    @Override
    public String getLineIndent(FormattingModel model, CodeStyleSettings settings, CodeStyleSettings.IndentOptions indentOptions, int offset, TextRange affectedRange) {
        Block block;
        FormattingDocumentModel documentModel = model.getDocumentModel();
        FormatProcessor processor = new FormatProcessor(documentModel, block = model.getRootBlock(), settings, indentOptions, new FormatTextRanges(affectedRange, true), offset);
        LeafBlockWrapper blockAfterOffset = processor.getBlockAfter(offset);
        if (blockAfterOffset != null) {
            WhiteSpace whiteSpace = blockAfterOffset.getWhiteSpace();
            IndentInfo indent = FormatterImpl.calcIndent(offset, documentModel, processor, whiteSpace);
            return indent.generateNewWhiteSpace(indentOptions).toString();
        }
        return null;
    }

    private static IndentInfo calcIndent(int offset, FormattingDocumentModel documentModel, FormatProcessor processor, WhiteSpace whiteSpace) {
        IndentInfo indent;
        processor.setAllWhiteSpacesAreReadOnly();
        whiteSpace.setLineFeedsAreReadOnly(true);
        if (FormatterImpl.hasContentAfterLineBreak(documentModel, offset, whiteSpace)) {
            whiteSpace.setReadOnly(false);
            processor.formatWithoutRealModifications();
            indent = new IndentInfo(0, whiteSpace.getIndentOffset(), whiteSpace.getSpaces());
        } else {
            indent = processor.getIndentAt(offset);
        }
        return indent;
    }

    public static String getText(FormattingDocumentModel documentModel) {
        return ((Object)FormatterImpl.getCharSequence(documentModel)).toString();
    }

    private static CharSequence getCharSequence(FormattingDocumentModel documentModel) {
        return documentModel.getText(new TextRange(0, documentModel.getTextLength()));
    }

    private static int getLineStartOffset(int offset, WhiteSpace whiteSpace, CharSequence text, FormattingDocumentModel documentModel) {
        int lineStartOffset = offset;
        if ((lineStartOffset = CharArrayUtil.shiftBackwardUntil((CharSequence)text, (int)lineStartOffset, (String)" \t\n")) > whiteSpace.getStartOffset()) {
            int prevEnd;
            if (lineStartOffset >= text.length()) {
                lineStartOffset = text.length() - 1;
            }
            int wsStart = whiteSpace.getStartOffset();
            if (text.charAt(lineStartOffset) == '\n' && wsStart <= (prevEnd = documentModel.getLineStartOffset(documentModel.getLineNumber(lineStartOffset - 1))) && ((Object)documentModel.getText(new TextRange(prevEnd, lineStartOffset))).toString().trim().length() == 0) {
                --lineStartOffset;
            }
            if ((lineStartOffset = CharArrayUtil.shiftBackward((CharSequence)text, (int)lineStartOffset, (String)"\t ")) < 0) {
                lineStartOffset = 0;
            }
            if (lineStartOffset != offset && text.charAt(lineStartOffset) == '\n') {
                ++lineStartOffset;
            }
        }
        return lineStartOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustTextRange(FormattingModel model, CodeStyleSettings settings, CodeStyleSettings.IndentOptions indentOptions, TextRange affectedRange, boolean keepBlankLines, boolean keepLineBreaks, boolean changeWSBeforeFirstElement, boolean changeLineFeedsBeforeFirstElement, @Nullable FormatterEx.IndentInfoStorage indentInfoStorage) {
        this.disableFormatting();
        try {
            FormatProcessor processor = new FormatProcessor(model.getDocumentModel(), model.getRootBlock(), settings, indentOptions, new FormatTextRanges(affectedRange, true));
            for (LeafBlockWrapper current = processor.getFirstTokenBlock(); current != null; current = current.getNextBlock()) {
                SpacingImpl spaceProperty;
                WhiteSpace whiteSpace = current.getWhiteSpace();
                if (whiteSpace.isReadOnly()) continue;
                if (whiteSpace.getStartOffset() > affectedRange.getStartOffset()) {
                    if (whiteSpace.containsLineFeeds() && indentInfoStorage != null) {
                        whiteSpace.setLineFeedsAreReadOnly(true);
                        current.setIndentFromParent(indentInfoStorage.getIndentInfo(current.getStartOffset()));
                        continue;
                    }
                    whiteSpace.setReadOnly(true);
                    continue;
                }
                if (!changeWSBeforeFirstElement) {
                    whiteSpace.setReadOnly(true);
                    continue;
                }
                if (!changeLineFeedsBeforeFirstElement) {
                    whiteSpace.setLineFeedsAreReadOnly(true);
                }
                if ((spaceProperty = current.getSpaceProperty()) == null) continue;
                boolean needChange = false;
                int newKeepLineBreaks = spaceProperty.getKeepBlankLines();
                boolean newKeepLineBreaksFlag = spaceProperty.shouldKeepLineFeeds();
                if (!keepLineBreaks) {
                    needChange = true;
                    newKeepLineBreaksFlag = false;
                }
                if (!keepBlankLines) {
                    needChange = true;
                    newKeepLineBreaks = 0;
                }
                if (!needChange) continue;
                assert (!(spaceProperty instanceof DependantSpacingImpl));
                current.setSpaceProperty(this.getSpacingImpl(spaceProperty.getMinSpaces(), spaceProperty.getMaxSpaces(), spaceProperty.getMinLineFeeds(), spaceProperty.isReadOnly(), spaceProperty.isSafe(), newKeepLineBreaksFlag, newKeepLineBreaks, false, spaceProperty.getPrefLineFeeds()));
            }
            processor.format(model);
        }
        finally {
            this.enableFormatting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustTextRange(FormattingModel model, CodeStyleSettings settings, CodeStyleSettings.IndentOptions indentOptions, TextRange affectedRange) {
        this.disableFormatting();
        try {
            FormatProcessor processor = new FormatProcessor(model.getDocumentModel(), model.getRootBlock(), settings, indentOptions, new FormatTextRanges(affectedRange, true));
            for (LeafBlockWrapper current = processor.getFirstTokenBlock(); current != null; current = current.getNextBlock()) {
                WhiteSpace whiteSpace = current.getWhiteSpace();
                if (whiteSpace.isReadOnly()) continue;
                if (whiteSpace.getStartOffset() > affectedRange.getStartOffset()) {
                    whiteSpace.setReadOnly(true);
                    continue;
                }
                whiteSpace.setReadOnly(false);
            }
            processor.format(model);
        }
        finally {
            this.enableFormatting();
        }
    }

    @Override
    public void saveIndents(FormattingModel model, TextRange affectedRange, FormatterEx.IndentInfoStorage storage, CodeStyleSettings settings, CodeStyleSettings.IndentOptions indentOptions) {
        Block block = model.getRootBlock();
        FormatProcessor processor = new FormatProcessor(model.getDocumentModel(), block, settings, indentOptions, new FormatTextRanges(affectedRange, true));
        for (LeafBlockWrapper current = processor.getFirstTokenBlock(); current != null; current = current.getNextBlock()) {
            WhiteSpace whiteSpace = current.getWhiteSpace();
            if (whiteSpace.isReadOnly() || !whiteSpace.containsLineFeeds()) continue;
            storage.saveIndentInfo(current.calcIndentFromParent(), current.getStartOffset());
        }
    }

    public FormattingModel createFormattingModelForPsiFile(PsiFile file, @NotNull Block rootBlock, CodeStyleSettings settings) {
        if (rootBlock == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/formatting/FormatterImpl.createFormattingModelForPsiFile must not be null");
        }
        return new PsiBasedFormattingModel(file, rootBlock, FormattingDocumentModelImpl.createOn(file));
    }

    public Indent getSpaceIndent(int spaces) {
        return new IndentImpl(IndentImpl.Type.SPACES, false, spaces);
    }

    public Indent getAbsoluteLabelIndent() {
        return this.myAbsoluteLabelIndent;
    }

    public Spacing createSafeSpacing(boolean shouldKeepLineBreaks, int keepBlankLines) {
        return this.getSpacingImpl(0, 0, 0, false, true, shouldKeepLineBreaks, keepBlankLines, false, 0);
    }

    public Spacing createKeepingFirstColumnSpacing(int minSpace, int maxSpace, boolean keepLineBreaks, int keepBlankLines) {
        return this.getSpacingImpl(minSpace, maxSpace, -1, false, false, keepLineBreaks, keepBlankLines, true, 0);
    }

    public Spacing createSpacing(int minSpaces, int maxSpaces, int minLineFeeds, boolean keepLineBreaks, int keepBlankLines, int prefLineFeeds) {
        return this.getSpacingImpl(minSpaces, maxSpaces, -1, false, false, keepLineBreaks, keepBlankLines, false, prefLineFeeds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SpacingImpl getSpacingImpl(int minSpaces, int maxSpaces, int minLineFeeds, boolean readOnly, boolean safe, boolean keepLineBreaksFlag, int keepLineBreaks, boolean keepFirstColumn, int prefLineFeeds) {
        FormatterImpl formatterImpl = this;
        synchronized (formatterImpl) {
            this.ourSharedSpacing.init(minSpaces, maxSpaces, minLineFeeds, readOnly, safe, keepLineBreaksFlag, keepLineBreaks, keepFirstColumn, prefLineFeeds);
            SpacingImpl spacing = this.ourSharedProperties.get((Object)this.ourSharedSpacing);
            if (spacing == null) {
                spacing = new SpacingImpl(minSpaces, maxSpaces, minLineFeeds, readOnly, safe, keepLineBreaksFlag, keepLineBreaks, keepFirstColumn, prefLineFeeds);
                this.ourSharedProperties.put(spacing, spacing);
            }
            return spacing;
        }
    }

    @NotNull
    public String getComponentName() {
        if ("FormatterEx" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/formatting/FormatterImpl.getComponentName must not return null");
        }
        return "FormatterEx";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public Indent getAbsoluteNoneIndent() {
        return this.myAbsoluteNoneIndent;
    }

    public Indent getLabelIndent() {
        return this.myLabelIndent;
    }

    public Indent getContinuationIndent() {
        return this.myContinuationIndent;
    }

    public Indent getContinuationWithoutFirstIndent() {
        return this.myContinutationWithoutFirstIndent;
    }

    public static int getLineFeedsToModified(FormattingDocumentModel model, int offset, int startOffset) {
        return model.getLineNumber(offset) - model.getLineNumber(startOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDisabled() {
        Object object = this.DISABLING_LOCK;
        synchronized (object) {
            return this.myIsDisabledCount > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableFormatting() {
        Object object = this.DISABLING_LOCK;
        synchronized (object) {
            ++this.myIsDisabledCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableFormatting() {
        Object object = this.DISABLING_LOCK;
        synchronized (object) {
            if (this.myIsDisabledCount <= 0) {
                LOG.error("enableFormatting()/disableFormatting() not paired. DisabledLevel = " + this.myIsDisabledCount);
            }
            --this.myIsDisabledCount;
        }
    }
}

