/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.views.table;

import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;

public class ArrowBorder
implements Border {
    private final int myArrowWidth = 7;
    private final Insets myInsets = new Insets(1, 7, 1, 0);
    private Color myColor;

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        g.setColor(c.getBackground());
        g.fillRect(0, 0, 7, height);
        g.setColor(this.myColor);
        int horizAxis = y + height / 2;
        UIUtil.drawLine((Graphics)g, (int)0, (int)horizAxis, (int)2, (int)horizAxis);
        int right = x + 7;
        int[] xPoints = new int[]{x + 2, right, right};
        int[] yPoints = new int[]{horizAxis, y, y + height};
        g.drawPolygon(xPoints, yPoints, 3);
        g.fillPolygon(xPoints, yPoints, 3);
        g.drawRect(right, y, width - right, height - 1);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.myInsets;
    }

    public void setColor(Color c) {
        this.myColor = c;
    }
}

